/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UserHandle;
import android.util.LongSparseArray;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class MemoryPowerCalculator
extends PowerCalculator {
    public static final String TAG = "MemoryPowerCalculator";
    private final UsageBasedPowerEstimator[] mPowerEstimators;

    public MemoryPowerCalculator(PowerProfile profile) {
        int numBuckets = profile.getNumElements("memory.bandwidths");
        this.mPowerEstimators = new UsageBasedPowerEstimator[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.mPowerEstimators[i] = new UsageBasedPowerEstimator(profile.getAveragePower("memory.bandwidths", i));
        }
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, 0);
        double powerMah = this.calculatePower(batteryStats, rawRealtimeUs, 0);
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(13, durationMs)).setConsumedPower(13, powerMah);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        long durationMs = this.calculateDuration(batteryStats, rawRealtimeUs, statsType);
        double powerMah = this.calculatePower(batteryStats, rawRealtimeUs, statsType);
        BatterySipper memory = new BatterySipper(BatterySipper.DrainType.MEMORY, null, 0.0);
        memory.usageTimeMs = durationMs;
        memory.usagePowerMah = powerMah;
        memory.sumPower();
        if (memory.totalPowerMah > 0.0) {
            sippers.add(memory);
        }
    }

    private long calculateDuration(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        long usageDurationMs = 0L;
        LongSparseArray<? extends BatteryStats.Timer> timers = batteryStats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.mPowerEstimators.length; ++i) {
            usageDurationMs += this.mPowerEstimators[i].calculateDuration(timers.valueAt(i), rawRealtimeUs, statsType);
        }
        return usageDurationMs;
    }

    private double calculatePower(BatteryStats batteryStats, long rawRealtimeUs, int statsType) {
        double powerMah = 0.0;
        LongSparseArray<? extends BatteryStats.Timer> timers = batteryStats.getKernelMemoryStats();
        for (int i = 0; i < timers.size() && i < this.mPowerEstimators.length; ++i) {
            UsageBasedPowerEstimator estimator = this.mPowerEstimators[(int)timers.keyAt(i)];
            long usageDurationMs = estimator.calculateDuration(timers.valueAt(i), rawRealtimeUs, statsType);
            powerMah += estimator.calculatePower(usageDurationMs);
        }
        return powerMah;
    }
}

