/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelSingleProcessCpuThreadReader;
import java.io.IOException;

public class SystemServerCpuThreadReader {
    private final KernelSingleProcessCpuThreadReader mKernelCpuThreadReader;
    private long[] mLastThreadCpuTimesUs;
    private long[] mLastBinderThreadCpuTimesUs;
    private final SystemServiceCpuThreadTimes mDeltaCpuThreadTimes = new SystemServiceCpuThreadTimes();

    public static SystemServerCpuThreadReader create() {
        return new SystemServerCpuThreadReader(KernelSingleProcessCpuThreadReader.create(Process.myPid()));
    }

    @VisibleForTesting
    public SystemServerCpuThreadReader(int pid, KernelSingleProcessCpuThreadReader.CpuTimeInStateReader cpuTimeInStateReader) throws IOException {
        this(new KernelSingleProcessCpuThreadReader(pid, cpuTimeInStateReader));
    }

    @VisibleForTesting
    public SystemServerCpuThreadReader(KernelSingleProcessCpuThreadReader kernelCpuThreadReader) {
        this.mKernelCpuThreadReader = kernelCpuThreadReader;
    }

    public void startTrackingThreadCpuTime() {
        this.mKernelCpuThreadReader.startTrackingThreadCpuTimes();
    }

    public void setBinderThreadNativeTids(int[] nativeTids) {
        this.mKernelCpuThreadReader.setSelectedThreadIds(nativeTids);
    }

    public SystemServiceCpuThreadTimes readDelta() {
        KernelSingleProcessCpuThreadReader.ProcessCpuUsage processCpuUsage;
        int numCpuFrequencies = this.mKernelCpuThreadReader.getCpuFrequencyCount();
        if (this.mLastThreadCpuTimesUs == null) {
            this.mLastThreadCpuTimesUs = new long[numCpuFrequencies];
            this.mLastBinderThreadCpuTimesUs = new long[numCpuFrequencies];
            this.mDeltaCpuThreadTimes.threadCpuTimesUs = new long[numCpuFrequencies];
            this.mDeltaCpuThreadTimes.binderThreadCpuTimesUs = new long[numCpuFrequencies];
        }
        if ((processCpuUsage = this.mKernelCpuThreadReader.getProcessCpuUsage()) == null) {
            return null;
        }
        for (int i = numCpuFrequencies - 1; i >= 0; --i) {
            long threadCpuTimesUs = processCpuUsage.threadCpuTimesMillis[i] * 1000L;
            long binderThreadCpuTimesUs = processCpuUsage.selectedThreadCpuTimesMillis[i] * 1000L;
            this.mDeltaCpuThreadTimes.threadCpuTimesUs[i] = Math.max(0L, threadCpuTimesUs - this.mLastThreadCpuTimesUs[i]);
            this.mDeltaCpuThreadTimes.binderThreadCpuTimesUs[i] = Math.max(0L, binderThreadCpuTimesUs - this.mLastBinderThreadCpuTimesUs[i]);
            this.mLastThreadCpuTimesUs[i] = threadCpuTimesUs;
            this.mLastBinderThreadCpuTimesUs[i] = binderThreadCpuTimesUs;
        }
        return this.mDeltaCpuThreadTimes;
    }

    public SystemServiceCpuThreadTimes readAbsolute() {
        int numCpuFrequencies = this.mKernelCpuThreadReader.getCpuFrequencyCount();
        KernelSingleProcessCpuThreadReader.ProcessCpuUsage processCpuUsage = this.mKernelCpuThreadReader.getProcessCpuUsage();
        if (processCpuUsage == null) {
            return null;
        }
        SystemServiceCpuThreadTimes result = new SystemServiceCpuThreadTimes();
        result.threadCpuTimesUs = new long[numCpuFrequencies];
        result.binderThreadCpuTimesUs = new long[numCpuFrequencies];
        for (int i = 0; i < numCpuFrequencies; ++i) {
            result.threadCpuTimesUs[i] = processCpuUsage.threadCpuTimesMillis[i] * 1000L;
            result.binderThreadCpuTimesUs[i] = processCpuUsage.selectedThreadCpuTimesMillis[i] * 1000L;
        }
        return result;
    }

    public static class SystemServiceCpuThreadTimes {
        public long[] threadCpuTimesUs;
        public long[] binderThreadCpuTimesUs;
    }
}

