/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;

public class UsageBasedPowerEstimator {
    private static final double MILLIS_IN_HOUR = 3600000.0;
    private final double mAveragePowerMahPerMs;

    public UsageBasedPowerEstimator(double averagePowerMilliAmp) {
        this.mAveragePowerMahPerMs = averagePowerMilliAmp / 3600000.0;
    }

    public boolean isSupported() {
        return this.mAveragePowerMahPerMs != 0.0;
    }

    public long calculateDuration(BatteryStats.Timer timer, long rawRealtimeUs, int statsType) {
        return timer == null ? 0L : timer.getTotalTimeLocked(rawRealtimeUs, statsType) / 1000L;
    }

    public double calculatePower(long durationMs) {
        return this.mAveragePowerMahPerMs * (double)durationMs;
    }
}

