/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class WakelockPowerCalculator
extends PowerCalculator {
    private static final String TAG = "WakelockPowerCalculator";
    private static final boolean DEBUG = false;
    private final UsageBasedPowerEstimator mPowerEstimator;

    public WakelockPowerCalculator(PowerProfile profile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("cpu.idle"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long wakeTimeMs;
        PowerAndDuration result = new PowerAndDuration();
        UidBatteryConsumer.Builder osBatteryConsumer = null;
        double osPowerMah = 0.0;
        long osDurationMs = 0L;
        long totalAppDurationMs = 0L;
        double appPowerMah = 0.0;
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(result, app.getBatteryStatsUid(), rawRealtimeUs, 0);
            ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(12, result.durationMs)).setConsumedPower(12, result.powerMah);
            totalAppDurationMs += result.durationMs;
            appPowerMah += result.powerMah;
            if (app.getUid() != 0) continue;
            osBatteryConsumer = app;
            osDurationMs = result.durationMs;
            osPowerMah = result.powerMah;
        }
        this.calculateRemaining(result, batteryStats, rawRealtimeUs, rawUptimeUs, 0, osPowerMah, osDurationMs, totalAppDurationMs);
        double remainingPowerMah = result.powerMah;
        if (osBatteryConsumer != null) {
            ((UidBatteryConsumer.Builder)osBatteryConsumer.setUsageDurationMillis(12, result.durationMs)).setConsumedPower(12, remainingPowerMah);
        }
        if ((wakeTimeMs = this.calculateWakeTimeMillis(batteryStats, rawRealtimeUs, rawUptimeUs)) < 0L) {
            wakeTimeMs = 0L;
        }
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(12, wakeTimeMs)).setConsumedPower(12, appPowerMah + remainingPowerMah);
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(12, totalAppDurationMs)).setConsumedPower(12, appPowerMah);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        PowerAndDuration result = new PowerAndDuration();
        BatterySipper osSipper = null;
        double osPowerMah = 0.0;
        long osDurationMs = 0L;
        long totalAppDurationMs = 0L;
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            this.calculateApp(result, app.uidObj, rawRealtimeUs, statsType);
            app.wakeLockTimeMs = result.durationMs;
            app.wakeLockPowerMah = result.powerMah;
            totalAppDurationMs += result.durationMs;
            if (app.getUid() != 0) continue;
            osSipper = app;
            osPowerMah = result.powerMah;
            osDurationMs = result.durationMs;
        }
        if (osSipper != null) {
            this.calculateRemaining(result, batteryStats, rawRealtimeUs, rawUptimeUs, statsType, osPowerMah, osDurationMs, totalAppDurationMs);
            osSipper.wakeLockTimeMs = result.durationMs;
            osSipper.wakeLockPowerMah = result.powerMah;
            osSipper.sumPower();
        }
    }

    private void calculateApp(PowerAndDuration result, BatteryStats.Uid u, long rawRealtimeUs, int statsType) {
        long wakeLockTimeUs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> wakelockStats = u.getWakelockStats();
        int wakelockStatsCount = wakelockStats.size();
        for (int i = 0; i < wakelockStatsCount; ++i) {
            BatteryStats.Uid.Wakelock wakelock = wakelockStats.valueAt(i);
            BatteryStats.Timer timer = wakelock.getWakeTime(0);
            if (timer == null) continue;
            wakeLockTimeUs += timer.getTotalTimeLocked(rawRealtimeUs, statsType);
        }
        result.durationMs = wakeLockTimeUs / 1000L;
        result.powerMah = this.mPowerEstimator.calculatePower(result.durationMs);
    }

    private void calculateRemaining(PowerAndDuration result, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType, double osPowerMah, long osDurationMs, long totalAppDurationMs) {
        long wakeTimeMillis = this.calculateWakeTimeMillis(stats, rawRealtimeUs, rawUptimeUs) - totalAppDurationMs;
        if (wakeTimeMillis > 0L) {
            double power = this.mPowerEstimator.calculatePower(wakeTimeMillis);
            result.durationMs = osDurationMs + wakeTimeMillis;
            result.powerMah = osPowerMah + power;
        } else {
            result.durationMs = 0L;
            result.powerMah = 0.0;
        }
    }

    private long calculateWakeTimeMillis(BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs) {
        long batteryUptimeUs = batteryStats.getBatteryUptime(rawUptimeUs);
        long screenOnTimeUs = batteryStats.getScreenOnTime(rawRealtimeUs, 0);
        return (batteryUptimeUs - screenOnTimeUs) / 1000L;
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;

        private PowerAndDuration() {
        }
    }
}

