/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.app.ITransientNotificationCallback;
import android.content.ComponentName;
import android.hardware.biometrics.IBiometricSysuiReceiver;
import android.hardware.biometrics.PromptInfo;
import android.hardware.fingerprint.IUdfpsHbmListener;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.text.TextUtils;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.view.AppearanceRegion;

public interface IStatusBar
extends IInterface {
    public void setIcon(String var1, StatusBarIcon var2) throws RemoteException;

    public void removeIcon(String var1) throws RemoteException;

    public void disable(int var1, int var2, int var3) throws RemoteException;

    public void animateExpandNotificationsPanel() throws RemoteException;

    public void animateExpandSettingsPanel(String var1) throws RemoteException;

    public void animateCollapsePanels() throws RemoteException;

    public void togglePanel() throws RemoteException;

    public void showWirelessChargingAnimation(int var1) throws RemoteException;

    public void setImeWindowStatus(int var1, IBinder var2, int var3, int var4, boolean var5, boolean var6) throws RemoteException;

    public void setWindowState(int var1, int var2, int var3) throws RemoteException;

    public void showRecentApps(boolean var1) throws RemoteException;

    public void hideRecentApps(boolean var1, boolean var2) throws RemoteException;

    public void toggleRecentApps() throws RemoteException;

    public void toggleSplitScreen() throws RemoteException;

    public void preloadRecentApps() throws RemoteException;

    public void cancelPreloadRecentApps() throws RemoteException;

    public void showScreenPinningRequest(int var1) throws RemoteException;

    public void dismissKeyboardShortcutsMenu() throws RemoteException;

    public void toggleKeyboardShortcutsMenu(int var1) throws RemoteException;

    public void appTransitionPending(int var1) throws RemoteException;

    public void appTransitionCancelled(int var1) throws RemoteException;

    public void appTransitionStarting(int var1, long var2, long var4) throws RemoteException;

    public void appTransitionFinished(int var1) throws RemoteException;

    public void showAssistDisclosure() throws RemoteException;

    public void startAssist(Bundle var1) throws RemoteException;

    public void onCameraLaunchGestureDetected(int var1) throws RemoteException;

    public void onEmergencyActionLaunchGestureDetected() throws RemoteException;

    public void showPictureInPictureMenu() throws RemoteException;

    public void showGlobalActionsMenu() throws RemoteException;

    public void onProposedRotationChanged(int var1, boolean var2) throws RemoteException;

    public void setTopAppHidesStatusBar(boolean var1) throws RemoteException;

    public void addQsTile(ComponentName var1) throws RemoteException;

    public void remQsTile(ComponentName var1) throws RemoteException;

    public void clickQsTile(ComponentName var1) throws RemoteException;

    public void handleSystemKey(int var1) throws RemoteException;

    public void showPinningEnterExitToast(boolean var1) throws RemoteException;

    public void showPinningEscapeToast() throws RemoteException;

    public void showShutdownUi(boolean var1, String var2) throws RemoteException;

    public void showAuthenticationDialog(PromptInfo var1, IBiometricSysuiReceiver var2, int[] var3, boolean var4, boolean var5, int var6, String var7, long var8, int var10) throws RemoteException;

    public void onBiometricAuthenticated() throws RemoteException;

    public void onBiometricHelp(int var1, String var2) throws RemoteException;

    public void onBiometricError(int var1, int var2, int var3) throws RemoteException;

    public void hideAuthenticationDialog() throws RemoteException;

    public void setUdfpsHbmListener(IUdfpsHbmListener var1) throws RemoteException;

    public void onDisplayReady(int var1) throws RemoteException;

    public void onRecentsAnimationStateChanged(boolean var1) throws RemoteException;

    public void onSystemBarAttributesChanged(int var1, int var2, AppearanceRegion[] var3, boolean var4, int var5, boolean var6) throws RemoteException;

    public void showTransient(int var1, int[] var2) throws RemoteException;

    public void abortTransient(int var1, int[] var2) throws RemoteException;

    public void showInattentiveSleepWarning() throws RemoteException;

    public void dismissInattentiveSleepWarning(boolean var1) throws RemoteException;

    public void showToast(int var1, String var2, IBinder var3, CharSequence var4, IBinder var5, int var6, ITransientNotificationCallback var7) throws RemoteException;

    public void hideToast(String var1, IBinder var2) throws RemoteException;

    public void startTracing() throws RemoteException;

    public void stopTracing() throws RemoteException;

    public void handleWindowManagerLoggingCommand(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void suppressAmbientDisplay(boolean var1) throws RemoteException;

    public void requestWindowMagnificationConnection(boolean var1) throws RemoteException;

    public void passThroughShellCommand(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void setNavigationBarLumaSamplingEnabled(int var1, boolean var2) throws RemoteException;

    public void runGcForTest() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBar {
        public static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBar";
        static final int TRANSACTION_setIcon = 1;
        static final int TRANSACTION_removeIcon = 2;
        static final int TRANSACTION_disable = 3;
        static final int TRANSACTION_animateExpandNotificationsPanel = 4;
        static final int TRANSACTION_animateExpandSettingsPanel = 5;
        static final int TRANSACTION_animateCollapsePanels = 6;
        static final int TRANSACTION_togglePanel = 7;
        static final int TRANSACTION_showWirelessChargingAnimation = 8;
        static final int TRANSACTION_setImeWindowStatus = 9;
        static final int TRANSACTION_setWindowState = 10;
        static final int TRANSACTION_showRecentApps = 11;
        static final int TRANSACTION_hideRecentApps = 12;
        static final int TRANSACTION_toggleRecentApps = 13;
        static final int TRANSACTION_toggleSplitScreen = 14;
        static final int TRANSACTION_preloadRecentApps = 15;
        static final int TRANSACTION_cancelPreloadRecentApps = 16;
        static final int TRANSACTION_showScreenPinningRequest = 17;
        static final int TRANSACTION_dismissKeyboardShortcutsMenu = 18;
        static final int TRANSACTION_toggleKeyboardShortcutsMenu = 19;
        static final int TRANSACTION_appTransitionPending = 20;
        static final int TRANSACTION_appTransitionCancelled = 21;
        static final int TRANSACTION_appTransitionStarting = 22;
        static final int TRANSACTION_appTransitionFinished = 23;
        static final int TRANSACTION_showAssistDisclosure = 24;
        static final int TRANSACTION_startAssist = 25;
        static final int TRANSACTION_onCameraLaunchGestureDetected = 26;
        static final int TRANSACTION_onEmergencyActionLaunchGestureDetected = 27;
        static final int TRANSACTION_showPictureInPictureMenu = 28;
        static final int TRANSACTION_showGlobalActionsMenu = 29;
        static final int TRANSACTION_onProposedRotationChanged = 30;
        static final int TRANSACTION_setTopAppHidesStatusBar = 31;
        static final int TRANSACTION_addQsTile = 32;
        static final int TRANSACTION_remQsTile = 33;
        static final int TRANSACTION_clickQsTile = 34;
        static final int TRANSACTION_handleSystemKey = 35;
        static final int TRANSACTION_showPinningEnterExitToast = 36;
        static final int TRANSACTION_showPinningEscapeToast = 37;
        static final int TRANSACTION_showShutdownUi = 38;
        static final int TRANSACTION_showAuthenticationDialog = 39;
        static final int TRANSACTION_onBiometricAuthenticated = 40;
        static final int TRANSACTION_onBiometricHelp = 41;
        static final int TRANSACTION_onBiometricError = 42;
        static final int TRANSACTION_hideAuthenticationDialog = 43;
        static final int TRANSACTION_setUdfpsHbmListener = 44;
        static final int TRANSACTION_onDisplayReady = 45;
        static final int TRANSACTION_onRecentsAnimationStateChanged = 46;
        static final int TRANSACTION_onSystemBarAttributesChanged = 47;
        static final int TRANSACTION_showTransient = 48;
        static final int TRANSACTION_abortTransient = 49;
        static final int TRANSACTION_showInattentiveSleepWarning = 50;
        static final int TRANSACTION_dismissInattentiveSleepWarning = 51;
        static final int TRANSACTION_showToast = 52;
        static final int TRANSACTION_hideToast = 53;
        static final int TRANSACTION_startTracing = 54;
        static final int TRANSACTION_stopTracing = 55;
        static final int TRANSACTION_handleWindowManagerLoggingCommand = 56;
        static final int TRANSACTION_suppressAmbientDisplay = 57;
        static final int TRANSACTION_requestWindowMagnificationConnection = 58;
        static final int TRANSACTION_passThroughShellCommand = 59;
        static final int TRANSACTION_setNavigationBarLumaSamplingEnabled = 60;
        static final int TRANSACTION_runGcForTest = 61;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatusBar asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatusBar) {
                return (IStatusBar)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setIcon";
                }
                case 2: {
                    return "removeIcon";
                }
                case 3: {
                    return "disable";
                }
                case 4: {
                    return "animateExpandNotificationsPanel";
                }
                case 5: {
                    return "animateExpandSettingsPanel";
                }
                case 6: {
                    return "animateCollapsePanels";
                }
                case 7: {
                    return "togglePanel";
                }
                case 8: {
                    return "showWirelessChargingAnimation";
                }
                case 9: {
                    return "setImeWindowStatus";
                }
                case 10: {
                    return "setWindowState";
                }
                case 11: {
                    return "showRecentApps";
                }
                case 12: {
                    return "hideRecentApps";
                }
                case 13: {
                    return "toggleRecentApps";
                }
                case 14: {
                    return "toggleSplitScreen";
                }
                case 15: {
                    return "preloadRecentApps";
                }
                case 16: {
                    return "cancelPreloadRecentApps";
                }
                case 17: {
                    return "showScreenPinningRequest";
                }
                case 18: {
                    return "dismissKeyboardShortcutsMenu";
                }
                case 19: {
                    return "toggleKeyboardShortcutsMenu";
                }
                case 20: {
                    return "appTransitionPending";
                }
                case 21: {
                    return "appTransitionCancelled";
                }
                case 22: {
                    return "appTransitionStarting";
                }
                case 23: {
                    return "appTransitionFinished";
                }
                case 24: {
                    return "showAssistDisclosure";
                }
                case 25: {
                    return "startAssist";
                }
                case 26: {
                    return "onCameraLaunchGestureDetected";
                }
                case 27: {
                    return "onEmergencyActionLaunchGestureDetected";
                }
                case 28: {
                    return "showPictureInPictureMenu";
                }
                case 29: {
                    return "showGlobalActionsMenu";
                }
                case 30: {
                    return "onProposedRotationChanged";
                }
                case 31: {
                    return "setTopAppHidesStatusBar";
                }
                case 32: {
                    return "addQsTile";
                }
                case 33: {
                    return "remQsTile";
                }
                case 34: {
                    return "clickQsTile";
                }
                case 35: {
                    return "handleSystemKey";
                }
                case 36: {
                    return "showPinningEnterExitToast";
                }
                case 37: {
                    return "showPinningEscapeToast";
                }
                case 38: {
                    return "showShutdownUi";
                }
                case 39: {
                    return "showAuthenticationDialog";
                }
                case 40: {
                    return "onBiometricAuthenticated";
                }
                case 41: {
                    return "onBiometricHelp";
                }
                case 42: {
                    return "onBiometricError";
                }
                case 43: {
                    return "hideAuthenticationDialog";
                }
                case 44: {
                    return "setUdfpsHbmListener";
                }
                case 45: {
                    return "onDisplayReady";
                }
                case 46: {
                    return "onRecentsAnimationStateChanged";
                }
                case 47: {
                    return "onSystemBarAttributesChanged";
                }
                case 48: {
                    return "showTransient";
                }
                case 49: {
                    return "abortTransient";
                }
                case 50: {
                    return "showInattentiveSleepWarning";
                }
                case 51: {
                    return "dismissInattentiveSleepWarning";
                }
                case 52: {
                    return "showToast";
                }
                case 53: {
                    return "hideToast";
                }
                case 54: {
                    return "startTracing";
                }
                case 55: {
                    return "stopTracing";
                }
                case 56: {
                    return "handleWindowManagerLoggingCommand";
                }
                case 57: {
                    return "suppressAmbientDisplay";
                }
                case 58: {
                    return "requestWindowMagnificationConnection";
                }
                case 59: {
                    return "passThroughShellCommand";
                }
                case 60: {
                    return "setNavigationBarLumaSamplingEnabled";
                }
                case 61: {
                    return "runGcForTest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    StatusBarIcon _arg1 = 0 != data.readInt() ? StatusBarIcon.CREATOR.createFromParcel(data) : null;
                    this.setIcon(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.removeIcon(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.disable(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.animateExpandNotificationsPanel();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.animateExpandSettingsPanel(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.animateCollapsePanels();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.togglePanel();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.showWirelessChargingAnimation(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    boolean _arg5 = 0 != data.readInt();
                    this.setImeWindowStatus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setWindowState(_arg0, _arg1, _arg2);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.showRecentApps(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.hideRecentApps(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    this.toggleRecentApps();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    this.toggleSplitScreen();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    this.preloadRecentApps();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.cancelPreloadRecentApps();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.showScreenPinningRequest(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    this.dismissKeyboardShortcutsMenu();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.toggleKeyboardShortcutsMenu(_arg0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionPending(_arg0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionCancelled(_arg0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    this.appTransitionStarting(_arg0, _arg1, _arg2);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.appTransitionFinished(_arg0);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    this.showAssistDisclosure();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.startAssist(_arg0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onCameraLaunchGestureDetected(_arg0);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    this.onEmergencyActionLaunchGestureDetected();
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    this.showPictureInPictureMenu();
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    this.showGlobalActionsMenu();
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.onProposedRotationChanged(_arg0, _arg1);
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setTopAppHidesStatusBar(_arg0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.addQsTile(_arg0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.remQsTile(_arg0);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    ComponentName _arg0 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    this.clickQsTile(_arg0);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.handleSystemKey(_arg0);
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.showPinningEnterExitToast(_arg0);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    this.showPinningEscapeToast();
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    String _arg1 = data.readString();
                    this.showShutdownUi(_arg0, _arg1);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    PromptInfo _arg0 = 0 != data.readInt() ? PromptInfo.CREATOR.createFromParcel(data) : null;
                    IBiometricSysuiReceiver _arg1 = IBiometricSysuiReceiver.Stub.asInterface(data.readStrongBinder());
                    int[] _arg2 = data.createIntArray();
                    boolean _arg3 = 0 != data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    long _arg7 = data.readLong();
                    int _arg8 = data.readInt();
                    this.showAuthenticationDialog(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    this.onBiometricAuthenticated();
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.onBiometricHelp(_arg0, _arg1);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onBiometricError(_arg0, _arg1, _arg2);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    this.hideAuthenticationDialog();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    IUdfpsHbmListener _arg0 = IUdfpsHbmListener.Stub.asInterface(data.readStrongBinder());
                    this.setUdfpsHbmListener(_arg0);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onDisplayReady(_arg0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onRecentsAnimationStateChanged(_arg0);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AppearanceRegion[] _arg2 = data.createTypedArray(AppearanceRegion.CREATOR);
                    boolean _arg3 = 0 != data.readInt();
                    int _arg4 = data.readInt();
                    boolean _arg5 = 0 != data.readInt();
                    this.onSystemBarAttributesChanged(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    this.showTransient(_arg0, _arg1);
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int[] _arg1 = data.createIntArray();
                    this.abortTransient(_arg0, _arg1);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    this.showInattentiveSleepWarning();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.dismissInattentiveSleepWarning(_arg0);
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    CharSequence _arg3 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    IBinder _arg4 = data.readStrongBinder();
                    int _arg5 = data.readInt();
                    ITransientNotificationCallback _arg6 = ITransientNotificationCallback.Stub.asInterface(data.readStrongBinder());
                    this.showToast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    this.hideToast(_arg0, _arg1);
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    this.startTracing();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    this.stopTracing();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.handleWindowManagerLoggingCommand(_arg0, _arg1);
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.suppressAmbientDisplay(_arg0);
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.requestWindowMagnificationConnection(_arg0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = 0 != data.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(data) : null;
                    this.passThroughShellCommand(_arg0, _arg1);
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setNavigationBarLumaSamplingEnabled(_arg0, _arg1);
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    this.runGcForTest();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IStatusBar impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IStatusBar getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IStatusBar {
            private IBinder mRemote;
            public static IStatusBar sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    if (icon != null) {
                        _data.writeInt(1);
                        icon.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setIcon(slot, icon);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIcon(String slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeIcon(slot);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(int displayId, int state1, int state2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state1);
                    _data.writeInt(state2);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disable(displayId, state1, state2);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateExpandNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateExpandNotificationsPanel();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subPanel);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateExpandSettingsPanel(subPanel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateCollapsePanels() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().animateCollapsePanels();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void togglePanel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().togglePanel();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(batteryLevel);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showWirelessChargingAnimation(batteryLevel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher, boolean isMultiClientImeEnabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(token);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    _data.writeInt(showImeSwitcher ? 1 : 0);
                    _data.writeInt(isMultiClientImeEnabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setImeWindowStatus(displayId, token, vis, backDisposition, showImeSwitcher, isMultiClientImeEnabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowState(int display, int window, int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(display);
                    _data.writeInt(window);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWindowState(display, window, state);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showRecentApps(triggeredFromAltTab);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    _data.writeInt(triggeredFromHomeKey ? 1 : 0);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideRecentApps(triggeredFromAltTab, triggeredFromHomeKey);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleSplitScreen() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleSplitScreen();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void preloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().preloadRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPreloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelPreloadRecentApps();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showScreenPinningRequest(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showScreenPinningRequest(taskId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dismissKeyboardShortcutsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismissKeyboardShortcutsMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().toggleKeyboardShortcutsMenu(deviceId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionPending(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionPending(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionCancelled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionCancelled(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(statusBarAnimationsStartTime);
                    _data.writeLong(statusBarAnimationsDuration);
                    boolean _status = this.mRemote.transact(22, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionStarting(displayId, statusBarAnimationsStartTime, statusBarAnimationsDuration);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionFinished(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appTransitionFinished(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showAssistDisclosure() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showAssistDisclosure();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAssist(Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(25, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startAssist(args);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraLaunchGestureDetected(int source) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(source);
                    boolean _status = this.mRemote.transact(26, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCameraLaunchGestureDetected(source);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEmergencyActionLaunchGestureDetected();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPictureInPictureMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPictureInPictureMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showGlobalActionsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showGlobalActionsMenu();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeInt(isValid ? 1 : 0);
                    boolean _status = this.mRemote.transact(30, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProposedRotationChanged(rotation, isValid);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hidesStatusBar ? 1 : 0);
                    boolean _status = this.mRemote.transact(31, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setTopAppHidesStatusBar(hidesStatusBar);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().remQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clickQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (tile != null) {
                        _data.writeInt(1);
                        tile.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(34, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clickQsTile(tile);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleSystemKey(int key) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(key);
                    boolean _status = this.mRemote.transact(35, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().handleSystemKey(key);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEnterExitToast(boolean entering) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(entering ? 1 : 0);
                    boolean _status = this.mRemote.transact(36, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPinningEnterExitToast(entering);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPinningEscapeToast() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showPinningEscapeToast();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isReboot ? 1 : 0);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(38, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showShutdownUi(isReboot, reason);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, String opPackageName, long operationId, int multiSensorConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (promptInfo != null) {
                        _data.writeInt(1);
                        promptInfo.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(sysuiReceiver != null ? sysuiReceiver.asBinder() : null);
                    _data.writeIntArray(sensorIds);
                    _data.writeInt(credentialAllowed ? 1 : 0);
                    _data.writeInt(requireConfirmation ? 1 : 0);
                    _data.writeInt(userId);
                    _data.writeString(opPackageName);
                    _data.writeLong(operationId);
                    _data.writeInt(multiSensorConfig);
                    boolean _status = this.mRemote.transact(39, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showAuthenticationDialog(promptInfo, sysuiReceiver, sensorIds, credentialAllowed, requireConfirmation, userId, opPackageName, operationId, multiSensorConfig);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBiometricAuthenticated() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricAuthenticated();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricHelp(int modality, String message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeString(message);
                    boolean _status = this.mRemote.transact(41, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricHelp(modality, message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(42, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBiometricError(modality, error, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void hideAuthenticationDialog() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(43, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideAuthenticationDialog();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUdfpsHbmListener(IUdfpsHbmListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(44, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setUdfpsHbmListener(listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayReady(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(45, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisplayReady(displayId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(running ? 1 : 0);
                    boolean _status = this.mRemote.transact(46, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRecentsAnimationStateChanged(running);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, boolean isFullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(appearance);
                    _data.writeTypedArray(appearanceRegions, 0);
                    _data.writeInt(navbarColorManagedByIme ? 1 : 0);
                    _data.writeInt(behavior);
                    _data.writeInt(isFullscreen ? 1 : 0);
                    boolean _status = this.mRemote.transact(47, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSystemBarAttributesChanged(displayId, appearance, appearanceRegions, navbarColorManagedByIme, behavior, isFullscreen);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showTransient(int displayId, int[] types) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(types);
                    boolean _status = this.mRemote.transact(48, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showTransient(displayId, types);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortTransient(int displayId, int[] types) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeIntArray(types);
                    boolean _status = this.mRemote.transact(49, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().abortTransient(displayId, types);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showInattentiveSleepWarning() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(50, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showInattentiveSleepWarning();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(animated ? 1 : 0);
                    boolean _status = this.mRemote.transact(51, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dismissInattentiveSleepWarning(animated);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(duration);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(52, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showToast(uid, packageName, token, text, windowToken, duration, callback);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideToast(String packageName, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(53, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().hideToast(packageName, token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void startTracing() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(54, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startTracing();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stopTracing() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopTracing();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleWindowManagerLoggingCommand(String[] args, ParcelFileDescriptor outFd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    if (outFd != null) {
                        _data.writeInt(1);
                        outFd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(56, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().handleWindowManagerLoggingCommand(args, outFd);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(suppress ? 1 : 0);
                    boolean _status = this.mRemote.transact(57, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().suppressAmbientDisplay(suppress);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestWindowMagnificationConnection(boolean connect) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(connect ? 1 : 0);
                    boolean _status = this.mRemote.transact(58, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().requestWindowMagnificationConnection(connect);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    if (pfd != null) {
                        _data.writeInt(1);
                        pfd.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(59, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().passThroughShellCommand(args, pfd);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(60, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setNavigationBarLumaSamplingEnabled(displayId, enable);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void runGcForTest() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().runGcForTest();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatusBar {
        @Override
        public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
        }

        @Override
        public void removeIcon(String slot) throws RemoteException {
        }

        @Override
        public void disable(int displayId, int state1, int state2) throws RemoteException {
        }

        @Override
        public void animateExpandNotificationsPanel() throws RemoteException {
        }

        @Override
        public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
        }

        @Override
        public void animateCollapsePanels() throws RemoteException {
        }

        @Override
        public void togglePanel() throws RemoteException {
        }

        @Override
        public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
        }

        @Override
        public void setImeWindowStatus(int displayId, IBinder token, int vis, int backDisposition, boolean showImeSwitcher, boolean isMultiClientImeEnabled) throws RemoteException {
        }

        @Override
        public void setWindowState(int display, int window, int state) throws RemoteException {
        }

        @Override
        public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
        }

        @Override
        public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
        }

        @Override
        public void toggleRecentApps() throws RemoteException {
        }

        @Override
        public void toggleSplitScreen() throws RemoteException {
        }

        @Override
        public void preloadRecentApps() throws RemoteException {
        }

        @Override
        public void cancelPreloadRecentApps() throws RemoteException {
        }

        @Override
        public void showScreenPinningRequest(int taskId) throws RemoteException {
        }

        @Override
        public void dismissKeyboardShortcutsMenu() throws RemoteException {
        }

        @Override
        public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
        }

        @Override
        public void appTransitionPending(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionCancelled(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
        }

        @Override
        public void appTransitionFinished(int displayId) throws RemoteException {
        }

        @Override
        public void showAssistDisclosure() throws RemoteException {
        }

        @Override
        public void startAssist(Bundle args) throws RemoteException {
        }

        @Override
        public void onCameraLaunchGestureDetected(int source) throws RemoteException {
        }

        @Override
        public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
        }

        @Override
        public void showPictureInPictureMenu() throws RemoteException {
        }

        @Override
        public void showGlobalActionsMenu() throws RemoteException {
        }

        @Override
        public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
        }

        @Override
        public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
        }

        @Override
        public void addQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void remQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void clickQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void handleSystemKey(int key) throws RemoteException {
        }

        @Override
        public void showPinningEnterExitToast(boolean entering) throws RemoteException {
        }

        @Override
        public void showPinningEscapeToast() throws RemoteException {
        }

        @Override
        public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
        }

        @Override
        public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, String opPackageName, long operationId, int multiSensorConfig) throws RemoteException {
        }

        @Override
        public void onBiometricAuthenticated() throws RemoteException {
        }

        @Override
        public void onBiometricHelp(int modality, String message) throws RemoteException {
        }

        @Override
        public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void hideAuthenticationDialog() throws RemoteException {
        }

        @Override
        public void setUdfpsHbmListener(IUdfpsHbmListener listener) throws RemoteException {
        }

        @Override
        public void onDisplayReady(int displayId) throws RemoteException {
        }

        @Override
        public void onRecentsAnimationStateChanged(boolean running) throws RemoteException {
        }

        @Override
        public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, boolean isFullscreen) throws RemoteException {
        }

        @Override
        public void showTransient(int displayId, int[] types) throws RemoteException {
        }

        @Override
        public void abortTransient(int displayId, int[] types) throws RemoteException {
        }

        @Override
        public void showInattentiveSleepWarning() throws RemoteException {
        }

        @Override
        public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
        }

        @Override
        public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback) throws RemoteException {
        }

        @Override
        public void hideToast(String packageName, IBinder token) throws RemoteException {
        }

        @Override
        public void startTracing() throws RemoteException {
        }

        @Override
        public void stopTracing() throws RemoteException {
        }

        @Override
        public void handleWindowManagerLoggingCommand(String[] args, ParcelFileDescriptor outFd) throws RemoteException {
        }

        @Override
        public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
        }

        @Override
        public void requestWindowMagnificationConnection(boolean connect) throws RemoteException {
        }

        @Override
        public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
        }

        @Override
        public void runGcForTest() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

