/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.view.AppearanceRegion;

public class RegisterStatusBarResult
implements Parcelable {
    public final ArrayMap<String, StatusBarIcon> mIcons;
    public final int mDisabledFlags1;
    public final int mAppearance;
    public final AppearanceRegion[] mAppearanceRegions;
    public final int mImeWindowVis;
    public final int mImeBackDisposition;
    public final boolean mShowImeSwitcher;
    public final int mDisabledFlags2;
    public final IBinder mImeToken;
    public final boolean mNavbarColorManagedByIme;
    public final int mBehavior;
    public final boolean mAppFullscreen;
    public final int[] mTransientBarTypes;
    public static final Parcelable.Creator<RegisterStatusBarResult> CREATOR = new Parcelable.Creator<RegisterStatusBarResult>(){

        @Override
        public RegisterStatusBarResult createFromParcel(Parcel source) {
            ArrayMap<String, StatusBarIcon> icons = source.createTypedArrayMap(StatusBarIcon.CREATOR);
            int disabledFlags1 = source.readInt();
            int appearance = source.readInt();
            AppearanceRegion[] appearanceRegions = (AppearanceRegion[])source.readParcelableArray(null, AppearanceRegion.class);
            int imeWindowVis = source.readInt();
            int imeBackDisposition = source.readInt();
            boolean showImeSwitcher = source.readBoolean();
            int disabledFlags2 = source.readInt();
            IBinder imeToken = source.readStrongBinder();
            boolean navbarColorManagedByIme = source.readBoolean();
            int behavior = source.readInt();
            boolean appFullscreen = source.readBoolean();
            int[] transientBarTypes = source.createIntArray();
            return new RegisterStatusBarResult(icons, disabledFlags1, appearance, appearanceRegions, imeWindowVis, imeBackDisposition, showImeSwitcher, disabledFlags2, imeToken, navbarColorManagedByIme, behavior, appFullscreen, transientBarTypes);
        }

        public RegisterStatusBarResult[] newArray(int size) {
            return new RegisterStatusBarResult[size];
        }
    };

    public RegisterStatusBarResult(ArrayMap<String, StatusBarIcon> icons, int disabledFlags1, int appearance, AppearanceRegion[] appearanceRegions, int imeWindowVis, int imeBackDisposition, boolean showImeSwitcher, int disabledFlags2, IBinder imeToken, boolean navbarColorManagedByIme, int behavior, boolean appFullscreen, int[] transientBarTypes) {
        this.mIcons = new ArrayMap<String, StatusBarIcon>(icons);
        this.mDisabledFlags1 = disabledFlags1;
        this.mAppearance = appearance;
        this.mAppearanceRegions = appearanceRegions;
        this.mImeWindowVis = imeWindowVis;
        this.mImeBackDisposition = imeBackDisposition;
        this.mShowImeSwitcher = showImeSwitcher;
        this.mDisabledFlags2 = disabledFlags2;
        this.mImeToken = imeToken;
        this.mNavbarColorManagedByIme = navbarColorManagedByIme;
        this.mBehavior = behavior;
        this.mAppFullscreen = appFullscreen;
        this.mTransientBarTypes = transientBarTypes;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedArrayMap(this.mIcons, flags);
        dest.writeInt(this.mDisabledFlags1);
        dest.writeInt(this.mAppearance);
        dest.writeParcelableArray(this.mAppearanceRegions, 0);
        dest.writeInt(this.mImeWindowVis);
        dest.writeInt(this.mImeBackDisposition);
        dest.writeBoolean(this.mShowImeSwitcher);
        dest.writeInt(this.mDisabledFlags2);
        dest.writeStrongBinder(this.mImeToken);
        dest.writeBoolean(this.mNavbarColorManagedByIme);
        dest.writeInt(this.mBehavior);
        dest.writeBoolean(this.mAppFullscreen);
        dest.writeIntArray(this.mTransientBarTypes);
    }
}

