/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;

public interface ICarrierConfigLoader
extends IInterface {
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/internal/telephony/ICarrierConfigLoader.aidl:27:1:27:69")
    public PersistableBundle getConfigForSubId(int var1, String var2) throws RemoteException;

    public PersistableBundle getConfigForSubIdWithFeature(int var1, String var2, String var3) throws RemoteException;

    public void overrideConfig(int var1, PersistableBundle var2, boolean var3) throws RemoteException;

    public void notifyConfigChangedForSubId(int var1) throws RemoteException;

    public void updateConfigForPhoneId(int var1, String var2) throws RemoteException;

    public String getDefaultCarrierServicePackageName() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICarrierConfigLoader {
        public static final String DESCRIPTOR = "com.android.internal.telephony.ICarrierConfigLoader";
        static final int TRANSACTION_getConfigForSubId = 1;
        static final int TRANSACTION_getConfigForSubIdWithFeature = 2;
        static final int TRANSACTION_overrideConfig = 3;
        static final int TRANSACTION_notifyConfigChangedForSubId = 4;
        static final int TRANSACTION_updateConfigForPhoneId = 5;
        static final int TRANSACTION_getDefaultCarrierServicePackageName = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICarrierConfigLoader asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICarrierConfigLoader) {
                return (ICarrierConfigLoader)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getConfigForSubId";
                }
                case 2: {
                    return "getConfigForSubIdWithFeature";
                }
                case 3: {
                    return "overrideConfig";
                }
                case 4: {
                    return "notifyConfigChangedForSubId";
                }
                case 5: {
                    return "updateConfigForPhoneId";
                }
                case 6: {
                    return "getDefaultCarrierServicePackageName";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    PersistableBundle _result = this.getConfigForSubId(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    PersistableBundle _result = this.getConfigForSubIdWithFeature(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    PersistableBundle _arg1 = 0 != data.readInt() ? PersistableBundle.CREATOR.createFromParcel(data) : null;
                    boolean _arg2 = 0 != data.readInt();
                    this.overrideConfig(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.notifyConfigChangedForSubId(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.updateConfigForPhoneId(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _result = this.getDefaultCarrierServicePackageName();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ICarrierConfigLoader impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ICarrierConfigLoader getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ICarrierConfigLoader {
            private IBinder mRemote;
            public static ICarrierConfigLoader sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getConfigForSubId(int subId, String callingPackage) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PersistableBundle persistableBundle = Stub.getDefaultImpl().getConfigForSubId(subId, callingPackage);
                        return persistableBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PersistableBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PersistableBundle getConfigForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                PersistableBundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        PersistableBundle persistableBundle = Stub.getDefaultImpl().getConfigForSubIdWithFeature(subId, callingPackage, callingFeatureId);
                        return persistableBundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? PersistableBundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideConfig(int subId, PersistableBundle overrides, boolean persistent) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    if (overrides != null) {
                        _data.writeInt(1);
                        overrides.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(persistent ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().overrideConfig(subId, overrides, persistent);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyConfigChangedForSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyConfigChangedForSubId(subId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateConfigForPhoneId(int phoneId, String simState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(phoneId);
                    _data.writeString(simState);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateConfigForPhoneId(phoneId, simState);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultCarrierServicePackageName() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getDefaultCarrierServicePackageName();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICarrierConfigLoader {
        @Override
        public PersistableBundle getConfigForSubId(int subId, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public PersistableBundle getConfigForSubIdWithFeature(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void overrideConfig(int subId, PersistableBundle overrides, boolean persistent) throws RemoteException {
        }

        @Override
        public void notifyConfigChangedForSubId(int subId) throws RemoteException {
        }

        @Override
        public void updateConfigForPhoneId(int phoneId, String simState) throws RemoteException {
        }

        @Override
        public String getDefaultCarrierServicePackageName() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

