/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.graphics.Bitmap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.GsmAlphabet;
import com.android.telephony.Rlog;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class IccUtils {
    static final String LOG_TAG = "IccUtils";
    @VisibleForTesting
    static final int FPLMN_BYTE_SIZE = 3;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @UnsupportedAppUsage
    public static String bcdToString(byte[] data, int offset, int length) {
        int v;
        StringBuilder ret = new StringBuilder(length * 2);
        for (int i = offset; i < offset + length && (v = data[i] & 0xF) <= 9; ++i) {
            ret.append((char)(48 + v));
            v = data[i] >> 4 & 0xF;
            if (v == 15) continue;
            if (v > 9) break;
            ret.append((char)(48 + v));
        }
        return ret.toString();
    }

    public static String bcdToString(byte[] data) {
        return IccUtils.bcdToString(data, 0, data.length);
    }

    public static byte[] bcdToBytes(String bcd) {
        byte[] output = new byte[(bcd.length() + 1) / 2];
        IccUtils.bcdToBytes(bcd, output);
        return output;
    }

    public static void bcdToBytes(String bcd, byte[] bytes) {
        IccUtils.bcdToBytes(bcd, bytes, 0);
    }

    public static void bcdToBytes(String bcd, byte[] bytes, int offset) {
        if (bcd.length() % 2 != 0) {
            bcd = bcd + "0";
        }
        int size = Math.min((bytes.length - offset) * 2, bcd.length());
        int i = 0;
        int j = offset;
        while (i + 1 < size) {
            bytes[j] = (byte)(IccUtils.charToByte(bcd.charAt(i + 1)) << 4 | IccUtils.charToByte(bcd.charAt(i)));
            i += 2;
            ++j;
        }
    }

    public static String bcdPlmnToString(byte[] data, int offset) {
        if (offset + 3 > data.length) {
            return null;
        }
        byte[] trans = new byte[]{(byte)(data[0 + offset] << 4 | data[0 + offset] >> 4 & 0xF), (byte)(data[1 + offset] << 4 | data[2 + offset] & 0xF), (byte)(data[2 + offset] & 0xF0 | data[1 + offset] >> 4 & 0xF)};
        String ret = IccUtils.bytesToHexString(trans);
        if (ret.contains("F")) {
            ret = ret.replaceAll("F", "");
        }
        return ret;
    }

    public static void stringToBcdPlmn(String plmn, byte[] data, int offset) {
        char digit6 = plmn.length() > 5 ? (char)plmn.charAt(5) : (char)'F';
        data[offset] = (byte)(IccUtils.charToByte(plmn.charAt(1)) << 4 | IccUtils.charToByte(plmn.charAt(0)));
        data[offset + 1] = (byte)(IccUtils.charToByte(digit6) << 4 | IccUtils.charToByte(plmn.charAt(2)));
        data[offset + 2] = (byte)(IccUtils.charToByte(plmn.charAt(4)) << 4 | IccUtils.charToByte(plmn.charAt(3)));
    }

    public static String bchToString(byte[] data, int offset, int length) {
        StringBuilder ret = new StringBuilder(length * 2);
        for (int i = offset; i < offset + length; ++i) {
            int v = data[i] & 0xF;
            ret.append(HEX_CHARS[v]);
            v = data[i] >> 4 & 0xF;
            ret.append(HEX_CHARS[v]);
        }
        return ret.toString();
    }

    @UnsupportedAppUsage
    public static String cdmaBcdToString(byte[] data, int offset, int length) {
        StringBuilder ret = new StringBuilder(length);
        int count = 0;
        int i = offset;
        while (count < length) {
            int v = data[i] & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            if (++count == length) break;
            v = data[i] >> 4 & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            ++count;
            ++i;
        }
        return ret.toString();
    }

    @UnsupportedAppUsage
    public static int gsmBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = b >> 4 & 0xF;
        }
        if ((b & 0xF) <= 9) {
            ret += (b & 0xF) * 10;
        }
        return ret;
    }

    @UnsupportedAppUsage
    public static int cdmaBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = (b >> 4 & 0xF) * 10;
        }
        if ((b & 0xF) <= 9) {
            ret += b & 0xF;
        }
        return ret;
    }

    public static byte[] stringToAdnStringField(String alphaTag) {
        int septets = GsmAlphabet.countGsmSeptetsUsingTables(alphaTag, false, 0, 0);
        if (septets != -1) {
            byte[] ret = new byte[septets];
            GsmAlphabet.stringToGsm8BitUnpackedField(alphaTag, ret, 0, ret.length);
            return ret;
        }
        byte[] alphaTagBytes = alphaTag.getBytes(StandardCharsets.UTF_16BE);
        byte[] ret = new byte[alphaTagBytes.length + 1];
        ret[0] = -128;
        System.arraycopy(alphaTagBytes, 0, ret, 1, alphaTagBytes.length);
        return ret;
    }

    @UnsupportedAppUsage
    public static String adnStringFieldToString(byte[] data, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (length >= 1 && data[offset] == -128) {
            int ucslen = (length - 1) / 2;
            String ret = null;
            try {
                ret = new String(data, offset + 1, ucslen * 2, "utf-16be");
            }
            catch (UnsupportedEncodingException ex) {
                Rlog.e(LOG_TAG, "implausible UnsupportedEncodingException", ex);
            }
            if (ret != null) {
                for (ucslen = ret.length(); ucslen > 0 && ret.charAt(ucslen - 1) == '\uffff'; --ucslen) {
                }
                return ret.substring(0, ucslen);
            }
        }
        boolean isucs2 = false;
        int base = 0;
        int len = 0;
        if (length >= 3 && data[offset] == -127) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 3) {
                len = length - 3;
            }
            base = (char)((data[offset + 2] & 0xFF) << 7);
            offset += 3;
            isucs2 = true;
        } else if (length >= 4 && data[offset] == -126) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 4) {
                len = length - 4;
            }
            base = (char)((data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF);
            offset += 4;
            isucs2 = true;
        }
        if (isucs2) {
            StringBuilder ret = new StringBuilder();
            while (len > 0) {
                int count;
                if (data[offset] < 0) {
                    ret.append((char)(base + (data[offset] & 0x7F)));
                    ++offset;
                    --len;
                }
                for (count = 0; count < len && data[offset + count] >= 0; ++count) {
                }
                ret.append(GsmAlphabet.gsm8BitUnpackedToString(data, offset, count));
                offset += count;
                len -= count;
            }
            return ret.toString();
        }
        Resources resource = Resources.getSystem();
        String defaultCharset = "";
        try {
            defaultCharset = resource.getString(17040351);
        }
        catch (Resources.NotFoundException notFoundException) {
            // empty catch block
        }
        return GsmAlphabet.gsm8BitUnpackedToString(data, offset, length, defaultCharset.trim());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("invalid hex char '" + c + "'");
    }

    @UnsupportedAppUsage
    public static byte[] hexStringToBytes(String s) {
        if (s == null) {
            return null;
        }
        int sz = s.length();
        byte[] ret = new byte[sz / 2];
        for (int i = 0; i < sz; i += 2) {
            ret[i / 2] = (byte)(IccUtils.hexCharToInt(s.charAt(i)) << 4 | IccUtils.hexCharToInt(s.charAt(i + 1)));
        }
        return ret;
    }

    @UnsupportedAppUsage
    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0xF & bytes[i] >> 4;
            ret.append(HEX_CHARS[b]);
            b = 0xF & bytes[i];
            ret.append(HEX_CHARS[b]);
        }
        return ret.toString();
    }

    @UnsupportedAppUsage
    public static String networkNameToString(byte[] data, int offset, int length) {
        String ret;
        if ((data[offset] & 0x80) != 128 || length < 1) {
            return "";
        }
        switch (data[offset] >>> 4 & 7) {
            case 0: {
                int unusedBits = data[offset] & 7;
                int countSeptets = ((length - 1) * 8 - unusedBits) / 7;
                ret = GsmAlphabet.gsm7BitPackedToString(data, offset + 1, countSeptets);
                break;
            }
            case 1: {
                try {
                    ret = new String(data, offset + 1, length - 1, "utf-16");
                }
                catch (UnsupportedEncodingException ex) {
                    ret = "";
                    Rlog.e(LOG_TAG, "implausible UnsupportedEncodingException", ex);
                }
                break;
            }
            default: {
                ret = "";
            }
        }
        if ((data[offset] & 0x40) != 0) {
            // empty if block
        }
        return ret;
    }

    @UnsupportedAppUsage
    public static Bitmap parseToBnW(byte[] data, int length) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        int pixelIndex = 0;
        int bitIndex = 7;
        byte currentByte = 0;
        while (pixelIndex < numOfPixels) {
            if (pixelIndex % 8 == 0) {
                currentByte = data[valueIndex++];
                bitIndex = 7;
            }
            pixels[pixelIndex++] = IccUtils.bitToRGB(currentByte >> bitIndex-- & 1);
        }
        if (pixelIndex != numOfPixels) {
            Rlog.e(LOG_TAG, "parse end and size error");
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    private static int bitToRGB(int bit) {
        if (bit == 1) {
            return -1;
        }
        return -16777216;
    }

    @UnsupportedAppUsage
    public static Bitmap parseToRGB(byte[] data, int length, boolean transparency) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int bits = data[valueIndex++] & 0xFF;
        int colorNumber = data[valueIndex++] & 0xFF;
        int clutOffset = (data[valueIndex++] & 0xFF) << 8 | data[valueIndex++] & 0xFF;
        int[] colorIndexArray = IccUtils.getCLUT(data, clutOffset, colorNumber);
        if (transparency) {
            colorIndexArray[colorNumber - 1] = 0;
        }
        int[] resultArray = null;
        resultArray = 0 == 8 % bits ? IccUtils.mapTo2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits) : IccUtils.mapToNon2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits);
        return Bitmap.createBitmap(resultArray, width, height, Bitmap.Config.RGB_565);
    }

    private static int[] mapTo2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 != 8 % bits) {
            Rlog.e(LOG_TAG, "not event number of color");
            return IccUtils.mapToNon2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int mask = 1;
        switch (bits) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 3;
                break;
            }
            case 4: {
                mask = 15;
                break;
            }
            case 8: {
                mask = 255;
            }
        }
        int[] resultArray = new int[length];
        int resultIndex = 0;
        int run = 8 / bits;
        while (resultIndex < length) {
            byte tempByte = data[valueIndex++];
            for (int runIndex = 0; runIndex < run; ++runIndex) {
                int offset = run - runIndex - 1;
                resultArray[resultIndex++] = colorArray[tempByte >> offset * bits & mask];
            }
        }
        return resultArray;
    }

    private static int[] mapToNon2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 == 8 % bits) {
            Rlog.e(LOG_TAG, "not odd number of color");
            return IccUtils.mapTo2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int[] resultArray = new int[length];
        return resultArray;
    }

    private static int[] getCLUT(byte[] rawData, int offset, int number) {
        if (null == rawData) {
            return null;
        }
        int[] result = new int[number];
        int endIndex = offset + number * 3;
        int valueIndex = offset;
        int colorIndex = 0;
        int alpha = -16777216;
        do {
            result[colorIndex++] = alpha | (rawData[valueIndex++] & 0xFF) << 16 | (rawData[valueIndex++] & 0xFF) << 8 | rawData[valueIndex++] & 0xFF;
        } while (valueIndex < endIndex);
        return result;
    }

    public static String getDecimalSubstring(String iccId) {
        int position;
        for (position = 0; position < iccId.length() && Character.isDigit(iccId.charAt(position)); ++position) {
        }
        return iccId.substring(0, position);
    }

    public static int bytesToInt(byte[] src, int offset, int length) {
        if (length > 4) {
            throw new IllegalArgumentException("length must be <= 4 (only 32-bit integer supported): " + length);
        }
        if (offset < 0 || length < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: src=[" + src.length + "], offset=" + offset + ", length=" + length);
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | src[offset + i] & 0xFF;
        }
        if (result < 0) {
            throw new IllegalArgumentException("src cannot be parsed as a positive integer: " + result);
        }
        return result;
    }

    public static long bytesToRawLong(byte[] src, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("length must be <= 8 (only 64-bit long supported): " + length);
        }
        if (offset < 0 || length < 0 || offset + length > src.length) {
            throw new IndexOutOfBoundsException("Out of the bounds: src=[" + src.length + "], offset=" + offset + ", length=" + length);
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result = result << 8 | (long)(src[offset + i] & 0xFF);
        }
        return result;
    }

    public static byte[] unsignedIntToBytes(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        byte[] bytes = new byte[IccUtils.byteNumForUnsignedInt(value)];
        IccUtils.unsignedIntToBytes(value, bytes, 0);
        return bytes;
    }

    public static byte[] signedIntToBytes(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        byte[] bytes = new byte[IccUtils.byteNumForSignedInt(value)];
        IccUtils.signedIntToBytes(value, bytes, 0);
        return bytes;
    }

    public static int unsignedIntToBytes(int value, byte[] dest, int offset) {
        return IccUtils.intToBytes(value, dest, offset, false);
    }

    public static int signedIntToBytes(int value, byte[] dest, int offset) {
        return IccUtils.intToBytes(value, dest, offset, true);
    }

    public static int byteNumForUnsignedInt(int value) {
        return IccUtils.byteNumForInt(value, false);
    }

    public static int byteNumForSignedInt(int value) {
        return IccUtils.byteNumForInt(value, true);
    }

    private static int intToBytes(int value, byte[] dest, int offset, boolean signed) {
        int l = IccUtils.byteNumForInt(value, signed);
        if (offset < 0 || offset + l > dest.length) {
            throw new IndexOutOfBoundsException("Not enough space to write. Required bytes: " + l);
        }
        int i = l - 1;
        int v = value;
        while (i >= 0) {
            byte b;
            dest[offset + i] = b = (byte)(v & 0xFF);
            --i;
            v >>>= 8;
        }
        return l;
    }

    private static int byteNumForInt(int value, boolean signed) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be 0 or positive: " + value);
        }
        if (signed) {
            if (value <= 127) {
                return 1;
            }
            if (value <= Short.MAX_VALUE) {
                return 2;
            }
            if (value <= 0x7FFFFF) {
                return 3;
            }
        } else {
            if (value <= 255) {
                return 1;
            }
            if (value <= 65535) {
                return 2;
            }
            if (value <= 0xFFFFFF) {
                return 3;
            }
        }
        return 4;
    }

    public static byte countTrailingZeros(byte b) {
        if (b == 0) {
            return 8;
        }
        int v = b & 0xFF;
        byte c = 7;
        if ((v & 0xF) != 0) {
            c = (byte)(c - 4);
        }
        if ((v & 0x33) != 0) {
            c = (byte)(c - 2);
        }
        if ((v & 0x55) != 0) {
            c = (byte)(c - 1);
        }
        return c;
    }

    public static String byteToHex(byte b) {
        return new String(new char[]{HEX_CHARS[(b & 0xFF) >>> 4], HEX_CHARS[b & 0xF]});
    }

    public static String stripTrailingFs(String s) {
        return s == null ? null : s.replaceAll("(?i)f*$", "");
    }

    private static byte charToByte(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 55);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 87);
        }
        return 0;
    }

    public static byte[] encodeFplmns(List<String> fplmns, int dataLength) {
        byte[] serializedFplmns = new byte[dataLength];
        int offset = 0;
        for (String fplmn : fplmns) {
            if (offset >= dataLength) break;
            IccUtils.stringToBcdPlmn(fplmn, serializedFplmns, offset);
            offset += 3;
        }
        while (offset < dataLength) {
            serializedFplmns[offset++] = -1;
        }
        return serializedFplmns;
    }
}

