/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.util.CharsetUtils;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Objects;

public class FastDataOutput
implements DataOutput,
Flushable,
Closeable {
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private final VMRuntime mRuntime;
    private final OutputStream mOut;
    private final byte[] mBuffer;
    private final long mBufferPtr;
    private final int mBufferCap;
    private int mBufferPos;
    private HashMap<String, Short> mStringRefs = new HashMap();

    public FastDataOutput(OutputStream out, int bufferSize) {
        this.mRuntime = VMRuntime.getRuntime();
        this.mOut = Objects.requireNonNull(out);
        if (bufferSize < 8) {
            throw new IllegalArgumentException();
        }
        this.mBuffer = (byte[])this.mRuntime.newNonMovableArray(Byte.TYPE, bufferSize);
        this.mBufferPtr = this.mRuntime.addressOf(this.mBuffer);
        this.mBufferCap = this.mBuffer.length;
    }

    private void drain() throws IOException {
        if (this.mBufferPos > 0) {
            this.mOut.write(this.mBuffer, 0, this.mBufferPos);
            this.mBufferPos = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.mOut.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mBufferCap < len) {
            this.drain();
            this.mOut.write(b, off, len);
        } else {
            if (this.mBufferCap - this.mBufferPos < len) {
                this.drain();
            }
            System.arraycopy(b, off, this.mBuffer, this.mBufferPos, len);
            this.mBufferPos += len;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len;
        if (this.mBufferCap - this.mBufferPos < 2 + s.length()) {
            this.drain();
        }
        if (Math.abs(len = CharsetUtils.toModifiedUtf8Bytes(s, this.mBufferPtr, this.mBufferPos + 2, this.mBufferCap)) > 65535) {
            throw new IOException("Modified UTF-8 length too large: " + len);
        }
        if (len >= 0) {
            this.writeShort(len);
            this.mBufferPos += len;
        } else {
            len = -len;
            byte[] tmp = (byte[])this.mRuntime.newNonMovableArray(Byte.TYPE, len + 1);
            CharsetUtils.toModifiedUtf8Bytes(s, this.mRuntime.addressOf(tmp), 0, tmp.length);
            this.writeShort(len);
            this.write(tmp, 0, len);
        }
    }

    public void writeInternedUTF(String s) throws IOException {
        Short ref = this.mStringRefs.get(s);
        if (ref != null) {
            this.writeShort(ref.shortValue());
        } else {
            this.writeShort(65535);
            this.writeUTF(s);
            ref = (short)this.mStringRefs.size();
            if (ref < 65535) {
                this.mStringRefs.put(s, ref);
            }
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.writeByte(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.mBufferCap - this.mBufferPos < 1) {
            this.drain();
        }
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 0 & 0xFF);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.mBufferCap - this.mBufferPos < 2) {
            this.drain();
        }
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 8 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 0 & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort((short)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.mBufferCap - this.mBufferPos < 4) {
            this.drain();
        }
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 24 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 16 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 8 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(v >> 0 & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.mBufferCap - this.mBufferPos < 8) {
            this.drain();
        }
        int i = (int)(v >> 32);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 24 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 16 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 8 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 0 & 0xFF);
        i = (int)v;
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 24 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 16 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 8 & 0xFF);
        this.mBuffer[this.mBufferPos++] = (byte)(i >> 0 & 0xFF);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new UnsupportedOperationException();
    }
}

