/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.graphics.Insets;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import java.util.function.Consumer;

public class ScreenshotHelper {
    public static final int SCREENSHOT_MSG_URI = 1;
    public static final int SCREENSHOT_MSG_PROCESS_COMPLETE = 2;
    private static final String TAG = "ScreenshotHelper";
    private final int SCREENSHOT_TIMEOUT_MS = 10000;
    private final Object mScreenshotLock = new Object();
    private IBinder mScreenshotService = null;
    private ServiceConnection mScreenshotConnection = null;
    private final Context mContext;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = ScreenshotHelper.this.mScreenshotLock;
            synchronized (object) {
                if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                    ScreenshotHelper.this.resetConnection();
                }
            }
        }
    };

    public ScreenshotHelper(Context context) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
    }

    public void takeScreenshot(int screenshotType, boolean hasStatus, boolean hasNav, int source, Handler handler, Consumer<Uri> completionConsumer) {
        ScreenshotRequest screenshotRequest = new ScreenshotRequest(source, hasStatus, hasNav);
        this.takeScreenshot(screenshotType, 10000L, handler, screenshotRequest, completionConsumer);
    }

    public void takeScreenshot(int screenshotType, boolean hasStatus, boolean hasNav, Handler handler, Consumer<Uri> completionConsumer) {
        this.takeScreenshot(screenshotType, hasStatus, hasNav, 10000, handler, completionConsumer);
    }

    public void takeScreenshot(int screenshotType, boolean hasStatus, boolean hasNav, long timeoutMs, Handler handler, Consumer<Uri> completionConsumer) {
        ScreenshotRequest screenshotRequest = new ScreenshotRequest(5, hasStatus, hasNav);
        this.takeScreenshot(screenshotType, timeoutMs, handler, screenshotRequest, completionConsumer);
    }

    public void provideScreenshot(Bundle screenshotBundle, Rect boundsInScreen, Insets insets, int taskId, int userId, ComponentName topComponent, int source, Handler handler, Consumer<Uri> completionConsumer) {
        ScreenshotRequest screenshotRequest = new ScreenshotRequest(source, screenshotBundle, boundsInScreen, insets, taskId, userId, topComponent);
        this.takeScreenshot(3, 10000L, handler, screenshotRequest, completionConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeScreenshot(int screenshotType, long timeoutMs, final Handler handler, ScreenshotRequest screenshotRequest, final Consumer<Uri> completionConsumer) {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            final Runnable mScreenshotTimeout = () -> {
                Object object = this.mScreenshotLock;
                synchronized (object) {
                    if (this.mScreenshotConnection != null) {
                        Log.e(TAG, "Timed out before getting screenshot capture response");
                        this.resetConnection();
                        this.notifyScreenshotError();
                    }
                }
                if (completionConsumer != null) {
                    completionConsumer.accept(null);
                }
            };
            final Message msg = Message.obtain(null, screenshotType, screenshotRequest);
            Handler h = new Handler(handler.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            if (completionConsumer != null) {
                                completionConsumer.accept((Uri)msg.obj);
                            }
                            handler.removeCallbacks(mScreenshotTimeout);
                            break;
                        }
                        case 2: {
                            Object object = ScreenshotHelper.this.mScreenshotLock;
                            synchronized (object) {
                                ScreenshotHelper.this.resetConnection();
                                break;
                            }
                        }
                    }
                }
            };
            msg.replyTo = new Messenger(h);
            if (this.mScreenshotConnection == null || this.mScreenshotService == null) {
                ComponentName serviceComponent = ComponentName.unflattenFromString(this.mContext.getResources().getString(17039990));
                Intent serviceIntent = new Intent();
                serviceIntent.setComponent(serviceComponent);
                ServiceConnection conn = new ServiceConnection(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onServiceConnected(ComponentName name, IBinder service) {
                        Object object = ScreenshotHelper.this.mScreenshotLock;
                        synchronized (object) {
                            block6: {
                                if (ScreenshotHelper.this.mScreenshotConnection != this) {
                                    return;
                                }
                                ScreenshotHelper.this.mScreenshotService = service;
                                Messenger messenger = new Messenger(ScreenshotHelper.this.mScreenshotService);
                                try {
                                    messenger.send(msg);
                                }
                                catch (RemoteException e) {
                                    Log.e(ScreenshotHelper.TAG, "Couldn't take screenshot: " + e);
                                    if (completionConsumer == null) break block6;
                                    completionConsumer.accept(null);
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Object object = ScreenshotHelper.this.mScreenshotLock;
                        synchronized (object) {
                            if (ScreenshotHelper.this.mScreenshotConnection != null) {
                                ScreenshotHelper.this.resetConnection();
                                if (handler.hasCallbacks(mScreenshotTimeout)) {
                                    Log.e(ScreenshotHelper.TAG, "Screenshot service disconnected");
                                    handler.removeCallbacks(mScreenshotTimeout);
                                    ScreenshotHelper.this.notifyScreenshotError();
                                }
                            }
                        }
                    }
                };
                if (this.mContext.bindServiceAsUser(serviceIntent, conn, 0x4000001, UserHandle.CURRENT)) {
                    this.mScreenshotConnection = conn;
                    handler.postDelayed(mScreenshotTimeout, timeoutMs);
                }
            } else {
                block8: {
                    Messenger messenger = new Messenger(this.mScreenshotService);
                    try {
                        messenger.send(msg);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Couldn't take screenshot: " + e);
                        if (completionConsumer == null) break block8;
                        completionConsumer.accept(null);
                    }
                }
                handler.postDelayed(mScreenshotTimeout, timeoutMs);
            }
        }
    }

    private void resetConnection() {
        if (this.mScreenshotConnection != null) {
            this.mContext.unbindService(this.mScreenshotConnection);
            this.mScreenshotConnection = null;
            this.mScreenshotService = null;
        }
    }

    private void notifyScreenshotError() {
        ComponentName errorComponent = ComponentName.unflattenFromString(this.mContext.getResources().getString(17039989));
        Intent errorIntent = new Intent("android.intent.action.USER_PRESENT");
        errorIntent.setComponent(errorComponent);
        errorIntent.addFlags(0x14000000);
        this.mContext.sendBroadcastAsUser(errorIntent, UserHandle.CURRENT);
    }

    public static class ScreenshotRequest
    implements Parcelable {
        private int mSource;
        private boolean mHasStatusBar;
        private boolean mHasNavBar;
        private Bundle mBitmapBundle;
        private Rect mBoundsInScreen;
        private Insets mInsets;
        private int mTaskId;
        private int mUserId;
        private ComponentName mTopComponent;
        public static final Parcelable.Creator<ScreenshotRequest> CREATOR = new Parcelable.Creator<ScreenshotRequest>(){

            @Override
            public ScreenshotRequest createFromParcel(Parcel source) {
                return new ScreenshotRequest(source);
            }

            public ScreenshotRequest[] newArray(int size) {
                return new ScreenshotRequest[size];
            }
        };

        ScreenshotRequest(int source, boolean hasStatus, boolean hasNav) {
            this.mSource = source;
            this.mHasStatusBar = hasStatus;
            this.mHasNavBar = hasNav;
        }

        ScreenshotRequest(int source, Bundle bitmapBundle, Rect boundsInScreen, Insets insets, int taskId, int userId, ComponentName topComponent) {
            this.mSource = source;
            this.mBitmapBundle = bitmapBundle;
            this.mBoundsInScreen = boundsInScreen;
            this.mInsets = insets;
            this.mTaskId = taskId;
            this.mUserId = userId;
            this.mTopComponent = topComponent;
        }

        ScreenshotRequest(Parcel in) {
            this.mSource = in.readInt();
            this.mHasStatusBar = in.readBoolean();
            this.mHasNavBar = in.readBoolean();
            if (in.readInt() == 1) {
                this.mBitmapBundle = in.readBundle(this.getClass().getClassLoader());
                this.mBoundsInScreen = (Rect)in.readParcelable(Rect.class.getClassLoader());
                this.mInsets = (Insets)in.readParcelable(Insets.class.getClassLoader());
                this.mTaskId = in.readInt();
                this.mUserId = in.readInt();
                this.mTopComponent = (ComponentName)in.readParcelable(ComponentName.class.getClassLoader());
            }
        }

        public int getSource() {
            return this.mSource;
        }

        public boolean getHasStatusBar() {
            return this.mHasStatusBar;
        }

        public boolean getHasNavBar() {
            return this.mHasNavBar;
        }

        public Bundle getBitmapBundle() {
            return this.mBitmapBundle;
        }

        public Rect getBoundsInScreen() {
            return this.mBoundsInScreen;
        }

        public Insets getInsets() {
            return this.mInsets;
        }

        public int getTaskId() {
            return this.mTaskId;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public ComponentName getTopComponent() {
            return this.mTopComponent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSource);
            dest.writeBoolean(this.mHasStatusBar);
            dest.writeBoolean(this.mHasNavBar);
            if (this.mBitmapBundle == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeBundle(this.mBitmapBundle);
                dest.writeParcelable(this.mBoundsInScreen, 0);
                dest.writeParcelable(this.mInsets, 0);
                dest.writeInt(this.mTaskId);
                dest.writeInt(this.mUserId);
                dest.writeParcelable(this.mTopComponent, 0);
            }
        }
    }
}

