/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.ScrollCaptureViewHelper;

public class ScrollViewCaptureHelper
implements ScrollCaptureViewHelper<ViewGroup> {
    private int mStartScrollY;
    private boolean mScrollBarEnabled;
    private int mOverScrollMode;

    @Override
    public void onPrepareForStart(ViewGroup view, Rect scrollBounds) {
        this.mStartScrollY = view.getScrollY();
        this.mOverScrollMode = view.getOverScrollMode();
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(2);
        }
        this.mScrollBarEnabled = view.isVerticalScrollBarEnabled();
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(false);
        }
    }

    @Override
    public ScrollCaptureViewHelper.ScrollResult onScrollRequested(ViewGroup view, Rect scrollBounds, Rect requestRect) {
        int scrollDelta = view.getScrollY() - this.mStartScrollY;
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.scrollDelta = scrollDelta;
        result.availableArea = new Rect();
        View contentView = view.getChildAt(0);
        if (contentView == null) {
            return result;
        }
        Rect requestedContainerBounds = new Rect(requestRect);
        requestedContainerBounds.offset(0, -scrollDelta);
        requestedContainerBounds.offset(scrollBounds.left, scrollBounds.top);
        Rect requestedContentBounds = new Rect(requestedContainerBounds);
        requestedContentBounds.offset(view.getScrollX() - contentView.getLeft(), view.getScrollY() - contentView.getTop());
        Rect input = new Rect(requestedContentBounds);
        int remainingHeight = view.getHeight() - view.getPaddingTop() - view.getPaddingBottom() - input.height();
        if (remainingHeight > 0) {
            input.inset(0, -remainingHeight / 2);
        }
        contentView.requestRectangleOnScreen(input, true);
        result.scrollDelta = scrollDelta = view.getScrollY() - this.mStartScrollY;
        Point offset = new Point();
        Rect available = new Rect(requestedContentBounds);
        if (!view.getChildVisibleRect(contentView, available, offset)) {
            available.setEmpty();
            result.availableArea = available;
            return result;
        }
        available.offset(-offset.x, -offset.y);
        available.offset(contentView.getLeft() - view.getScrollX(), contentView.getTop() - view.getScrollY());
        available.offset(-scrollBounds.left, -scrollBounds.top);
        available.offset(0, scrollDelta);
        result.availableArea = new Rect(available);
        return result;
    }

    @Override
    public void onPrepareForEnd(ViewGroup view) {
        view.scrollTo(0, this.mStartScrollY);
        if (this.mOverScrollMode != 2) {
            view.setOverScrollMode(this.mOverScrollMode);
        }
        if (this.mScrollBarEnabled) {
            view.setVerticalScrollBarEnabled(true);
        }
    }
}

