/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.LocalImageResolver;
import java.io.IOException;

@RemoteViews.RemoteView
public class BigPictureNotificationImageView
extends ImageView {
    private static final String TAG = BigPictureNotificationImageView.class.getSimpleName();

    public BigPictureNotificationImageView(Context context) {
        super(context);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(Uri uri) {
        this.setImageDrawable(this.loadImage(uri));
    }

    @Override
    public Runnable setImageURIAsync(Uri uri) {
        Drawable drawable2 = this.loadImage(uri);
        return () -> this.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon) {
        this.setImageDrawable(this.loadImage(icon));
    }

    @Override
    public Runnable setImageIconAsync(Icon icon) {
        Drawable drawable2 = this.loadImage(icon);
        return () -> this.setImageDrawable(drawable2);
    }

    private Drawable loadImage(Uri uri) {
        if (uri == null) {
            return null;
        }
        try {
            return LocalImageResolver.resolveImage(uri, this.mContext);
        }
        catch (IOException ex) {
            Log.d(TAG, "Resolve failed from " + uri, ex);
            return null;
        }
    }

    private Drawable loadImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        try {
            return LocalImageResolver.resolveImage(icon, this.mContext);
        }
        catch (IOException ex) {
            Log.d(TAG, "Resolve failed from " + icon, ex);
            return null;
        }
    }
}

