/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import java.util.LinkedList;
import java.util.List;

@RemoteViews.RemoteView
public class ConversationHeaderLinearLayout
extends LinearLayout {
    public ConversationHeaderLinearLayout(Context context) {
        super(context);
    }

    public ConversationHeaderLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConversationHeaderLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private int calculateTotalChildLength() {
        int count = this.getChildCount();
        int totalLength = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            totalLength += child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
        }
        return totalLength + this.getPaddingLeft() + this.getPaddingRight();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int containerWidth = this.getMeasuredWidth();
        int contentsWidth = this.calculateTotalChildLength();
        int excessContents = contentsWidth - containerWidth;
        if (excessContents <= 0) {
            return;
        }
        int count = this.getChildCount();
        float remainingWeight = 0.0f;
        LinkedList<ViewInfo> visibleChildrenToShorten = null;
        for (int i = 0; i < count; ++i) {
            float weight;
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8 || (weight = ((LinearLayout.LayoutParams)child.getLayoutParams()).weight) == 0.0f || child.getMeasuredWidth() == 0) continue;
            if (visibleChildrenToShorten == null) {
                visibleChildrenToShorten = new LinkedList<ViewInfo>();
            }
            visibleChildrenToShorten.add(new ViewInfo(child));
            remainingWeight += Math.max(0.0f, weight);
        }
        if (visibleChildrenToShorten == null || visibleChildrenToShorten.isEmpty()) {
            return;
        }
        this.balanceViewWidths((List<ViewInfo>)visibleChildrenToShorten, remainingWeight, excessContents);
        this.remeasureChangedChildren((List<ViewInfo>)visibleChildrenToShorten);
    }

    private void remeasureChangedChildren(List<ViewInfo> childrenInfo) {
        for (ViewInfo info : childrenInfo) {
            if (info.mWidth == info.mStartWidth) continue;
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, info.mWidth), 0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(info.mView.getMeasuredHeight(), 0x40000000);
            info.mView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    void balanceViewWidths(List<ViewInfo> viewInfos, float weightSum, int excessContents) {
        boolean performAnotherPass = true;
        while (performAnotherPass && excessContents > 0 && weightSum > 0.0f) {
            int excessRemovedDuringThisPass = 0;
            float weightSumForNextPass = 0.0f;
            performAnotherPass = false;
            for (ViewInfo info : viewInfos) {
                if (info.mWeight <= 0.0f || info.mWidth <= 0) continue;
                int newWidth = (int)((float)info.mWidth - (float)excessContents * (info.mWeight / weightSum));
                if (newWidth < 0) {
                    newWidth = 0;
                    performAnotherPass = true;
                }
                excessRemovedDuringThisPass += info.mWidth - newWidth;
                info.mWidth = newWidth;
                if (info.mWidth <= 0) continue;
                weightSumForNextPass += info.mWeight;
            }
            excessContents -= excessRemovedDuringThisPass;
            weightSum = weightSumForNextPass;
        }
    }

    static class ViewInfo {
        final View mView;
        final float mWeight;
        final int mStartWidth;
        int mWidth;

        ViewInfo(View view) {
            this.mView = view;
            this.mWeight = ((LinearLayout.LayoutParams)view.getLayoutParams()).weight;
            this.mStartWidth = this.mWidth = view.getMeasuredWidth();
        }
    }
}

