/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class MediaNotificationView
extends FrameLayout {
    private ArrayList<VisibilityChangeListener> mListeners;

    public MediaNotificationView(Context context) {
        this(context, null);
    }

    public MediaNotificationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public MediaNotificationView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (this.mListeners != null) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.get(i).onAggregatedVisibilityChanged(isVisible);
            }
        }
    }

    public void addVisibilityListener(VisibilityChangeListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeVisibilityListener(VisibilityChangeListener listener) {
        if (this.mListeners != null) {
            this.mListeners.remove(listener);
        }
    }

    public static interface VisibilityChangeListener {
        public void onAggregatedVisibilityChanged(boolean var1);
    }
}

