/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.view.DisplayCutout;
import android.view.DisplayInfo;
import android.view.View;

class DisplayCutoutView
extends View {
    private final DisplayInfo mInfo = new DisplayInfo();
    private final Paint mPaint = new Paint();
    private final Region mBounds = new Region();
    private final Rect mBoundingRect = new Rect();
    private final Path mBoundingPath = new Path();
    private final int[] mLocation = new int[2];
    private final boolean mStart;

    public DisplayCutoutView(Context context, boolean start) {
        super(context);
        this.mStart = start;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.update();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.getLocationOnScreen(this.mLocation);
        canvas.translate(-this.mLocation[0], -this.mLocation[1]);
        if (!this.mBoundingPath.isEmpty()) {
            this.mPaint.setColor(-16777216);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawPath(this.mBoundingPath, this.mPaint);
        }
    }

    private void update() {
        int newVisible;
        this.requestLayout();
        this.getDisplay().getDisplayInfo(this.mInfo);
        this.mBounds.setEmpty();
        this.mBoundingRect.setEmpty();
        this.mBoundingPath.reset();
        if (this.hasCutout()) {
            this.mBounds.set(this.mInfo.displayCutout.getBoundingRectTop());
            this.localBounds(this.mBoundingRect);
            this.mBounds.getBoundaryPath(this.mBoundingPath);
            newVisible = 0;
        } else {
            newVisible = 8;
        }
        if (newVisible != this.getVisibility()) {
            this.setVisibility(newVisible);
        }
    }

    private boolean hasCutout() {
        DisplayCutout displayCutout = this.mInfo.displayCutout;
        if (displayCutout == null) {
            return false;
        }
        if (this.mStart) {
            return displayCutout.getSafeInsetLeft() > 0 || displayCutout.getSafeInsetTop() > 0;
        }
        return displayCutout.getSafeInsetRight() > 0 || displayCutout.getSafeInsetBottom() > 0;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mBounds.isEmpty()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        this.setMeasuredDimension(DisplayCutoutView.resolveSizeAndState(this.mBoundingRect.width(), widthMeasureSpec, 0), DisplayCutoutView.resolveSizeAndState(this.mBoundingRect.height(), heightMeasureSpec, 0));
    }

    public static void boundsFromDirection(DisplayCutout displayCutout, int gravity, Rect out) {
        Region bounds = new Region(displayCutout.getBoundingRectTop());
        switch (gravity) {
            case 48: {
                bounds.op(0, 0, Integer.MAX_VALUE, displayCutout.getSafeInsetTop(), Region.Op.INTERSECT);
                out.set(bounds.getBounds());
                break;
            }
            case 3: {
                bounds.op(0, 0, displayCutout.getSafeInsetLeft(), Integer.MAX_VALUE, Region.Op.INTERSECT);
                out.set(bounds.getBounds());
                break;
            }
            case 80: {
                bounds.op(0, displayCutout.getSafeInsetTop() + 1, Integer.MAX_VALUE, Integer.MAX_VALUE, Region.Op.INTERSECT);
                out.set(bounds.getBounds());
                break;
            }
            case 5: {
                bounds.op(displayCutout.getSafeInsetLeft() + 1, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, Region.Op.INTERSECT);
                out.set(bounds.getBounds());
            }
        }
        bounds.recycle();
    }

    private void localBounds(Rect out) {
        DisplayCutout displayCutout = this.mInfo.displayCutout;
        if (this.mStart) {
            if (displayCutout.getSafeInsetLeft() > 0) {
                DisplayCutoutView.boundsFromDirection(displayCutout, 3, out);
            } else if (displayCutout.getSafeInsetTop() > 0) {
                DisplayCutoutView.boundsFromDirection(displayCutout, 48, out);
            }
        } else if (displayCutout.getSafeInsetRight() > 0) {
            DisplayCutoutView.boundsFromDirection(displayCutout, 5, out);
        } else if (displayCutout.getSafeInsetBottom() > 0) {
            DisplayCutoutView.boundsFromDirection(displayCutout, 80, out);
        }
    }
}

