/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.impl.binding.AdapterHelper;
import com.android.layoutlib.bridge.impl.binding.AdapterItem;
import java.util.ArrayList;
import java.util.List;

public class FakeAdapter
extends BaseAdapter {
    private final List<ResourceReference> mTypes = new ArrayList<ResourceReference>();
    private final LayoutlibCallback mCallback;
    private final ResourceReference mAdapterRef;
    private final List<AdapterItem> mItems = new ArrayList<AdapterItem>();
    private boolean mSkipCallbackParser = false;

    public FakeAdapter(ResourceReference adapterRef, AdapterBinding binding, LayoutlibCallback callback) {
        this.mAdapterRef = adapterRef;
        this.mCallback = callback;
        int repeatCount = binding.getRepeatCount();
        int itemCount = binding.getItemCount();
        int[] typeCount = new int[itemCount];
        for (int r = 0; r < repeatCount; ++r) {
            for (DataBindingItem dataBindingItem : binding) {
                ResourceReference viewRef = dataBindingItem.getViewReference();
                int typeIndex = this.mTypes.indexOf(viewRef);
                if (typeIndex == -1) {
                    typeIndex = this.mTypes.size();
                    this.mTypes.add(viewRef);
                }
                int count = dataBindingItem.getCount();
                int index = typeCount[typeIndex];
                int n = typeIndex;
                typeCount[n] = typeCount[n] + count;
                for (int k = 0; k < count; ++k) {
                    this.mItems.add(new AdapterItem(dataBindingItem, typeIndex, this.mItems.size(), index++));
                }
            }
        }
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    @Override
    public int getCount() {
        return this.mItems.size();
    }

    @Override
    public Object getItem(int position) {
        return this.mItems.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemViewType(int position) {
        return this.mItems.get(position).getType();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        AdapterItem item = this.mItems.get(position);
        Pair<View, Boolean> pair = AdapterHelper.getView(item, null, parent, this.mCallback, this.mAdapterRef, this.mSkipCallbackParser);
        this.mSkipCallbackParser = (Boolean)pair.second;
        return (View)pair.first;
    }

    @Override
    public int getViewTypeCount() {
        return this.mTypes.size();
    }

    @Override
    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return null;
    }
}

