/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EditableContentDescCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 1;
    public static final int RESULT_ID_EDITABLE_TEXTVIEW_CONTENT_DESC = 2;
    public static final int RESULT_ID_NOT_EDITABLE_TEXTVIEW = 3;

    @Override
    protected String getHelpTopic() {
        return "6378120";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = EditableContentDescCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!viewHierarchyElement.isImportantForAccessibility()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (Boolean.TRUE.equals(viewHierarchyElement.isEditable()) || viewHierarchyElement.checkInstanceOf("android.widget.EditText")) {
                if (TextUtils.isEmpty(viewHierarchyElement.getContentDescription())) continue;
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.ERROR, viewHierarchyElement, 2, null));
                continue;
            }
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return EditableContentDescCheck.generateMessageForResultId(locale, resultId);
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return EditableContentDescCheck.generateMessageForResultId(locale, resultId);
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_editable_content_desc");
    }

    private static String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_editable_textview_content_desc");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_not_editable_textview");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }
}

