/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.HashMapResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.replacements.LayoutParams;
import com.google.android.apps.common.testing.accessibility.framework.replacements.SpannableString;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DisplayInfo;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TextSizeCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_TEXT_VIEW = 2;
    public static final int RESULT_ID_TEXTVIEW_EMPTY = 3;
    public static final int RESULT_ID_SMALL_FIXED_TEXT_SIZE = 4;
    public static final int RESULT_ID_FIXED_TEXT_SIZE = 5;
    public static final int RESULT_ID_FIXED_SIZE_TEXT_VIEW_WITH_SCALABLE_TEXT = 6;
    public static final int RESULT_ID_FIXED_SIZE_VIEW_GROUP_WITH_SCALABLE_TEXT = 7;
    public static final int RESULT_ID_TEXT_SIZE_NOT_AVAILABLE = 8;
    @VisibleForTesting
    static final float MIN_TEXT_SIZE = 16.0f;
    @VisibleForTesting
    static final float ADEQUATE_TEXT_SIZE = 28.0f;
    @VisibleForTesting
    static final int COMPLEX_UNIT_DIP = 1;
    @VisibleForTesting
    static final int COMPLEX_UNIT_IN = 4;
    @VisibleForTesting
    static final int COMPLEX_UNIT_MM = 5;
    @VisibleForTesting
    static final int COMPLEX_UNIT_PX = 0;
    @VisibleForTesting
    static final int COMPLEX_UNIT_PT = 3;
    @VisibleForTesting
    static final int COMPLEX_UNIT_SP = 2;
    private static final ImmutableMap<Integer, String> SIZE_UNIT_TO_STRING_MAP = ImmutableMap.builder().put((Object)1, (Object)"dip").put((Object)4, (Object)"in").put((Object)5, (Object)"mm").put((Object)3, (Object)"pt").put((Object)0, (Object)"px").build();
    public static final String KEY_TEXT_SIZE_UNIT = "KEY_TEXT_SIZE_UNIT";
    public static final String KEY_TEXT = "KEY_TEXT";
    private static final Class<? extends AccessibilityHierarchyCheck> CHECK_CLASS = TextSizeCheck.class;

    @Override
    protected @Nullable String getHelpTopic() {
        return null;
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = TextSizeCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.checkInstanceOf("android.widget.TextView")) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            if (TextUtils.isEmpty(viewHierarchyElement.getText()) && TextUtils.isEmpty(viewHierarchyElement.getHintText())) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 3, null));
                continue;
            }
            Float textSize = viewHierarchyElement.getTextSize();
            Integer textSizeUnit = viewHierarchyElement.getTextSizeUnit();
            if (textSize == null || textSizeUnit == null) {
                results.add(new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, null, 8, null));
                continue;
            }
            AccessibilityHierarchyCheckResult result = textSizeUnit == 2 ? TextSizeCheck.checkTextViewWithScalingText(viewHierarchyElement) : TextSizeCheck.checkTextViewWithNonScalingText(hierarchy, viewHierarchyElement, textSize.floatValue(), textSizeUnit);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextSizeCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 5: {
                return "Consider specifying the textSize in Scalable Pixels (sp).";
            }
            case 4: {
                return "This text is small and may be difficult for some users to read. Consider using a larger size or specifying the textSize in Scalable Pixels (sp).";
            }
            case 6: 
            case 7: {
                return "Something more descriptive here.";
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        String generated = TextSizeCheck.generateMessageForResultId(locale, resultId);
        if (generated != null) {
            return generated;
        }
        switch (resultId) {
            case 4: 
            case 5: {
                Preconditions.checkNotNull((Object)metadata);
                return String.format(locale, "Text size is specified in units of '%s'", TextSizeCheck.unitToString(metadata.getInt(KEY_TEXT_SIZE_UNIT)));
            }
            case 6: {
                return "This TextView has a fixed size and scalable text.";
            }
            case 7: {
                return String.format(locale, "This ViewGroup has a fixed size and contains a TextView with the scalable text \"%s\".", ((ResultMetadata)Preconditions.checkNotNull((Object)metadata)).getString(KEY_TEXT));
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_text_size");
    }

    private static @Nullable String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 8: {
                return "Text size data is not available.";
            }
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_text_view");
            }
            case 3: {
                return StringManager.getString(locale, "result_message_textview_empty");
            }
        }
        return null;
    }

    private static @Nullable AccessibilityHierarchyCheckResult checkTextViewWithScalingText(ViewHierarchyElement view) {
        LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams != null && TextSizeCheck.isFixed(layoutParams.getWidth()) && TextSizeCheck.isFixed(layoutParams.getHeight())) {
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, 6, null);
        }
        return TextSizeCheck.checkViewGroupWithTextViewWithScalingText(view.getParentView(), view);
    }

    private static @Nullable AccessibilityHierarchyCheckResult checkViewGroupWithTextViewWithScalingText(@Nullable ViewHierarchyElement viewGroup, ViewHierarchyElement textView) {
        if (viewGroup == null) {
            return null;
        }
        LayoutParams parentLayoutParams = viewGroup.getLayoutParams();
        if (parentLayoutParams != null && TextSizeCheck.isFixed(parentLayoutParams.getWidth()) && TextSizeCheck.isFixed(parentLayoutParams.getHeight())) {
            HashMapResultMetadata metadata = new HashMapResultMetadata();
            metadata.putString(KEY_TEXT, ((SpannableString)Preconditions.checkNotNull((Object)textView.getText())).toString());
            return new AccessibilityHierarchyCheckResult(CHECK_CLASS, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewGroup, 7, metadata);
        }
        return TextSizeCheck.checkViewGroupWithTextViewWithScalingText(viewGroup.getParentView(), textView);
    }

    private static boolean isFixed(int dimension) {
        return dimension != -1 && dimension != -2 && dimension != 0;
    }

    private static @Nullable AccessibilityHierarchyCheckResult checkTextViewWithNonScalingText(AccessibilityHierarchy hierarchy, ViewHierarchyElement view, float textSize, int textSizeUnit) {
        float textSizeDp = textSize / TextSizeCheck.getDensity(hierarchy);
        if (textSizeDp >= 28.0f) {
            return null;
        }
        boolean isSmall = textSizeDp < 16.0f;
        HashMapResultMetadata metadata = new HashMapResultMetadata();
        metadata.putInt(KEY_TEXT_SIZE_UNIT, textSizeUnit);
        return new AccessibilityHierarchyCheckResult(CHECK_CLASS, isSmall ? AccessibilityCheckResult.AccessibilityCheckResultType.ERROR : AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, view, isSmall ? 4 : 5, metadata);
    }

    private static String unitToString(int unit) {
        return (String)SIZE_UNIT_TO_STRING_MAP.getOrDefault((Object)unit, (Object)"?");
    }

    private static float getDensity(AccessibilityHierarchy hierarchy) {
        return ((DisplayInfo.Metrics)Preconditions.checkNotNull((Object)hierarchy.getDeviceState().getDefaultDisplayInfo().getRealMetrics())).getScaledDensity();
    }
}

