/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionProducer;
import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestionsProvider;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseFixSuggestionsProvider<T extends AccessibilityHierarchyCheck>
implements FixSuggestionsProvider {
    BaseFixSuggestionsProvider() {
    }

    @Override
    public ImmutableList<FixSuggestion> provideFixSuggestions(AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        if (checkResult.getType() == AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN || checkResult.getType() == AccessibilityCheckResult.AccessibilityCheckResultType.SUPPRESSED) {
            return ImmutableList.of();
        }
        if (!Objects.equals(checkResult.getSourceCheckClass(), this.getTargetCheckClass())) {
            return ImmutableList.of();
        }
        ImmutableList.Builder fixSuggestionBuilder = new ImmutableList.Builder();
        for (FixSuggestionProducer suggestionProducer : this.getFixSuggestionProducers()) {
            Object suggestion = suggestionProducer.produceFixSuggestion(checkResult, hierarchy, parameters);
            if (suggestion == null) continue;
            fixSuggestionBuilder.add(suggestion);
        }
        return this.sortFixSuggestions((ImmutableList<FixSuggestion>)fixSuggestionBuilder.build(), checkResult, hierarchy, parameters);
    }

    protected abstract ImmutableList<FixSuggestionProducer<? extends FixSuggestion>> getFixSuggestionProducers();

    protected ImmutableList<FixSuggestion> sortFixSuggestions(ImmutableList<FixSuggestion> fixSuggestions, AccessibilityHierarchyCheckResult checkResult, AccessibilityHierarchy hierarchy, @Nullable Parameters parameters) {
        return fixSuggestions;
    }

    protected abstract Class<T> getTargetCheckClass();
}

