/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.os._Original_Build;
import android.util.Size;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

class AccessibilityNodeInfoExtraDataExtractor {
    private static final boolean AT_26 = _Original_Build.VERSION.SDK_INT >= 26;
    private final boolean obtainCharacterLocations;
    private final boolean obtainRenderingInfo;

    AccessibilityNodeInfoExtraDataExtractor(boolean obtainCharacterLocations, boolean obtainRenderingInfo) {
        this.obtainCharacterLocations = obtainCharacterLocations;
        this.obtainRenderingInfo = obtainRenderingInfo;
    }

    ExtraData getExtraData(AccessibilityNodeInfo fromInfo) {
        ExtraData extraData = new ExtraData();
        if (this.obtainCharacterLocations && _Original_Build.VERSION.SDK_INT >= 26) {
            AccessibilityNodeInfoExtraDataExtractor.fetchTextCharacterLocations(fromInfo, extraData);
        }
        if (this.obtainRenderingInfo && _Original_Build.VERSION.SDK_INT >= 30) {
            AccessibilityNodeInfoExtraDataExtractor.fetchRenderingInfo(fromInfo, extraData);
        }
        return extraData;
    }

    ImmutableList<Rect> getTextCharacterLocations(TextView textView) {
        return this.obtainCharacterLocations && AT_26 ? AccessibilityNodeInfoExtraDataExtractor.getTextCharacterLocationsAux(textView) : ImmutableList.of();
    }

    @RequiresApi(value=30)
    private static ImmutableList<Rect> getTextCharacterLocationsAux(TextView textView) {
        CharSequence text = textView.getText();
        if (TextUtils.isEmpty(text)) {
            return ImmutableList.of();
        }
        AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain();
        Bundle args = AccessibilityNodeInfoExtraDataExtractor.createTextCharacterLocationsRequestBundle(text);
        textView.addExtraDataToAccessibilityNodeInfo(nodeInfo, "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", args);
        ImmutableList<Rect> locations = AccessibilityNodeInfoExtraDataExtractor.parseCharacterLocationsFromExtras(nodeInfo.getExtras());
        return locations == null ? ImmutableList.of() : locations;
    }

    @RequiresApi(value=30)
    private static void fetchRenderingInfo(AccessibilityNodeInfo fromInfo, ExtraData extraData) {
        block6: {
            Bundle args = new Bundle();
            try {
                AccessibilityNodeInfo.ExtraRenderingInfo extraRenderingInfo;
                if (fromInfo.refreshWithExtraData("android.view.accessibility.extra.DATA_RENDERING_INFO_KEY", args) && (extraRenderingInfo = fromInfo.getExtraRenderingInfo()) != null) {
                    Size layoutSize;
                    int textSizeUnit;
                    float size = extraRenderingInfo.getTextSizeInPx();
                    if (size >= 0.0f) {
                        extraData.setTextSize(Float.valueOf(size));
                    }
                    if ((textSizeUnit = extraRenderingInfo.getTextSizeUnit()) >= 0) {
                        extraData.setTextSizeUnit(textSizeUnit);
                    }
                    if ((layoutSize = extraRenderingInfo.getLayoutSize()) != null) {
                        extraData.setLayoutSize(layoutSize);
                    }
                }
            }
            catch (IllegalStateException e) {
                if (AccessibilityNodeInfoExtraDataExtractor.isRobolectric()) break block6;
                throw e;
            }
        }
    }

    @RequiresApi(value=26)
    private static void fetchTextCharacterLocations(AccessibilityNodeInfo fromInfo, ExtraData extraData) {
        CharSequence text = fromInfo.getText();
        if (TextUtils.isEmpty(text)) {
            extraData.setTextCharacterLocations((ImmutableList<Rect>)ImmutableList.of());
        } else {
            ImmutableList<Rect> locations;
            Bundle args = AccessibilityNodeInfoExtraDataExtractor.createTextCharacterLocationsRequestBundle(text);
            if (fromInfo.refreshWithExtraData("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", args) && (locations = AccessibilityNodeInfoExtraDataExtractor.parseCharacterLocationsFromExtras(fromInfo.getExtras())) != null) {
                extraData.setTextCharacterLocations(locations);
            }
        }
    }

    private static @Nullable ImmutableList<Rect> parseCharacterLocationsFromExtras(Bundle extras) {
        Parcelable[] data = extras.getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY");
        if (data == null) {
            return null;
        }
        ImmutableList.Builder charLocations = ImmutableList.builder();
        for (Parcelable item : data) {
            if (!(item instanceof RectF)) continue;
            RectF rectF = (RectF)item;
            charLocations.add((Object)new Rect((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom)));
        }
        return charLocations.build();
    }

    private static Bundle createTextCharacterLocationsRequestBundle(CharSequence text) {
        Bundle args = new Bundle();
        args.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX", 0);
        args.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH", text.length());
        return args;
    }

    private static boolean isRobolectric() {
        return "robolectric".equals(_Original_Build.FINGERPRINT);
    }

    static class ExtraData {
        private @Nullable Float textSize = null;
        private @Nullable Integer textSizeUnit = null;
        private @Nullable Size layoutSize = null;
        private @Nullable ImmutableList<Rect> textCharacterLocations = null;

        ExtraData() {
        }

        @Nullable Float getTextSize() {
            return this.textSize;
        }

        @VisibleForTesting
        ExtraData setTextSize(Float textSize) {
            this.textSize = textSize;
            return this;
        }

        @Nullable Integer getTextSizeUnit() {
            return this.textSizeUnit;
        }

        @VisibleForTesting
        ExtraData setTextSizeUnit(Integer textSizeUnit) {
            this.textSizeUnit = textSizeUnit;
            return this;
        }

        @Nullable Size getLayoutSize() {
            return this.layoutSize;
        }

        @VisibleForTesting
        ExtraData setLayoutSize(Size layoutSize) {
            this.layoutSize = layoutSize;
            return this;
        }

        @Nullable ImmutableList<Rect> getTextCharacterLocations() {
            return this.textCharacterLocations;
        }

        @VisibleForTesting
        ExtraData setTextCharacterLocations(ImmutableList<Rect> textCharacterLocations) {
            this.textCharacterLocations = textCharacterLocations;
            return this;
        }
    }
}

