/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.accounts.Account;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.IServiceConnection;
import android.app.admin.FactoryResetProtectionPolicy;
import android.app.admin.FullyManagedDeviceProvisioningParams;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.ManagedProfileProvisioningParams;
import android.app.admin.NetworkEvent;
import android.app.admin.PasswordMetrics;
import android.app.admin.ProvisioningException;
import android.app.admin.SecurityLog;
import android.app.admin.StartInstallingUpdateCallback;
import android.app.admin.SystemUpdateInfo;
import android.app.admin.SystemUpdatePolicy;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.net.PrivateDnsConnectivityChecker;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.AttestedKeyPair;
import android.security.Credentials;
import android.security.KeyChain;
import android.security.KeyChainException;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.AttestationUtils;
import android.security.keystore.KeyAttestationException;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.ParcelableKeyGenParameterSpec;
import android.security.keystore.StrongBoxUnavailableException;
import android.telephony.data.ApnSetting;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.NetworkUtilsInternal;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@SuppressLint(value={"UseIcu"})
public class DevicePolicyManager {
    private static String TAG = "DevicePolicyManager";
    private final Context mContext;
    private final IDevicePolicyManager mService;
    private final boolean mParentInstance;
    public static final String ACTION_PROVISION_MANAGED_PROFILE = "android.app.action.PROVISION_MANAGED_PROFILE";
    public static final String ACTION_PROVISION_MANAGED_USER = "android.app.action.PROVISION_MANAGED_USER";
    @Deprecated
    public static final String ACTION_PROVISION_MANAGED_DEVICE = "android.app.action.PROVISION_MANAGED_DEVICE";
    @SystemApi
    public static final String ACTION_STATE_USER_SETUP_COMPLETE = "android.app.action.STATE_USER_SETUP_COMPLETE";
    @SystemApi
    public static final String ACTION_PROVISION_MANAGED_DEVICE_FROM_TRUSTED_SOURCE = "android.app.action.PROVISION_MANAGED_DEVICE_FROM_TRUSTED_SOURCE";
    @SystemApi
    public static final String ACTION_PROVISION_FINANCED_DEVICE = "android.app.action.PROVISION_FINANCED_DEVICE";
    @SystemApi
    public static final String ACTION_PROVISION_FINALIZATION = "android.app.action.PROVISION_FINALIZATION";
    public static final String ACTION_BUGREPORT_SHARING_ACCEPTED = "com.android.server.action.REMOTE_BUGREPORT_SHARING_ACCEPTED";
    public static final String ACTION_BUGREPORT_SHARING_DECLINED = "com.android.server.action.REMOTE_BUGREPORT_SHARING_DECLINED";
    public static final String ACTION_REMOTE_BUGREPORT_DISPATCH = "android.intent.action.REMOTE_BUGREPORT_DISPATCH";
    public static final String EXTRA_REMOTE_BUGREPORT_HASH = "android.intent.extra.REMOTE_BUGREPORT_HASH";
    public static final String EXTRA_BUGREPORT_NOTIFICATION_TYPE = "android.app.extra.bugreport_notification_type";
    public static final boolean PREFERENTIAL_NETWORK_SERVICE_ENABLED_DEFAULT = false;
    public static final int NOTIFICATION_BUGREPORT_STARTED = 1;
    public static final int NOTIFICATION_BUGREPORT_ACCEPTED_NOT_FINISHED = 2;
    public static final int NOTIFICATION_BUGREPORT_FINISHED_NOT_ACCEPTED = 3;
    public static final long DEFAULT_STRONG_AUTH_TIMEOUT_MS = 259200000L;
    public static final String EXTRA_PROVISIONING_ADMIN_EXTRAS_BUNDLE = "android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE";
    @Deprecated
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_COMPONENT_NAME";
    public static final String EXTRA_PROVISIONING_ACCOUNT_TO_MIGRATE = "android.app.extra.PROVISIONING_ACCOUNT_TO_MIGRATE";
    public static final String EXTRA_PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION = "android.app.extra.PROVISIONING_KEEP_ACCOUNT_ON_MIGRATION";
    @Deprecated
    public static final String EXTRA_PROVISIONING_EMAIL_ADDRESS = "android.app.extra.PROVISIONING_EMAIL_ADDRESS";
    @Deprecated
    public static final String EXTRA_PROVISIONING_MAIN_COLOR = "android.app.extra.PROVISIONING_MAIN_COLOR";
    public static final String EXTRA_PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED = "android.app.extra.PROVISIONING_LEAVE_ALL_SYSTEM_APPS_ENABLED";
    public static final String EXTRA_PROVISIONING_TIME_ZONE = "android.app.extra.PROVISIONING_TIME_ZONE";
    public static final String EXTRA_PROVISIONING_LOCAL_TIME = "android.app.extra.PROVISIONING_LOCAL_TIME";
    public static final String EXTRA_PROVISIONING_LOCALE = "android.app.extra.PROVISIONING_LOCALE";
    public static final String EXTRA_PROVISIONING_WIFI_SSID = "android.app.extra.PROVISIONING_WIFI_SSID";
    public static final String EXTRA_PROVISIONING_WIFI_HIDDEN = "android.app.extra.PROVISIONING_WIFI_HIDDEN";
    public static final String EXTRA_PROVISIONING_WIFI_SECURITY_TYPE = "android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE";
    public static final String EXTRA_PROVISIONING_WIFI_PASSWORD = "android.app.extra.PROVISIONING_WIFI_PASSWORD";
    public static final String EXTRA_PROVISIONING_WIFI_EAP_METHOD = "android.app.extra.PROVISIONING_WIFI_EAP_METHOD";
    public static final String EXTRA_PROVISIONING_WIFI_PHASE2_AUTH = "android.app.extra.PROVISIONING_WIFI_PHASE2_AUTH";
    public static final String EXTRA_PROVISIONING_WIFI_CA_CERTIFICATE = "android.app.extra.PROVISIONING_WIFI_CA_CERTIFICATE";
    public static final String EXTRA_PROVISIONING_WIFI_USER_CERTIFICATE = "android.app.extra.PROVISIONING_WIFI_USER_CERTIFICATE";
    public static final String EXTRA_PROVISIONING_WIFI_IDENTITY = "android.app.extra.PROVISIONING_WIFI_IDENTITY";
    public static final String EXTRA_PROVISIONING_WIFI_ANONYMOUS_IDENTITY = "android.app.extra.PROVISIONING_WIFI_ANONYMOUS_IDENTITY";
    public static final String EXTRA_PROVISIONING_WIFI_DOMAIN = "android.app.extra.PROVISIONING_WIFI_DOMAIN";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_HOST = "android.app.extra.PROVISIONING_WIFI_PROXY_HOST";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_PORT = "android.app.extra.PROVISIONING_WIFI_PROXY_PORT";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_BYPASS = "android.app.extra.PROVISIONING_WIFI_PROXY_BYPASS";
    public static final String EXTRA_PROVISIONING_WIFI_PAC_URL = "android.app.extra.PROVISIONING_WIFI_PAC_URL";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION";
    @SystemApi
    public static final String EXTRA_PROVISIONING_ORGANIZATION_NAME = "android.app.extra.PROVISIONING_ORGANIZATION_NAME";
    @SystemApi
    public static final String EXTRA_PROVISIONING_SUPPORT_URL = "android.app.extra.PROVISIONING_SUPPORT_URL";
    @Deprecated
    @SystemApi
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_LABEL = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_LABEL";
    @SystemApi
    @Deprecated
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_ICON_URI = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_ICON_URI";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE = "android.app.extra.PROVISIONING_DEVICE_ADMIN_MINIMUM_VERSION_CODE";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM";
    public static final String EXTRA_PROVISIONING_SENSORS_PERMISSION_GRANT_OPT_OUT = "android.app.extra.PROVISIONING_SENSORS_PERMISSION_GRANT_OPT_OUT";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_SIGNATURE_CHECKSUM";
    public static final String ACTION_MANAGED_PROFILE_PROVISIONED = "android.app.action.MANAGED_PROFILE_PROVISIONED";
    public static final String ACTION_PROVISIONING_SUCCESSFUL = "android.app.action.PROVISIONING_SUCCESSFUL";
    public static final String EXTRA_PROVISIONING_SKIP_ENCRYPTION = "android.app.extra.PROVISIONING_SKIP_ENCRYPTION";
    public static final String EXTRA_PROVISIONING_LOGO_URI = "android.app.extra.PROVISIONING_LOGO_URI";
    public static final String EXTRA_PROVISIONING_DISCLAIMERS = "android.app.extra.PROVISIONING_DISCLAIMERS";
    public static final String EXTRA_PROVISIONING_DISCLAIMER_HEADER = "android.app.extra.PROVISIONING_DISCLAIMER_HEADER";
    public static final String EXTRA_PROVISIONING_DISCLAIMER_CONTENT = "android.app.extra.PROVISIONING_DISCLAIMER_CONTENT";
    @Deprecated
    public static final String EXTRA_PROVISIONING_SKIP_USER_CONSENT = "android.app.extra.PROVISIONING_SKIP_USER_CONSENT";
    public static final String EXTRA_PROVISIONING_SKIP_EDUCATION_SCREENS = "android.app.extra.PROVISIONING_SKIP_EDUCATION_SCREENS";
    public static final String EXTRA_PROVISIONING_USE_MOBILE_DATA = "android.app.extra.PROVISIONING_USE_MOBILE_DATA";
    @SystemApi
    public static final String EXTRA_PROVISIONING_TRIGGER = "android.app.extra.PROVISIONING_TRIGGER";
    @SystemApi
    public static final int PROVISIONING_TRIGGER_UNSPECIFIED = 0;
    @SystemApi
    public static final int PROVISIONING_TRIGGER_CLOUD_ENROLLMENT = 1;
    @SystemApi
    public static final int PROVISIONING_TRIGGER_QR_CODE = 2;
    @SystemApi
    @Deprecated
    public static final int PROVISIONING_TRIGGER_PERSISTENT_DEVICE_OWNER = 3;
    @SystemApi
    public static final int PROVISIONING_TRIGGER_MANAGED_ACCOUNT = 4;
    @SystemApi
    public static final int FLAG_SUPPORTED_MODES_ORGANIZATION_OWNED = 1;
    @SystemApi
    public static final int FLAG_SUPPORTED_MODES_PERSONALLY_OWNED = 2;
    @SystemApi
    public static final int FLAG_SUPPORTED_MODES_DEVICE_OWNER = 4;
    public static final String MIME_TYPE_PROVISIONING_NFC = "application/com.android.managedprovisioning";
    public static final String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";
    @SystemApi
    public static final String ACTION_SET_PROFILE_OWNER = "android.app.action.SET_PROFILE_OWNER";
    @SystemApi
    public static final String EXTRA_PROFILE_OWNER_NAME = "android.app.extra.PROFILE_OWNER_NAME";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_DEVICE_POLICY_MANAGER_STATE_CHANGED = "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED";
    public static final String ACTION_DEVICE_OWNER_CHANGED = "android.app.action.DEVICE_OWNER_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_FACTORY_RESET_PROTECTION")
    public static final String ACTION_RESET_PROTECTION_POLICY_CHANGED = "android.app.action.RESET_PROTECTION_POLICY_CHANGED";
    public static final String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";
    public static final String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";
    public static final String POLICY_DISABLE_CAMERA = "policy_disable_camera";
    public static final String POLICY_DISABLE_SCREEN_CAPTURE = "policy_disable_screen_capture";
    public static final String POLICY_SUSPEND_PACKAGES = "policy_suspend_packages";
    @SystemApi
    public static final String EXTRA_RESTRICTION = "android.app.extra.RESTRICTION";
    public static final String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";
    @RequiresPermission(value="android.permission.REQUEST_PASSWORD_COMPLEXITY")
    public static final String EXTRA_PASSWORD_COMPLEXITY = "android.app.extra.PASSWORD_COMPLEXITY";
    public static final int PASSWORD_COMPLEXITY_NONE = 0;
    public static final int PASSWORD_COMPLEXITY_LOW = 65536;
    public static final int PASSWORD_COMPLEXITY_MEDIUM = 196608;
    public static final int PASSWORD_COMPLEXITY_HIGH = 327680;
    public static final String EXTRA_DEVICE_PASSWORD_REQUIREMENT_ONLY = "android.app.extra.DEVICE_PASSWORD_REQUIREMENT_ONLY";
    public static final int NEARBY_STREAMING_NOT_CONTROLLED_BY_POLICY = 0;
    public static final int NEARBY_STREAMING_DISABLED = 1;
    public static final int NEARBY_STREAMING_ENABLED = 2;
    public static final int NEARBY_STREAMING_SAME_MANAGED_ACCOUNT_ONLY = 3;
    public static final String ACTION_SET_NEW_PARENT_PROFILE_PASSWORD = "android.app.action.SET_NEW_PARENT_PROFILE_PASSWORD";
    public static final String ACTION_SHOW_DEVICE_MONITORING_DIALOG = "android.app.action.SHOW_DEVICE_MONITORING_DIALOG";
    public static final String ACTION_APPLICATION_DELEGATION_SCOPES_CHANGED = "android.app.action.APPLICATION_DELEGATION_SCOPES_CHANGED";
    public static final String EXTRA_DELEGATION_SCOPES = "android.app.extra.DELEGATION_SCOPES";
    public static final int FLAG_PARENT_CAN_ACCESS_MANAGED = 1;
    public static final int FLAG_MANAGED_CAN_ACCESS_PARENT = 2;
    public static final String ACTION_SYSTEM_UPDATE_POLICY_CHANGED = "android.app.action.SYSTEM_UPDATE_POLICY_CHANGED";
    public static final String ACTION_DATA_SHARING_RESTRICTION_APPLIED = "android.app.action.DATA_SHARING_RESTRICTION_APPLIED";
    public static final String ACTION_DEVICE_POLICY_CONSTANTS_CHANGED = "android.app.action.DEVICE_POLICY_CONSTANTS_CHANGED";
    public static final int PERMISSION_POLICY_PROMPT = 0;
    public static final int PERMISSION_POLICY_AUTO_GRANT = 1;
    public static final int PERMISSION_POLICY_AUTO_DENY = 2;
    public static final int PERMISSION_GRANT_STATE_DEFAULT = 0;
    public static final int PERMISSION_GRANT_STATE_GRANTED = 1;
    public static final int PERMISSION_GRANT_STATE_DENIED = 2;
    public static final String DELEGATION_CERT_INSTALL = "delegation-cert-install";
    public static final String DELEGATION_APP_RESTRICTIONS = "delegation-app-restrictions";
    public static final String DELEGATION_BLOCK_UNINSTALL = "delegation-block-uninstall";
    public static final String DELEGATION_PERMISSION_GRANT = "delegation-permission-grant";
    public static final String DELEGATION_PACKAGE_ACCESS = "delegation-package-access";
    public static final String DELEGATION_ENABLE_SYSTEM_APP = "delegation-enable-system-app";
    public static final String DELEGATION_INSTALL_EXISTING_PACKAGE = "delegation-install-existing-package";
    public static final String DELEGATION_KEEP_UNINSTALLED_PACKAGES = "delegation-keep-uninstalled-packages";
    public static final String DELEGATION_NETWORK_LOGGING = "delegation-network-logging";
    public static final String DELEGATION_CERT_SELECTION = "delegation-cert-selection";
    public static final String DELEGATION_SECURITY_LOGGING = "delegation-security-logging";
    @SystemApi
    public static final int STATE_USER_UNMANAGED = 0;
    @SystemApi
    public static final int STATE_USER_SETUP_INCOMPLETE = 1;
    @SystemApi
    public static final int STATE_USER_SETUP_COMPLETE = 2;
    @SystemApi
    public static final int STATE_USER_SETUP_FINALIZED = 3;
    @SystemApi
    public static final int STATE_USER_PROFILE_COMPLETE = 4;
    @SystemApi
    public static final int STATE_USER_PROFILE_FINALIZED = 5;
    public static final int CODE_OK = 0;
    public static final int CODE_HAS_DEVICE_OWNER = 1;
    public static final int CODE_USER_HAS_PROFILE_OWNER = 2;
    public static final int CODE_USER_NOT_RUNNING = 3;
    public static final int CODE_USER_SETUP_COMPLETED = 4;
    public static final int CODE_NONSYSTEM_USER_EXISTS = 5;
    public static final int CODE_ACCOUNTS_NOT_EMPTY = 6;
    public static final int CODE_NOT_SYSTEM_USER = 7;
    public static final int CODE_HAS_PAIRED = 8;
    public static final int CODE_MANAGED_USERS_NOT_SUPPORTED = 9;
    public static final int CODE_SYSTEM_USER = 10;
    public static final int CODE_CANNOT_ADD_MANAGED_PROFILE = 11;
    @Deprecated
    public static final int CODE_NOT_SYSTEM_USER_SPLIT = 12;
    public static final int CODE_DEVICE_ADMIN_NOT_SUPPORTED = 13;
    @Deprecated
    public static final int CODE_SPLIT_SYSTEM_USER_DEVICE_SYSTEM_USER = 14;
    public static final int CODE_PROVISIONING_NOT_ALLOWED_FOR_NON_DEVELOPER_USERS = 15;
    public static final int PROVISIONING_RESULT_PRE_CONDITION_FAILED = 1;
    public static final int PROVISIONING_RESULT_PROFILE_CREATION_FAILED = 2;
    public static final int PROVISIONING_RESULT_ADMIN_PACKAGE_INSTALLATION_FAILED = 3;
    public static final int PROVISIONING_RESULT_SETTING_PROFILE_OWNER_FAILED = 4;
    public static final int PROVISIONING_RESULT_STARTING_PROFILE_FAILED = 5;
    public static final int PROVISIONING_RESULT_REMOVE_NON_REQUIRED_APPS_FAILED = 6;
    public static final int PROVISIONING_RESULT_SET_DEVICE_OWNER_FAILED = 7;
    public static final int LOCK_TASK_FEATURE_NONE = 0;
    public static final int LOCK_TASK_FEATURE_SYSTEM_INFO = 1;
    public static final int LOCK_TASK_FEATURE_NOTIFICATIONS = 2;
    public static final int LOCK_TASK_FEATURE_HOME = 4;
    public static final int LOCK_TASK_FEATURE_OVERVIEW = 8;
    public static final int LOCK_TASK_FEATURE_GLOBAL_ACTIONS = 16;
    public static final int LOCK_TASK_FEATURE_KEYGUARD = 32;
    public static final int LOCK_TASK_FEATURE_BLOCK_ACTIVITY_START_IN_TASK = 64;
    public static final String ACTION_DEVICE_ADMIN_SERVICE = "android.app.action.DEVICE_ADMIN_SERVICE";
    public static final int ID_TYPE_BASE_INFO = 1;
    public static final int ID_TYPE_SERIAL = 2;
    public static final int ID_TYPE_IMEI = 4;
    public static final int ID_TYPE_MEID = 8;
    public static final int ID_TYPE_INDIVIDUAL_ATTESTATION = 16;
    public static final int KEY_GEN_STRONGBOX_UNAVAILABLE = 1;
    public static final int INSTALLKEY_REQUEST_CREDENTIALS_ACCESS = 1;
    public static final int INSTALLKEY_SET_USER_SELECTABLE = 2;
    public static final String ACTION_PROFILE_OWNER_CHANGED = "android.app.action.PROFILE_OWNER_CHANGED";
    public static final int PRIVATE_DNS_MODE_UNKNOWN = 0;
    public static final int PRIVATE_DNS_MODE_OFF = 1;
    public static final int PRIVATE_DNS_MODE_OPPORTUNISTIC = 2;
    public static final int PRIVATE_DNS_MODE_PROVIDER_HOSTNAME = 3;
    public static final int PRIVATE_DNS_SET_NO_ERROR = 0;
    public static final int PRIVATE_DNS_SET_ERROR_HOST_NOT_SERVING = 1;
    public static final int PRIVATE_DNS_SET_ERROR_FAILURE_SETTING = 2;
    public static final String ACTION_GET_PROVISIONING_MODE = "android.app.action.GET_PROVISIONING_MODE";
    public static final String EXTRA_PROVISIONING_IMEI = "android.app.extra.PROVISIONING_IMEI";
    public static final String EXTRA_PROVISIONING_SERIAL_NUMBER = "android.app.extra.PROVISIONING_SERIAL_NUMBER";
    public static final String EXTRA_PROVISIONING_MODE = "android.app.extra.PROVISIONING_MODE";
    @SystemApi
    public static final String EXTRA_PROVISIONING_SUPPORTED_MODES = "android.app.extra.PROVISIONING_SUPPORTED_MODES";
    @SystemApi
    public static final String EXTRA_PROVISIONING_SKIP_OWNERSHIP_DISCLAIMER = "android.app.extra.PROVISIONING_SKIP_OWNERSHIP_DISCLAIMER";
    public static final String EXTRA_PROVISIONING_ALLOWED_PROVISIONING_MODES = "android.app.extra.PROVISIONING_ALLOWED_PROVISIONING_MODES";
    public static final int PROVISIONING_MODE_FULLY_MANAGED_DEVICE = 1;
    public static final int PROVISIONING_MODE_MANAGED_PROFILE = 2;
    public static final int PROVISIONING_MODE_MANAGED_PROFILE_ON_PERSONAL_DEVICE = 3;
    @SystemApi
    public static final String EXTRA_PROVISIONING_RETURN_BEFORE_POLICY_COMPLIANCE = "android.app.extra.PROVISIONING_RETURN_BEFORE_POLICY_COMPLIANCE";
    public static final String ACTION_ADMIN_POLICY_COMPLIANCE = "android.app.action.ADMIN_POLICY_COMPLIANCE";
    public static final int MAX_PASSWORD_LENGTH = 16;
    @SystemApi
    public static final String ACTION_BIND_SECONDARY_LOCKSCREEN_SERVICE = "android.app.action.BIND_SECONDARY_LOCKSCREEN_SERVICE";
    public static final int PERSONAL_APPS_NOT_SUSPENDED = 0;
    public static final int PERSONAL_APPS_SUSPENDED_EXPLICITLY = 1;
    public static final int PERSONAL_APPS_SUSPENDED_PROFILE_TIMEOUT = 2;
    public static final int DEVICE_OWNER_TYPE_DEFAULT = 0;
    public static final int DEVICE_OWNER_TYPE_FINANCED = 1;
    public static final int OPERATION_LOCK_NOW = 1;
    public static final int OPERATION_SWITCH_USER = 2;
    public static final int OPERATION_START_USER_IN_BACKGROUND = 3;
    public static final int OPERATION_STOP_USER = 4;
    public static final int OPERATION_CREATE_AND_MANAGE_USER = 5;
    public static final int OPERATION_REMOVE_USER = 6;
    public static final int OPERATION_REBOOT = 7;
    public static final int OPERATION_WIPE_DATA = 8;
    public static final int OPERATION_LOGOUT_USER = 9;
    public static final int OPERATION_SET_USER_RESTRICTION = 10;
    public static final int OPERATION_SET_SYSTEM_SETTING = 11;
    public static final int OPERATION_SET_KEYGUARD_DISABLED = 12;
    public static final int OPERATION_SET_STATUS_BAR_DISABLED = 13;
    public static final int OPERATION_SET_SYSTEM_UPDATE_POLICY = 14;
    public static final int OPERATION_SET_APPLICATION_HIDDEN = 15;
    public static final int OPERATION_SET_APPLICATION_RESTRICTIONS = 16;
    public static final int OPERATION_SET_KEEP_UNINSTALLED_PACKAGES = 17;
    public static final int OPERATION_SET_LOCK_TASK_FEATURES = 18;
    public static final int OPERATION_SET_LOCK_TASK_PACKAGES = 19;
    public static final int OPERATION_SET_PACKAGES_SUSPENDED = 20;
    public static final int OPERATION_SET_TRUST_AGENT_CONFIGURATION = 21;
    public static final int OPERATION_SET_USER_CONTROL_DISABLED_PACKAGES = 22;
    public static final int OPERATION_CLEAR_APPLICATION_USER_DATA = 23;
    public static final int OPERATION_INSTALL_CA_CERT = 24;
    public static final int OPERATION_INSTALL_KEY_PAIR = 25;
    public static final int OPERATION_INSTALL_SYSTEM_UPDATE = 26;
    public static final int OPERATION_REMOVE_ACTIVE_ADMIN = 27;
    public static final int OPERATION_REMOVE_KEY_PAIR = 28;
    public static final int OPERATION_REQUEST_BUGREPORT = 29;
    public static final int OPERATION_SET_ALWAYS_ON_VPN_PACKAGE = 30;
    public static final int OPERATION_SET_CAMERA_DISABLED = 31;
    public static final int OPERATION_SET_FACTORY_RESET_PROTECTION_POLICY = 32;
    public static final int OPERATION_SET_GLOBAL_PRIVATE_DNS = 33;
    public static final int OPERATION_SET_LOGOUT_ENABLED = 34;
    public static final int OPERATION_SET_MASTER_VOLUME_MUTED = 35;
    public static final int OPERATION_SET_OVERRIDE_APNS_ENABLED = 36;
    public static final int OPERATION_SET_PERMISSION_GRANT_STATE = 37;
    public static final int OPERATION_SET_PERMISSION_POLICY = 38;
    public static final int OPERATION_SET_RESTRICTIONS_PROVIDER = 39;
    public static final int OPERATION_UNINSTALL_CA_CERT = 40;
    private static final String PREFIX_OPERATION = "OPERATION_";
    private static final String PREFIX_OPERATION_SAFETY_REASON = "OPERATION_SAFETY_REASON_";
    public static final int OPERATION_SAFETY_REASON_NONE = -1;
    public static final int OPERATION_SAFETY_REASON_DRIVING_DISTRACTION = 1;
    public static final int PASSWORD_QUALITY_UNSPECIFIED = 0;
    public static final int PASSWORD_QUALITY_BIOMETRIC_WEAK = 32768;
    public static final int PASSWORD_QUALITY_SOMETHING = 65536;
    public static final int PASSWORD_QUALITY_NUMERIC = 131072;
    public static final int PASSWORD_QUALITY_NUMERIC_COMPLEX = 196608;
    public static final int PASSWORD_QUALITY_ALPHABETIC = 262144;
    public static final int PASSWORD_QUALITY_ALPHANUMERIC = 327680;
    public static final int PASSWORD_QUALITY_COMPLEX = 393216;
    public static final int PASSWORD_QUALITY_MANAGED = 524288;
    @SystemApi
    public static final String ACCOUNT_FEATURE_DEVICE_OR_PROFILE_OWNER_ALLOWED = "android.account.DEVICE_OR_PROFILE_OWNER_ALLOWED";
    @SystemApi
    public static final String ACCOUNT_FEATURE_DEVICE_OR_PROFILE_OWNER_DISALLOWED = "android.account.DEVICE_OR_PROFILE_OWNER_DISALLOWED";
    @SystemApi
    public static final String REQUIRED_APP_MANAGED_USER = "android.app.REQUIRED_APP_MANAGED_USER";
    @SystemApi
    public static final String REQUIRED_APP_MANAGED_DEVICE = "android.app.REQUIRED_APP_MANAGED_DEVICE";
    @SystemApi
    public static final String REQUIRED_APP_MANAGED_PROFILE = "android.app.REQUIRED_APP_MANAGED_PROFILE";
    public static final int RESET_PASSWORD_REQUIRE_ENTRY = 1;
    public static final int RESET_PASSWORD_DO_NOT_ASK_CREDENTIALS_ON_BOOT = 2;
    public static final int FLAG_EVICT_CREDENTIAL_ENCRYPTION_KEY = 1;
    public static final int WIPE_EXTERNAL_STORAGE = 1;
    public static final int WIPE_RESET_PROTECTION_DATA = 2;
    public static final int WIPE_EUICC = 4;
    public static final int WIPE_SILENTLY = 8;
    public static final int ENCRYPTION_STATUS_UNSUPPORTED = 0;
    public static final int ENCRYPTION_STATUS_INACTIVE = 1;
    public static final int ENCRYPTION_STATUS_ACTIVATING = 2;
    public static final int ENCRYPTION_STATUS_ACTIVE = 3;
    public static final int ENCRYPTION_STATUS_ACTIVE_DEFAULT_KEY = 4;
    public static final int ENCRYPTION_STATUS_ACTIVE_PER_USER = 5;
    public static final String ACTION_START_ENCRYPTION = "android.app.action.START_ENCRYPTION";
    public static final String ACTION_CHECK_POLICY_COMPLIANCE = "android.app.action.CHECK_POLICY_COMPLIANCE";
    public static final String ACTION_MANAGED_USER_CREATED = "android.app.action.MANAGED_USER_CREATED";
    public static final String ACTION_SHOW_NEW_USER_DISCLAIMER = "android.app.action.ACTION_SHOW_NEW_USER_DISCLAIMER";
    public static final int KEYGUARD_DISABLE_FEATURES_NONE = 0;
    public static final int KEYGUARD_DISABLE_WIDGETS_ALL = 1;
    public static final int KEYGUARD_DISABLE_SECURE_CAMERA = 2;
    public static final int KEYGUARD_DISABLE_SECURE_NOTIFICATIONS = 4;
    public static final int KEYGUARD_DISABLE_UNREDACTED_NOTIFICATIONS = 8;
    public static final int KEYGUARD_DISABLE_TRUST_AGENTS = 16;
    public static final int KEYGUARD_DISABLE_FINGERPRINT = 32;
    public static final int KEYGUARD_DISABLE_REMOTE_INPUT = 64;
    public static final int KEYGUARD_DISABLE_FACE = 128;
    public static final int KEYGUARD_DISABLE_IRIS = 256;
    public static final int KEYGUARD_DISABLE_BIOMETRICS = 416;
    public static final int KEYGUARD_DISABLE_FEATURES_ALL = Integer.MAX_VALUE;
    public static final int NON_ORG_OWNED_PROFILE_KEYGUARD_FEATURES_AFFECT_OWNER = 432;
    public static final int ORG_OWNED_PROFILE_KEYGUARD_FEATURES_PARENT_ONLY = 6;
    public static final int PROFILE_KEYGUARD_FEATURES_AFFECT_OWNER = 438;
    public static final int ERROR_VPN_PACKAGE_NOT_FOUND = 1;
    public static final int SKIP_SETUP_WIZARD = 1;
    public static final int MAKE_USER_EPHEMERAL = 2;
    public static final int MAKE_USER_DEMO = 4;
    public static final int LEAVE_ALL_SYSTEM_APPS_ENABLED = 16;

    public DevicePolicyManager(Context context, IDevicePolicyManager service) {
        this(context, service, false);
    }

    @RequiresPermission(value="android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS")
    public void finalizeWorkProfileProvisioning(UserHandle managedProfileUser, Account migratedAccount) {
        Objects.requireNonNull(managedProfileUser, "managedProfileUser can't be null");
        if (this.mService == null) {
            throw new IllegalStateException("Could not find DevicePolicyManagerService");
        }
        try {
            this.mService.finalizeWorkProfileProvisioning(managedProfileUser, migratedAccount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    protected DevicePolicyManager(Context context, IDevicePolicyManager service, boolean parentInstance) {
        this.mContext = context;
        this.mService = service;
        this.mParentInstance = parentInstance;
    }

    @VisibleForTesting
    protected int myUserId() {
        return this.mContext.getUserId();
    }

    public static String operationToString(int operation) {
        return DebugUtils.constantToString(DevicePolicyManager.class, PREFIX_OPERATION, operation);
    }

    public static String operationSafetyReasonToString(int reason) {
        return DebugUtils.constantToString(DevicePolicyManager.class, PREFIX_OPERATION_SAFETY_REASON, reason);
    }

    public static boolean isValidOperationSafetyReason(int reason) {
        return reason == 1;
    }

    public boolean isSafeOperation(int reason) {
        this.throwIfParentInstance("isSafeOperation");
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isSafeOperation(reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resetNewUserDisclaimer() {
        if (this.mService != null) {
            try {
                this.mService.resetNewUserDisclaimer();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isAdminActive(ComponentName admin) {
        this.throwIfParentInstance("isAdminActive");
        return this.isAdminActiveAsUser(admin, this.myUserId());
    }

    public boolean isAdminActiveAsUser(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isAdminActive(admin, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isRemovingAdmin(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isRemovingAdmin(admin, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<ComponentName> getActiveAdmins() {
        this.throwIfParentInstance("getActiveAdmins");
        return this.getActiveAdminsAsUser(this.myUserId());
    }

    @UnsupportedAppUsage
    public List<ComponentName> getActiveAdminsAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getActiveAdmins(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    public boolean packageHasActiveAdmins(String packageName) {
        return this.packageHasActiveAdmins(packageName, this.myUserId());
    }

    @UnsupportedAppUsage
    public boolean packageHasActiveAdmins(String packageName, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.packageHasActiveAdmins(packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void removeActiveAdmin(ComponentName admin) {
        this.throwIfParentInstance("removeActiveAdmin");
        if (this.mService != null) {
            try {
                this.mService.removeActiveAdmin(admin, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean hasGrantedPolicy(ComponentName admin, int usesPolicy) {
        this.throwIfParentInstance("hasGrantedPolicy");
        if (this.mService != null) {
            try {
                return this.mService.hasGrantedPolicy(admin, usesPolicy, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isSeparateProfileChallengeAllowed(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isSeparateProfileChallengeAllowed(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    public void setPasswordQuality(ComponentName admin, int quality) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordQuality(admin, quality, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordQuality(ComponentName admin) {
        return this.getPasswordQuality(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordQuality(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordQuality(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLength(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumLength(ComponentName admin) {
        return this.getPasswordMinimumLength(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLength(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumUpperCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumUpperCase(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumUpperCase(ComponentName admin) {
        return this.getPasswordMinimumUpperCase(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumUpperCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumUpperCase(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumLowerCase(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLowerCase(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumLowerCase(ComponentName admin) {
        return this.getPasswordMinimumLowerCase(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumLowerCase(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLowerCase(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumLetters(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumLetters(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumLetters(ComponentName admin) {
        return this.getPasswordMinimumLetters(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumLetters(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumLetters(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumNumeric(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNumeric(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumNumeric(ComponentName admin) {
        return this.getPasswordMinimumNumeric(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumNumeric(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNumeric(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumSymbols(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumSymbols(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumSymbols(ComponentName admin) {
        return this.getPasswordMinimumSymbols(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumSymbols(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumSymbols(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public void setPasswordMinimumNonLetter(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordMinimumNonLetter(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public int getPasswordMinimumNonLetter(ComponentName admin) {
        return this.getPasswordMinimumNonLetter(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordMinimumNonLetter(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumNonLetter(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public PasswordMetrics getPasswordMinimumMetrics(int userHandle) {
        return this.getPasswordMinimumMetrics(userHandle, false);
    }

    public PasswordMetrics getPasswordMinimumMetrics(int userHandle, boolean deviceWideOnly) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordMinimumMetrics(userHandle, deviceWideOnly);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setPasswordHistoryLength(ComponentName admin, int length) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordHistoryLength(admin, length, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setPasswordExpirationTimeout(ComponentName admin, long timeout) {
        if (this.mService != null) {
            try {
                this.mService.setPasswordExpirationTimeout(admin, timeout, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public long getPasswordExpirationTimeout(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpirationTimeout(admin, this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    public long getPasswordExpiration(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordExpiration(admin, this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    public int getPasswordHistoryLength(ComponentName admin) {
        return this.getPasswordHistoryLength(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public int getPasswordHistoryLength(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getPasswordHistoryLength(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public int getPasswordMaximumLength(int quality) {
        PackageManager pm = this.mContext.getPackageManager();
        if (!pm.hasSystemFeature("android.software.secure_lock_screen")) {
            return 0;
        }
        return 16;
    }

    public boolean isActivePasswordSufficient() {
        if (this.mService != null) {
            try {
                return this.mService.isActivePasswordSufficient(this.myUserId(), this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isActivePasswordSufficientForDeviceRequirement() {
        if (!this.mParentInstance) {
            throw new SecurityException("only callable on the parent instance");
        }
        if (this.mService != null) {
            try {
                return this.mService.isActivePasswordSufficientForDeviceRequirement();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.REQUEST_PASSWORD_COMPLEXITY")
    public int getPasswordComplexity() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getPasswordComplexity(this.mParentInstance);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setRequiredPasswordComplexity(int passwordComplexity) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setRequiredPasswordComplexity(passwordComplexity, this.mParentInstance);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getRequiredPasswordComplexity() {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getRequiredPasswordComplexity(this.mParentInstance);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getAggregatedPasswordComplexityForUser(int userId) {
        return this.getAggregatedPasswordComplexityForUser(userId, false);
    }

    public int getAggregatedPasswordComplexityForUser(int userId, boolean deviceWideOnly) {
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getAggregatedPasswordComplexityForUser(userId, deviceWideOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isUsingUnifiedPassword(ComponentName admin) {
        this.throwIfParentInstance("isUsingUnifiedPassword");
        if (this.mService != null) {
            try {
                return this.mService.isUsingUnifiedPassword(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean isPasswordSufficientAfterProfileUnification(int userHandle, int profileUser) {
        if (this.mService != null) {
            try {
                return this.mService.isPasswordSufficientAfterProfileUnification(userHandle, profileUser);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public int getCurrentFailedPasswordAttempts() {
        return this.getCurrentFailedPasswordAttempts(this.myUserId());
    }

    @UnsupportedAppUsage
    public int getCurrentFailedPasswordAttempts(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCurrentFailedPasswordAttempts(userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public boolean getDoNotAskCredentialsOnBoot() {
        if (this.mService != null) {
            try {
                return this.mService.getDoNotAskCredentialsOnBoot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setMaximumFailedPasswordsForWipe(ComponentName admin, int num) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumFailedPasswordsForWipe(admin, num, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName admin) {
        return this.getMaximumFailedPasswordsForWipe(admin, this.myUserId());
    }

    @UnsupportedAppUsage
    public int getMaximumFailedPasswordsForWipe(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumFailedPasswordsForWipe(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public int getProfileWithMinimumFailedPasswordsForWipe(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getProfileWithMinimumFailedPasswordsForWipe(userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -10000;
    }

    @Deprecated
    public boolean resetPassword(String password, int flags) {
        this.throwIfParentInstance("resetPassword");
        if (this.mService != null) {
            try {
                return this.mService.resetPassword(password, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean setResetPasswordToken(ComponentName admin, byte[] token) {
        this.throwIfParentInstance("setResetPasswordToken");
        if (this.mService != null) {
            try {
                return this.mService.setResetPasswordToken(admin, token);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean clearResetPasswordToken(ComponentName admin) {
        this.throwIfParentInstance("clearResetPasswordToken");
        if (this.mService != null) {
            try {
                return this.mService.clearResetPasswordToken(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isResetPasswordTokenActive(ComponentName admin) {
        this.throwIfParentInstance("isResetPasswordTokenActive");
        if (this.mService != null) {
            try {
                return this.mService.isResetPasswordTokenActive(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean resetPasswordWithToken(ComponentName admin, String password, byte[] token, int flags) {
        this.throwIfParentInstance("resetPassword");
        if (this.mService != null) {
            try {
                return this.mService.resetPasswordWithToken(admin, password, token, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setMaximumTimeToLock(ComponentName admin, long timeMs) {
        if (this.mService != null) {
            try {
                this.mService.setMaximumTimeToLock(admin, timeMs, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public long getMaximumTimeToLock(ComponentName admin) {
        return this.getMaximumTimeToLock(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getMaximumTimeToLock(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getMaximumTimeToLock(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    public void setRequiredStrongAuthTimeout(ComponentName admin, long timeoutMs) {
        if (this.mService != null) {
            try {
                this.mService.setRequiredStrongAuthTimeout(admin, timeoutMs, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public long getRequiredStrongAuthTimeout(ComponentName admin) {
        return this.getRequiredStrongAuthTimeout(admin, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long getRequiredStrongAuthTimeout(ComponentName admin, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getRequiredStrongAuthTimeout(admin, userId, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 259200000L;
    }

    public void lockNow() {
        this.lockNow(0);
    }

    public void lockNow(int flags) {
        if (this.mService != null) {
            try {
                this.mService.lockNow(flags, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void wipeData(int flags) {
        this.wipeDataInternal(flags, "");
    }

    public void wipeData(int flags, CharSequence reason) {
        Objects.requireNonNull(reason, "reason string is null");
        Preconditions.checkStringNotEmpty(reason, "reason string is empty");
        Preconditions.checkArgument((flags & 8) == 0, "WIPE_SILENTLY cannot be set");
        this.wipeDataInternal(flags, reason.toString());
    }

    private void wipeDataInternal(int flags, String wipeReasonForUser) {
        if (this.mService != null) {
            try {
                this.mService.wipeDataWithReason(flags, wipeReasonForUser, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setFactoryResetProtectionPolicy(ComponentName admin, FactoryResetProtectionPolicy policy) {
        this.throwIfParentInstance("setFactoryResetProtectionPolicy");
        if (this.mService != null) {
            try {
                this.mService.setFactoryResetProtectionPolicy(admin, policy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public FactoryResetProtectionPolicy getFactoryResetProtectionPolicy(ComponentName admin) {
        this.throwIfParentInstance("getFactoryResetProtectionPolicy");
        if (this.mService != null) {
            try {
                return this.mService.getFactoryResetProtectionPolicy(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ComponentName setGlobalProxy(ComponentName admin, Proxy proxySpec, List<String> exclusionList) {
        this.throwIfParentInstance("setGlobalProxy");
        if (proxySpec == null) {
            throw new NullPointerException();
        }
        if (this.mService != null) {
            try {
                String exclSpec;
                String hostSpec;
                if (proxySpec.equals(Proxy.NO_PROXY)) {
                    hostSpec = null;
                    exclSpec = null;
                } else {
                    if (!proxySpec.type().equals((Object)Proxy.Type.HTTP)) {
                        throw new IllegalArgumentException();
                    }
                    Pair<String, String> proxyParams = this.getProxyParameters(proxySpec, exclusionList);
                    hostSpec = (String)proxyParams.first;
                    exclSpec = (String)proxyParams.second;
                }
                return this.mService.setGlobalProxy(admin, hostSpec, exclSpec);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @VisibleForTesting
    public Pair<String, String> getProxyParameters(Proxy proxySpec, List<String> exclusionList) {
        List<String> trimmedExclList;
        InetSocketAddress sa = (InetSocketAddress)proxySpec.address();
        String hostName = sa.getHostName();
        int port = sa.getPort();
        if (exclusionList == null) {
            trimmedExclList = Collections.emptyList();
        } else {
            trimmedExclList = new ArrayList(exclusionList.size());
            for (String exclDomain : exclusionList) {
                trimmedExclList.add(exclDomain.trim());
            }
        }
        ProxyInfo info = ProxyInfo.buildDirectProxy(hostName, port, trimmedExclList);
        if (port == 0 || TextUtils.isEmpty(hostName) || !info.isValid()) {
            throw new IllegalArgumentException();
        }
        return new Pair<String, String>(hostName + ":" + port, TextUtils.join((CharSequence)",", trimmedExclList));
    }

    public void setRecommendedGlobalProxy(ComponentName admin, ProxyInfo proxyInfo) {
        this.throwIfParentInstance("setRecommendedGlobalProxy");
        if (this.mService != null) {
            try {
                this.mService.setRecommendedGlobalProxy(admin, proxyInfo);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public ComponentName getGlobalProxyAdmin() {
        if (this.mService != null) {
            try {
                return this.mService.getGlobalProxyAdmin(this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @Deprecated
    public int setStorageEncryption(ComponentName admin, boolean encrypt) {
        this.throwIfParentInstance("setStorageEncryption");
        if (this.mService != null) {
            try {
                return this.mService.setStorageEncryption(admin, encrypt);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @Deprecated
    public boolean getStorageEncryption(ComponentName admin) {
        this.throwIfParentInstance("getStorageEncryption");
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryption(admin, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public int getStorageEncryptionStatus() {
        this.throwIfParentInstance("getStorageEncryptionStatus");
        return this.getStorageEncryptionStatus(this.myUserId());
    }

    @UnsupportedAppUsage
    public int getStorageEncryptionStatus(int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getStorageEncryptionStatus(this.mContext.getPackageName(), userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public boolean approveCaCert(String alias, int userHandle, boolean approval) {
        if (this.mService != null) {
            try {
                return this.mService.approveCaCert(alias, userHandle, approval);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isCaCertApproved(String alias, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isCaCertApproved(alias, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean installCaCert(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("installCaCert");
        if (this.mService != null) {
            try {
                return this.mService.installCaCert(admin, this.mContext.getPackageName(), certBuffer);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void uninstallCaCert(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("uninstallCaCert");
        if (this.mService != null) {
            try {
                String alias = DevicePolicyManager.getCaCertAlias(certBuffer);
                this.mService.uninstallCaCerts(admin, this.mContext.getPackageName(), new String[]{alias});
            }
            catch (CertificateException e) {
                Log.w(TAG, "Unable to parse certificate", e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public List<byte[]> getInstalledCaCerts(ComponentName admin) {
        ArrayList<byte[]> certs = new ArrayList<byte[]>();
        this.throwIfParentInstance("getInstalledCaCerts");
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin, this.mContext.getPackageName());
                TrustedCertificateStore certStore = new TrustedCertificateStore();
                for (String alias : certStore.userAliases()) {
                    try {
                        certs.add(certStore.getCertificate(alias).getEncoded());
                    }
                    catch (CertificateException ce) {
                        Log.w(TAG, "Could not encode certificate: " + alias, ce);
                    }
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return certs;
    }

    public void uninstallAllUserCaCerts(ComponentName admin) {
        this.throwIfParentInstance("uninstallAllUserCaCerts");
        if (this.mService != null) {
            try {
                this.mService.uninstallCaCerts(admin, this.mContext.getPackageName(), new TrustedCertificateStore().userAliases().toArray(new String[0]));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean hasCaCertInstalled(ComponentName admin, byte[] certBuffer) {
        this.throwIfParentInstance("hasCaCertInstalled");
        if (this.mService != null) {
            try {
                this.mService.enforceCanManageCaCerts(admin, this.mContext.getPackageName());
                return DevicePolicyManager.getCaCertAlias(certBuffer) != null;
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
            catch (CertificateException ce) {
                Log.w(TAG, "Could not parse certificate", ce);
            }
        }
        return false;
    }

    public boolean installKeyPair(ComponentName admin, PrivateKey privKey, Certificate cert, String alias) {
        return this.installKeyPair(admin, privKey, new Certificate[]{cert}, alias, false);
    }

    public boolean installKeyPair(ComponentName admin, PrivateKey privKey, Certificate[] certs, String alias, boolean requestAccess) {
        int flags = 2;
        if (requestAccess) {
            flags |= 1;
        }
        return this.installKeyPair(admin, privKey, certs, alias, flags);
    }

    public boolean installKeyPair(ComponentName admin, PrivateKey privKey, Certificate[] certs, String alias, int flags) {
        this.throwIfParentInstance("installKeyPair");
        boolean requestAccess = (flags & 1) == 1;
        boolean isUserSelectable = (flags & 2) == 2;
        try {
            byte[] pemCert = Credentials.convertToPem(certs[0]);
            byte[] pemChain = null;
            if (certs.length > 1) {
                pemChain = Credentials.convertToPem(Arrays.copyOfRange(certs, 1, certs.length));
            }
            byte[] pkcs8Key = KeyFactory.getInstance(privKey.getAlgorithm()).getKeySpec(privKey, PKCS8EncodedKeySpec.class).getEncoded();
            return this.mService.installKeyPair(admin, this.mContext.getPackageName(), pkcs8Key, pemCert, pemChain, alias, requestAccess, isUserSelectable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            Log.w(TAG, "Failed to obtain private key material", e);
        }
        catch (IOException | CertificateException e) {
            Log.w(TAG, "Could not pem-encode certificate", e);
        }
        return false;
    }

    public boolean removeKeyPair(ComponentName admin, String alias) {
        this.throwIfParentInstance("removeKeyPair");
        try {
            return this.mService.removeKeyPair(admin, this.mContext.getPackageName(), alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasKeyPair(String alias) {
        this.throwIfParentInstance("hasKeyPair");
        try {
            return this.mService.hasKeyPair(this.mContext.getPackageName(), alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public AttestedKeyPair generateKeyPair(ComponentName admin, String algorithm, KeyGenParameterSpec keySpec, int idAttestationFlags) {
        this.throwIfParentInstance("generateKeyPair");
        try {
            ParcelableKeyGenParameterSpec parcelableSpec = new ParcelableKeyGenParameterSpec(keySpec);
            KeymasterCertificateChain attestationChain = new KeymasterCertificateChain();
            boolean success = this.mService.generateKeyPair(admin, this.mContext.getPackageName(), algorithm, parcelableSpec, idAttestationFlags, attestationChain);
            if (!success) {
                Log.e(TAG, "Error generating key via DevicePolicyManagerService.");
                return null;
            }
            String alias = keySpec.getKeystoreAlias();
            KeyPair keyPair = KeyChain.getKeyPair(this.mContext, alias);
            Certificate[] outputChain = null;
            try {
                if (AttestationUtils.isChainValid(attestationChain)) {
                    outputChain = AttestationUtils.parseCertificateChain(attestationChain);
                }
            }
            catch (KeyAttestationException e) {
                Log.e(TAG, "Error parsing attestation chain for alias " + alias, e);
                this.mService.removeKeyPair(admin, this.mContext.getPackageName(), alias);
                return null;
            }
            return new AttestedKeyPair(keyPair, outputChain);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (KeyChainException e) {
            Log.w(TAG, "Failed to generate key", e);
        }
        catch (InterruptedException e) {
            Log.w(TAG, "Interrupted while generating key", e);
            Thread.currentThread().interrupt();
        }
        catch (ServiceSpecificException e) {
            Log.w(TAG, String.format("Key Generation failure: %d", e.errorCode));
            switch (e.errorCode) {
                case 1: {
                    throw new StrongBoxUnavailableException("No StrongBox for key generation.");
                }
            }
            throw new RuntimeException(String.format("Unknown error while generating key: %d", e.errorCode));
        }
        return null;
    }

    public boolean grantKeyPairToApp(ComponentName admin, String alias, String packageName) {
        this.throwIfParentInstance("grantKeyPairToApp");
        try {
            return this.mService.setKeyGrantForApp(admin, this.mContext.getPackageName(), alias, packageName, true);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public Map<Integer, Set<String>> getKeyPairGrants(String alias) {
        this.throwIfParentInstance("getKeyPairGrants");
        try {
            return this.mService.getKeyPairGrants(this.mContext.getPackageName(), alias).getPackagesByUid();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public boolean revokeKeyPairFromApp(ComponentName admin, String alias, String packageName) {
        this.throwIfParentInstance("revokeKeyPairFromApp");
        try {
            return this.mService.setKeyGrantForApp(admin, this.mContext.getPackageName(), alias, packageName, false);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean grantKeyPairToWifiAuth(String alias) {
        this.throwIfParentInstance("grantKeyPairToWifiAuth");
        try {
            return this.mService.setKeyGrantToWifiAuth(this.mContext.getPackageName(), alias, true);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean revokeKeyPairFromWifiAuth(String alias) {
        this.throwIfParentInstance("revokeKeyPairFromWifiAuth");
        try {
            return this.mService.setKeyGrantToWifiAuth(this.mContext.getPackageName(), alias, false);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean isKeyPairGrantedToWifiAuth(String alias) {
        this.throwIfParentInstance("isKeyPairGrantedToWifiAuth");
        try {
            return this.mService.isKeyPairGrantedToWifiAuth(this.mContext.getPackageName(), alias);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }

    public boolean isDeviceIdAttestationSupported() {
        PackageManager pm = this.mContext.getPackageManager();
        return pm.hasSystemFeature("android.software.device_id_attestation");
    }

    public boolean isUniqueDeviceAttestationSupported() {
        PackageManager pm = this.mContext.getPackageManager();
        return pm.hasSystemFeature("android.hardware.device_unique_attestation");
    }

    public boolean setKeyPairCertificate(ComponentName admin, String alias, List<Certificate> certs, boolean isUserSelectable) {
        this.throwIfParentInstance("setKeyPairCertificate");
        try {
            byte[] pemCert = Credentials.convertToPem(certs.get(0));
            byte[] pemChain = null;
            if (certs.size() > 1) {
                pemChain = Credentials.convertToPem(certs.subList(1, certs.size()).toArray(new Certificate[0]));
            }
            return this.mService.setKeyPairCertificate(admin, this.mContext.getPackageName(), alias, pemCert, pemChain, isUserSelectable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IOException | CertificateException e) {
            Log.w(TAG, "Could not pem-encode certificate", e);
            return false;
        }
    }

    private static String getCaCertAlias(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
        return new TrustedCertificateStore().getCertificateAlias((Certificate)cert);
    }

    @Deprecated
    public void setCertInstallerPackage(ComponentName admin, String installerPackage) throws SecurityException {
        this.throwIfParentInstance("setCertInstallerPackage");
        if (this.mService != null) {
            try {
                this.mService.setCertInstallerPackage(admin, installerPackage);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public String getCertInstallerPackage(ComponentName admin) throws SecurityException {
        this.throwIfParentInstance("getCertInstallerPackage");
        if (this.mService != null) {
            try {
                return this.mService.getCertInstallerPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setDelegatedScopes(ComponentName admin, String delegatePackage, List<String> scopes) {
        this.throwIfParentInstance("setDelegatedScopes");
        if (this.mService != null) {
            try {
                this.mService.setDelegatedScopes(admin, delegatePackage, scopes);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public List<String> getDelegatedScopes(ComponentName admin, String delegatedPackage) {
        this.throwIfParentInstance("getDelegatedScopes");
        if (this.mService != null) {
            try {
                return this.mService.getDelegatedScopes(admin, delegatedPackage);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public List<String> getDelegatePackages(ComponentName admin, String delegationScope) {
        this.throwIfParentInstance("getDelegatePackages");
        if (this.mService != null) {
            try {
                return this.mService.getDelegatePackages(admin, delegationScope);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setAlwaysOnVpnPackage(ComponentName admin, String vpnPackage, boolean lockdownEnabled) throws PackageManager.NameNotFoundException {
        this.setAlwaysOnVpnPackage(admin, vpnPackage, lockdownEnabled, Collections.emptySet());
    }

    public void setAlwaysOnVpnPackage(ComponentName admin, String vpnPackage, boolean lockdownEnabled, Set<String> lockdownAllowlist) throws PackageManager.NameNotFoundException {
        this.throwIfParentInstance("setAlwaysOnVpnPackage");
        if (this.mService != null) {
            try {
                this.mService.setAlwaysOnVpnPackage(admin, vpnPackage, lockdownEnabled, (List<String>)(lockdownAllowlist == null ? null : new ArrayList<String>(lockdownAllowlist)));
            }
            catch (ServiceSpecificException e) {
                switch (e.errorCode) {
                    case 1: {
                        throw new PackageManager.NameNotFoundException(e.getMessage());
                    }
                }
                throw new RuntimeException("Unknown error setting always-on VPN: " + e.errorCode, e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isAlwaysOnVpnLockdownEnabled(ComponentName admin) {
        this.throwIfParentInstance("isAlwaysOnVpnLockdownEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isAlwaysOnVpnLockdownEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isAlwaysOnVpnLockdownEnabled() {
        this.throwIfParentInstance("isAlwaysOnVpnLockdownEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isAlwaysOnVpnLockdownEnabledForUser(this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public Set<String> getAlwaysOnVpnLockdownWhitelist(ComponentName admin) {
        this.throwIfParentInstance("getAlwaysOnVpnLockdownWhitelist");
        if (this.mService != null) {
            try {
                List<String> allowlist = this.mService.getAlwaysOnVpnLockdownAllowlist(admin);
                return allowlist == null ? null : new HashSet<String>(allowlist);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public String getAlwaysOnVpnPackage(ComponentName admin) {
        this.throwIfParentInstance("getAlwaysOnVpnPackage");
        if (this.mService != null) {
            try {
                return this.mService.getAlwaysOnVpnPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public String getAlwaysOnVpnPackage() {
        this.throwIfParentInstance("getAlwaysOnVpnPackage");
        if (this.mService != null) {
            try {
                return this.mService.getAlwaysOnVpnPackageForUser(this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setCameraDisabled(ComponentName admin, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setCameraDisabled(admin, disabled, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getCameraDisabled(ComponentName admin) {
        return this.getCameraDisabled(admin, this.myUserId());
    }

    @UnsupportedAppUsage
    public boolean getCameraDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCameraDisabled(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean requestBugreport(ComponentName admin) {
        this.throwIfParentInstance("requestBugreport");
        if (this.mService != null) {
            try {
                return this.mService.requestBugreport(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setScreenCaptureDisabled(ComponentName admin, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setScreenCaptureDisabled(admin, disabled, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getScreenCaptureDisabled(ComponentName admin) {
        return this.getScreenCaptureDisabled(admin, this.myUserId());
    }

    public boolean getScreenCaptureDisabled(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getScreenCaptureDisabled(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setNearbyNotificationStreamingPolicy(int policy) {
        this.throwIfParentInstance("setNearbyNotificationStreamingPolicy");
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setNearbyNotificationStreamingPolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getNearbyNotificationStreamingPolicy() {
        return this.getNearbyNotificationStreamingPolicy(this.myUserId());
    }

    public int getNearbyNotificationStreamingPolicy(int userId) {
        this.throwIfParentInstance("getNearbyNotificationStreamingPolicy");
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNearbyNotificationStreamingPolicy(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setNearbyAppStreamingPolicy(int policy) {
        this.throwIfParentInstance("setNearbyAppStreamingPolicy");
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setNearbyAppStreamingPolicy(policy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getNearbyAppStreamingPolicy() {
        return this.getNearbyAppStreamingPolicy(this.myUserId());
    }

    public int getNearbyAppStreamingPolicy(int userId) {
        this.throwIfParentInstance("getNearbyAppStreamingPolicy");
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getNearbyAppStreamingPolicy(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setAutoTimeRequired(ComponentName admin, boolean required) {
        this.throwIfParentInstance("setAutoTimeRequired");
        if (this.mService != null) {
            try {
                this.mService.setAutoTimeRequired(admin, required);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public boolean getAutoTimeRequired() {
        this.throwIfParentInstance("getAutoTimeRequired");
        if (this.mService != null) {
            try {
                return this.mService.getAutoTimeRequired();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setAutoTimeEnabled(ComponentName admin, boolean enabled) {
        if (this.mService != null) {
            try {
                this.mService.setAutoTimeEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getAutoTimeEnabled(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getAutoTimeEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setAutoTimeZoneEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setAutoTimeZone");
        if (this.mService != null) {
            try {
                this.mService.setAutoTimeZoneEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getAutoTimeZoneEnabled(ComponentName admin) {
        this.throwIfParentInstance("getAutoTimeZone");
        if (this.mService != null) {
            try {
                return this.mService.getAutoTimeZoneEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setForceEphemeralUsers(ComponentName admin, boolean forceEphemeralUsers) {
        this.throwIfParentInstance("setForceEphemeralUsers");
        if (this.mService != null) {
            try {
                this.mService.setForceEphemeralUsers(admin, forceEphemeralUsers);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getForceEphemeralUsers(ComponentName admin) {
        this.throwIfParentInstance("getForceEphemeralUsers");
        if (this.mService != null) {
            try {
                return this.mService.getForceEphemeralUsers(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setKeyguardDisabledFeatures(ComponentName admin, int which) {
        if (this.mService != null) {
            try {
                this.mService.setKeyguardDisabledFeatures(admin, which, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getKeyguardDisabledFeatures(ComponentName admin) {
        return this.getKeyguardDisabledFeatures(admin, this.myUserId());
    }

    @UnsupportedAppUsage
    public int getKeyguardDisabledFeatures(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getKeyguardDisabledFeatures(admin, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.MANAGE_DEVICE_ADMINS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void setActiveAdmin(ComponentName policyReceiver, boolean refreshing, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setActiveAdmin(policyReceiver, refreshing, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @UnsupportedAppUsage
    public void setActiveAdmin(ComponentName policyReceiver, boolean refreshing) {
        this.setActiveAdmin(policyReceiver, refreshing, this.myUserId());
    }

    public void getRemoveWarning(ComponentName admin, RemoteCallback result) {
        if (this.mService != null) {
            try {
                this.mService.getRemoveWarning(admin, result, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void reportPasswordChanged(int userId) {
        if (this.mService != null) {
            try {
                this.mService.reportPasswordChanged(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @UnsupportedAppUsage
    public void reportFailedPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportFailedPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @UnsupportedAppUsage
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportSuccessfulPasswordAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void reportFailedBiometricAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportFailedBiometricAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void reportSuccessfulBiometricAttempt(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportSuccessfulBiometricAttempt(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void reportKeyguardDismissed(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportKeyguardDismissed(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void reportKeyguardSecured(int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.reportKeyguardSecured(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean setDeviceOwner(ComponentName who) {
        return this.setDeviceOwner(who, null);
    }

    public boolean setDeviceOwner(ComponentName who, int userId) {
        return this.setDeviceOwner(who, null, userId);
    }

    public boolean setDeviceOwner(ComponentName who, String ownerName) {
        return this.setDeviceOwner(who, ownerName, 0);
    }

    @RequiresPermission(value="android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS")
    public boolean setDeviceOwner(ComponentName who, String ownerName, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.setDeviceOwner(who, ownerName, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isDeviceOwnerApp(String packageName) {
        this.throwIfParentInstance("isDeviceOwnerApp");
        return this.isDeviceOwnerAppOnCallingUser(packageName);
    }

    public boolean isDeviceOwnerAppOnCallingUser(String packageName) {
        return this.isDeviceOwnerAppOnAnyUserInner(packageName, true);
    }

    public boolean isDeviceOwnerAppOnAnyUser(String packageName) {
        return this.isDeviceOwnerAppOnAnyUserInner(packageName, false);
    }

    public ComponentName getDeviceOwnerComponentOnCallingUser() {
        return this.getDeviceOwnerComponentInner(true);
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS"})
    public ComponentName getDeviceOwnerComponentOnAnyUser() {
        return this.getDeviceOwnerComponentInner(false);
    }

    private boolean isDeviceOwnerAppOnAnyUserInner(String packageName, boolean callingUserOnly) {
        if (packageName == null) {
            return false;
        }
        ComponentName deviceOwner = this.getDeviceOwnerComponentInner(callingUserOnly);
        if (deviceOwner == null) {
            return false;
        }
        return packageName.equals(deviceOwner.getPackageName());
    }

    private ComponentName getDeviceOwnerComponentInner(boolean callingUserOnly) {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerComponent(callingUserOnly);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public UserHandle getDeviceOwnerUser() {
        if (this.mService != null) {
            try {
                int userId = this.mService.getDeviceOwnerUserId();
                if (userId != -10000) {
                    return UserHandle.of(userId);
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public int getDeviceOwnerUserId() {
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerUserId();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return -10000;
    }

    @Deprecated
    public void clearDeviceOwnerApp(String packageName) {
        this.throwIfParentInstance("clearDeviceOwnerApp");
        if (this.mService != null) {
            try {
                this.mService.clearDeviceOwner(packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getDeviceOwner() {
        this.throwIfParentInstance("getDeviceOwner");
        ComponentName name = this.getDeviceOwnerComponentOnCallingUser();
        return name != null ? name.getPackageName() : null;
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public boolean isDeviceManaged() {
        try {
            return this.mService.hasDeviceOwner();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getDeviceOwnerNameOnAnyUser() {
        this.throwIfParentInstance("getDeviceOwnerNameOnAnyUser");
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerName();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_DEVICE_ADMINS")
    public boolean setActiveProfileOwner(ComponentName admin, @Deprecated String ownerName) throws IllegalArgumentException {
        this.throwIfParentInstance("setActiveProfileOwner");
        if (this.mService != null) {
            try {
                int myUserId = this.myUserId();
                this.mService.setActiveAdmin(admin, false, myUserId);
                return this.mService.setProfileOwner(admin, ownerName, myUserId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    public void clearProfileOwner(ComponentName admin) {
        this.throwIfParentInstance("clearProfileOwner");
        if (this.mService != null) {
            try {
                this.mService.clearProfileOwner(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean hasUserSetupCompleted() {
        if (this.mService != null) {
            try {
                return this.mService.hasUserSetupCompleted();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean setProfileOwner(ComponentName admin, @Deprecated String ownerName, int userHandle) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                if (ownerName == null) {
                    ownerName = "";
                }
                return this.mService.setProfileOwner(admin, ownerName, userHandle);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setDeviceOwnerLockScreenInfo(ComponentName admin, CharSequence info) {
        this.throwIfParentInstance("setDeviceOwnerLockScreenInfo");
        if (this.mService != null) {
            try {
                this.mService.setDeviceOwnerLockScreenInfo(admin, info);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public CharSequence getDeviceOwnerLockScreenInfo() {
        this.throwIfParentInstance("getDeviceOwnerLockScreenInfo");
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerLockScreenInfo();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public String[] setPackagesSuspended(ComponentName admin, String[] packageNames, boolean suspended) {
        this.throwIfParentInstance("setPackagesSuspended");
        if (this.mService != null) {
            try {
                return this.mService.setPackagesSuspended(admin, this.mContext.getPackageName(), packageNames, suspended);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return packageNames;
    }

    public boolean isPackageSuspended(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        this.throwIfParentInstance("isPackageSuspended");
        if (this.mService != null) {
            try {
                return this.mService.isPackageSuspended(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            catch (IllegalArgumentException ex) {
                throw new PackageManager.NameNotFoundException(packageName);
            }
        }
        return false;
    }

    public void setProfileEnabled(ComponentName admin) {
        this.throwIfParentInstance("setProfileEnabled");
        if (this.mService != null) {
            try {
                this.mService.setProfileEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setProfileName(ComponentName admin, String profileName) {
        this.throwIfParentInstance("setProfileName");
        if (this.mService != null) {
            try {
                this.mService.setProfileName(admin, profileName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isProfileOwnerApp(String packageName) {
        this.throwIfParentInstance("isProfileOwnerApp");
        if (this.mService != null) {
            try {
                ComponentName profileOwner = this.mService.getProfileOwnerAsUser(this.myUserId());
                return profileOwner != null && profileOwner.getPackageName().equals(packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    public ComponentName getProfileOwner() throws IllegalArgumentException {
        this.throwIfParentInstance("getProfileOwner");
        return this.getProfileOwnerAsUser(this.mContext.getUserId());
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS", conditional=true)
    public ComponentName getProfileOwnerAsUser(UserHandle user) {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerAsUser(user.getIdentifier());
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public ComponentName getProfileOwnerAsUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerAsUser(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public ComponentName getProfileOwnerOrDeviceOwnerSupervisionComponent(UserHandle user) {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerOrDeviceOwnerSupervisionComponent(user);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public String getProfileOwnerName() throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(this.mContext.getUserId());
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public String getProfileOwnerNameAsUser(int userId) throws IllegalArgumentException {
        this.throwIfParentInstance("getProfileOwnerNameAsUser");
        if (this.mService != null) {
            try {
                return this.mService.getProfileOwnerName(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean isOrganizationOwnedDeviceWithManagedProfile() {
        this.throwIfParentInstance("isOrganizationOwnedDeviceWithManagedProfile");
        if (this.mService != null) {
            try {
                return this.mService.isOrganizationOwnedDeviceWithManagedProfile();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean hasDeviceIdentifierAccess(String packageName, int pid, int uid) {
        this.throwIfParentInstance("hasDeviceIdentifierAccess");
        if (packageName == null) {
            return false;
        }
        if (this.mService != null) {
            try {
                return this.mService.checkDeviceIdentifierAccess(packageName, pid, uid);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void addPersistentPreferredActivity(ComponentName admin, IntentFilter filter, ComponentName activity) {
        this.throwIfParentInstance("addPersistentPreferredActivity");
        if (this.mService != null) {
            try {
                this.mService.addPersistentPreferredActivity(admin, filter, activity);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void clearPackagePersistentPreferredActivities(ComponentName admin, String packageName) {
        this.throwIfParentInstance("clearPackagePersistentPreferredActivities");
        if (this.mService != null) {
            try {
                this.mService.clearPackagePersistentPreferredActivities(admin, packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setDefaultSmsApplication(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                this.mService.setDefaultSmsApplication(admin, packageName, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public void setApplicationRestrictionsManagingPackage(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        this.throwIfParentInstance("setApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                if (!this.mService.setApplicationRestrictionsManagingPackage(admin, packageName)) {
                    throw new PackageManager.NameNotFoundException(packageName);
                }
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Deprecated
    public String getApplicationRestrictionsManagingPackage(ComponentName admin) {
        this.throwIfParentInstance("getApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                return this.mService.getApplicationRestrictionsManagingPackage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @Deprecated
    public boolean isCallerApplicationRestrictionsManagingPackage() {
        this.throwIfParentInstance("isCallerApplicationRestrictionsManagingPackage");
        if (this.mService != null) {
            try {
                return this.mService.isCallerApplicationRestrictionsManagingPackage(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setApplicationRestrictions(ComponentName admin, String packageName, Bundle settings) {
        this.throwIfParentInstance("setApplicationRestrictions");
        if (this.mService != null) {
            try {
                this.mService.setApplicationRestrictions(admin, this.mContext.getPackageName(), packageName, settings);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setTrustAgentConfiguration(ComponentName admin, ComponentName target, PersistableBundle configuration) {
        if (this.mService != null) {
            try {
                this.mService.setTrustAgentConfiguration(admin, target, configuration, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName admin, ComponentName agent) {
        return this.getTrustAgentConfiguration(admin, agent, this.myUserId());
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName admin, ComponentName agent, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getTrustAgentConfiguration(admin, agent, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return new ArrayList<PersistableBundle>();
    }

    public void setCrossProfileCallerIdDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setCrossProfileCallerIdDisabled");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileCallerIdDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getCrossProfileCallerIdDisabled(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileCallerIdDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileCallerIdDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setCrossProfileContactsSearchDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setCrossProfileContactsSearchDisabled");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileContactsSearchDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getCrossProfileContactsSearchDisabled(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileContactsSearchDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileContactsSearchDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean getCrossProfileContactsSearchDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getCrossProfileContactsSearchDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void startManagedQuickContact(String actualLookupKey, long actualContactId, boolean isContactIdIgnored, long directoryId, Intent originalIntent) {
        if (this.mService != null) {
            try {
                this.mService.startManagedQuickContact(actualLookupKey, actualContactId, isContactIdIgnored, directoryId, originalIntent);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void startManagedQuickContact(String actualLookupKey, long actualContactId, Intent originalIntent) {
        this.startManagedQuickContact(actualLookupKey, actualContactId, false, 0L, originalIntent);
    }

    public void setBluetoothContactSharingDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setBluetoothContactSharingDisabled");
        if (this.mService != null) {
            try {
                this.mService.setBluetoothContactSharingDisabled(admin, disabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean getBluetoothContactSharingDisabled(ComponentName admin) {
        this.throwIfParentInstance("getBluetoothContactSharingDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getBluetoothContactSharingDisabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS")
    public boolean getBluetoothContactSharingDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getBluetoothContactSharingDisabledForUser(userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public void addCrossProfileIntentFilter(ComponentName admin, IntentFilter filter, int flags) {
        this.throwIfParentInstance("addCrossProfileIntentFilter");
        if (this.mService != null) {
            try {
                this.mService.addCrossProfileIntentFilter(admin, filter, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void clearCrossProfileIntentFilters(ComponentName admin) {
        this.throwIfParentInstance("clearCrossProfileIntentFilters");
        if (this.mService != null) {
            try {
                this.mService.clearCrossProfileIntentFilters(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.setPermittedAccessibilityServices(admin, packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<String> getPermittedAccessibilityServices(ComponentName admin) {
        this.throwIfParentInstance("getPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServices(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean isAccessibilityServicePermittedByAdmin(ComponentName admin, String packageName, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isAccessibilityServicePermittedByAdmin(admin, packageName, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public List<String> getPermittedAccessibilityServices(int userId) {
        this.throwIfParentInstance("getPermittedAccessibilityServices");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedAccessibilityServicesForUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        if (this.mService != null) {
            try {
                return this.mService.setPermittedInputMethods(admin, packageNames, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<String> getPermittedInputMethods(ComponentName admin) {
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethods(admin, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean isInputMethodPermittedByAdmin(ComponentName admin, String packageName, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.isInputMethodPermittedByAdmin(admin, packageName, userHandle, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public List<String> getPermittedInputMethodsForCurrentUser() {
        this.throwIfParentInstance("getPermittedInputMethodsForCurrentUser");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedInputMethodsForCurrentUser();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean setPermittedCrossProfileNotificationListeners(ComponentName admin, List<String> packageList) {
        this.throwIfParentInstance("setPermittedCrossProfileNotificationListeners");
        if (this.mService != null) {
            try {
                return this.mService.setPermittedCrossProfileNotificationListeners(admin, packageList);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<String> getPermittedCrossProfileNotificationListeners(ComponentName admin) {
        this.throwIfParentInstance("getPermittedCrossProfileNotificationListeners");
        if (this.mService != null) {
            try {
                return this.mService.getPermittedCrossProfileNotificationListeners(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean isNotificationListenerServicePermitted(String packageName, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isNotificationListenerServicePermitted(packageName, userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public List<String> getKeepUninstalledPackages(ComponentName admin) {
        this.throwIfParentInstance("getKeepUninstalledPackages");
        if (this.mService != null) {
            try {
                return this.mService.getKeepUninstalledPackages(admin, this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setKeepUninstalledPackages(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setKeepUninstalledPackages");
        if (this.mService != null) {
            try {
                this.mService.setKeepUninstalledPackages(admin, this.mContext.getPackageName(), packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public UserHandle createAndManageUser(ComponentName admin, String name, ComponentName profileOwner, PersistableBundle adminExtras, int flags) {
        this.throwIfParentInstance("createAndManageUser");
        try {
            return this.mService.createAndManageUser(admin, name, profileOwner, adminExtras, flags);
        }
        catch (ServiceSpecificException e) {
            throw new UserManager.UserOperationException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean removeUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("removeUser");
        try {
            return this.mService.removeUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean switchUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("switchUser");
        try {
            return this.mService.switchUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int startUserInBackground(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("startUserInBackground");
        try {
            return this.mService.startUserInBackground(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int stopUser(ComponentName admin, UserHandle userHandle) {
        this.throwIfParentInstance("stopUser");
        try {
            return this.mService.stopUser(admin, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int logoutUser(ComponentName admin) {
        this.throwIfParentInstance("logoutUser");
        try {
            return this.mService.logoutUser(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<UserHandle> getSecondaryUsers(ComponentName admin) {
        this.throwIfParentInstance("getSecondaryUsers");
        try {
            return this.mService.getSecondaryUsers(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isEphemeralUser(ComponentName admin) {
        this.throwIfParentInstance("isEphemeralUser");
        try {
            return this.mService.isEphemeralUser(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getApplicationRestrictions(ComponentName admin, String packageName) {
        this.throwIfParentInstance("getApplicationRestrictions");
        if (this.mService != null) {
            try {
                return this.mService.getApplicationRestrictions(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void addUserRestriction(ComponentName admin, String key) {
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, true, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void clearUserRestriction(ComponentName admin, String key) {
        if (this.mService != null) {
            try {
                this.mService.setUserRestriction(admin, key, false, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public Bundle getUserRestrictions(ComponentName admin) {
        Bundle ret = null;
        if (this.mService != null) {
            try {
                ret = this.mService.getUserRestrictions(admin, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return ret == null ? new Bundle() : ret;
    }

    public Intent createAdminSupportIntent(String restriction) {
        this.throwIfParentInstance("createAdminSupportIntent");
        if (this.mService != null) {
            try {
                return this.mService.createAdminSupportIntent(restriction);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public boolean setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        if (this.mService != null) {
            try {
                return this.mService.setApplicationHidden(admin, this.mContext.getPackageName(), packageName, hidden, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean isApplicationHidden(ComponentName admin, String packageName) {
        if (this.mService != null) {
            try {
                return this.mService.isApplicationHidden(admin, this.mContext.getPackageName(), packageName, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void enableSystemApp(ComponentName admin, String packageName) {
        this.throwIfParentInstance("enableSystemApp");
        if (this.mService != null) {
            try {
                this.mService.enableSystemApp(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int enableSystemApp(ComponentName admin, Intent intent) {
        this.throwIfParentInstance("enableSystemApp");
        if (this.mService != null) {
            try {
                return this.mService.enableSystemAppWithIntent(admin, this.mContext.getPackageName(), intent);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public boolean installExistingPackage(ComponentName admin, String packageName) {
        this.throwIfParentInstance("installExistingPackage");
        if (this.mService != null) {
            try {
                return this.mService.installExistingPackage(admin, this.mContext.getPackageName(), packageName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        if (this.mService != null) {
            try {
                this.mService.setAccountManagementDisabled(admin, accountType, disabled, this.mParentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(this.myUserId(), this.mParentInstance);
    }

    public String[] getAccountTypesWithManagementDisabledAsUser(int userId) {
        return this.getAccountTypesWithManagementDisabledAsUser(userId, false);
    }

    public String[] getAccountTypesWithManagementDisabledAsUser(int userId, boolean parentInstance) {
        if (this.mService != null) {
            try {
                return this.mService.getAccountTypesWithManagementDisabledAsUser(userId, parentInstance);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    public void setSecondaryLockscreenEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setSecondaryLockscreenEnabled");
        if (this.mService != null) {
            try {
                this.mService.setSecondaryLockscreenEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    public boolean isSecondaryLockscreenEnabled(UserHandle userHandle) {
        this.throwIfParentInstance("isSecondaryLockscreenEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isSecondaryLockscreenEnabled(userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setLockTaskPackages(ComponentName admin, String[] packages) throws SecurityException {
        this.throwIfParentInstance("setLockTaskPackages");
        if (this.mService != null) {
            try {
                this.mService.setLockTaskPackages(admin, packages);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public String[] getLockTaskPackages(ComponentName admin) {
        this.throwIfParentInstance("getLockTaskPackages");
        if (this.mService != null) {
            try {
                return this.mService.getLockTaskPackages(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return new String[0];
    }

    public boolean isLockTaskPermitted(String pkg) {
        this.throwIfParentInstance("isLockTaskPermitted");
        if (this.mService != null) {
            try {
                return this.mService.isLockTaskPermitted(pkg);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setLockTaskFeatures(ComponentName admin, int flags) {
        this.throwIfParentInstance("setLockTaskFeatures");
        if (this.mService != null) {
            try {
                this.mService.setLockTaskFeatures(admin, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public int getLockTaskFeatures(ComponentName admin) {
        this.throwIfParentInstance("getLockTaskFeatures");
        if (this.mService != null) {
            try {
                return this.mService.getLockTaskFeatures(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public void setPreferentialNetworkServiceEnabled(boolean enabled) {
        this.throwIfParentInstance("setPreferentialNetworkServiceEnabled");
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setPreferentialNetworkServiceEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPreferentialNetworkServiceEnabled() {
        this.throwIfParentInstance("isPreferentialNetworkServiceEnabled");
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.isPreferentialNetworkServiceEnabled(this.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setGlobalSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setGlobalSetting");
        if (this.mService != null) {
            try {
                this.mService.setGlobalSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setSystemSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setSystemSetting");
        if (this.mService != null) {
            try {
                this.mService.setSystemSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setConfiguredNetworksLockdownState(ComponentName admin, boolean lockdown) {
        this.throwIfParentInstance("setConfiguredNetworksLockdownState");
        if (this.mService != null) {
            try {
                this.mService.setConfiguredNetworksLockdownState(admin, lockdown);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean hasLockdownAdminConfiguredNetworks(ComponentName admin) {
        this.throwIfParentInstance("hasLockdownAdminConfiguredNetworks");
        if (this.mService != null) {
            try {
                return this.mService.hasLockdownAdminConfiguredNetworks(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean setTime(ComponentName admin, long millis) {
        this.throwIfParentInstance("setTime");
        if (this.mService != null) {
            try {
                return this.mService.setTime(admin, millis);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean setTimeZone(ComponentName admin, String timeZone) {
        this.throwIfParentInstance("setTimeZone");
        if (this.mService != null) {
            try {
                return this.mService.setTimeZone(admin, timeZone);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setLocationEnabled(ComponentName admin, boolean locationEnabled) {
        this.throwIfParentInstance("setLocationEnabled");
        if (this.mService != null) {
            try {
                this.mService.setLocationEnabled(admin, locationEnabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setSecureSetting(ComponentName admin, String setting, String value) {
        this.throwIfParentInstance("setSecureSetting");
        if (this.mService != null) {
            try {
                this.mService.setSecureSetting(admin, setting, value);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setRestrictionsProvider(ComponentName admin, ComponentName provider) {
        this.throwIfParentInstance("setRestrictionsProvider");
        if (this.mService != null) {
            try {
                this.mService.setRestrictionsProvider(admin, provider);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public void setMasterVolumeMuted(ComponentName admin, boolean on) {
        this.throwIfParentInstance("setMasterVolumeMuted");
        if (this.mService != null) {
            try {
                this.mService.setMasterVolumeMuted(admin, on);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean isMasterVolumeMuted(ComponentName admin) {
        this.throwIfParentInstance("isMasterVolumeMuted");
        if (this.mService != null) {
            try {
                return this.mService.isMasterVolumeMuted(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        this.throwIfParentInstance("setUninstallBlocked");
        if (this.mService != null) {
            try {
                this.mService.setUninstallBlocked(admin, this.mContext.getPackageName(), packageName, uninstallBlocked);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean isUninstallBlocked(ComponentName admin, String packageName) {
        this.throwIfParentInstance("isUninstallBlocked");
        if (this.mService != null) {
            try {
                return this.mService.isUninstallBlocked(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        this.throwIfParentInstance("addCrossProfileWidgetProvider");
        if (this.mService != null) {
            try {
                return this.mService.addCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        this.throwIfParentInstance("removeCrossProfileWidgetProvider");
        if (this.mService != null) {
            try {
                return this.mService.removeCrossProfileWidgetProvider(admin, packageName);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<String> getCrossProfileWidgetProviders(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileWidgetProviders");
        if (this.mService != null) {
            try {
                List<String> providers = this.mService.getCrossProfileWidgetProviders(admin);
                if (providers != null) {
                    return providers;
                }
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    public void setUserIcon(ComponentName admin, Bitmap icon) {
        this.throwIfParentInstance("setUserIcon");
        try {
            this.mService.setUserIcon(admin, icon);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setSystemUpdatePolicy(ComponentName admin, SystemUpdatePolicy policy) {
        this.throwIfParentInstance("setSystemUpdatePolicy");
        if (this.mService != null) {
            try {
                this.mService.setSystemUpdatePolicy(admin, policy);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public SystemUpdatePolicy getSystemUpdatePolicy() {
        this.throwIfParentInstance("getSystemUpdatePolicy");
        if (this.mService != null) {
            try {
                return this.mService.getSystemUpdatePolicy();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.CLEAR_FREEZE_PERIOD")
    public void clearSystemUpdatePolicyFreezePeriodRecord() {
        this.throwIfParentInstance("clearSystemUpdatePolicyFreezePeriodRecord");
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.clearSystemUpdatePolicyFreezePeriodRecord();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean setKeyguardDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setKeyguardDisabled");
        try {
            return this.mService.setKeyguardDisabled(admin, disabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean setStatusBarDisabled(ComponentName admin, boolean disabled) {
        this.throwIfParentInstance("setStatusBarDisabled");
        try {
            return this.mService.setStatusBarDisabled(admin, disabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFY_PENDING_SYSTEM_UPDATE")
    public void notifyPendingSystemUpdate(long updateReceivedTime) {
        this.throwIfParentInstance("notifyPendingSystemUpdate");
        if (this.mService != null) {
            try {
                this.mService.notifyPendingSystemUpdate(SystemUpdateInfo.of(updateReceivedTime));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.NOTIFY_PENDING_SYSTEM_UPDATE")
    public void notifyPendingSystemUpdate(long updateReceivedTime, boolean isSecurityPatch) {
        this.throwIfParentInstance("notifyPendingSystemUpdate");
        if (this.mService != null) {
            try {
                this.mService.notifyPendingSystemUpdate(SystemUpdateInfo.of(updateReceivedTime, isSecurityPatch));
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public SystemUpdateInfo getPendingSystemUpdate(ComponentName admin) {
        this.throwIfParentInstance("getPendingSystemUpdate");
        try {
            return this.mService.getPendingSystemUpdate(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setPermissionPolicy(ComponentName admin, int policy) {
        this.throwIfParentInstance("setPermissionPolicy");
        try {
            this.mService.setPermissionPolicy(admin, this.mContext.getPackageName(), policy);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int getPermissionPolicy(ComponentName admin) {
        this.throwIfParentInstance("getPermissionPolicy");
        try {
            return this.mService.getPermissionPolicy(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) {
        this.throwIfParentInstance("setPermissionGrantState");
        try {
            CompletableFuture result = new CompletableFuture();
            this.mService.setPermissionGrantState(admin, this.mContext.getPackageName(), packageName, permission2, grantState, new RemoteCallback(b -> result.complete(b != null)));
            BackgroundThread.getHandler().sendMessageDelayed(PooledLambda.obtainMessage(CompletableFuture::complete, result, false), 20000L);
            return (Boolean)result.get();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPermissionGrantState(ComponentName admin, String packageName, String permission2) {
        this.throwIfParentInstance("getPermissionGrantState");
        try {
            return this.mService.getPermissionGrantState(admin, this.mContext.getPackageName(), packageName, permission2);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isProvisioningAllowed(String action) {
        this.throwIfParentInstance("isProvisioningAllowed");
        try {
            return this.mService.isProvisioningAllowed(action, this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int checkProvisioningPreCondition(String action, String packageName) {
        try {
            return this.mService.checkProvisioningPreCondition(action, packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isManagedProfile(ComponentName admin) {
        this.throwIfParentInstance("isManagedProfile");
        try {
            return this.mService.isManagedProfile(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public String getWifiMacAddress(ComponentName admin) {
        this.throwIfParentInstance("getWifiMacAddress");
        try {
            return this.mService.getWifiMacAddress(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void reboot(ComponentName admin) {
        this.throwIfParentInstance("reboot");
        try {
            this.mService.reboot(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setShortSupportMessage(ComponentName admin, CharSequence message) {
        this.throwIfParentInstance("setShortSupportMessage");
        if (this.mService != null) {
            try {
                this.mService.setShortSupportMessage(admin, message);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public CharSequence getShortSupportMessage(ComponentName admin) {
        this.throwIfParentInstance("getShortSupportMessage");
        if (this.mService != null) {
            try {
                return this.mService.getShortSupportMessage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public void setLongSupportMessage(ComponentName admin, CharSequence message) {
        this.throwIfParentInstance("setLongSupportMessage");
        if (this.mService != null) {
            try {
                this.mService.setLongSupportMessage(admin, message);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public CharSequence getLongSupportMessage(ComponentName admin) {
        this.throwIfParentInstance("getLongSupportMessage");
        if (this.mService != null) {
            try {
                return this.mService.getLongSupportMessage(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public CharSequence getShortSupportMessageForUser(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getShortSupportMessageForUser(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public CharSequence getLongSupportMessageForUser(ComponentName admin, int userHandle) {
        if (this.mService != null) {
            try {
                return this.mService.getLongSupportMessageForUser(admin, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    public DevicePolicyManager getParentProfileInstance(ComponentName admin) {
        this.throwIfParentInstance("getParentProfileInstance");
        try {
            if (!this.mService.isManagedProfile(admin)) {
                throw new SecurityException("The current user does not have a parent profile.");
            }
            return new DevicePolicyManager(this.mContext, this.mService, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setSecurityLoggingEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setSecurityLoggingEnabled");
        try {
            this.mService.setSecurityLoggingEnabled(admin, this.mContext.getPackageName(), enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isSecurityLoggingEnabled(ComponentName admin) {
        this.throwIfParentInstance("isSecurityLoggingEnabled");
        try {
            return this.mService.isSecurityLoggingEnabled(admin, this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"NullableCollection"})
    public List<SecurityLog.SecurityEvent> retrieveSecurityLogs(ComponentName admin) {
        this.throwIfParentInstance("retrieveSecurityLogs");
        try {
            ParceledListSlice list = this.mService.retrieveSecurityLogs(admin, this.mContext.getPackageName());
            if (list != null) {
                return list.getList();
            }
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.FORCE_DEVICE_POLICY_MANAGER_LOGS")
    public long forceNetworkLogs() {
        if (this.mService == null) {
            return -1L;
        }
        try {
            return this.mService.forceNetworkLogs();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.FORCE_DEVICE_POLICY_MANAGER_LOGS")
    public long forceSecurityLogs() {
        if (this.mService == null) {
            return 0L;
        }
        try {
            return this.mService.forceSecurityLogs();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public DevicePolicyManager getParentProfileInstance(UserInfo uInfo) {
        this.mContext.checkSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS");
        if (!uInfo.isManagedProfile()) {
            throw new SecurityException("The user " + uInfo.id + " does not have a parent profile.");
        }
        return new DevicePolicyManager(this.mContext, this.mService, true);
    }

    public List<String> setMeteredDataDisabledPackages(ComponentName admin, List<String> packageNames) {
        this.throwIfParentInstance("setMeteredDataDisabled");
        if (this.mService != null) {
            try {
                return this.mService.setMeteredDataDisabledPackages(admin, packageNames);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return packageNames;
    }

    public List<String> getMeteredDataDisabledPackages(ComponentName admin) {
        this.throwIfParentInstance("getMeteredDataDisabled");
        if (this.mService != null) {
            try {
                return this.mService.getMeteredDataDisabledPackages(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return new ArrayList<String>();
    }

    public boolean isMeteredDataDisabledPackageForUser(ComponentName admin, String packageName, int userId) {
        this.throwIfParentInstance("getMeteredDataDisabledForUser");
        if (this.mService != null) {
            try {
                return this.mService.isMeteredDataDisabledPackageForUser(admin, packageName, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SuppressLint(value={"NullableCollection"})
    public List<SecurityLog.SecurityEvent> retrievePreRebootSecurityLogs(ComponentName admin) {
        this.throwIfParentInstance("retrievePreRebootSecurityLogs");
        try {
            ParceledListSlice list = this.mService.retrievePreRebootSecurityLogs(admin, this.mContext.getPackageName());
            if (list != null) {
                return list.getList();
            }
            return null;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setOrganizationColor(ComponentName admin, int color2) {
        this.throwIfParentInstance("setOrganizationColor");
        try {
            this.mService.setOrganizationColor(admin, color2 |= 0xFF000000);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void setOrganizationColorForUser(int color2, int userId) {
        try {
            this.mService.setOrganizationColorForUser(color2 |= 0xFF000000, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int getOrganizationColor(ComponentName admin) {
        this.throwIfParentInstance("getOrganizationColor");
        try {
            return this.mService.getOrganizationColor(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int getOrganizationColorForUser(int userHandle) {
        try {
            return this.mService.getOrganizationColorForUser(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setOrganizationName(ComponentName admin, CharSequence title) {
        this.throwIfParentInstance("setOrganizationName");
        try {
            this.mService.setOrganizationName(admin, title);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public CharSequence getOrganizationName(ComponentName admin) {
        this.throwIfParentInstance("getOrganizationName");
        try {
            return this.mService.getOrganizationName(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @SuppressLint(value={"RequiresPermission"})
    public CharSequence getDeviceOwnerOrganizationName() {
        try {
            return this.mService.getDeviceOwnerOrganizationName();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public CharSequence getOrganizationNameForUser(int userHandle) {
        try {
            return this.mService.getOrganizationNameForUser(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getUserProvisioningState() {
        this.throwIfParentInstance("getUserProvisioningState");
        if (this.mService != null) {
            try {
                return this.mService.getUserProvisioningState();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public void setUserProvisioningState(int state, int userHandle) {
        if (this.mService != null) {
            try {
                this.mService.setUserProvisioningState(state, userHandle);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void setAffiliationIds(ComponentName admin, Set<String> ids) {
        this.throwIfParentInstance("setAffiliationIds");
        if (ids == null) {
            throw new IllegalArgumentException("ids must not be null");
        }
        try {
            this.mService.setAffiliationIds(admin, new ArrayList<String>(ids));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public Set<String> getAffiliationIds(ComponentName admin) {
        this.throwIfParentInstance("getAffiliationIds");
        try {
            return new ArraySet<String>(this.mService.getAffiliationIds(admin));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAffiliatedUser() {
        this.throwIfParentInstance("isAffiliatedUser");
        try {
            return this.mService.isCallingUserAffiliated();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isAffiliatedUser(int userId) {
        try {
            return this.mService.isAffiliatedUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isUninstallInQueue(String packageName) {
        try {
            return this.mService.isUninstallInQueue(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void uninstallPackageWithActiveAdmins(String packageName) {
        try {
            this.mService.uninstallPackageWithActiveAdmins(packageName);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS")
    public void forceRemoveActiveAdmin(ComponentName adminReceiver, int userHandle) {
        try {
            this.mService.forceRemoveActiveAdmin(adminReceiver, userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isDeviceProvisioned() {
        try {
            return this.mService.isDeviceProvisioned();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public void setDeviceProvisioningConfigApplied() {
        try {
            this.mService.setDeviceProvisioningConfigApplied();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isDeviceProvisioningConfigApplied() {
        try {
            return this.mService.isDeviceProvisioningConfigApplied();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void forceUpdateUserSetupComplete(int userId) {
        try {
            this.mService.forceUpdateUserSetupComplete(userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void throwIfParentInstance(String functionName) {
        if (this.mParentInstance) {
            throw new SecurityException(functionName + " cannot be called on the parent instance");
        }
    }

    public void setBackupServiceEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setBackupServiceEnabled");
        try {
            this.mService.setBackupServiceEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isBackupServiceEnabled(ComponentName admin) {
        this.throwIfParentInstance("isBackupServiceEnabled");
        try {
            return this.mService.isBackupServiceEnabled(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setNetworkLoggingEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setNetworkLoggingEnabled");
        try {
            this.mService.setNetworkLoggingEnabled(admin, this.mContext.getPackageName(), enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isNetworkLoggingEnabled(ComponentName admin) {
        this.throwIfParentInstance("isNetworkLoggingEnabled");
        try {
            return this.mService.isNetworkLoggingEnabled(admin, this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<NetworkEvent> retrieveNetworkLogs(ComponentName admin, long batchToken) {
        this.throwIfParentInstance("retrieveNetworkLogs");
        try {
            return this.mService.retrieveNetworkLogs(admin, this.mContext.getPackageName(), batchToken);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean bindDeviceAdminServiceAsUser(ComponentName admin, Intent serviceIntent, ServiceConnection conn, int flags, UserHandle targetUser) {
        this.throwIfParentInstance("bindDeviceAdminServiceAsUser");
        try {
            IServiceConnection sd = this.mContext.getServiceDispatcher(conn, this.mContext.getMainThreadHandler(), flags);
            serviceIntent.prepareToLeaveProcess(this.mContext);
            return this.mService.bindDeviceAdminServiceAsUser(admin, this.mContext.getIApplicationThread(), this.mContext.getActivityToken(), serviceIntent, sd, flags, targetUser.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<UserHandle> getBindDeviceAdminTargetUsers(ComponentName admin) {
        this.throwIfParentInstance("getBindDeviceAdminTargetUsers");
        try {
            return this.mService.getBindDeviceAdminTargetUsers(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getLastSecurityLogRetrievalTime() {
        try {
            return this.mService.getLastSecurityLogRetrievalTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getLastBugReportRequestTime() {
        try {
            return this.mService.getLastBugReportRequestTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public long getLastNetworkLogRetrievalTime() {
        try {
            return this.mService.getLastNetworkLogRetrievalTime();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isCurrentInputMethodSetByOwner() {
        try {
            return this.mService.isCurrentInputMethodSetByOwner();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<String> getOwnerInstalledCaCerts(UserHandle user) {
        try {
            return this.mService.getOwnerInstalledCaCerts(user).getList();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isFactoryResetProtectionPolicySupported() {
        try {
            return this.mService.isFactoryResetProtectionPolicySupported();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void clearApplicationUserData(ComponentName admin, String packageName, final Executor executor, final OnClearApplicationUserDataListener listener) {
        this.throwIfParentInstance("clearAppData");
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        try {
            this.mService.clearApplicationUserData(admin, packageName, new IPackageDataObserver.Stub(){

                @Override
                public void onRemoveCompleted(String pkg, boolean succeeded) {
                    executor.execute(() -> listener.onApplicationUserDataCleared(pkg, succeeded));
                }
            });
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setLogoutEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setLogoutEnabled");
        try {
            this.mService.setLogoutEnabled(admin, enabled);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isLogoutEnabled() {
        this.throwIfParentInstance("isLogoutEnabled");
        try {
            return this.mService.isLogoutEnabled();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Set<String> getDisallowedSystemApps(ComponentName admin, int userId, String provisioningAction) {
        try {
            return new ArraySet<String>(this.mService.getDisallowedSystemApps(admin, userId, provisioningAction));
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void transferOwnership(ComponentName admin, ComponentName target, PersistableBundle bundle) {
        this.throwIfParentInstance("transferOwnership");
        try {
            this.mService.transferOwnership(admin, target, bundle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setStartUserSessionMessage(ComponentName admin, CharSequence startUserSessionMessage) {
        this.throwIfParentInstance("setStartUserSessionMessage");
        try {
            this.mService.setStartUserSessionMessage(admin, startUserSessionMessage);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setEndUserSessionMessage(ComponentName admin, CharSequence endUserSessionMessage) {
        this.throwIfParentInstance("setEndUserSessionMessage");
        try {
            this.mService.setEndUserSessionMessage(admin, endUserSessionMessage);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public CharSequence getStartUserSessionMessage(ComponentName admin) {
        this.throwIfParentInstance("getStartUserSessionMessage");
        try {
            return this.mService.getStartUserSessionMessage(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public CharSequence getEndUserSessionMessage(ComponentName admin) {
        this.throwIfParentInstance("getEndUserSessionMessage");
        try {
            return this.mService.getEndUserSessionMessage(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int addOverrideApn(ComponentName admin, ApnSetting apnSetting) {
        this.throwIfParentInstance("addOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.addOverrideApn(admin, apnSetting);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return -1;
    }

    public boolean updateOverrideApn(ComponentName admin, int apnId, ApnSetting apnSetting) {
        this.throwIfParentInstance("updateOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.updateOverrideApn(admin, apnId, apnSetting);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean removeOverrideApn(ComponentName admin, int apnId) {
        this.throwIfParentInstance("removeOverrideApn");
        if (this.mService != null) {
            try {
                return this.mService.removeOverrideApn(admin, apnId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<ApnSetting> getOverrideApns(ComponentName admin) {
        this.throwIfParentInstance("getOverrideApns");
        if (this.mService != null) {
            try {
                return this.mService.getOverrideApns(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    public void setOverrideApnsEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setOverrideApnEnabled");
        if (this.mService != null) {
            try {
                this.mService.setOverrideApnsEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isOverrideApnEnabled(ComponentName admin) {
        this.throwIfParentInstance("isOverrideApnEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isOverrideApnEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public PersistableBundle getTransferOwnershipBundle() {
        this.throwIfParentInstance("getTransferOwnershipBundle");
        try {
            return this.mService.getTransferOwnershipBundle();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int setGlobalPrivateDnsModeOpportunistic(ComponentName admin) {
        this.throwIfParentInstance("setGlobalPrivateDnsModeOpportunistic");
        if (this.mService == null) {
            return 2;
        }
        try {
            return this.mService.setGlobalPrivateDns(admin, 2, null);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public int setGlobalPrivateDnsModeSpecifiedHost(ComponentName admin, String privateDnsHost) {
        this.throwIfParentInstance("setGlobalPrivateDnsModeSpecifiedHost");
        Objects.requireNonNull(privateDnsHost, "dns resolver is null");
        if (this.mService == null) {
            return 2;
        }
        if (NetworkUtilsInternal.isWeaklyValidatedHostname(privateDnsHost) && !PrivateDnsConnectivityChecker.canConnectToPrivateDnsServer(privateDnsHost)) {
            return 1;
        }
        try {
            return this.mService.setGlobalPrivateDns(admin, 3, privateDnsHost);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void installSystemUpdate(ComponentName admin, Uri updateFilePath, final Executor executor, final InstallSystemUpdateCallback callback) {
        this.throwIfParentInstance("installUpdate");
        if (this.mService == null) {
            return;
        }
        try (ParcelFileDescriptor fileDescriptor = this.mContext.getContentResolver().openFileDescriptor(updateFilePath, "r");){
            this.mService.installUpdateFromFile(admin, fileDescriptor, new StartInstallingUpdateCallback.Stub(){

                @Override
                public void onStartInstallingUpdateError(int errorCode, String errorMessage) {
                    DevicePolicyManager.this.executeCallback(errorCode, errorMessage, executor, callback);
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (FileNotFoundException e) {
            Log.w(TAG, e);
            this.executeCallback(4, Log.getStackTraceString(e), executor, callback);
        }
        catch (IOException e) {
            Log.w(TAG, e);
            this.executeCallback(1, Log.getStackTraceString(e), executor, callback);
        }
    }

    private void executeCallback(int errorCode, String errorMessage, Executor executor, InstallSystemUpdateCallback callback) {
        executor.execute(() -> callback.onInstallUpdateError(errorCode, errorMessage));
    }

    public int getGlobalPrivateDnsMode(ComponentName admin) {
        this.throwIfParentInstance("setGlobalPrivateDns");
        if (this.mService == null) {
            return 0;
        }
        try {
            return this.mService.getGlobalPrivateDnsMode(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public String getGlobalPrivateDnsHost(ComponentName admin) {
        this.throwIfParentInstance("setGlobalPrivateDns");
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.getGlobalPrivateDnsHost(admin);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.GRANT_PROFILE_OWNER_DEVICE_IDS_ACCESS", conditional=true)
    public void setProfileOwnerCanAccessDeviceIds(ComponentName who) {
        ApplicationInfo ai = this.mContext.getApplicationInfo();
        if (ai.targetSdkVersion > 29) {
            throw new UnsupportedOperationException("This method is deprecated. use markProfileOwnerOnOrganizationOwnedDevice instead.");
        }
        this.markProfileOwnerOnOrganizationOwnedDevice(who);
    }

    @RequiresPermission(anyOf={"android.permission.MARK_DEVICE_ORGANIZATION_OWNED", "android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS"}, conditional=true)
    public void markProfileOwnerOnOrganizationOwnedDevice(ComponentName who) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.markProfileOwnerOnOrganizationOwnedDevice(who, this.myUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setCrossProfileCalendarPackages(ComponentName admin, Set<String> packageNames) {
        this.throwIfParentInstance("setCrossProfileCalendarPackages");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfileCalendarPackages(admin, (List<String>)(packageNames == null ? null : new ArrayList<String>(packageNames)));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public Set<String> getCrossProfileCalendarPackages(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfileCalendarPackages");
        if (this.mService != null) {
            try {
                List<String> packageNames = this.mService.getCrossProfileCalendarPackages(admin);
                return packageNames == null ? null : new ArraySet<String>(packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptySet();
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_USERS"}, conditional=true)
    public boolean isPackageAllowedToAccessCalendar(String packageName) {
        this.throwIfParentInstance("isPackageAllowedToAccessCalendar");
        if (this.mService != null) {
            try {
                return this.mService.isPackageAllowedToAccessCalendarForUser(packageName, this.myUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_USERS"})
    public Set<String> getCrossProfileCalendarPackages() {
        this.throwIfParentInstance("getCrossProfileCalendarPackages");
        if (this.mService != null) {
            try {
                List<String> packageNames = this.mService.getCrossProfileCalendarPackagesForUser(this.myUserId());
                return packageNames == null ? null : new ArraySet<String>(packageNames);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptySet();
    }

    public void setCrossProfilePackages(ComponentName admin, Set<String> packageNames) {
        this.throwIfParentInstance("setCrossProfilePackages");
        if (this.mService != null) {
            try {
                this.mService.setCrossProfilePackages(admin, new ArrayList<String>(packageNames));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public Set<String> getCrossProfilePackages(ComponentName admin) {
        this.throwIfParentInstance("getCrossProfilePackages");
        if (this.mService != null) {
            try {
                return new ArraySet<String>(this.mService.getCrossProfilePackages(admin));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptySet();
    }

    @RequiresPermission(anyOf={"android.permission.INTERACT_ACROSS_USERS_FULL", "android.permission.INTERACT_ACROSS_USERS", "android.permission.INTERACT_ACROSS_PROFILES"})
    public Set<String> getAllCrossProfilePackages() {
        this.throwIfParentInstance("getAllCrossProfilePackages");
        if (this.mService != null) {
            try {
                return new ArraySet<String>(this.mService.getAllCrossProfilePackages());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptySet();
    }

    public Set<String> getDefaultCrossProfilePackages() {
        this.throwIfParentInstance("getDefaultCrossProfilePackages");
        if (this.mService != null) {
            try {
                return new ArraySet<String>(this.mService.getDefaultCrossProfilePackages());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return Collections.emptySet();
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isManagedKiosk() {
        this.throwIfParentInstance("isManagedKiosk");
        if (this.mService != null) {
            try {
                return this.mService.isManagedKiosk();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isUnattendedManagedKiosk() {
        this.throwIfParentInstance("isUnattendedManagedKiosk");
        if (this.mService != null) {
            try {
                return this.mService.isUnattendedManagedKiosk();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean startViewCalendarEventInManagedProfile(long eventId, long start, long end, boolean allDay, int flags) {
        this.throwIfParentInstance("startViewCalendarEventInManagedProfile");
        if (this.mService != null) {
            try {
                return this.mService.startViewCalendarEventInManagedProfile(this.mContext.getPackageName(), eventId, start, end, allDay, flags);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setUserControlDisabledPackages(ComponentName admin, List<String> packages) {
        this.throwIfParentInstance("setUserControlDisabledPackages");
        if (this.mService != null) {
            try {
                this.mService.setUserControlDisabledPackages(admin, packages);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public List<String> getUserControlDisabledPackages(ComponentName admin) {
        this.throwIfParentInstance("getUserControlDisabledPackages");
        if (this.mService != null) {
            try {
                return this.mService.getUserControlDisabledPackages(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return Collections.emptyList();
    }

    public void setCommonCriteriaModeEnabled(ComponentName admin, boolean enabled) {
        this.throwIfParentInstance("setCommonCriteriaModeEnabled");
        if (this.mService != null) {
            try {
                this.mService.setCommonCriteriaModeEnabled(admin, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isCommonCriteriaModeEnabled(ComponentName admin) {
        this.throwIfParentInstance("isCommonCriteriaModeEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isCommonCriteriaModeEnabled(admin);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public int getPersonalAppsSuspendedReasons(ComponentName admin) {
        this.throwIfParentInstance("getPersonalAppsSuspendedReasons");
        if (this.mService != null) {
            try {
                return this.mService.getPersonalAppsSuspendedReasons(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public void setPersonalAppsSuspended(ComponentName admin, boolean suspended) {
        this.throwIfParentInstance("setPersonalAppsSuspended");
        if (this.mService != null) {
            try {
                this.mService.setPersonalAppsSuspended(admin, suspended);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public void setManagedProfileMaximumTimeOff(ComponentName admin, long timeoutMillis) {
        this.throwIfParentInstance("setManagedProfileMaximumTimeOff");
        if (this.mService != null) {
            try {
                this.mService.setManagedProfileMaximumTimeOff(admin, timeoutMillis);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public long getManagedProfileMaximumTimeOff(ComponentName admin) {
        this.throwIfParentInstance("getManagedProfileMaximumTimeOff");
        if (this.mService != null) {
            try {
                return this.mService.getManagedProfileMaximumTimeOff(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return 0L;
    }

    public void acknowledgeDeviceCompliant() {
        this.throwIfParentInstance("acknowledgeDeviceCompliant");
        if (this.mService != null) {
            try {
                this.mService.acknowledgeDeviceCompliant();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean isComplianceAcknowledgementRequired() {
        this.throwIfParentInstance("isComplianceAcknowledgementRequired");
        if (this.mService != null) {
            try {
                return this.mService.isComplianceAcknowledgementRequired();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public boolean canProfileOwnerResetPasswordWhenLocked(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.canProfileOwnerResetPasswordWhenLocked(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_ADMINS")
    public void setNextOperationSafety(int operation, int reason) {
        if (this.mService != null) {
            try {
                this.mService.setNextOperationSafety(operation, reason);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public String getEnrollmentSpecificId() {
        this.throwIfParentInstance("getEnrollmentSpecificId");
        if (this.mService == null) {
            return "";
        }
        try {
            return this.mService.getEnrollmentSpecificId(this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setOrganizationId(String enterpriseId) {
        this.throwIfParentInstance("setOrganizationId");
        this.setOrganizationIdForUser(this.mContext.getPackageName(), enterpriseId, this.myUserId());
    }

    public void setOrganizationIdForUser(String packageName, String enterpriseId, int userId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.setOrganizationIdForUser(packageName, enterpriseId, userId);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public UserHandle createAndProvisionManagedProfile(ManagedProfileProvisioningParams provisioningParams) throws ProvisioningException {
        if (this.mService == null) {
            return null;
        }
        try {
            return this.mService.createAndProvisionManagedProfile(provisioningParams, this.mContext.getPackageName());
        }
        catch (ServiceSpecificException e) {
            throw new ProvisioningException(e, e.errorCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS")
    public void provisionFullyManagedDevice(FullyManagedDeviceProvisioningParams provisioningParams) throws ProvisioningException {
        if (this.mService != null) {
            try {
                this.mService.provisionFullyManagedDevice(provisioningParams, this.mContext.getPackageName());
            }
            catch (ServiceSpecificException e) {
                throw new ProvisioningException(e, e.errorCode);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS")
    public void resetDefaultCrossProfileIntentFilters(int userId) {
        if (this.mService != null) {
            try {
                this.mService.resetDefaultCrossProfileIntentFilters(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public boolean canAdminGrantSensorsPermissions() {
        this.throwIfParentInstance("canAdminGrantSensorsPermissions");
        if (this.mService == null) {
            return false;
        }
        try {
            return this.mService.canAdminGrantSensorsPermissionsForUser(this.myUserId());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void setDeviceOwnerType(ComponentName admin, int deviceOwnerType) {
        this.throwIfParentInstance("setDeviceOwnerType");
        if (this.mService != null) {
            try {
                this.mService.setDeviceOwnerType(admin, deviceOwnerType);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    public int getDeviceOwnerType(ComponentName admin) {
        this.throwIfParentInstance("getDeviceOwnerType");
        if (this.mService != null) {
            try {
                return this.mService.getDeviceOwnerType(admin);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public void setUsbDataSignalingEnabled(boolean enabled) {
        this.throwIfParentInstance("setUsbDataSignalingEnabled");
        if (this.mService != null) {
            try {
                this.mService.setUsbDataSignalingEnabled(this.mContext.getPackageName(), enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public boolean isUsbDataSignalingEnabled() {
        this.throwIfParentInstance("isUsbDataSignalingEnabled");
        if (this.mService != null) {
            try {
                return this.mService.isUsbDataSignalingEnabled(this.mContext.getPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean isUsbDataSignalingEnabledForUser(int userId) {
        this.throwIfParentInstance("isUsbDataSignalingEnabledForUser");
        if (this.mService != null) {
            try {
                return this.mService.isUsbDataSignalingEnabledForUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return true;
    }

    public boolean canUsbDataSignalingBeDisabled() {
        this.throwIfParentInstance("canUsbDataSignalingBeDisabled");
        if (this.mService != null) {
            try {
                return this.mService.canUsbDataSignalingBeDisabled();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public List<UserHandle> listForegroundAffiliatedUsers() {
        if (this.mService == null) {
            return Collections.emptyList();
        }
        try {
            return this.mService.listForegroundAffiliatedUsers();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_ADMINS")
    public Set<String> getPolicyExemptApps() {
        if (this.mService == null) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<String>(this.mService.listPolicyExemptApps());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface OnClearApplicationUserDataListener {
        public void onApplicationUserDataCleared(String var1, boolean var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemSettingsWhitelist {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreateAndManageUserFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockNowFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OperationSafetyReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DevicePolicyOperation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceOwnerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PersonalAppsSuspensionReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrivateDnsModeErrorCodes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InstallUpdateCallbackErrorConstants {
    }

    public static abstract class InstallSystemUpdateCallback {
        public static final int UPDATE_ERROR_UNKNOWN = 1;
        public static final int UPDATE_ERROR_INCORRECT_OS_VERSION = 2;
        public static final int UPDATE_ERROR_UPDATE_FILE_INVALID = 3;
        public static final int UPDATE_ERROR_FILE_NOT_FOUND = 4;
        public static final int UPDATE_ERROR_BATTERY_LOW = 5;

        public void onInstallUpdateError(int errorCode, String errorMessage) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrivateDnsMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationIdType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LockTaskFeature {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProvisioningResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProvisioningPreCondition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UserProvisioningState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PermissionGrantState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NearbyStreamingPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PasswordComplexity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProvisioningConfiguration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProvisioningTrigger {
    }
}

