/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.SuppressLint;
import android.app.appsearch.util.BundleUtil;
import android.app.appsearch.util.IndentingStringBuilder;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GenericDocument {
    private static final String TAG = "AppSearchGenericDocumen";
    private static final int MAX_INDEXED_PROPERTIES = 16;
    private static final int DEFAULT_SCORE = 0;
    private static final long DEFAULT_TTL_MILLIS = 0L;
    private static final String PROPERTIES_FIELD = "properties";
    private static final String BYTE_ARRAY_FIELD = "byteArray";
    private static final String SCHEMA_TYPE_FIELD = "schemaType";
    private static final String ID_FIELD = "id";
    private static final String SCORE_FIELD = "score";
    private static final String TTL_MILLIS_FIELD = "ttlMillis";
    private static final String CREATION_TIMESTAMP_MILLIS_FIELD = "creationTimestampMillis";
    private static final String NAMESPACE_FIELD = "namespace";
    final Bundle mBundle;
    private final Bundle mProperties;
    private final String mId;
    private final String mSchemaType;
    private final long mCreationTimestampMillis;
    private Integer mHashCode;

    public static int getMaxIndexedProperties() {
        return 16;
    }

    public GenericDocument(Bundle bundle) {
        Objects.requireNonNull(bundle);
        this.mBundle = bundle;
        this.mProperties = Objects.requireNonNull((Bundle)bundle.getParcelable(PROPERTIES_FIELD));
        this.mId = Objects.requireNonNull(this.mBundle.getString(ID_FIELD));
        this.mSchemaType = Objects.requireNonNull(this.mBundle.getString(SCHEMA_TYPE_FIELD));
        this.mCreationTimestampMillis = this.mBundle.getLong(CREATION_TIMESTAMP_MILLIS_FIELD, System_Delegate.currentTimeMillis());
    }

    protected GenericDocument(GenericDocument document) {
        this(document.mBundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public String getId() {
        return this.mId;
    }

    public String getNamespace() {
        return this.mBundle.getString(NAMESPACE_FIELD, "");
    }

    public String getSchemaType() {
        return this.mSchemaType;
    }

    public long getCreationTimestampMillis() {
        return this.mCreationTimestampMillis;
    }

    public long getTtlMillis() {
        return this.mBundle.getLong(TTL_MILLIS_FIELD, 0L);
    }

    public int getScore() {
        return this.mBundle.getInt(SCORE_FIELD, 0);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.mProperties.keySet());
    }

    public Object getProperty(String path) {
        Objects.requireNonNull(path);
        Object rawValue = GenericDocument.getRawPropertyFromRawDocument(path, this.mBundle);
        if (rawValue instanceof Bundle) {
            GenericDocument document = new GenericDocument((Bundle)rawValue);
            return new GenericDocument[]{document};
        }
        if (rawValue instanceof List) {
            List bundles = (List)rawValue;
            if (bundles.size() == 0) {
                return null;
            }
            byte[][] bytes = new byte[bundles.size()][];
            for (int i = 0; i < bundles.size(); ++i) {
                Bundle bundle = (Bundle)bundles.get(i);
                if (bundle == null) {
                    Log.e(TAG, "The inner bundle is null at " + i + ", for path: " + path);
                    continue;
                }
                byte[] innerBytes = bundle.getByteArray(BYTE_ARRAY_FIELD);
                if (innerBytes == null) {
                    Log.e(TAG, "The bundle at " + i + " contains a null byte[].");
                    continue;
                }
                bytes[i] = innerBytes;
            }
            return bytes;
        }
        if (rawValue instanceof Parcelable[]) {
            Parcelable[] bundles = (Parcelable[])rawValue;
            if (bundles.length == 0) {
                return null;
            }
            GenericDocument[] documents = new GenericDocument[bundles.length];
            for (int i = 0; i < bundles.length; ++i) {
                if (bundles[i] == null) {
                    Log.e(TAG, "The inner bundle is null at " + i + ", for path: " + path);
                    continue;
                }
                if (!(bundles[i] instanceof Bundle)) {
                    Log.e(TAG, "The inner element at " + i + " is a " + bundles[i].getClass() + ", not a Bundle for path: " + path);
                    continue;
                }
                documents[i] = new GenericDocument((Bundle)bundles[i]);
            }
            return documents;
        }
        return rawValue;
    }

    private static Object getRawPropertyFromRawDocument(String path, Bundle documentBundle) {
        String remainingPath;
        Object firstElementValue;
        Objects.requireNonNull(path);
        Objects.requireNonNull(documentBundle);
        Bundle properties = Objects.requireNonNull(documentBundle.getBundle(PROPERTIES_FIELD));
        int controlIdx = -1;
        boolean controlIsIndex = false;
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c != '[' && c != '.') continue;
            controlIdx = i;
            controlIsIndex = c == '[';
            break;
        }
        if (controlIdx == -1) {
            firstElementValue = properties.get(path);
        } else {
            String name = path.substring(0, controlIdx);
            firstElementValue = properties.get(name);
        }
        if (firstElementValue == null || controlIdx == -1) {
            return firstElementValue;
        }
        if (!controlIsIndex) {
            remainingPath = path.substring(controlIdx + 1);
        } else {
            Parcelable[] bundles;
            int endBracketIdx = path.indexOf(93, controlIdx);
            if (endBracketIdx == -1) {
                throw new IllegalArgumentException("Malformed path (no ending ']'): " + path);
            }
            if (endBracketIdx + 1 < path.length() && path.charAt(endBracketIdx + 1) != '.') {
                throw new IllegalArgumentException("Malformed path (']' not followed by '.'): " + path);
            }
            String indexStr = path.substring(controlIdx + 1, endBracketIdx);
            int index = Integer.parseInt(indexStr);
            if (index < 0) {
                throw new IllegalArgumentException("Path index less than 0: " + path);
            }
            remainingPath = endBracketIdx + 1 < path.length() ? path.substring(endBracketIdx + 2) : null;
            Object extractedValue = null;
            if (firstElementValue instanceof String[]) {
                String[] stringValues = (String[])firstElementValue;
                if (index < stringValues.length) {
                    extractedValue = Arrays.copyOfRange(stringValues, index, index + 1);
                }
            } else if (firstElementValue instanceof long[]) {
                long[] longValues = (long[])firstElementValue;
                if (index < longValues.length) {
                    extractedValue = Arrays.copyOfRange(longValues, index, index + 1);
                }
            } else if (firstElementValue instanceof double[]) {
                double[] doubleValues = (double[])firstElementValue;
                if (index < doubleValues.length) {
                    extractedValue = Arrays.copyOfRange(doubleValues, index, index + 1);
                }
            } else if (firstElementValue instanceof boolean[]) {
                boolean[] booleanValues = (boolean[])firstElementValue;
                if (index < booleanValues.length) {
                    extractedValue = Arrays.copyOfRange(booleanValues, index, index + 1);
                }
            } else if (firstElementValue instanceof List) {
                bundles = (Parcelable[])firstElementValue;
                if (index < bundles.size()) {
                    extractedValue = bundles.subList(index, index + 1);
                }
            } else if (firstElementValue instanceof Parcelable[]) {
                bundles = (Parcelable[])firstElementValue;
                if (index < bundles.length) {
                    extractedValue = (Bundle)bundles[index];
                }
            } else {
                throw new IllegalStateException("Unsupported value type: " + firstElementValue);
            }
            firstElementValue = extractedValue;
        }
        if (firstElementValue == null || remainingPath == null) {
            return firstElementValue;
        }
        if (firstElementValue instanceof Bundle) {
            return GenericDocument.getRawPropertyFromRawDocument(remainingPath, (Bundle)firstElementValue);
        }
        if (firstElementValue instanceof Parcelable[]) {
            Parcelable[] parcelables = (Parcelable[])firstElementValue;
            if (parcelables.length == 1) {
                return GenericDocument.getRawPropertyFromRawDocument(remainingPath, (Bundle)parcelables[0]);
            }
            ArrayList<Object> accumulator = new ArrayList<Object>(parcelables.length);
            for (int i = 0; i < parcelables.length; ++i) {
                Object value = GenericDocument.getRawPropertyFromRawDocument(remainingPath, (Bundle)parcelables[i]);
                if (value == null) continue;
                accumulator.add(value);
            }
            return GenericDocument.flattenAccumulator(accumulator);
        }
        Log.e(TAG, "Failed to apply path to document; no nested value found: " + path);
        return null;
    }

    private static Object flattenAccumulator(List<Object> accumulator) {
        if (accumulator.isEmpty()) {
            return null;
        }
        Object first = accumulator.get(0);
        if (first instanceof String[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((String[])accumulator.get(i)).length;
            }
            String[] result = new String[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                String[] castValue = (String[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof long[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((long[])accumulator.get(i)).length;
            }
            long[] result = new long[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                long[] castValue = (long[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof double[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((double[])accumulator.get(i)).length;
            }
            double[] result = new double[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                double[] castValue = (double[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof boolean[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((boolean[])accumulator.get(i)).length;
            }
            boolean[] result = new boolean[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                boolean[] castValue = (boolean[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        if (first instanceof List) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((List)accumulator.get(i)).size();
            }
            ArrayList result = new ArrayList(length);
            for (int i = 0; i < accumulator.size(); ++i) {
                List castValue = (List)accumulator.get(i);
                result.addAll(castValue);
            }
            return result;
        }
        if (first instanceof Parcelable[]) {
            int length = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                length += ((Parcelable[])accumulator.get(i)).length;
            }
            Parcelable[] result = new Parcelable[length];
            int total = 0;
            for (int i = 0; i < accumulator.size(); ++i) {
                Parcelable[] castValue = (Parcelable[])accumulator.get(i);
                System.arraycopy(castValue, 0, result, total, castValue.length);
                total += castValue.length;
            }
            return result;
        }
        throw new IllegalStateException("Unexpected property type: " + first);
    }

    public String getPropertyString(String path) {
        Objects.requireNonNull(path);
        String[] propertyArray = this.getPropertyStringArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("String", path, propertyArray.length);
        return propertyArray[0];
    }

    public long getPropertyLong(String path) {
        Objects.requireNonNull(path);
        long[] propertyArray = this.getPropertyLongArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return 0L;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Long", path, propertyArray.length);
        return propertyArray[0];
    }

    public double getPropertyDouble(String path) {
        Objects.requireNonNull(path);
        double[] propertyArray = this.getPropertyDoubleArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return 0.0;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Double", path, propertyArray.length);
        return propertyArray[0];
    }

    public boolean getPropertyBoolean(String path) {
        Objects.requireNonNull(path);
        boolean[] propertyArray = this.getPropertyBooleanArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return false;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Boolean", path, propertyArray.length);
        return propertyArray[0];
    }

    public byte[] getPropertyBytes(String path) {
        Objects.requireNonNull(path);
        byte[][] propertyArray = this.getPropertyBytesArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("ByteArray", path, propertyArray.length);
        return propertyArray[0];
    }

    public GenericDocument getPropertyDocument(String path) {
        Objects.requireNonNull(path);
        GenericDocument[] propertyArray = this.getPropertyDocumentArray(path);
        if (propertyArray == null || propertyArray.length == 0) {
            return null;
        }
        GenericDocument.warnIfSinglePropertyTooLong("Document", path, propertyArray.length);
        return propertyArray[0];
    }

    private static void warnIfSinglePropertyTooLong(String propertyType, String path, int propertyLength) {
        if (propertyLength > 1) {
            Log.w(TAG, "The value for \"" + path + "\" contains " + propertyLength + " elements. Only the first one will be returned from getProperty" + propertyType + "(). Try getProperty" + propertyType + "Array().");
        }
    }

    public String[] getPropertyStringArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, String[].class);
    }

    public long[] getPropertyLongArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, long[].class);
    }

    public double[] getPropertyDoubleArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, double[].class);
    }

    public boolean[] getPropertyBooleanArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, boolean[].class);
    }

    @SuppressLint(value={"ArrayReturn"})
    public byte[][] getPropertyBytesArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, byte[][].class);
    }

    @SuppressLint(value={"ArrayReturn"})
    public GenericDocument[] getPropertyDocumentArray(String path) {
        Objects.requireNonNull(path);
        Object value = this.getProperty(path);
        return GenericDocument.safeCastProperty(path, value, GenericDocument[].class);
    }

    private static <T> T safeCastProperty(String path, Object value, Class<T> tClass) {
        if (value == null) {
            return null;
        }
        try {
            return tClass.cast(value);
        }
        catch (ClassCastException e) {
            Log.w(TAG, "Error casting to requested type for path \"" + path + "\"", e);
            return null;
        }
    }

    public Builder<Builder<?>> toBuilder() {
        Bundle clonedBundle = BundleUtil.deepCopy(this.mBundle);
        return new Builder(clonedBundle);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GenericDocument)) {
            return false;
        }
        GenericDocument otherDocument = (GenericDocument)other;
        return BundleUtil.deepEquals(this.mBundle, otherDocument.mBundle);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = BundleUtil.deepHashCode(this.mBundle);
        }
        return this.mHashCode;
    }

    public String toString() {
        IndentingStringBuilder stringBuilder = new IndentingStringBuilder();
        this.appendGenericDocumentString(stringBuilder);
        return stringBuilder.toString();
    }

    void appendGenericDocumentString(IndentingStringBuilder builder) {
        Objects.requireNonNull(builder);
        builder.append("{\n");
        builder.increaseIndentLevel();
        builder.append("namespace: \"").append(this.getNamespace()).append("\",\n");
        builder.append("id: \"").append(this.getId()).append("\",\n");
        builder.append("score: ").append(this.getScore()).append(",\n");
        builder.append("schemaType: \"").append(this.getSchemaType()).append("\",\n");
        builder.append("creationTimestampMillis: ").append(this.getCreationTimestampMillis()).append(",\n");
        builder.append("timeToLiveMillis: ").append(this.getTtlMillis()).append(",\n");
        builder.append("properties: {\n");
        Object[] sortedProperties = this.getPropertyNames().toArray(new String[0]);
        Arrays.sort(sortedProperties);
        for (int i = 0; i < sortedProperties.length; ++i) {
            Object property = this.getProperty((String)sortedProperties[i]);
            builder.increaseIndentLevel();
            this.appendPropertyString((String)sortedProperties[i], property, builder);
            if (i != sortedProperties.length - 1) {
                builder.append(",\n");
            }
            builder.decreaseIndentLevel();
        }
        builder.append("\n");
        builder.append("}");
        builder.decreaseIndentLevel();
        builder.append("\n");
        builder.append("}");
    }

    private void appendPropertyString(String propertyName, Object property, IndentingStringBuilder builder) {
        Objects.requireNonNull(propertyName);
        Objects.requireNonNull(property);
        Objects.requireNonNull(builder);
        builder.append("\"").append(propertyName).append("\": [");
        if (property instanceof GenericDocument[]) {
            GenericDocument[] documentValues = (GenericDocument[])property;
            for (int i = 0; i < documentValues.length; ++i) {
                builder.append("\n");
                builder.increaseIndentLevel();
                documentValues[i].appendGenericDocumentString(builder);
                if (i != documentValues.length - 1) {
                    builder.append(",");
                }
                builder.append("\n");
                builder.decreaseIndentLevel();
            }
            builder.append("]");
        } else {
            int propertyArrLength = Array.getLength(property);
            for (int i = 0; i < propertyArrLength; ++i) {
                Object propertyElement = Array.get(property, i);
                if (propertyElement instanceof String) {
                    builder.append("\"").append((String)propertyElement).append("\"");
                } else if (propertyElement instanceof byte[]) {
                    builder.append(Arrays.toString((byte[])propertyElement));
                } else {
                    builder.append(propertyElement.toString());
                }
                if (i != propertyArrLength - 1) {
                    builder.append(", ");
                    continue;
                }
                builder.append("]");
            }
        }
    }

    @SuppressLint(value={"StaticFinalBuilder"})
    public static class Builder<BuilderType extends Builder> {
        private Bundle mBundle;
        private Bundle mProperties;
        private final BuilderType mBuilderTypeInstance;
        private boolean mBuilt = false;

        public Builder(String namespace, String id2, String schemaType) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(id2);
            Objects.requireNonNull(schemaType);
            this.mBundle = new Bundle();
            this.mBuilderTypeInstance = this;
            this.mBundle.putString(GenericDocument.NAMESPACE_FIELD, namespace);
            this.mBundle.putString(GenericDocument.ID_FIELD, id2);
            this.mBundle.putString(GenericDocument.SCHEMA_TYPE_FIELD, schemaType);
            this.mBundle.putLong(GenericDocument.TTL_MILLIS_FIELD, 0L);
            this.mBundle.putInt(GenericDocument.SCORE_FIELD, 0);
            this.mProperties = new Bundle();
            this.mBundle.putBundle(GenericDocument.PROPERTIES_FIELD, this.mProperties);
        }

        Builder(Bundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle);
            this.mProperties = this.mBundle.getBundle(GenericDocument.PROPERTIES_FIELD);
            this.mBuilderTypeInstance = this;
        }

        public BuilderType setNamespace(String namespace) {
            Objects.requireNonNull(namespace);
            this.resetIfBuilt();
            this.mBundle.putString(GenericDocument.NAMESPACE_FIELD, namespace);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setId(String id2) {
            Objects.requireNonNull(id2);
            this.resetIfBuilt();
            this.mBundle.putString(GenericDocument.ID_FIELD, id2);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setSchemaType(String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            this.mBundle.putString(GenericDocument.SCHEMA_TYPE_FIELD, schemaType);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setScore(int score) {
            if (score < 0) {
                throw new IllegalArgumentException("Document score cannot be negative.");
            }
            this.resetIfBuilt();
            this.mBundle.putInt(GenericDocument.SCORE_FIELD, score);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setCreationTimestampMillis(long creationTimestampMillis) {
            this.resetIfBuilt();
            this.mBundle.putLong(GenericDocument.CREATION_TIMESTAMP_MILLIS_FIELD, creationTimestampMillis);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setTtlMillis(long ttlMillis) {
            if (ttlMillis < 0L) {
                throw new IllegalArgumentException("Document ttlMillis cannot be negative.");
            }
            this.resetIfBuilt();
            this.mBundle.putLong(GenericDocument.TTL_MILLIS_FIELD, ttlMillis);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyString(String name, String ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyBoolean(String name, boolean ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyLong(String name, long ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyDouble(String name, double ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyBytes(String name, byte[] ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType setPropertyDocument(String name, GenericDocument ... values) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(values);
            this.resetIfBuilt();
            this.putInPropertyBundle(name, values);
            return this.mBuilderTypeInstance;
        }

        public BuilderType clearProperty(String name) {
            Objects.requireNonNull(name);
            this.resetIfBuilt();
            this.mProperties.remove(name);
            return this.mBuilderTypeInstance;
        }

        private void putInPropertyBundle(String name, String[] values) throws IllegalArgumentException {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("The String at " + i + " is null.");
            }
            this.mProperties.putStringArray(name, values);
        }

        private void putInPropertyBundle(String name, boolean[] values) {
            this.mProperties.putBooleanArray(name, values);
        }

        private void putInPropertyBundle(String name, double[] values) {
            this.mProperties.putDoubleArray(name, values);
        }

        private void putInPropertyBundle(String name, long[] values) {
            this.mProperties.putLongArray(name, values);
        }

        private void putInPropertyBundle(String name, byte[][] values) {
            ArrayList<Bundle> bundles = new ArrayList<Bundle>(values.length);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    throw new IllegalArgumentException("The byte[] at " + i + " is null.");
                }
                Bundle bundle = new Bundle();
                bundle.putByteArray(GenericDocument.BYTE_ARRAY_FIELD, values[i]);
                bundles.add(bundle);
            }
            this.mProperties.putParcelableArrayList(name, bundles);
        }

        private void putInPropertyBundle(String name, GenericDocument[] values) {
            Parcelable[] documentBundles = new Parcelable[values.length];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) {
                    throw new IllegalArgumentException("The document at " + i + " is null.");
                }
                documentBundles[i] = values[i].mBundle;
            }
            this.mProperties.putParcelableArray(name, documentBundles);
        }

        public GenericDocument build() {
            this.mBuilt = true;
            if (this.mBundle.getLong(GenericDocument.CREATION_TIMESTAMP_MILLIS_FIELD, -1L) == -1L) {
                this.mBundle.putLong(GenericDocument.CREATION_TIMESTAMP_MILLIS_FIELD, System_Delegate.currentTimeMillis());
            }
            return new GenericDocument(this.mBundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mBundle = BundleUtil.deepCopy(this.mBundle);
                this.mProperties = this.mBundle.getBundle(GenericDocument.PROPERTIES_FIELD);
                this.mBuilt = false;
            }
        }
    }
}

