/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.FullBackupDataOutput;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FullBackup {
    static final String TAG = "FullBackup";
    static final String TAG_XML_PARSER = "BackupXmlParserLogging";
    public static final String APK_TREE_TOKEN = "a";
    public static final String OBB_TREE_TOKEN = "obb";
    public static final String KEY_VALUE_DATA_TOKEN = "k";
    public static final String ROOT_TREE_TOKEN = "r";
    public static final String FILES_TREE_TOKEN = "f";
    public static final String NO_BACKUP_TREE_TOKEN = "nb";
    public static final String DATABASE_TREE_TOKEN = "db";
    public static final String SHAREDPREFS_TREE_TOKEN = "sp";
    public static final String CACHE_TREE_TOKEN = "c";
    public static final String DEVICE_ROOT_TREE_TOKEN = "d_r";
    public static final String DEVICE_FILES_TREE_TOKEN = "d_f";
    public static final String DEVICE_NO_BACKUP_TREE_TOKEN = "d_nb";
    public static final String DEVICE_DATABASE_TREE_TOKEN = "d_db";
    public static final String DEVICE_SHAREDPREFS_TREE_TOKEN = "d_sp";
    public static final String DEVICE_CACHE_TREE_TOKEN = "d_c";
    public static final String MANAGED_EXTERNAL_TREE_TOKEN = "ef";
    public static final String SHARED_STORAGE_TOKEN = "shared";
    public static final String APPS_PREFIX = "apps/";
    public static final String SHARED_PREFIX = "shared/";
    public static final String FULL_BACKUP_INTENT_ACTION = "fullback";
    public static final String FULL_RESTORE_INTENT_ACTION = "fullrest";
    public static final String CONF_TOKEN_INTENT_EXTRA = "conftoken";
    public static final String FLAG_REQUIRED_CLIENT_SIDE_ENCRYPTION = "clientSideEncryption";
    public static final String FLAG_REQUIRED_DEVICE_TO_DEVICE_TRANSFER = "deviceToDeviceTransfer";
    public static final String FLAG_REQUIRED_FAKE_CLIENT_SIDE_ENCRYPTION = "fakeClientSideEncryption";
    private static final String FLAG_DISABLE_IF_NO_ENCRYPTION_CAPABILITIES = "disableIfNoEncryptionCapabilities";
    private static final long IGNORE_FULL_BACKUP_CONTENT_IN_D2D = 180523564L;
    private static final Map<BackupSchemeId, BackupScheme> kPackageBackupSchemeMap = new ArrayMap<BackupSchemeId, BackupScheme>();

    @UnsupportedAppUsage
    public static int backupToTar(String string2, String string3, String string4, String string5, String string6, FullBackupDataOutput fullBackupDataOutput) {
        return OverrideMethod.invokeI("android.app.backup.FullBackup#backupToTar(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Landroid/app/backup/FullBackupDataOutput;)I", true, null);
    }

    static synchronized BackupScheme getBackupScheme(Context context, int operationType) {
        BackupSchemeId backupSchemeId = new BackupSchemeId(context.getPackageName(), operationType);
        BackupScheme backupSchemeForPackage = kPackageBackupSchemeMap.get(backupSchemeId);
        if (backupSchemeForPackage == null) {
            backupSchemeForPackage = new BackupScheme(context, operationType);
            kPackageBackupSchemeMap.put(backupSchemeId, backupSchemeForPackage);
        }
        return backupSchemeForPackage;
    }

    public static BackupScheme getBackupSchemeForTest(Context context) {
        BackupScheme testing = new BackupScheme(context, 0);
        testing.mExcludes = new ArraySet();
        testing.mIncludes = new ArrayMap<String, Set<BackupScheme.PathWithRequiredFlags>>();
        return testing;
    }

    public static void restoreFile(ParcelFileDescriptor data, long size, int type, long mode, long mtime, File outFile) throws IOException {
        if (type == 2) {
            if (outFile != null) {
                outFile.mkdirs();
            }
        } else {
            FileOutputStream out = null;
            try {
                if (outFile != null) {
                    File parent = outFile.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    out = new FileOutputStream(outFile);
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to create/open file " + outFile.getPath(), e);
            }
            byte[] buffer = new byte[32768];
            long origSize = size;
            FileInputStream in = new FileInputStream(data.getFileDescriptor());
            while (size > 0L) {
                int toRead = size > (long)buffer.length ? buffer.length : (int)size;
                int got = in.read(buffer, 0, toRead);
                if (got <= 0) {
                    Log.w(TAG, "Incomplete read: expected " + size + " but got " + (origSize - size));
                    break;
                }
                if (out != null) {
                    try {
                        out.write(buffer, 0, got);
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Unable to write to file " + outFile.getPath(), e);
                        out.close();
                        out = null;
                        outFile.delete();
                    }
                }
                size -= (long)got;
            }
            if (out != null) {
                out.close();
            }
        }
        if (mode >= 0L && outFile != null) {
            try {
                Os.chmod(outFile.getPath(), (int)(mode &= 0x1C0L));
            }
            catch (ErrnoException e) {
                e.rethrowAsIOException();
            }
            outFile.setLastModified(mtime);
        }
    }

    @VisibleForTesting
    public static class BackupScheme {
        private final File FILES_DIR;
        private final File DATABASE_DIR;
        private final File ROOT_DIR;
        private final File SHAREDPREF_DIR;
        private final File CACHE_DIR;
        private final File NOBACKUP_DIR;
        private final File DEVICE_FILES_DIR;
        private final File DEVICE_DATABASE_DIR;
        private final File DEVICE_ROOT_DIR;
        private final File DEVICE_SHAREDPREF_DIR;
        private final File DEVICE_CACHE_DIR;
        private final File DEVICE_NOBACKUP_DIR;
        private final File EXTERNAL_DIR;
        private static final String TAG_INCLUDE = "include";
        private static final String TAG_EXCLUDE = "exclude";
        final int mDataExtractionRules;
        final int mFullBackupContent;
        final int mOperationType;
        final PackageManager mPackageManager;
        final StorageManager mStorageManager;
        final String mPackageName;
        private StorageVolume[] mVolumes = null;
        private Integer mRequiredTransportFlags;
        private Boolean mIsUsingNewScheme;
        Map<String, Set<PathWithRequiredFlags>> mIncludes;
        ArraySet<PathWithRequiredFlags> mExcludes;

        String tokenToDirectoryPath(String domainToken) {
            try {
                if (domainToken.equals(FullBackup.FILES_TREE_TOKEN)) {
                    return this.FILES_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DATABASE_TREE_TOKEN)) {
                    return this.DATABASE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.ROOT_TREE_TOKEN)) {
                    return this.ROOT_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.SHAREDPREFS_TREE_TOKEN)) {
                    return this.SHAREDPREF_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.CACHE_TREE_TOKEN)) {
                    return this.CACHE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.NO_BACKUP_TREE_TOKEN)) {
                    return this.NOBACKUP_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_FILES_TREE_TOKEN)) {
                    return this.DEVICE_FILES_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_DATABASE_TREE_TOKEN)) {
                    return this.DEVICE_DATABASE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_ROOT_TREE_TOKEN)) {
                    return this.DEVICE_ROOT_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_SHAREDPREFS_TREE_TOKEN)) {
                    return this.DEVICE_SHAREDPREF_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_CACHE_TREE_TOKEN)) {
                    return this.DEVICE_CACHE_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.DEVICE_NO_BACKUP_TREE_TOKEN)) {
                    return this.DEVICE_NOBACKUP_DIR.getCanonicalPath();
                }
                if (domainToken.equals(FullBackup.MANAGED_EXTERNAL_TREE_TOKEN)) {
                    if (this.EXTERNAL_DIR != null) {
                        return this.EXTERNAL_DIR.getCanonicalPath();
                    }
                    return null;
                }
                if (domainToken.startsWith(FullBackup.SHARED_PREFIX)) {
                    return this.sharedDomainToPath(domainToken);
                }
                Log.i(FullBackup.TAG, "Unrecognized domain " + domainToken);
                return null;
            }
            catch (Exception e) {
                Log.i(FullBackup.TAG, "Error reading directory for domain: " + domainToken);
                return null;
            }
        }

        private String sharedDomainToPath(String domain) throws IOException {
            String volume = domain.substring(FullBackup.SHARED_PREFIX.length());
            StorageVolume[] volumes = this.getVolumeList();
            int volNum = Integer.parseInt(volume);
            if (volNum < this.mVolumes.length) {
                return volumes[volNum].getPathFile().getCanonicalPath();
            }
            return null;
        }

        private StorageVolume[] getVolumeList() {
            if (this.mStorageManager != null) {
                if (this.mVolumes == null) {
                    this.mVolumes = this.mStorageManager.getVolumeList();
                }
            } else {
                Log.e(FullBackup.TAG, "Unable to access Storage Manager");
            }
            return this.mVolumes;
        }

        BackupScheme(Context context, int operationType) {
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            this.mDataExtractionRules = applicationInfo.dataExtractionRulesRes;
            this.mFullBackupContent = applicationInfo.fullBackupContent;
            this.mOperationType = operationType;
            this.mStorageManager = (StorageManager)context.getSystemService("storage");
            this.mPackageManager = context.getPackageManager();
            this.mPackageName = context.getPackageName();
            Context ceContext = context.createCredentialProtectedStorageContext();
            this.FILES_DIR = ceContext.getFilesDir();
            this.DATABASE_DIR = ceContext.getDatabasePath("foo").getParentFile();
            this.ROOT_DIR = ceContext.getDataDir();
            this.SHAREDPREF_DIR = ceContext.getSharedPreferencesPath("foo").getParentFile();
            this.CACHE_DIR = ceContext.getCacheDir();
            this.NOBACKUP_DIR = ceContext.getNoBackupFilesDir();
            Context deContext = context.createDeviceProtectedStorageContext();
            this.DEVICE_FILES_DIR = deContext.getFilesDir();
            this.DEVICE_DATABASE_DIR = deContext.getDatabasePath("foo").getParentFile();
            this.DEVICE_ROOT_DIR = deContext.getDataDir();
            this.DEVICE_SHAREDPREF_DIR = deContext.getSharedPreferencesPath("foo").getParentFile();
            this.DEVICE_CACHE_DIR = deContext.getCacheDir();
            this.DEVICE_NOBACKUP_DIR = deContext.getNoBackupFilesDir();
            this.EXTERNAL_DIR = Process.myUid() != 1000 ? context.getExternalFilesDir(null) : null;
        }

        boolean isFullBackupEnabled(int transportFlags) {
            try {
                if (this.isUsingNewScheme()) {
                    int requiredTransportFlags = this.getRequiredTransportFlags();
                    return (transportFlags & requiredTransportFlags) == requiredTransportFlags;
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(FullBackup.TAG, "Failed to interpret the backup scheme: " + e);
                return false;
            }
            return this.isFullBackupContentEnabled();
        }

        boolean isFullRestoreEnabled() {
            try {
                if (this.isUsingNewScheme()) {
                    return true;
                }
            }
            catch (IOException | XmlPullParserException e) {
                Slog.w(FullBackup.TAG, "Failed to interpret the backup scheme: " + e);
                return false;
            }
            return this.isFullBackupContentEnabled();
        }

        boolean isFullBackupContentEnabled() {
            if (this.mFullBackupContent < 0) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "android:fullBackupContent - \"false\"");
                }
                return false;
            }
            return true;
        }

        public synchronized Map<String, Set<PathWithRequiredFlags>> maybeParseAndGetCanonicalIncludePaths() throws IOException, XmlPullParserException {
            if (this.mIncludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mIncludes;
        }

        public synchronized ArraySet<PathWithRequiredFlags> maybeParseAndGetCanonicalExcludePaths() throws IOException, XmlPullParserException {
            if (this.mExcludes == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mExcludes;
        }

        @VisibleForTesting
        public synchronized int getRequiredTransportFlags() throws IOException, XmlPullParserException {
            if (this.mRequiredTransportFlags == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mRequiredTransportFlags;
        }

        private synchronized boolean isUsingNewScheme() throws IOException, XmlPullParserException {
            if (this.mIsUsingNewScheme == null) {
                this.maybeParseBackupSchemeLocked();
            }
            return this.mIsUsingNewScheme;
        }

        private void maybeParseBackupSchemeLocked() throws IOException, XmlPullParserException {
            this.mIncludes = new ArrayMap<String, Set<PathWithRequiredFlags>>();
            this.mExcludes = new ArraySet();
            this.mRequiredTransportFlags = 0;
            this.mIsUsingNewScheme = false;
            if (this.mFullBackupContent == 0 && this.mDataExtractionRules == 0) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "android:fullBackupContent - \"true\"");
                }
            } else {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "Found xml scheme: android:fullBackupContent=" + this.mFullBackupContent + "; android:dataExtractionRules=" + this.mDataExtractionRules);
                }
                try {
                    this.parseSchemeForOperationType(this.mOperationType);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IOException(e);
                }
            }
        }

        private void parseSchemeForOperationType(int operationType) throws PackageManager.NameNotFoundException, IOException, XmlPullParserException {
            String configSection = this.getConfigSectionForOperationType(operationType);
            if (configSection == null) {
                Slog.w(FullBackup.TAG, "Given operation type isn't supported by backup scheme: " + operationType);
                return;
            }
            if (this.mDataExtractionRules != 0) {
                boolean isSectionPresent;
                try (XmlResourceParser parser = this.getParserForResource(this.mDataExtractionRules);){
                    isSectionPresent = this.parseNewBackupSchemeFromXmlLocked(parser, configSection, this.mExcludes, this.mIncludes);
                }
                if (isSectionPresent) {
                    this.mIsUsingNewScheme = true;
                    return;
                }
            }
            if (operationType == 1 && CompatChanges.isChangeEnabled(180523564L)) {
                this.mIsUsingNewScheme = true;
                return;
            }
            if (this.mFullBackupContent != 0) {
                try (XmlResourceParser parser = this.getParserForResource(this.mFullBackupContent);){
                    this.parseBackupSchemeFromXmlLocked(parser, this.mExcludes, this.mIncludes);
                }
            }
        }

        private String getConfigSectionForOperationType(int operationType) {
            switch (operationType) {
                case 0: {
                    return "cloud-backup";
                }
                case 1: {
                    return "device-transfer";
                }
            }
            return null;
        }

        private XmlResourceParser getParserForResource(int resourceId) throws PackageManager.NameNotFoundException {
            return this.mPackageManager.getResourcesForApplication(this.mPackageName).getXml(resourceId);
        }

        @VisibleForTesting
        public boolean parseNewBackupSchemeFromXmlLocked(XmlPullParser parser, @ConfigSection String configSection, Set<PathWithRequiredFlags> excludes, Map<String, Set<PathWithRequiredFlags>> includes) throws IOException, XmlPullParserException {
            int event;
            this.verifyTopLevelTag(parser, "data-extraction-rules");
            boolean isSectionPresent = false;
            while ((event = parser.next()) != 1) {
                if (event != 2 || !configSection.equals(parser.getName())) continue;
                isSectionPresent = true;
                this.parseRequiredTransportFlags(parser, configSection);
                this.parseRules(parser, excludes, includes, Optional.of(0), configSection);
            }
            this.logParsingResults(excludes, includes);
            return isSectionPresent;
        }

        private void parseRequiredTransportFlags(XmlPullParser parser, @ConfigSection String configSection) {
            String encryptionAttribute;
            if ("cloud-backup".equals(configSection) && "true".equals(encryptionAttribute = parser.getAttributeValue(null, FullBackup.FLAG_DISABLE_IF_NO_ENCRYPTION_CAPABILITIES))) {
                this.mRequiredTransportFlags = 1;
            }
        }

        @VisibleForTesting
        public void parseBackupSchemeFromXmlLocked(XmlPullParser parser, Set<PathWithRequiredFlags> excludes, Map<String, Set<PathWithRequiredFlags>> includes) throws IOException, XmlPullParserException {
            this.verifyTopLevelTag(parser, "full-backup-content");
            this.parseRules(parser, excludes, includes, Optional.empty(), "full-backup-content");
            this.logParsingResults(excludes, includes);
        }

        private void verifyTopLevelTag(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int event = parser.getEventType();
            while (event != 2) {
                event = parser.next();
            }
            if (!tag.equals(parser.getName())) {
                throw new XmlPullParserException("Xml file didn't start with correct tag (" + tag + " ). Found \"" + parser.getName() + "\"");
            }
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "Found valid " + tag + "; parsing xml resource.");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "");
            }
        }

        private void parseRules(XmlPullParser parser, Set<PathWithRequiredFlags> excludes, Map<String, Set<PathWithRequiredFlags>> includes, Optional<Integer> maybeRequiredFlags, String endingTag) throws IOException, XmlPullParserException {
            int event;
            while ((event = parser.next()) != 1 && !parser.getName().equals(endingTag)) {
                switch (event) {
                    case 2: {
                        this.validateInnerTagContents(parser);
                        String domainFromXml = parser.getAttributeValue(null, "domain");
                        File domainDirectory = this.getDirectoryForCriteriaDomain(domainFromXml);
                        if (domainDirectory == null) {
                            if (!Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) break;
                            Log.v(FullBackup.TAG_XML_PARSER, "...parsing \"" + parser.getName() + "\": domain=\"" + domainFromXml + "\" invalid; skipping");
                            break;
                        }
                        File canonicalFile = this.extractCanonicalFile(domainDirectory, parser.getAttributeValue(null, "path"));
                        if (canonicalFile == null) break;
                        int requiredFlags = this.getRequiredFlagsForRule(parser, maybeRequiredFlags);
                        Set<PathWithRequiredFlags> activeSet = this.parseCurrentTagForDomain(parser, excludes, includes, domainFromXml);
                        activeSet.add(new PathWithRequiredFlags(canonicalFile.getCanonicalPath(), requiredFlags));
                        if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                            Log.v(FullBackup.TAG_XML_PARSER, "...parsed " + canonicalFile.getCanonicalPath() + " for domain \"" + domainFromXml + "\", requiredFlags + \"" + requiredFlags + "\"");
                        }
                        if ("database".equals(domainFromXml) && !canonicalFile.isDirectory()) {
                            String canonicalJournalPath = canonicalFile.getCanonicalPath() + "-journal";
                            activeSet.add(new PathWithRequiredFlags(canonicalJournalPath, requiredFlags));
                            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                                Log.v(FullBackup.TAG_XML_PARSER, "...automatically generated " + canonicalJournalPath + ". Ignore if nonexistent.");
                            }
                            String canonicalWalPath = canonicalFile.getCanonicalPath() + "-wal";
                            activeSet.add(new PathWithRequiredFlags(canonicalWalPath, requiredFlags));
                            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                                Log.v(FullBackup.TAG_XML_PARSER, "...automatically generated " + canonicalWalPath + ". Ignore if nonexistent.");
                            }
                        }
                        if (!"sharedpref".equals(domainFromXml) || canonicalFile.isDirectory() || canonicalFile.getCanonicalPath().endsWith(".xml")) break;
                        String canonicalXmlPath = canonicalFile.getCanonicalPath() + ".xml";
                        activeSet.add(new PathWithRequiredFlags(canonicalXmlPath, requiredFlags));
                        if (!Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) break;
                        Log.v(FullBackup.TAG_XML_PARSER, "...automatically generated " + canonicalXmlPath + ". Ignore if nonexistent.");
                    }
                }
            }
        }

        private void logParsingResults(Set<PathWithRequiredFlags> excludes, Map<String, Set<PathWithRequiredFlags>> includes) {
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
                Log.v(FullBackup.TAG_XML_PARSER, "Xml resource parsing complete.");
                Log.v(FullBackup.TAG_XML_PARSER, "Final tally.");
                Log.v(FullBackup.TAG_XML_PARSER, "Includes:");
                if (includes.isEmpty()) {
                    Log.v(FullBackup.TAG_XML_PARSER, "  ...nothing specified (This means the entirety of app data minus excludes)");
                } else {
                    for (Map.Entry<String, Set<PathWithRequiredFlags>> entry : includes.entrySet()) {
                        Log.v(FullBackup.TAG_XML_PARSER, "  domain=" + entry.getKey());
                        for (PathWithRequiredFlags includeData : entry.getValue()) {
                            Log.v(FullBackup.TAG_XML_PARSER, " path: " + includeData.getPath() + " requiredFlags: " + includeData.getRequiredFlags());
                        }
                    }
                }
                Log.v(FullBackup.TAG_XML_PARSER, "Excludes:");
                if (excludes.isEmpty()) {
                    Log.v(FullBackup.TAG_XML_PARSER, "  ...nothing to exclude.");
                } else {
                    for (PathWithRequiredFlags excludeData : excludes) {
                        Log.v(FullBackup.TAG_XML_PARSER, " path: " + excludeData.getPath() + " requiredFlags: " + excludeData.getRequiredFlags());
                    }
                }
                Log.v(FullBackup.TAG_XML_PARSER, "  ");
                Log.v(FullBackup.TAG_XML_PARSER, "====================================================");
                Log.v(FullBackup.TAG_XML_PARSER, "\n");
            }
        }

        private int getRequiredFlagsFromString(String requiredFlags) {
            String[] flagsStr;
            int flags = 0;
            if (requiredFlags == null || requiredFlags.length() == 0) {
                return flags;
            }
            String[] stringArray = flagsStr = requiredFlags.split("\\|");
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String f;
                switch (f = stringArray[i]) {
                    case "clientSideEncryption": {
                        flags |= 1;
                        continue block10;
                    }
                    case "deviceToDeviceTransfer": {
                        flags |= 2;
                        continue block10;
                    }
                    case "fakeClientSideEncryption": {
                        flags |= Integer.MIN_VALUE;
                    }
                    default: {
                        Log.w(FullBackup.TAG, "Unrecognized requiredFlag provided, value: \"" + f + "\"");
                    }
                }
            }
            return flags;
        }

        private int getRequiredFlagsForRule(XmlPullParser parser, Optional<Integer> maybeRequiredFlags) {
            if (maybeRequiredFlags.isPresent()) {
                return maybeRequiredFlags.get();
            }
            if (TAG_INCLUDE.equals(parser.getName())) {
                return this.getRequiredFlagsFromString(parser.getAttributeValue(null, "requireFlags"));
            }
            return 0;
        }

        private Set<PathWithRequiredFlags> parseCurrentTagForDomain(XmlPullParser parser, Set<PathWithRequiredFlags> excludes, Map<String, Set<PathWithRequiredFlags>> includes, String domain) throws XmlPullParserException {
            if (TAG_INCLUDE.equals(parser.getName())) {
                String domainToken = this.getTokenForXmlDomain(domain);
                Set<PathWithRequiredFlags> includeSet = includes.get(domainToken);
                if (includeSet == null) {
                    includeSet = new ArraySet<PathWithRequiredFlags>();
                    includes.put(domainToken, includeSet);
                }
                return includeSet;
            }
            if (TAG_EXCLUDE.equals(parser.getName())) {
                return excludes;
            }
            if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                Log.v(FullBackup.TAG_XML_PARSER, "Invalid tag found in xml \"" + parser.getName() + "\"; aborting operation.");
            }
            throw new XmlPullParserException("Unrecognised tag in backup criteria xml (" + parser.getName() + ")");
        }

        private String getTokenForXmlDomain(String xmlDomain) {
            if ("root".equals(xmlDomain)) {
                return FullBackup.ROOT_TREE_TOKEN;
            }
            if ("file".equals(xmlDomain)) {
                return FullBackup.FILES_TREE_TOKEN;
            }
            if ("database".equals(xmlDomain)) {
                return FullBackup.DATABASE_TREE_TOKEN;
            }
            if ("sharedpref".equals(xmlDomain)) {
                return FullBackup.SHAREDPREFS_TREE_TOKEN;
            }
            if ("device_root".equals(xmlDomain)) {
                return FullBackup.DEVICE_ROOT_TREE_TOKEN;
            }
            if ("device_file".equals(xmlDomain)) {
                return FullBackup.DEVICE_FILES_TREE_TOKEN;
            }
            if ("device_database".equals(xmlDomain)) {
                return FullBackup.DEVICE_DATABASE_TREE_TOKEN;
            }
            if ("device_sharedpref".equals(xmlDomain)) {
                return FullBackup.DEVICE_SHAREDPREFS_TREE_TOKEN;
            }
            if ("external".equals(xmlDomain)) {
                return FullBackup.MANAGED_EXTERNAL_TREE_TOKEN;
            }
            return null;
        }

        private File extractCanonicalFile(File domain, String filePathFromXml) {
            if (filePathFromXml == null) {
                filePathFromXml = "";
            }
            if (filePathFromXml.contains("..")) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", but the \"..\" path is not permitted; skipping.");
                }
                return null;
            }
            if (filePathFromXml.contains("//")) {
                if (Log.isLoggable(FullBackup.TAG_XML_PARSER, 2)) {
                    Log.v(FullBackup.TAG_XML_PARSER, "...resolved \"" + domain.getPath() + " " + filePathFromXml + "\", which contains the invalid \"//\" sequence; skipping.");
                }
                return null;
            }
            return new File(domain, filePathFromXml);
        }

        private File getDirectoryForCriteriaDomain(String domain) {
            if (TextUtils.isEmpty(domain)) {
                return null;
            }
            if ("file".equals(domain)) {
                return this.FILES_DIR;
            }
            if ("database".equals(domain)) {
                return this.DATABASE_DIR;
            }
            if ("root".equals(domain)) {
                return this.ROOT_DIR;
            }
            if ("sharedpref".equals(domain)) {
                return this.SHAREDPREF_DIR;
            }
            if ("device_file".equals(domain)) {
                return this.DEVICE_FILES_DIR;
            }
            if ("device_database".equals(domain)) {
                return this.DEVICE_DATABASE_DIR;
            }
            if ("device_root".equals(domain)) {
                return this.DEVICE_ROOT_DIR;
            }
            if ("device_sharedpref".equals(domain)) {
                return this.DEVICE_SHAREDPREF_DIR;
            }
            if ("external".equals(domain)) {
                return this.EXTERNAL_DIR;
            }
            return null;
        }

        private void validateInnerTagContents(XmlPullParser parser) throws XmlPullParserException {
            if (parser == null) {
                return;
            }
            switch (parser.getName()) {
                case "include": {
                    if (parser.getAttributeCount() <= 3) break;
                    throw new XmlPullParserException("At most 3 tag attributes allowed for \"include\" tag (\"domain\" & \"path\" & optional \"requiredFlags\").");
                }
                case "exclude": {
                    if (parser.getAttributeCount() <= 2) break;
                    throw new XmlPullParserException("At most 2 tag attributes allowed for \"exclude\" tag (\"domain\" & \"path\".");
                }
                default: {
                    throw new XmlPullParserException("A valid tag is one of \"<include/>\" or \"<exclude/>. You provided \"" + parser.getName() + "\"");
                }
            }
        }

        public static class PathWithRequiredFlags {
            private final String mPath;
            private final int mRequiredFlags;

            public PathWithRequiredFlags(String path, int requiredFlags) {
                this.mPath = path;
                this.mRequiredFlags = requiredFlags;
            }

            public String getPath() {
                return this.mPath;
            }

            public int getRequiredFlags() {
                return this.mRequiredFlags;
            }
        }
    }

    private static class BackupSchemeId {
        final String mPackageName;
        final int mOperationType;

        BackupSchemeId(String packageName, int operationType) {
            this.mPackageName = packageName;
            this.mOperationType = operationType;
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mOperationType);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            BackupSchemeId that = (BackupSchemeId)object;
            return Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mOperationType, that.mOperationType);
        }
    }

    static @interface ConfigSection {
        public static final String CLOUD_BACKUP = "cloud-backup";
        public static final String DEVICE_TRANSFER = "device-transfer";
    }
}

