/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class ExternalTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<ExternalTimeSuggestion> CREATOR = new Parcelable.Creator<ExternalTimeSuggestion>(){

        @Override
        public ExternalTimeSuggestion createFromParcel(Parcel in) {
            return ExternalTimeSuggestion.createFromParcel(in);
        }

        public ExternalTimeSuggestion[] newArray(int size) {
            return new ExternalTimeSuggestion[size];
        }
    };
    private final TimestampedValue<Long> mUtcTime;
    private ArrayList<String> mDebugInfo;

    public ExternalTimeSuggestion(long elapsedRealtimeMillis, long suggestionMillis) {
        this.mUtcTime = new TimestampedValue<Long>(elapsedRealtimeMillis, suggestionMillis);
    }

    private static ExternalTimeSuggestion createFromParcel(Parcel in) {
        ArrayList debugInfo;
        TimestampedValue utcTime = (TimestampedValue)in.readParcelable(null);
        ExternalTimeSuggestion suggestion = new ExternalTimeSuggestion(utcTime.getReferenceTimeMillis(), (Long)utcTime.getValue());
        suggestion.mDebugInfo = debugInfo = in.readArrayList(null);
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUtcTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public TimestampedValue<Long> getUtcTime() {
        return this.mUtcTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTimeSuggestion that = (ExternalTimeSuggestion)o;
        return Objects.equals(this.mUtcTime, that.mUtcTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUtcTime);
    }

    public String toString() {
        return "ExternalTimeSuggestion{mUtcTime=" + this.mUtcTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }
}

