/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothMapClient;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SystemApi
public class BluetoothMapClient
implements BluetoothProfile {
    private static final String TAG = "BluetoothMapClient";
    private static final boolean DBG = Log.isLoggable("BluetoothMapClient", 3);
    private static final boolean VDBG = Log.isLoggable("BluetoothMapClient", 2);
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.mapmce.profile.action.CONNECTION_STATE_CHANGED";
    @RequiresPermission(value="android.permission.RECEIVE_SMS")
    public static final String ACTION_MESSAGE_RECEIVED = "android.bluetooth.mapmce.profile.action.MESSAGE_RECEIVED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MESSAGE_SENT_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_SENT_SUCCESSFULLY";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MESSAGE_DELIVERED_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_DELIVERED_SUCCESSFULLY";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MESSAGE_READ_STATUS_CHANGED = "android.bluetooth.mapmce.profile.action.MESSAGE_READ_STATUS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MESSAGE_DELETED_STATUS_CHANGED = "android.bluetooth.mapmce.profile.action.MESSAGE_DELETED_STATUS_CHANGED";
    public static final String EXTRA_MESSAGE_HANDLE = "android.bluetooth.mapmce.profile.extra.MESSAGE_HANDLE";
    public static final String EXTRA_MESSAGE_TIMESTAMP = "android.bluetooth.mapmce.profile.extra.MESSAGE_TIMESTAMP";
    public static final String EXTRA_MESSAGE_READ_STATUS = "android.bluetooth.mapmce.profile.extra.MESSAGE_READ_STATUS";
    public static final String EXTRA_SENDER_CONTACT_URI = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_URI";
    public static final String EXTRA_SENDER_CONTACT_NAME = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_NAME";
    public static final String EXTRA_MESSAGE_DELETED_STATUS = "android.bluetooth.mapmce.profile.extra.MESSAGE_DELETED_STATUS";
    public static final String EXTRA_RESULT_CODE = "android.bluetooth.device.extra.RESULT_CODE";
    public static final int STATE_ERROR = -1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private static final int UPLOADING_FEATURE_BITMASK = 8;
    public static final int UNREAD = 0;
    public static final int READ = 1;
    public static final int UNDELETED = 2;
    public static final int DELETED = 3;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothMapClient> mProfileConnector = new BluetoothProfileConnector(this, 18, "BluetoothMapClient", IBluetoothMapClient.class.getName()){

        public IBluetoothMapClient getServiceInterface(IBinder service) {
            return IBluetoothMapClient.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothMapClient(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        if (DBG) {
            Log.d(TAG, "Create BluetoothMapClient proxy object");
        }
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    public void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothMapClient getService() {
        return this.mProfileConnector.getService();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d(TAG, "isConnected(" + device + ")");
        }
        if ((service = this.getService()) != null) {
            try {
                return service.isConnected(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                Log.d(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean connect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "connect(" + device + ")for MAPS MCE");
        }
        if ((service = this.getService()) != null) {
            try {
                return service.connect(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                Log.d(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean disconnect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "disconnect(" + device + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.disconnect(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getConnectedDevices()");
        }
        if ((service = this.getService()) != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getConnectedDevices(this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getDevicesMatchingStates()");
        }
        if ((service = this.getService()) != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getDevicesMatchingConnectionStates(states, this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getConnectionState(" + device + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getConnectionState(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        if (DBG) {
            Log.d(TAG, "setPriority(" + device + ", " + priority + ")");
        }
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            if (connectionPolicy != 0 && connectionPolicy != 100) {
                return false;
            }
            try {
                return service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getPriority(BluetoothDevice device) {
        if (VDBG) {
            Log.d(TAG, "getPriority(" + device + ")");
        }
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d(TAG, "getConnectionPolicy(" + device + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getConnectionPolicy(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.SEND_SMS"})
    public boolean sendMessage(BluetoothDevice device, Collection<Uri> contacts, String message, PendingIntent sentIntent, PendingIntent deliveredIntent) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "sendMessage(" + device + ", " + contacts + ", " + message);
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.sendMessage(device, contacts.toArray(new Uri[contacts.size()]), message, sentIntent, deliveredIntent, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.SEND_SMS"})
    public boolean sendMessage(BluetoothDevice device, Uri[] contacts, String message, PendingIntent sentIntent, PendingIntent deliveredIntent) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "sendMessage(" + device + ", " + contacts + ", " + message);
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.sendMessage(device, contacts, message, sentIntent, deliveredIntent, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.READ_SMS"})
    public boolean getUnreadMessages(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getUnreadMessages(" + device + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getUnreadMessages(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isUploadingSupported(BluetoothDevice device) {
        IBluetoothMapClient service = this.getService();
        try {
            return service != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device) && (service.getSupportedFeatures(device, this.mAttributionSource) & 8) > 0;
        }
        catch (RemoteException e) {
            Log.e(TAG, e.getMessage());
            return false;
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.READ_SMS"})
    public boolean setMessageStatus(BluetoothDevice device, String handle, int status) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "setMessageStatus(" + device + ", " + handle + ", " + status + ")");
        }
        if ((service = this.getService()) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device) && handle != null && (status == 1 || status == 0 || status == 2 || status == 3)) {
            try {
                return service.setMessageStatus(device, handle, status, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    private boolean isEnabled() {
        return this.mAdapter.isEnabled();
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }
}

