/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothProfileConnector;
import android.bluetooth.IBluetoothSap;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Attributable;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public class BluetoothSap
implements BluetoothProfile {
    private static final String TAG = "BluetoothSap";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.sap.profile.action.CONNECTION_STATE_CHANGED";
    public static final int STATE_ERROR = -1;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private final BluetoothAdapter mAdapter;
    private final AttributionSource mAttributionSource;
    private final BluetoothProfileConnector<IBluetoothSap> mProfileConnector = new BluetoothProfileConnector(this, 10, "BluetoothSap", IBluetoothSap.class.getName()){

        public IBluetoothSap getServiceInterface(IBinder service) {
            return IBluetoothSap.Stub.asInterface(Binder.allowBlocking(service));
        }
    };

    BluetoothSap(Context context, BluetoothProfile.ServiceListener listener, BluetoothAdapter adapter) {
        Log.d(TAG, "Create BluetoothSap proxy object");
        this.mAdapter = adapter;
        this.mAttributionSource = adapter.getAttributionSource();
        this.mProfileConnector.connect(context, listener);
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void close() {
        this.mProfileConnector.disconnect();
    }

    private IBluetoothSap getService() {
        return this.mProfileConnector.getService();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getState() {
        IBluetoothSap service = this.getService();
        if (service != null) {
            try {
                return service.getState(this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothDevice getClient() {
        IBluetoothSap service = this.getService();
        if (service != null) {
            try {
                return Attributable.setAttributionSource(service.getClient(this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected(BluetoothDevice device) {
        IBluetoothSap service = this.getService();
        if (service != null) {
            try {
                return service.isConnected(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            BluetoothSap.log(Log.getStackTraceString(new Throwable()));
        }
        return false;
    }

    @RequiresNoPermission
    public boolean connect(BluetoothDevice device) {
        BluetoothSap.log("connect(" + device + ")not supported for SAPS");
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disconnect(BluetoothDevice device) {
        BluetoothSap.log("disconnect(" + device + ")");
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.disconnect(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getConnectedDevices() {
        BluetoothSap.log("getConnectedDevices()");
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getConnectedDevices(this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        BluetoothSap.log("getDevicesMatchingStates()");
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled()) {
            try {
                return Attributable.setAttributionSource(service.getDevicesMatchingConnectionStates(states, this.mAttributionSource), this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getConnectionState(BluetoothDevice device) {
        BluetoothSap.log("getConnectionState(" + device + ")");
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.getConnectionState(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPriority(BluetoothDevice device, int priority) {
        BluetoothSap.log("setPriority(" + device + ", " + priority + ")");
        return this.setConnectionPolicy(device, BluetoothAdapter.priorityToConnectionPolicy(priority));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setConnectionPolicy(BluetoothDevice device, int connectionPolicy) {
        BluetoothSap.log("setConnectionPolicy(" + device + ", " + connectionPolicy + ")");
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            if (connectionPolicy != 0 && connectionPolicy != 100) {
                return false;
            }
            try {
                return service.setConnectionPolicy(device, connectionPolicy, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getPriority(BluetoothDevice device) {
        return BluetoothAdapter.connectionPolicyToPriority(this.getConnectionPolicy(device));
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionPolicy(BluetoothDevice device) {
        IBluetoothSap service = this.getService();
        if (service != null && this.isEnabled() && BluetoothSap.isValidDevice(device)) {
            try {
                return service.getConnectionPolicy(device, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    private boolean isEnabled() {
        return this.mAdapter.isEnabled();
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }
}

