/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.bluetooth.BluetoothDevice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothMetadataListener
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothMetadataListener";

    @RequiresNoPermission
    public void onMetadataChanged(BluetoothDevice var1, int var2, byte[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothMetadataListener {
        static final int TRANSACTION_onMetadataChanged = 1;

        public Stub() {
            this.attachInterface(this, IBluetoothMetadataListener.DESCRIPTOR);
        }

        public static IBluetoothMetadataListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothMetadataListener.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothMetadataListener) {
                return (IBluetoothMetadataListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onMetadataChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothMetadataListener.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    BluetoothDevice _arg0 = 0 != data.readInt() ? BluetoothDevice.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    this.onMetadataChanged(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IBluetoothMetadataListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IBluetoothMetadataListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IBluetoothMetadataListener {
            private IBinder mRemote;
            public static IBluetoothMetadataListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothMetadataListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMetadataChanged(BluetoothDevice devices, int key, byte[] value) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothMetadataListener.DESCRIPTOR);
                    if (devices != null) {
                        _data.writeInt(1);
                        devices.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(key);
                    _data.writeByteArray(value);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onMetadataChanged(devices, key, value);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothMetadataListener {
        @Override
        public void onMetadataChanged(BluetoothDevice devices, int key, byte[] value) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

