/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BluetoothLeAdvertiser {
    private static final String TAG = "BluetoothLeAdvertiser";
    private static final int MAX_ADVERTISING_DATA_BYTES = 1650;
    private static final int MAX_LEGACY_ADVERTISING_DATA_BYTES = 31;
    private static final int OVERHEAD_BYTES_PER_FIELD = 2;
    private static final int FLAGS_FIELD_BYTES = 3;
    private static final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private final BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final AttributionSource mAttributionSource;
    private final Handler mHandler;
    private final Map<AdvertiseCallback, AdvertisingSetCallback> mLegacyAdvertisers = new HashMap<AdvertiseCallback, AdvertisingSetCallback>();
    private final Map<AdvertisingSetCallback, IAdvertisingSetCallback> mCallbackWrappers = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, AdvertisingSet> mAdvertisingSets = Collections.synchronizedMap(new HashMap());

    public BluetoothLeAdvertiser(BluetoothAdapter bluetoothAdapter) {
        this.mBluetoothAdapter = Objects.requireNonNull(bluetoothAdapter);
        this.mBluetoothManager = this.mBluetoothAdapter.getBluetoothManager();
        this.mAttributionSource = this.mBluetoothAdapter.getAttributionSource();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            boolean isConnectable = settings.isConnectable();
            if (this.totalBytes(advertiseData, isConnectable) > 31 || this.totalBytes(scanResponse, false) > 31) {
                this.postStartFailure(callback, 1);
                return;
            }
            if (this.mLegacyAdvertisers.containsKey(callback)) {
                this.postStartFailure(callback, 3);
                return;
            }
            AdvertisingSetParameters.Builder parameters = new AdvertisingSetParameters.Builder();
            parameters.setLegacyMode(true);
            parameters.setConnectable(isConnectable);
            parameters.setScannable(true);
            if (settings.getMode() == 0) {
                parameters.setInterval(1600);
            } else if (settings.getMode() == 1) {
                parameters.setInterval(400);
            } else if (settings.getMode() == 2) {
                parameters.setInterval(160);
            }
            if (settings.getTxPowerLevel() == 0) {
                parameters.setTxPowerLevel(-21);
            } else if (settings.getTxPowerLevel() == 1) {
                parameters.setTxPowerLevel(-15);
            } else if (settings.getTxPowerLevel() == 2) {
                parameters.setTxPowerLevel(-7);
            } else if (settings.getTxPowerLevel() == 3) {
                parameters.setTxPowerLevel(1);
            }
            int duration = 0;
            int timeoutMillis = settings.getTimeout();
            if (timeoutMillis > 0) {
                duration = timeoutMillis < 10 ? 1 : timeoutMillis / 10;
            }
            AdvertisingSetCallback wrapped = this.wrapOldCallback(callback, settings);
            this.mLegacyAdvertisers.put(callback, wrapped);
            this.startAdvertisingSet(parameters.build(), advertiseData, scanResponse, null, null, duration, 0, wrapped);
        }
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission", "AndroidFrameworkRequiresPermission"})
    AdvertisingSetCallback wrapOldCallback(final AdvertiseCallback callback, final AdvertiseSettings settings) {
        return new AdvertisingSetCallback(){

            @Override
            public void onAdvertisingSetStarted(AdvertisingSet advertisingSet, int txPower, int status) {
                if (status != 0) {
                    BluetoothLeAdvertiser.this.postStartFailure(callback, status);
                    return;
                }
                BluetoothLeAdvertiser.this.postStartSuccess(callback, settings);
            }

            @Override
            public void onAdvertisingEnabled(AdvertisingSet advertisingSet, boolean enabled, int status) {
                if (enabled) {
                    Log.e(BluetoothLeAdvertiser.TAG, "Legacy advertiser should be only disabled on timeout, but was enabled!");
                    return;
                }
                BluetoothLeAdvertiser.this.stopAdvertising(callback);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertising(AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertisingSetCallback wrapper = this.mLegacyAdvertisers.get(callback);
            if (wrapper == null) {
                return;
            }
            this.stopAdvertisingSet(wrapper);
            this.mLegacyAdvertisers.remove(callback);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, new Handler(Looper.getMainLooper()));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback, Handler handler) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, handler);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, callback, new Handler(Looper.getMainLooper()));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback, Handler handler) {
        IBluetoothGatt gatt;
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        boolean isConnectable = parameters.isConnectable();
        if (parameters.isLegacy()) {
            if (this.totalBytes(advertiseData, isConnectable) > 31) {
                throw new IllegalArgumentException("Legacy advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > 31) {
                throw new IllegalArgumentException("Legacy scan response data too big");
            }
        } else {
            boolean supportCodedPhy = this.mBluetoothAdapter.isLeCodedPhySupported();
            boolean support2MPhy = this.mBluetoothAdapter.isLe2MPhySupported();
            int pphy = parameters.getPrimaryPhy();
            int sphy = parameters.getSecondaryPhy();
            if (pphy == 3 && !supportCodedPhy) {
                throw new IllegalArgumentException("Unsupported primary PHY selected");
            }
            if (sphy == 3 && !supportCodedPhy || sphy == 2 && !support2MPhy) {
                throw new IllegalArgumentException("Unsupported secondary PHY selected");
            }
            int maxData = this.mBluetoothAdapter.getLeMaximumAdvertisingDataLength();
            if (this.totalBytes(advertiseData, isConnectable) > maxData) {
                throw new IllegalArgumentException("Advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > maxData) {
                throw new IllegalArgumentException("Scan response data too big");
            }
            if (this.totalBytes(periodicData, false) > maxData) {
                throw new IllegalArgumentException("Periodic advertising data too big");
            }
            boolean supportPeriodic = this.mBluetoothAdapter.isLePeriodicAdvertisingSupported();
            if (periodicParameters != null && !supportPeriodic) {
                throw new IllegalArgumentException("Controller does not support LE Periodic Advertising");
            }
        }
        if (maxExtendedAdvertisingEvents < 0 || maxExtendedAdvertisingEvents > 255) {
            throw new IllegalArgumentException("maxExtendedAdvertisingEvents out of range: " + maxExtendedAdvertisingEvents);
        }
        if (maxExtendedAdvertisingEvents != 0 && !this.mBluetoothAdapter.isLePeriodicAdvertisingSupported()) {
            throw new IllegalArgumentException("Can't use maxExtendedAdvertisingEvents with controller that don't support LE Extended Advertising");
        }
        if (duration < 0 || duration > 65535) {
            throw new IllegalArgumentException("duration out of range: " + duration);
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get Bluetooth GATT - ", e);
            this.postStartSetFailure(handler, callback, 4);
            return;
        }
        if (gatt == null) {
            Log.e(TAG, "Bluetooth GATT is null");
            this.postStartSetFailure(handler, callback, 4);
            return;
        }
        IAdvertisingSetCallback wrapped = this.wrap(callback, handler);
        if (this.mCallbackWrappers.putIfAbsent(callback, wrapped) != null) {
            throw new IllegalArgumentException("callback instance already associated with advertising");
        }
        try {
            gatt.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, wrapped, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to start advertising set - ", e);
            this.postStartSetFailure(handler, callback, 4);
            return;
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertisingSet(AdvertisingSetCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        IAdvertisingSetCallback wrapped = this.mCallbackWrappers.remove(callback);
        if (wrapped == null) {
            return;
        }
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            gatt.stopAdvertisingSet(wrapped, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to stop advertising - ", e);
        }
    }

    @RequiresNoPermission
    public void cleanup() {
        this.mLegacyAdvertisers.clear();
        this.mCallbackWrappers.clear();
        this.mAdvertisingSets.clear();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    private int totalBytes(AdvertiseData data, boolean isFlagsIncluded) {
        int length;
        int num128BitUuids;
        int num32BitUuids;
        int num16BitUuids;
        int size;
        if (data == null) {
            return 0;
        }
        int n = size = isFlagsIncluded ? 3 : 0;
        if (data.getServiceUuids() != null) {
            num16BitUuids = 0;
            num32BitUuids = 0;
            num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid(uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        if (data.getServiceSolicitationUuids() != null) {
            num16BitUuids = 0;
            num32BitUuids = 0;
            num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceSolicitationUuids()) {
                if (BluetoothUuid.is16BitUuid(uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        for (ParcelUuid uuid : data.getServiceData().keySet()) {
            int uuidLen = BluetoothUuid.uuidToBytes(uuid).length;
            size += 2 + uuidLen + this.byteLength(data.getServiceData().get(uuid));
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + this.byteLength(data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && (length = this.mBluetoothAdapter.getNameLengthForAdvertise()) >= 0) {
            size += 2 + length;
        }
        return size;
    }

    private int byteLength(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    IAdvertisingSetCallback wrap(final AdvertisingSetCallback callback, final Handler handler) {
        return new IAdvertisingSetCallback.Stub(){

            @Override
            public void onAdvertisingSetStarted(final int advertiserId, final int txPower, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (status != 0) {
                            callback.onAdvertisingSetStarted(null, 0, status);
                            BluetoothLeAdvertiser.this.mCallbackWrappers.remove(callback);
                            return;
                        }
                        AdvertisingSet advertisingSet = new AdvertisingSet(advertiserId, BluetoothLeAdvertiser.this.mBluetoothManager, BluetoothLeAdvertiser.this.mAttributionSource);
                        BluetoothLeAdvertiser.this.mAdvertisingSets.put(advertiserId, advertisingSet);
                        callback.onAdvertisingSetStarted(advertisingSet, txPower, status);
                    }
                });
            }

            @Override
            public void onOwnAddressRead(final int advertiserId, final int addressType, final String address) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onOwnAddressRead(advertisingSet, addressType, address);
                    }
                });
            }

            @Override
            public void onAdvertisingSetStopped(final int advertiserId) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onAdvertisingSetStopped(advertisingSet);
                        BluetoothLeAdvertiser.this.mAdvertisingSets.remove(advertiserId);
                        BluetoothLeAdvertiser.this.mCallbackWrappers.remove(callback);
                    }
                });
            }

            @Override
            public void onAdvertisingEnabled(final int advertiserId, final boolean enabled, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onAdvertisingEnabled(advertisingSet, enabled, status);
                    }
                });
            }

            @Override
            public void onAdvertisingDataSet(final int advertiserId, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onAdvertisingDataSet(advertisingSet, status);
                    }
                });
            }

            @Override
            public void onScanResponseDataSet(final int advertiserId, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onScanResponseDataSet(advertisingSet, status);
                    }
                });
            }

            @Override
            public void onAdvertisingParametersUpdated(final int advertiserId, final int txPower, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onAdvertisingParametersUpdated(advertisingSet, txPower, status);
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingParametersUpdated(final int advertiserId, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onPeriodicAdvertisingParametersUpdated(advertisingSet, status);
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingDataSet(final int advertiserId, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onPeriodicAdvertisingDataSet(advertisingSet, status);
                    }
                });
            }

            @Override
            public void onPeriodicAdvertisingEnabled(final int advertiserId, final boolean enable, final int status) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)BluetoothLeAdvertiser.this.mAdvertisingSets.get(advertiserId);
                        callback.onPeriodicAdvertisingEnabled(advertisingSet, enable, status);
                    }
                });
            }
        };
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postStartSetFailure(Handler handler, final AdvertisingSetCallback callback, final int error) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                callback.onAdvertisingSetStarted(null, 0, error);
            }
        });
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postStartFailure(final AdvertiseCallback callback, final int error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onStartFailure(error);
            }
        });
    }

    @SuppressLint(value={"AndroidFrameworkBluetoothPermission"})
    private void postStartSuccess(final AdvertiseCallback callback, final AdvertiseSettings settings) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                callback.onStartSuccess(settings);
            }
        });
    }
}

