/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.appwidget.AppWidgetProviderInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.LocusId;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPinItemRequest;
import android.content.pm.IShortcutChangeCallback;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherActivityInfoInternal;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutQueryWrapper;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class LauncherApps {
    static final String TAG = "LauncherApps";
    static final boolean DEBUG = false;
    public static final String ACTION_CONFIRM_PIN_SHORTCUT = "android.content.pm.action.CONFIRM_PIN_SHORTCUT";
    public static final String ACTION_CONFIRM_PIN_APPWIDGET = "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
    public static final String EXTRA_PIN_ITEM_REQUEST = "android.content.pm.extra.PIN_ITEM_REQUEST";
    public static final int FLAG_CACHE_NOTIFICATION_SHORTCUTS = 0;
    public static final int FLAG_CACHE_BUBBLE_SHORTCUTS = 1;
    public static final int FLAG_CACHE_PEOPLE_TILE_SHORTCUTS = 2;
    private final Context mContext;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final ILauncherApps mService;
    @UnsupportedAppUsage
    private final PackageManager mPm;
    private final UserManager mUserManager;
    private final List<CallbackMessageHandler> mCallbacks = new ArrayList<CallbackMessageHandler>();
    private final List<PackageInstaller.SessionCallbackDelegate> mDelegates = new ArrayList<PackageInstaller.SessionCallbackDelegate>();
    private final Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> mShortcutChangeCallbacks = new HashMap<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>>();
    private IOnAppsChangedListener.Stub mAppsChangedListener = new IOnAppsChangedListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageRemoved(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageChanged(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageChanged(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageAdded(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageAdded(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesAvailable(packageNames, user, replacing);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesUnavailable(packageNames, user, replacing);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesSuspended(UserHandle user, String[] packageNames, Bundle launcherExtras) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesSuspended(packageNames, launcherExtras, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesUnsuspended(UserHandle user, String[] packageNames) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesUnsuspended(packageNames, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShortcutChanged(UserHandle user, String packageName, ParceledListSlice shortcuts) {
            List list = shortcuts.getList();
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnShortcutChanged(packageName, user, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageLoadingProgressChanged(user, packageName, progress);
                }
            }
        }
    };

    public LauncherApps(Context context, ILauncherApps service) {
        this.mContext = context;
        this.mService = service;
        this.mPm = context.getPackageManager();
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    public LauncherApps(Context context) {
        this(context, ILauncherApps.Stub.asInterface(ServiceManager.getService("launcherapps")));
    }

    private void logErrorForInvalidProfileAccess(UserHandle target) {
        if (UserHandle.myUserId() != target.getIdentifier() && this.mUserManager.isManagedProfile() && this.mContext.checkSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            Log.w(TAG, "Accessing other profiles/users from managed profile is no longer allowed.");
        }
    }

    public List<UserHandle> getProfiles() {
        if (this.mUserManager.isManagedProfile()) {
            ArrayList<UserHandle> result = new ArrayList<UserHandle>(1);
            result.add(Process.myUserHandle());
            return result;
        }
        return this.mUserManager.getUserProfiles();
    }

    public List<LauncherActivityInfo> getActivityList(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getLauncherActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public PendingIntent getMainActivityLaunchIntent(ComponentName component, Bundle startActivityOptions, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getActivityLaunchIntent(component, null, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            LauncherActivityInfoInternal ai = this.mService.resolveLauncherActivityInternal(this.mContext.getPackageName(), intent.getComponent(), user);
            if (ai == null) {
                return null;
            }
            return new LauncherActivityInfo(this.mContext, user, ai);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void startMainActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void startPackageInstallerSessionDetailsActivity(PackageInstaller.SessionInfo sessionInfo, Rect sourceBounds, Bundle opts) {
        try {
            this.mService.startSessionDetailsActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), sessionInfo, sourceBounds, opts, sessionInfo.getUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public void startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.showAppDetailsAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public PendingIntent getShortcutIntent(String packageName, String shortcutId, Bundle opts, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getShortcutIntent(this.mContext.getPackageName(), packageName, shortcutId, null, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<LauncherActivityInfo> getShortcutConfigActivityList(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getShortcutConfigActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private List<LauncherActivityInfo> convertToActivityList(ParceledListSlice<LauncherActivityInfoInternal> internals, UserHandle user) {
        if (internals == null || internals.getList().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> lais = new ArrayList<LauncherActivityInfo>();
        for (LauncherActivityInfoInternal internal : internals.getList()) {
            LauncherActivityInfo lai = new LauncherActivityInfo(this.mContext, user, internal);
            lais.add(lai);
        }
        return lais;
    }

    public IntentSender getShortcutConfigActivityIntent(LauncherActivityInfo info) {
        try {
            return this.mService.getShortcutConfigActivityIntent(this.mContext.getPackageName(), info.getComponentName(), info.getUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isPackageEnabled(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isPackageEnabled(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public Bundle getSuspendedPackageLauncherExtras(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getSuspendedPackageLauncherExtras(packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean shouldHideFromSuggestions(String packageName, UserHandle user) {
        Objects.requireNonNull(packageName, "packageName");
        Objects.requireNonNull(user, "user");
        try {
            return this.mService.shouldHideFromSuggestions(packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public ApplicationInfo getApplicationInfo(String packageName, int flags, UserHandle user) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName, "packageName");
        Objects.requireNonNull(user, "user");
        this.logErrorForInvalidProfileAccess(user);
        try {
            ApplicationInfo ai = this.mService.getApplicationInfo(this.mContext.getPackageName(), packageName, flags, user);
            if (ai == null) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " not found for user " + user.getIdentifier());
            }
            return ai;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public AppUsageLimit getAppUsageLimit(String packageName, UserHandle user) {
        try {
            return this.mService.getAppUsageLimit(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean isActivityEnabled(ComponentName component, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isActivityEnabled(this.mContext.getPackageName(), component, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasShortcutHostPermission() {
        try {
            return this.mService.hasShortcutHostPermission(this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private List<ShortcutInfo> maybeUpdateDisabledMessage(List<ShortcutInfo> shortcuts) {
        if (shortcuts == null) {
            return null;
        }
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = shortcuts.get(i);
            String message = ShortcutInfo.getDisabledReasonForRestoreIssue(this.mContext, si.getDisabledReason());
            if (message == null) continue;
            si.setDisabledMessage(message);
        }
        return shortcuts;
    }

    public List<ShortcutInfo> getShortcuts(ShortcutQuery query, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.maybeUpdateDisabledMessage(this.mService.getShortcuts(this.mContext.getPackageName(), new ShortcutQueryWrapper(query), user).getList());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<ShortcutInfo> getShortcutInfo(String packageName, List<String> ids, UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(ids);
        q.setQueryFlags(27);
        return this.getShortcuts(q, user);
    }

    public void pinShortcuts(String packageName, List<String> shortcutIds, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.pinShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
    public void cacheShortcuts(String packageName, List<String> shortcutIds, UserHandle user, int cacheFlags) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.cacheShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user, cacheFlags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
    public void uncacheShortcuts(String packageName, List<String> shortcutIds, UserHandle user, int cacheFlags) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.uncacheShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user, cacheFlags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int getShortcutIconResId(ShortcutInfo shortcut) {
        return shortcut.getIconResourceId();
    }

    @Deprecated
    public int getShortcutIconResId(String packageName, String shortcutId, UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(Arrays.asList(shortcutId));
        q.setQueryFlags(27);
        List<ShortcutInfo> shortcuts = this.getShortcuts(q, user);
        return shortcuts.size() > 0 ? shortcuts.get(0).getIconResourceId() : 0;
    }

    public ParcelFileDescriptor getShortcutIconFd(ShortcutInfo shortcut) {
        return this.getShortcutIconFd(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
    }

    public ParcelFileDescriptor getShortcutIconFd(String packageName, String shortcutId, UserHandle user) {
        return this.getShortcutIconFd(packageName, shortcutId, user.getIdentifier());
    }

    private ParcelFileDescriptor getShortcutIconFd(String packageName, String shortcutId, int userId) {
        try {
            return this.mService.getShortcutIconFd(this.mContext.getPackageName(), packageName, shortcutId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    public ParcelFileDescriptor getUriShortcutIconFd(ShortcutInfo shortcut) {
        return this.getUriShortcutIconFd(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
    }

    private ParcelFileDescriptor getUriShortcutIconFd(String packageName, String shortcutId, int userId) {
        String uri = this.getShortcutIconUri(packageName, shortcutId, userId);
        if (uri == null) {
            return null;
        }
        try {
            return this.mContext.getContentResolver().openFileDescriptor(Uri.parse(uri), "r");
        }
        catch (FileNotFoundException e) {
            Log.e(TAG, "Icon file not found: " + uri);
            return null;
        }
    }

    private String getShortcutIconUri(String packageName, String shortcutId, int userId) {
        String uri = null;
        try {
            uri = this.mService.getShortcutIconUri(this.mContext.getPackageName(), packageName, shortcutId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return uri;
    }

    public Drawable getShortcutIconDrawable(ShortcutInfo shortcut, int density) {
        if (shortcut.hasIconFile()) {
            ParcelFileDescriptor pfd = this.getShortcutIconFd(shortcut);
            return this.loadDrawableFromFileDescriptor(pfd, shortcut.hasAdaptiveBitmap());
        }
        if (shortcut.hasIconUri()) {
            ParcelFileDescriptor pfd = this.getUriShortcutIconFd(shortcut);
            return this.loadDrawableFromFileDescriptor(pfd, shortcut.hasAdaptiveBitmap());
        }
        if (shortcut.hasIconResource()) {
            return this.loadDrawableResourceFromPackage(shortcut.getPackage(), shortcut.getIconResourceId(), shortcut.getUserHandle(), density);
        }
        if (shortcut.getIcon() != null) {
            Icon icon = shortcut.getIcon();
            switch (icon.getType()) {
                case 2: {
                    return this.loadDrawableResourceFromPackage(shortcut.getPackage(), icon.getResId(), shortcut.getUserHandle(), density);
                }
                case 1: 
                case 5: {
                    return icon.loadDrawable(this.mContext);
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable loadDrawableFromFileDescriptor(ParcelFileDescriptor pfd, boolean adaptive) {
        if (pfd == null) {
            return null;
        }
        try {
            Bitmap bmp = BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor());
            if (bmp != null) {
                BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bmp);
                if (adaptive) {
                    AdaptiveIconDrawable adaptiveIconDrawable = new AdaptiveIconDrawable(null, dr);
                    return adaptiveIconDrawable;
                }
                BitmapDrawable bitmapDrawable = dr;
                return bitmapDrawable;
            }
            Drawable drawable2 = null;
            return drawable2;
        }
        finally {
            try {
                pfd.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Icon getShortcutIcon(ShortcutInfo shortcut) {
        if (shortcut.hasIconFile()) {
            ParcelFileDescriptor pfd = this.getShortcutIconFd(shortcut);
            if (pfd == null) {
                return null;
            }
            try {
                Bitmap bmp = BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor());
                if (bmp != null) {
                    if (shortcut.hasAdaptiveBitmap()) {
                        Icon icon = Icon.createWithAdaptiveBitmap(bmp);
                        return icon;
                    }
                    Icon icon = Icon.createWithBitmap(bmp);
                    return icon;
                }
                Icon icon = null;
                return icon;
            }
            finally {
                try {
                    pfd.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!shortcut.hasIconUri()) {
            if (!shortcut.hasIconResource()) return shortcut.getIcon();
            return Icon.createWithResource(shortcut.getPackage(), shortcut.getIconResourceId());
        }
        String uri = this.getShortcutIconUri(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
        if (uri == null) {
            return null;
        }
        if (!shortcut.hasAdaptiveBitmap()) return Icon.createWithContentUri(uri);
        return Icon.createWithAdaptiveBitmapContentUri(uri);
    }

    private Drawable loadDrawableResourceFromPackage(String packageName, int resId, UserHandle user, int density) {
        try {
            if (resId == 0) {
                return null;
            }
            ApplicationInfo ai = this.getApplicationInfo(packageName, 0, user);
            Resources res = this.mContext.getPackageManager().getResourcesForApplication(ai);
            return res.getDrawableForDensity(resId, density);
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return null;
        }
    }

    public Drawable getShortcutBadgedIconDrawable(ShortcutInfo shortcut, int density) {
        Drawable originalIcon = this.getShortcutIconDrawable(shortcut, density);
        return originalIcon == null ? null : this.mContext.getPackageManager().getUserBadgedIcon(originalIcon, shortcut.getUserHandle());
    }

    public void startShortcut(String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        this.startShortcut(packageName, shortcutId, sourceBounds, startActivityOptions, user.getIdentifier());
    }

    public void startShortcut(ShortcutInfo shortcut, Rect sourceBounds, Bundle startActivityOptions) {
        this.startShortcut(shortcut.getPackage(), shortcut.getId(), sourceBounds, startActivityOptions, shortcut.getUserId());
    }

    @UnsupportedAppUsage
    private void startShortcut(String packageName, String shortcutId, Rect sourceBounds, Bundle startActivityOptions, int userId) {
        try {
            boolean success = this.mService.startShortcut(this.mContext.getPackageName(), packageName, null, shortcutId, sourceBounds, startActivityOptions, userId);
            if (!success) {
                throw new ActivityNotFoundException("Shortcut could not be started");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCallback(Callback callback, Handler handler) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            if (callback != null && this.findCallbackLocked(callback) < 0) {
                boolean addedFirstCallback = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (addedFirstCallback) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mContext.getPackageName(), this.mAppsChangedListener);
                    }
                    catch (RemoteException re) {
                        throw re.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            this.removeCallbackLocked(callback);
            if (this.mCallbacks.size() == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
        }
    }

    private int findCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int size = this.mCallbacks.size();
        for (int i = 0; i < size; ++i) {
            if (this.mCallbacks.get(i).mCallback != callback) continue;
            return i;
        }
        return -1;
    }

    private void removeCallbackLocked(Callback callback) {
        int pos = this.findCallbackLocked(callback);
        if (pos >= 0) {
            this.mCallbacks.remove(pos);
        }
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler toAdd = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(toAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPackageInstallerSessionCallback(Executor executor, PackageInstaller.SessionCallback callback) {
        if (executor == null) {
            throw new NullPointerException("Executor must not be null");
        }
        List<PackageInstaller.SessionCallbackDelegate> list = this.mDelegates;
        synchronized (list) {
            PackageInstaller.SessionCallbackDelegate delegate = new PackageInstaller.SessionCallbackDelegate(callback, executor);
            try {
                this.mService.registerPackageInstallerCallback(this.mContext.getPackageName(), delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPackageInstallerSessionCallback(PackageInstaller.SessionCallback callback) {
        List<PackageInstaller.SessionCallbackDelegate> list = this.mDelegates;
        synchronized (list) {
            Iterator<PackageInstaller.SessionCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                PackageInstaller.SessionCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                this.mPm.getPackageInstaller().unregisterSessionCallback(delegate.mCallback);
                i.remove();
            }
        }
    }

    public List<PackageInstaller.SessionInfo> getAllPackageInstallerSessions() {
        try {
            return this.mService.getAllSessions(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShortcutChangeCallback(ShortcutChangeCallback callback, ShortcutQuery query, Executor executor) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> map = this.mShortcutChangeCallbacks;
        synchronized (map) {
            ShortcutChangeCallbackProxy proxy = new ShortcutChangeCallbackProxy(executor, callback);
            this.mShortcutChangeCallbacks.put(callback, new Pair<Executor, ShortcutChangeCallbackProxy>(executor, proxy));
            try {
                this.mService.registerShortcutChangeCallback(this.mContext.getPackageName(), new ShortcutQueryWrapper(query), proxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShortcutChangeCallback(ShortcutChangeCallback callback) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> map = this.mShortcutChangeCallbacks;
        synchronized (map) {
            if (this.mShortcutChangeCallbacks.containsKey(callback)) {
                IShortcutChangeCallback proxy = (IShortcutChangeCallback)this.mShortcutChangeCallbacks.remove((Object)callback).second;
                try {
                    this.mService.unregisterShortcutChangeCallback(this.mContext.getPackageName(), proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    public PinItemRequest getPinItemRequest(Intent intent) {
        return (PinItemRequest)intent.getParcelableExtra(EXTRA_PIN_ITEM_REQUEST);
    }

    @SystemApi
    public static class AppUsageLimit
    implements Parcelable {
        private final long mTotalUsageLimit;
        private final long mUsageRemaining;
        public static final Parcelable.Creator<AppUsageLimit> CREATOR = new Parcelable.Creator<AppUsageLimit>(){

            @Override
            public AppUsageLimit createFromParcel(Parcel source) {
                return new AppUsageLimit(source);
            }

            public AppUsageLimit[] newArray(int size) {
                return new AppUsageLimit[size];
            }
        };

        public AppUsageLimit(long totalUsageLimit, long usageRemaining) {
            this.mTotalUsageLimit = totalUsageLimit;
            this.mUsageRemaining = usageRemaining;
        }

        public long getTotalUsageLimit() {
            return this.mTotalUsageLimit;
        }

        public long getUsageRemaining() {
            return this.mUsageRemaining;
        }

        private AppUsageLimit(Parcel source) {
            this.mTotalUsageLimit = source.readLong();
            this.mUsageRemaining = source.readLong();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mTotalUsageLimit);
            dest.writeLong(this.mUsageRemaining);
        }
    }

    public static class PinItemRequest
    implements Parcelable {
        public static final int REQUEST_TYPE_SHORTCUT = 1;
        public static final int REQUEST_TYPE_APPWIDGET = 2;
        private final int mRequestType;
        private final IPinItemRequest mInner;
        public static final Parcelable.Creator<PinItemRequest> CREATOR = new Parcelable.Creator<PinItemRequest>(){

            @Override
            public PinItemRequest createFromParcel(Parcel source) {
                return new PinItemRequest(source);
            }

            public PinItemRequest[] newArray(int size) {
                return new PinItemRequest[size];
            }
        };

        public PinItemRequest(IPinItemRequest inner, int type) {
            this.mInner = inner;
            this.mRequestType = type;
        }

        public int getRequestType() {
            return this.mRequestType;
        }

        public ShortcutInfo getShortcutInfo() {
            try {
                return this.mInner.getShortcutInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        public AppWidgetProviderInfo getAppWidgetProviderInfo(Context context) {
            try {
                AppWidgetProviderInfo info = this.mInner.getAppWidgetProviderInfo();
                if (info == null) {
                    return null;
                }
                info.updateDimensions(context.getResources().getDisplayMetrics());
                return info;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        public Bundle getExtras() {
            try {
                return this.mInner.getExtras();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        public boolean isValid() {
            try {
                return this.mInner.isValid();
            }
            catch (RemoteException e) {
                return false;
            }
        }

        public boolean accept(Bundle options) {
            try {
                return this.mInner.accept(options);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public boolean accept() {
            return this.accept(null);
        }

        private PinItemRequest(Parcel source) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.mRequestType = source.readInt();
            this.mInner = IPinItemRequest.Stub.asInterface(source.readStrongBinder());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRequestType);
            dest.writeStrongBinder(this.mInner.asBinder());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    private static class CallbackMessageHandler
    extends Handler {
        private static final int MSG_ADDED = 1;
        private static final int MSG_REMOVED = 2;
        private static final int MSG_CHANGED = 3;
        private static final int MSG_AVAILABLE = 4;
        private static final int MSG_UNAVAILABLE = 5;
        private static final int MSG_SUSPENDED = 6;
        private static final int MSG_UNSUSPENDED = 7;
        private static final int MSG_SHORTCUT_CHANGED = 8;
        private static final int MSG_LOADING_PROGRESS_CHANGED = 9;
        private Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mCallback == null || !(msg.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo info = (CallbackInfo)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onPackageAdded(info.packageName, info.user);
                    break;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(info.packageName, info.user);
                    break;
                }
                case 3: {
                    this.mCallback.onPackageChanged(info.packageName, info.user);
                    break;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 5: {
                    this.mCallback.onPackagesUnavailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 6: {
                    this.mCallback.onPackagesSuspended(info.packageNames, info.user, info.launcherExtras);
                    break;
                }
                case 7: {
                    this.mCallback.onPackagesUnsuspended(info.packageNames, info.user);
                    break;
                }
                case 8: {
                    this.mCallback.onShortcutsChanged(info.packageName, info.shortcuts, info.user);
                    break;
                }
                case 9: {
                    this.mCallback.onPackageLoadingProgressChanged(info.packageName, info.user, info.mLoadingProgress);
                }
            }
        }

        public void postOnPackageAdded(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(1, info).sendToTarget();
        }

        public void postOnPackageRemoved(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(2, info).sendToTarget();
        }

        public void postOnPackageChanged(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(3, info).sendToTarget();
        }

        public void postOnPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(4, info).sendToTarget();
        }

        public void postOnPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(5, info).sendToTarget();
        }

        public void postOnPackagesSuspended(String[] packageNames, Bundle launcherExtras, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.user = user;
            info.launcherExtras = launcherExtras;
            this.obtainMessage(6, info).sendToTarget();
        }

        public void postOnPackagesUnsuspended(String[] packageNames, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.user = user;
            this.obtainMessage(7, info).sendToTarget();
        }

        public void postOnShortcutChanged(String packageName, UserHandle user, List<ShortcutInfo> shortcuts) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            info.shortcuts = shortcuts;
            this.obtainMessage(8, info).sendToTarget();
        }

        public void postOnPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            info.mLoadingProgress = progress;
            this.obtainMessage(9, info).sendToTarget();
        }

        private static class CallbackInfo {
            String[] packageNames;
            String packageName;
            Bundle launcherExtras;
            boolean replacing;
            UserHandle user;
            List<ShortcutInfo> shortcuts;
            float mLoadingProgress;

            private CallbackInfo() {
            }
        }
    }

    private static class ShortcutChangeCallbackProxy
    extends IShortcutChangeCallback.Stub {
        private final WeakReference<Pair<Executor, ShortcutChangeCallback>> mRemoteReferences;

        ShortcutChangeCallbackProxy(Executor executor, ShortcutChangeCallback callback) {
            this.mRemoteReferences = new WeakReference<Pair<Executor, ShortcutChangeCallback>>(new Pair<Executor, ShortcutChangeCallback>(executor, callback));
        }

        @Override
        public void onShortcutsAddedOrUpdated(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
            Pair remoteReferences = (Pair)this.mRemoteReferences.get();
            if (remoteReferences == null) {
                return;
            }
            Executor executor = (Executor)remoteReferences.first;
            ShortcutChangeCallback callback = (ShortcutChangeCallback)remoteReferences.second;
            executor.execute(PooledLambda.obtainRunnable(ShortcutChangeCallback::onShortcutsAddedOrUpdated, callback, packageName, shortcuts, user).recycleOnUse());
        }

        @Override
        public void onShortcutsRemoved(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
            Pair remoteReferences = (Pair)this.mRemoteReferences.get();
            if (remoteReferences == null) {
                return;
            }
            Executor executor = (Executor)remoteReferences.first;
            ShortcutChangeCallback callback = (ShortcutChangeCallback)remoteReferences.second;
            executor.execute(PooledLambda.obtainRunnable(ShortcutChangeCallback::onShortcutsRemoved, callback, packageName, shortcuts, user).recycleOnUse());
        }
    }

    public static interface ShortcutChangeCallback {
        default public void onShortcutsAddedOrUpdated(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
        }

        default public void onShortcutsRemoved(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
        }
    }

    public static class ShortcutQuery {
        public static final int FLAG_MATCH_DYNAMIC = 1;
        @Deprecated
        public static final int FLAG_GET_DYNAMIC = 1;
        public static final int FLAG_MATCH_PINNED = 2;
        @Deprecated
        public static final int FLAG_GET_PINNED = 2;
        public static final int FLAG_MATCH_MANIFEST = 8;
        public static final int FLAG_MATCH_CACHED = 16;
        @Deprecated
        public static final int FLAG_GET_MANIFEST = 8;
        public static final int FLAG_MATCH_PINNED_BY_ANY_LAUNCHER = 1024;
        public static final int FLAG_MATCH_ALL_KINDS = 27;
        public static final int FLAG_MATCH_ALL_KINDS_WITH_ALL_PINNED = 1051;
        @Deprecated
        public static final int FLAG_GET_ALL_KINDS = 27;
        public static final int FLAG_GET_KEY_FIELDS_ONLY = 4;
        @SystemApi
        @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
        public static final int FLAG_GET_PERSONS_DATA = 2048;
        long mChangedSince;
        String mPackage;
        List<String> mShortcutIds;
        List<LocusId> mLocusIds;
        ComponentName mActivity;
        int mQueryFlags;

        public ShortcutQuery setChangedSince(long changedSince) {
            this.mChangedSince = changedSince;
            return this;
        }

        public ShortcutQuery setPackage(String packageName) {
            this.mPackage = packageName;
            return this;
        }

        public ShortcutQuery setShortcutIds(List<String> shortcutIds) {
            this.mShortcutIds = shortcutIds;
            return this;
        }

        public ShortcutQuery setLocusIds(List<LocusId> locusIds) {
            this.mLocusIds = locusIds;
            return this;
        }

        public ShortcutQuery setActivity(ComponentName activity) {
            this.mActivity = activity;
            return this;
        }

        public ShortcutQuery setQueryFlags(int queryFlags) {
            this.mQueryFlags = queryFlags;
            return this;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface QueryFlags {
        }
    }

    public static abstract class Callback {
        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);

        public void onPackagesSuspended(String[] packageNames, UserHandle user) {
        }

        @Deprecated
        public void onPackagesSuspended(String[] packageNames, UserHandle user, Bundle launcherExtras) {
            this.onPackagesSuspended(packageNames, user);
        }

        public void onPackagesUnsuspended(String[] packageNames, UserHandle user) {
        }

        public void onShortcutsChanged(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
        }

        public void onPackageLoadingProgressChanged(String packageName, UserHandle user, float progress) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShortcutCacheFlags {
    }
}

