/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.parsing.PackageInfoWithoutStateUtils;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingPackageUtils;
import android.content.pm.parsing.component.ParsedActivity;
import android.content.pm.parsing.component.ParsedAttribution;
import android.content.pm.parsing.component.ParsedComponent;
import android.content.pm.parsing.component.ParsedInstrumentation;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.component.ParsedMainComponent;
import android.content.pm.parsing.component.ParsedPermission;
import android.content.pm.parsing.component.ParsedPermissionGroup;
import android.content.pm.parsing.component.ParsedProcess;
import android.content.pm.parsing.component.ParsedProvider;
import android.content.pm.parsing.component.ParsedService;
import android.content.pm.parsing.component.ParsedUsesPermission;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.storage.StorageManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Parcelling;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ParsingPackageImpl
implements ParsingPackage,
Parcelable {
    private static final String TAG = "PackageImpl";
    public static Parcelling.BuiltIn.ForBoolean sForBoolean = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForBoolean.class);
    public static Parcelling.BuiltIn.ForInternedString sForInternedString = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedString.class);
    public static Parcelling.BuiltIn.ForInternedStringArray sForInternedStringArray = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringArray.class);
    public static Parcelling.BuiltIn.ForInternedStringList sForInternedStringList = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringList.class);
    public static Parcelling.BuiltIn.ForInternedStringValueMap sForInternedStringValueMap = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringValueMap.class);
    public static Parcelling.BuiltIn.ForStringSet sForStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForStringSet.class);
    public static Parcelling.BuiltIn.ForInternedStringSet sForInternedStringSet = Parcelling.Cache.getOrCreate(Parcelling.BuiltIn.ForInternedStringSet.class);
    protected static ParsedIntentInfo.StringPairListParceler sForIntentInfoPairs = Parcelling.Cache.getOrCreate(ParsedIntentInfo.StringPairListParceler.class);
    private static final Comparator<ParsedMainComponent> ORDER_COMPARATOR = (first, second) -> Integer.compare(second.getOrder(), first.getOrder());
    private Boolean supportsSmallScreens;
    private Boolean supportsNormalScreens;
    private Boolean supportsLargeScreens;
    private Boolean supportsExtraLargeScreens;
    private Boolean resizeable;
    private Boolean anyDensity;
    protected int versionCode;
    protected int versionCodeMajor;
    private int baseRevisionCode;
    private String versionName;
    private int compileSdkVersion;
    private String compileSdkVersionCodeName;
    protected String packageName;
    private String realPackage;
    protected String mBaseApkPath;
    private String restrictedAccountType;
    private String requiredAccountType;
    private String overlayTarget;
    private String overlayTargetName;
    private String overlayCategory;
    private int overlayPriority;
    private Map<String, String> overlayables = Collections.emptyMap();
    private String staticSharedLibName;
    private long staticSharedLibVersion;
    private List<String> libraryNames = Collections.emptyList();
    protected List<String> usesLibraries = Collections.emptyList();
    protected List<String> usesOptionalLibraries = Collections.emptyList();
    protected List<String> usesNativeLibraries = Collections.emptyList();
    protected List<String> usesOptionalNativeLibraries = Collections.emptyList();
    private List<String> usesStaticLibraries = Collections.emptyList();
    private long[] usesStaticLibrariesVersions;
    private String[][] usesStaticLibrariesCertDigests;
    private String sharedUserId;
    private int sharedUserLabel;
    private List<ConfigurationInfo> configPreferences = Collections.emptyList();
    private List<FeatureInfo> reqFeatures = Collections.emptyList();
    private List<FeatureGroupInfo> featureGroups = Collections.emptyList();
    private byte[] restrictUpdateHash;
    protected List<String> originalPackages = Collections.emptyList();
    protected List<String> adoptPermissions = Collections.emptyList();
    @Deprecated
    protected List<String> requestedPermissions = Collections.emptyList();
    private List<ParsedUsesPermission> usesPermissions = Collections.emptyList();
    private List<String> implicitPermissions = Collections.emptyList();
    private Set<String> upgradeKeySets = Collections.emptySet();
    private Map<String, ArraySet<PublicKey>> keySetMapping = Collections.emptyMap();
    protected List<String> protectedBroadcasts = Collections.emptyList();
    protected List<ParsedActivity> activities = Collections.emptyList();
    protected List<ParsedActivity> receivers = Collections.emptyList();
    protected List<ParsedService> services = Collections.emptyList();
    protected List<ParsedProvider> providers = Collections.emptyList();
    private List<ParsedAttribution> attributions = Collections.emptyList();
    protected List<ParsedPermission> permissions = Collections.emptyList();
    protected List<ParsedPermissionGroup> permissionGroups = Collections.emptyList();
    protected List<ParsedInstrumentation> instrumentations = Collections.emptyList();
    private List<Pair<String, ParsedIntentInfo>> preferredActivityFilters = Collections.emptyList();
    private Map<String, ParsedProcess> processes = Collections.emptyMap();
    private Bundle metaData;
    private Map<String, PackageManager.Property> mProperties = Collections.emptyMap();
    protected String volumeUuid;
    private PackageParser.SigningDetails signingDetails;
    protected String mPath;
    private List<Intent> queriesIntents = Collections.emptyList();
    private List<String> queriesPackages = Collections.emptyList();
    private Set<String> queriesProviders = Collections.emptySet();
    private String[] splitClassLoaderNames;
    protected String[] splitCodePaths;
    private SparseArray<int[]> splitDependencies;
    private int[] splitFlags;
    private String[] splitNames;
    private int[] splitRevisionCodes;
    private String appComponentFactory;
    private String backupAgentName;
    private int banner;
    private int category;
    private String classLoaderName;
    private String className;
    private int compatibleWidthLimitDp;
    private int descriptionRes;
    private int fullBackupContent;
    private int dataExtractionRules;
    private int iconRes;
    private int installLocation = -1;
    private int labelRes;
    private int largestWidthLimitDp;
    private int logo;
    private String manageSpaceActivityName;
    private float maxAspectRatio;
    private float minAspectRatio;
    private SparseIntArray minExtensionVersions;
    private int minSdkVersion = 1;
    private int networkSecurityConfigRes;
    private CharSequence nonLocalizedLabel;
    private String permission;
    private String processName;
    private int requiresSmallestWidthDp;
    private int roundIconRes;
    private int targetSandboxVersion;
    private int targetSdkVersion = 0;
    private String taskAffinity;
    private int theme;
    private int uiOptions;
    private String zygotePreloadName;
    private Boolean resizeableActivity;
    private int autoRevokePermissions;
    private int gwpAsanMode;
    private int memtagMode;
    private int nativeHeapZeroInitialized;
    private Boolean requestRawExternalStorageAccess;
    private ArraySet<String> mimeGroups;
    private long mBooleans = 0x100000000000L;
    private UUID mStorageUuid;
    private long mLongVersionCode;
    public static final Parcelable.Creator<ParsingPackageImpl> CREATOR = new Parcelable.Creator<ParsingPackageImpl>(){

        @Override
        public ParsingPackageImpl createFromParcel(Parcel source) {
            return new ParsingPackageImpl(source);
        }

        public ParsingPackageImpl[] newArray(int size) {
            return new ParsingPackageImpl[size];
        }
    };

    private ParsingPackageImpl setBoolean(@Booleans.Values long flag, boolean value) {
        this.mBooleans = value ? (this.mBooleans |= flag) : (this.mBooleans &= flag ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    private boolean getBoolean(@Booleans.Values long flag) {
        return (this.mBooleans & flag) != 0L;
    }

    @VisibleForTesting
    public ParsingPackageImpl(String packageName, String baseApkPath, String path, TypedArray manifestArray) {
        this.packageName = TextUtils.safeIntern(packageName);
        this.mBaseApkPath = baseApkPath;
        this.mPath = path;
        if (manifestArray != null) {
            this.versionCode = manifestArray.getInteger(1, 0);
            this.versionCodeMajor = manifestArray.getInteger(11, 0);
            this.setBaseRevisionCode(manifestArray.getInteger(5, 0));
            this.setVersionName(manifestArray.getNonConfigurationString(2, 0));
            this.setCompileSdkVersion(manifestArray.getInteger(9, 0));
            this.setCompileSdkVersionCodename(manifestArray.getNonConfigurationString(10, 0));
            this.setIsolatedSplitLoading(manifestArray.getBoolean(6, false));
        }
    }

    @Override
    public boolean isSupportsSmallScreens() {
        if (this.supportsSmallScreens == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.supportsSmallScreens;
    }

    @Override
    public boolean isSupportsNormalScreens() {
        return this.supportsNormalScreens == null || this.supportsNormalScreens != false;
    }

    @Override
    public boolean isSupportsLargeScreens() {
        if (this.supportsLargeScreens == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.supportsLargeScreens;
    }

    @Override
    public boolean isSupportsExtraLargeScreens() {
        if (this.supportsExtraLargeScreens == null) {
            return this.targetSdkVersion >= 9;
        }
        return this.supportsExtraLargeScreens;
    }

    @Override
    public boolean isResizeable() {
        if (this.resizeable == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.resizeable;
    }

    @Override
    public boolean isAnyDensity() {
        if (this.anyDensity == null) {
            return this.targetSdkVersion >= 4;
        }
        return this.anyDensity;
    }

    @Override
    public ParsingPackageImpl sortActivities() {
        Collections.sort(this.activities, ORDER_COMPARATOR);
        return this;
    }

    @Override
    public ParsingPackageImpl sortReceivers() {
        Collections.sort(this.receivers, ORDER_COMPARATOR);
        return this;
    }

    @Override
    public ParsingPackageImpl sortServices() {
        Collections.sort(this.services, ORDER_COMPARATOR);
        return this;
    }

    @Override
    public Object hideAsParsed() {
        this.assignDerivedFields();
        return this;
    }

    private void assignDerivedFields() {
        this.mStorageUuid = StorageManager.convert(this.volumeUuid);
        this.mLongVersionCode = PackageInfo.composeLongVersionCode(this.versionCodeMajor, this.versionCode);
    }

    @Override
    public ParsingPackageImpl addConfigPreference(ConfigurationInfo configPreference) {
        this.configPreferences = CollectionUtils.add(this.configPreferences, configPreference);
        return this;
    }

    @Override
    public ParsingPackageImpl addReqFeature(FeatureInfo reqFeature) {
        this.reqFeatures = CollectionUtils.add(this.reqFeatures, reqFeature);
        return this;
    }

    @Override
    public ParsingPackageImpl addFeatureGroup(FeatureGroupInfo featureGroup) {
        this.featureGroups = CollectionUtils.add(this.featureGroups, featureGroup);
        return this;
    }

    @Override
    public ParsingPackageImpl addProperty(PackageManager.Property property) {
        if (property == null) {
            return this;
        }
        this.mProperties = CollectionUtils.add(this.mProperties, property.getName(), property);
        return this;
    }

    @Override
    public ParsingPackageImpl addProtectedBroadcast(String protectedBroadcast) {
        if (!this.protectedBroadcasts.contains(protectedBroadcast)) {
            this.protectedBroadcasts = CollectionUtils.add(this.protectedBroadcasts, TextUtils.safeIntern(protectedBroadcast));
        }
        return this;
    }

    @Override
    public ParsingPackageImpl addInstrumentation(ParsedInstrumentation instrumentation) {
        this.instrumentations = CollectionUtils.add(this.instrumentations, instrumentation);
        return this;
    }

    @Override
    public ParsingPackageImpl addOriginalPackage(String originalPackage) {
        this.originalPackages = CollectionUtils.add(this.originalPackages, originalPackage);
        return this;
    }

    @Override
    public ParsingPackage addOverlayable(String overlayableName, String actorName) {
        this.overlayables = CollectionUtils.add(this.overlayables, overlayableName, TextUtils.safeIntern(actorName));
        return this;
    }

    @Override
    public ParsingPackageImpl addAdoptPermission(String adoptPermission) {
        this.adoptPermissions = CollectionUtils.add(this.adoptPermissions, TextUtils.safeIntern(adoptPermission));
        return this;
    }

    @Override
    public ParsingPackageImpl addPermission(ParsedPermission permission2) {
        this.permissions = CollectionUtils.add(this.permissions, permission2);
        return this;
    }

    @Override
    public ParsingPackageImpl addPermissionGroup(ParsedPermissionGroup permissionGroup) {
        this.permissionGroups = CollectionUtils.add(this.permissionGroups, permissionGroup);
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesPermission(ParsedUsesPermission permission2) {
        this.usesPermissions = CollectionUtils.add(this.usesPermissions, permission2);
        this.requestedPermissions = CollectionUtils.add(this.requestedPermissions, permission2.name);
        return this;
    }

    @Override
    public ParsingPackageImpl addImplicitPermission(String permission2) {
        this.implicitPermissions = CollectionUtils.add(this.implicitPermissions, TextUtils.safeIntern(permission2));
        return this;
    }

    @Override
    public ParsingPackageImpl addKeySet(String keySetName, PublicKey publicKey) {
        ArraySet<PublicKey> publicKeys = this.keySetMapping.get(keySetName);
        if (publicKeys == null) {
            publicKeys = new ArraySet();
        }
        publicKeys.add(publicKey);
        this.keySetMapping = CollectionUtils.add(this.keySetMapping, keySetName, publicKeys);
        return this;
    }

    @Override
    public ParsingPackageImpl addActivity(ParsedActivity parsedActivity) {
        this.activities = CollectionUtils.add(this.activities, parsedActivity);
        this.addMimeGroupsFromComponent(parsedActivity);
        return this;
    }

    @Override
    public ParsingPackageImpl addReceiver(ParsedActivity parsedReceiver) {
        this.receivers = CollectionUtils.add(this.receivers, parsedReceiver);
        this.addMimeGroupsFromComponent(parsedReceiver);
        return this;
    }

    @Override
    public ParsingPackageImpl addService(ParsedService parsedService) {
        this.services = CollectionUtils.add(this.services, parsedService);
        this.addMimeGroupsFromComponent(parsedService);
        return this;
    }

    @Override
    public ParsingPackageImpl addProvider(ParsedProvider parsedProvider) {
        this.providers = CollectionUtils.add(this.providers, parsedProvider);
        this.addMimeGroupsFromComponent(parsedProvider);
        return this;
    }

    @Override
    public ParsingPackageImpl addAttribution(ParsedAttribution attribution) {
        this.attributions = CollectionUtils.add(this.attributions, attribution);
        return this;
    }

    @Override
    public ParsingPackageImpl addLibraryName(String libraryName) {
        this.libraryNames = CollectionUtils.add(this.libraryNames, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesOptionalLibrary(String libraryName) {
        this.usesOptionalLibraries = CollectionUtils.add(this.usesOptionalLibraries, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesLibrary(String libraryName) {
        this.usesLibraries = CollectionUtils.add(this.usesLibraries, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl removeUsesOptionalLibrary(String libraryName) {
        this.usesOptionalLibraries = CollectionUtils.remove(this.usesOptionalLibraries, libraryName);
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesOptionalNativeLibrary(String libraryName) {
        this.usesOptionalNativeLibraries = CollectionUtils.add(this.usesOptionalNativeLibraries, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesNativeLibrary(String libraryName) {
        this.usesNativeLibraries = CollectionUtils.add(this.usesNativeLibraries, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl removeUsesOptionalNativeLibrary(String libraryName) {
        this.usesOptionalNativeLibraries = CollectionUtils.remove(this.usesOptionalNativeLibraries, libraryName);
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesStaticLibrary(String libraryName) {
        this.usesStaticLibraries = CollectionUtils.add(this.usesStaticLibraries, TextUtils.safeIntern(libraryName));
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesStaticLibraryVersion(long version) {
        this.usesStaticLibrariesVersions = ArrayUtils.appendLong(this.usesStaticLibrariesVersions, version, true);
        return this;
    }

    @Override
    public ParsingPackageImpl addUsesStaticLibraryCertDigests(String[] certSha256Digests) {
        this.usesStaticLibrariesCertDigests = ArrayUtils.appendElement(String[].class, this.usesStaticLibrariesCertDigests, certSha256Digests, true);
        return this;
    }

    @Override
    public ParsingPackageImpl addPreferredActivityFilter(String className, ParsedIntentInfo intentInfo) {
        this.preferredActivityFilters = CollectionUtils.add(this.preferredActivityFilters, Pair.create(className, intentInfo));
        return this;
    }

    @Override
    public ParsingPackageImpl addQueriesIntent(Intent intent) {
        this.queriesIntents = CollectionUtils.add(this.queriesIntents, intent);
        return this;
    }

    @Override
    public ParsingPackageImpl addQueriesPackage(String packageName) {
        this.queriesPackages = CollectionUtils.add(this.queriesPackages, TextUtils.safeIntern(packageName));
        return this;
    }

    @Override
    public ParsingPackageImpl addQueriesProvider(String authority) {
        this.queriesProviders = CollectionUtils.add(this.queriesProviders, authority);
        return this;
    }

    @Override
    public ParsingPackageImpl setSupportsSmallScreens(int supportsSmallScreens) {
        if (supportsSmallScreens == 1) {
            return this;
        }
        this.supportsSmallScreens = supportsSmallScreens < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl setSupportsNormalScreens(int supportsNormalScreens) {
        if (supportsNormalScreens == 1) {
            return this;
        }
        this.supportsNormalScreens = supportsNormalScreens < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl setSupportsLargeScreens(int supportsLargeScreens) {
        if (supportsLargeScreens == 1) {
            return this;
        }
        this.supportsLargeScreens = supportsLargeScreens < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl setSupportsExtraLargeScreens(int supportsExtraLargeScreens) {
        if (supportsExtraLargeScreens == 1) {
            return this;
        }
        this.supportsExtraLargeScreens = supportsExtraLargeScreens < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl setResizeable(int resizeable) {
        if (resizeable == 1) {
            return this;
        }
        this.resizeable = resizeable < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl setAnyDensity(int anyDensity) {
        if (anyDensity == 1) {
            return this;
        }
        this.anyDensity = anyDensity < 0;
        return this;
    }

    @Override
    public ParsingPackageImpl asSplit(String[] splitNames, String[] splitCodePaths, int[] splitRevisionCodes, SparseArray<int[]> splitDependencies) {
        this.splitNames = splitNames;
        this.splitCodePaths = splitCodePaths;
        this.splitRevisionCodes = splitRevisionCodes;
        this.splitDependencies = splitDependencies;
        int count = splitNames.length;
        this.splitFlags = new int[count];
        this.splitClassLoaderNames = new String[count];
        return this;
    }

    @Override
    public ParsingPackageImpl setSplitHasCode(int splitIndex, boolean splitHasCode) {
        this.splitFlags[splitIndex] = splitHasCode ? this.splitFlags[splitIndex] | 4 : this.splitFlags[splitIndex] & 0xFFFFFFFB;
        return this;
    }

    @Override
    public ParsingPackageImpl setSplitClassLoaderName(int splitIndex, String classLoaderName) {
        this.splitClassLoaderNames[splitIndex] = classLoaderName;
        return this;
    }

    @Override
    public ParsingPackageImpl setRequiredAccountType(String requiredAccountType) {
        this.requiredAccountType = TextUtils.nullIfEmpty(requiredAccountType);
        return this;
    }

    @Override
    public ParsingPackageImpl setOverlayTarget(String overlayTarget) {
        this.overlayTarget = TextUtils.safeIntern(overlayTarget);
        return this;
    }

    @Override
    public ParsingPackageImpl setVolumeUuid(String volumeUuid) {
        this.volumeUuid = TextUtils.safeIntern(volumeUuid);
        return this;
    }

    @Override
    public ParsingPackageImpl setStaticSharedLibName(String staticSharedLibName) {
        this.staticSharedLibName = TextUtils.safeIntern(staticSharedLibName);
        return this;
    }

    @Override
    public ParsingPackageImpl setSharedUserId(String sharedUserId) {
        this.sharedUserId = TextUtils.safeIntern(sharedUserId);
        return this;
    }

    @Override
    public ParsingPackageImpl setNonLocalizedLabel(CharSequence value) {
        this.nonLocalizedLabel = value == null ? null : value.toString().trim();
        return this;
    }

    @Override
    public String getProcessName() {
        return this.processName != null ? this.processName : this.packageName;
    }

    public String toString() {
        return "Package{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    @Override
    @Deprecated
    public ApplicationInfo toAppInfoWithoutState() {
        ApplicationInfo appInfo = this.toAppInfoWithoutStateWithoutFlags();
        appInfo.flags = PackageInfoWithoutStateUtils.appInfoFlags(this);
        appInfo.privateFlags = PackageInfoWithoutStateUtils.appInfoPrivateFlags(this);
        appInfo.privateFlagsExt = PackageInfoWithoutStateUtils.appInfoPrivateFlagsExt(this);
        return appInfo;
    }

    @Override
    public ApplicationInfo toAppInfoWithoutStateWithoutFlags() {
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.appComponentFactory = this.appComponentFactory;
        appInfo.backupAgentName = this.backupAgentName;
        appInfo.banner = this.banner;
        appInfo.category = this.category;
        appInfo.classLoaderName = this.classLoaderName;
        appInfo.className = this.className;
        appInfo.compatibleWidthLimitDp = this.compatibleWidthLimitDp;
        appInfo.compileSdkVersion = this.compileSdkVersion;
        appInfo.compileSdkVersionCodename = this.compileSdkVersionCodeName;
        appInfo.crossProfile = this.isCrossProfile();
        appInfo.descriptionRes = this.descriptionRes;
        appInfo.enabled = this.getBoolean(0x100000000000L);
        appInfo.fullBackupContent = this.fullBackupContent;
        appInfo.dataExtractionRulesRes = this.dataExtractionRules;
        appInfo.icon = ParsingPackageUtils.sUseRoundIcon && this.roundIconRes != 0 ? this.roundIconRes : this.iconRes;
        appInfo.iconRes = this.iconRes;
        appInfo.roundIconRes = this.roundIconRes;
        appInfo.installLocation = this.installLocation;
        appInfo.labelRes = this.labelRes;
        appInfo.largestWidthLimitDp = this.largestWidthLimitDp;
        appInfo.logo = this.logo;
        appInfo.manageSpaceActivityName = this.manageSpaceActivityName;
        appInfo.maxAspectRatio = this.maxAspectRatio;
        appInfo.metaData = this.metaData;
        appInfo.minAspectRatio = this.minAspectRatio;
        appInfo.minSdkVersion = this.minSdkVersion;
        appInfo.name = this.className;
        appInfo.networkSecurityConfigRes = this.networkSecurityConfigRes;
        appInfo.nonLocalizedLabel = this.nonLocalizedLabel;
        appInfo.packageName = this.packageName;
        appInfo.permission = this.permission;
        appInfo.processName = this.getProcessName();
        appInfo.requiresSmallestWidthDp = this.requiresSmallestWidthDp;
        appInfo.splitClassLoaderNames = this.splitClassLoaderNames;
        appInfo.splitDependencies = this.splitDependencies;
        appInfo.splitNames = this.splitNames;
        appInfo.storageUuid = this.mStorageUuid;
        appInfo.targetSandboxVersion = this.targetSandboxVersion;
        appInfo.targetSdkVersion = this.targetSdkVersion;
        appInfo.taskAffinity = this.taskAffinity;
        appInfo.theme = this.theme;
        appInfo.uiOptions = this.uiOptions;
        appInfo.volumeUuid = this.volumeUuid;
        appInfo.zygotePreloadName = this.zygotePreloadName;
        appInfo.setGwpAsanMode(this.gwpAsanMode);
        appInfo.setMemtagMode(this.memtagMode);
        appInfo.setNativeHeapZeroInitialized(this.nativeHeapZeroInitialized);
        appInfo.setRequestRawExternalStorageAccess(this.requestRawExternalStorageAccess);
        appInfo.setBaseCodePath(this.mBaseApkPath);
        appInfo.setBaseResourcePath(this.mBaseApkPath);
        appInfo.setCodePath(this.mPath);
        appInfo.setResourcePath(this.mPath);
        appInfo.setSplitCodePaths(this.splitCodePaths);
        appInfo.setSplitResourcePaths(this.splitCodePaths);
        appInfo.setVersionCode(this.mLongVersionCode);
        return appInfo;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        sForBoolean.parcel(this.supportsSmallScreens, dest, flags);
        sForBoolean.parcel(this.supportsNormalScreens, dest, flags);
        sForBoolean.parcel(this.supportsLargeScreens, dest, flags);
        sForBoolean.parcel(this.supportsExtraLargeScreens, dest, flags);
        sForBoolean.parcel(this.resizeable, dest, flags);
        sForBoolean.parcel(this.anyDensity, dest, flags);
        dest.writeInt(this.versionCode);
        dest.writeInt(this.versionCodeMajor);
        dest.writeInt(this.baseRevisionCode);
        sForInternedString.parcel(this.versionName, dest, flags);
        dest.writeInt(this.compileSdkVersion);
        dest.writeString(this.compileSdkVersionCodeName);
        sForInternedString.parcel(this.packageName, dest, flags);
        dest.writeString(this.realPackage);
        dest.writeString(this.mBaseApkPath);
        dest.writeString(this.restrictedAccountType);
        dest.writeString(this.requiredAccountType);
        sForInternedString.parcel(this.overlayTarget, dest, flags);
        dest.writeString(this.overlayTargetName);
        dest.writeString(this.overlayCategory);
        dest.writeInt(this.overlayPriority);
        sForInternedStringValueMap.parcel(this.overlayables, dest, flags);
        sForInternedString.parcel(this.staticSharedLibName, dest, flags);
        dest.writeLong(this.staticSharedLibVersion);
        sForInternedStringList.parcel(this.libraryNames, dest, flags);
        sForInternedStringList.parcel(this.usesLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesOptionalLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesNativeLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesOptionalNativeLibraries, dest, flags);
        sForInternedStringList.parcel(this.usesStaticLibraries, dest, flags);
        dest.writeLongArray(this.usesStaticLibrariesVersions);
        if (this.usesStaticLibrariesCertDigests == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.usesStaticLibrariesCertDigests.length);
            for (int index = 0; index < this.usesStaticLibrariesCertDigests.length; ++index) {
                dest.writeStringArray(this.usesStaticLibrariesCertDigests[index]);
            }
        }
        sForInternedString.parcel(this.sharedUserId, dest, flags);
        dest.writeInt(this.sharedUserLabel);
        dest.writeTypedList(this.configPreferences);
        dest.writeTypedList(this.reqFeatures);
        dest.writeTypedList(this.featureGroups);
        dest.writeByteArray(this.restrictUpdateHash);
        dest.writeStringList(this.originalPackages);
        sForInternedStringList.parcel(this.adoptPermissions, dest, flags);
        sForInternedStringList.parcel(this.requestedPermissions, dest, flags);
        dest.writeTypedList(this.usesPermissions);
        sForInternedStringList.parcel(this.implicitPermissions, dest, flags);
        sForStringSet.parcel(this.upgradeKeySets, dest, flags);
        ParsingPackageUtils.writeKeySetMapping(dest, this.keySetMapping);
        sForInternedStringList.parcel(this.protectedBroadcasts, dest, flags);
        dest.writeTypedList(this.activities);
        dest.writeTypedList(this.receivers);
        dest.writeTypedList(this.services);
        dest.writeTypedList(this.providers);
        dest.writeTypedList(this.attributions);
        dest.writeTypedList(this.permissions);
        dest.writeTypedList(this.permissionGroups);
        dest.writeTypedList(this.instrumentations);
        sForIntentInfoPairs.parcel(this.preferredActivityFilters, dest, flags);
        dest.writeMap(this.processes);
        dest.writeBundle(this.metaData);
        sForInternedString.parcel(this.volumeUuid, dest, flags);
        dest.writeParcelable(this.signingDetails, flags);
        dest.writeString(this.mPath);
        dest.writeTypedList(this.queriesIntents, flags);
        sForInternedStringList.parcel(this.queriesPackages, dest, flags);
        sForInternedStringSet.parcel(this.queriesProviders, dest, flags);
        dest.writeString(this.appComponentFactory);
        dest.writeString(this.backupAgentName);
        dest.writeInt(this.banner);
        dest.writeInt(this.category);
        dest.writeString(this.classLoaderName);
        dest.writeString(this.className);
        dest.writeInt(this.compatibleWidthLimitDp);
        dest.writeInt(this.descriptionRes);
        dest.writeInt(this.fullBackupContent);
        dest.writeInt(this.dataExtractionRules);
        dest.writeInt(this.iconRes);
        dest.writeInt(this.installLocation);
        dest.writeInt(this.labelRes);
        dest.writeInt(this.largestWidthLimitDp);
        dest.writeInt(this.logo);
        dest.writeString(this.manageSpaceActivityName);
        dest.writeFloat(this.maxAspectRatio);
        dest.writeFloat(this.minAspectRatio);
        dest.writeInt(this.minSdkVersion);
        dest.writeInt(this.networkSecurityConfigRes);
        dest.writeCharSequence(this.nonLocalizedLabel);
        dest.writeString(this.permission);
        dest.writeString(this.processName);
        dest.writeInt(this.requiresSmallestWidthDp);
        dest.writeInt(this.roundIconRes);
        dest.writeInt(this.targetSandboxVersion);
        dest.writeInt(this.targetSdkVersion);
        dest.writeString(this.taskAffinity);
        dest.writeInt(this.theme);
        dest.writeInt(this.uiOptions);
        dest.writeString(this.zygotePreloadName);
        dest.writeStringArray(this.splitClassLoaderNames);
        dest.writeStringArray(this.splitCodePaths);
        dest.writeSparseArray(this.splitDependencies);
        dest.writeIntArray(this.splitFlags);
        dest.writeStringArray(this.splitNames);
        dest.writeIntArray(this.splitRevisionCodes);
        sForBoolean.parcel(this.resizeableActivity, dest, flags);
        dest.writeInt(this.autoRevokePermissions);
        dest.writeArraySet(this.mimeGroups);
        dest.writeInt(this.gwpAsanMode);
        dest.writeSparseIntArray(this.minExtensionVersions);
        dest.writeLong(this.mBooleans);
        dest.writeMap(this.mProperties);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
        sForBoolean.parcel(this.requestRawExternalStorageAccess, dest, flags);
    }

    public ParsingPackageImpl(Parcel in) {
        ClassLoader boot = Object.class.getClassLoader();
        this.supportsSmallScreens = sForBoolean.unparcel(in);
        this.supportsNormalScreens = sForBoolean.unparcel(in);
        this.supportsLargeScreens = sForBoolean.unparcel(in);
        this.supportsExtraLargeScreens = sForBoolean.unparcel(in);
        this.resizeable = sForBoolean.unparcel(in);
        this.anyDensity = sForBoolean.unparcel(in);
        this.versionCode = in.readInt();
        this.versionCodeMajor = in.readInt();
        this.baseRevisionCode = in.readInt();
        this.versionName = sForInternedString.unparcel(in);
        this.compileSdkVersion = in.readInt();
        this.compileSdkVersionCodeName = in.readString();
        this.packageName = sForInternedString.unparcel(in);
        this.realPackage = in.readString();
        this.mBaseApkPath = in.readString();
        this.restrictedAccountType = in.readString();
        this.requiredAccountType = in.readString();
        this.overlayTarget = sForInternedString.unparcel(in);
        this.overlayTargetName = in.readString();
        this.overlayCategory = in.readString();
        this.overlayPriority = in.readInt();
        this.overlayables = sForInternedStringValueMap.unparcel(in);
        this.staticSharedLibName = sForInternedString.unparcel(in);
        this.staticSharedLibVersion = in.readLong();
        this.libraryNames = sForInternedStringList.unparcel(in);
        this.usesLibraries = sForInternedStringList.unparcel(in);
        this.usesOptionalLibraries = sForInternedStringList.unparcel(in);
        this.usesNativeLibraries = sForInternedStringList.unparcel(in);
        this.usesOptionalNativeLibraries = sForInternedStringList.unparcel(in);
        this.usesStaticLibraries = sForInternedStringList.unparcel(in);
        this.usesStaticLibrariesVersions = in.createLongArray();
        int digestsSize = in.readInt();
        if (digestsSize >= 0) {
            this.usesStaticLibrariesCertDigests = new String[digestsSize][];
            for (int index = 0; index < digestsSize; ++index) {
                this.usesStaticLibrariesCertDigests[index] = sForInternedStringArray.unparcel(in);
            }
        }
        this.sharedUserId = sForInternedString.unparcel(in);
        this.sharedUserLabel = in.readInt();
        this.configPreferences = in.createTypedArrayList(ConfigurationInfo.CREATOR);
        this.reqFeatures = in.createTypedArrayList(FeatureInfo.CREATOR);
        this.featureGroups = in.createTypedArrayList(FeatureGroupInfo.CREATOR);
        this.restrictUpdateHash = in.createByteArray();
        this.originalPackages = in.createStringArrayList();
        this.adoptPermissions = sForInternedStringList.unparcel(in);
        this.requestedPermissions = sForInternedStringList.unparcel(in);
        this.usesPermissions = in.createTypedArrayList(ParsedUsesPermission.CREATOR);
        this.implicitPermissions = sForInternedStringList.unparcel(in);
        this.upgradeKeySets = sForStringSet.unparcel(in);
        this.keySetMapping = ParsingPackageUtils.readKeySetMapping(in);
        this.protectedBroadcasts = sForInternedStringList.unparcel(in);
        this.activities = in.createTypedArrayList(ParsedActivity.CREATOR);
        this.receivers = in.createTypedArrayList(ParsedActivity.CREATOR);
        this.services = in.createTypedArrayList(ParsedService.CREATOR);
        this.providers = in.createTypedArrayList(ParsedProvider.CREATOR);
        this.attributions = in.createTypedArrayList(ParsedAttribution.CREATOR);
        this.permissions = in.createTypedArrayList(ParsedPermission.CREATOR);
        this.permissionGroups = in.createTypedArrayList(ParsedPermissionGroup.CREATOR);
        this.instrumentations = in.createTypedArrayList(ParsedInstrumentation.CREATOR);
        this.preferredActivityFilters = sForIntentInfoPairs.unparcel(in);
        this.processes = in.readHashMap(boot);
        this.metaData = in.readBundle(boot);
        this.volumeUuid = sForInternedString.unparcel(in);
        this.signingDetails = (PackageParser.SigningDetails)in.readParcelable(boot);
        this.mPath = in.readString();
        this.queriesIntents = in.createTypedArrayList(Intent.CREATOR);
        this.queriesPackages = sForInternedStringList.unparcel(in);
        this.queriesProviders = sForInternedStringSet.unparcel(in);
        this.appComponentFactory = in.readString();
        this.backupAgentName = in.readString();
        this.banner = in.readInt();
        this.category = in.readInt();
        this.classLoaderName = in.readString();
        this.className = in.readString();
        this.compatibleWidthLimitDp = in.readInt();
        this.descriptionRes = in.readInt();
        this.fullBackupContent = in.readInt();
        this.dataExtractionRules = in.readInt();
        this.iconRes = in.readInt();
        this.installLocation = in.readInt();
        this.labelRes = in.readInt();
        this.largestWidthLimitDp = in.readInt();
        this.logo = in.readInt();
        this.manageSpaceActivityName = in.readString();
        this.maxAspectRatio = in.readFloat();
        this.minAspectRatio = in.readFloat();
        this.minSdkVersion = in.readInt();
        this.networkSecurityConfigRes = in.readInt();
        this.nonLocalizedLabel = in.readCharSequence();
        this.permission = in.readString();
        this.processName = in.readString();
        this.requiresSmallestWidthDp = in.readInt();
        this.roundIconRes = in.readInt();
        this.targetSandboxVersion = in.readInt();
        this.targetSdkVersion = in.readInt();
        this.taskAffinity = in.readString();
        this.theme = in.readInt();
        this.uiOptions = in.readInt();
        this.zygotePreloadName = in.readString();
        this.splitClassLoaderNames = in.createStringArray();
        this.splitCodePaths = in.createStringArray();
        this.splitDependencies = in.readSparseArray(boot);
        this.splitFlags = in.createIntArray();
        this.splitNames = in.createStringArray();
        this.splitRevisionCodes = in.createIntArray();
        this.resizeableActivity = sForBoolean.unparcel(in);
        this.autoRevokePermissions = in.readInt();
        this.mimeGroups = in.readArraySet(boot);
        this.gwpAsanMode = in.readInt();
        this.minExtensionVersions = in.readSparseIntArray();
        this.mBooleans = in.readLong();
        this.mProperties = in.readHashMap(boot);
        this.memtagMode = in.readInt();
        this.nativeHeapZeroInitialized = in.readInt();
        this.requestRawExternalStorageAccess = sForBoolean.unparcel(in);
        this.assignDerivedFields();
    }

    @Override
    public int getVersionCode() {
        return this.versionCode;
    }

    @Override
    public int getVersionCodeMajor() {
        return this.versionCodeMajor;
    }

    @Override
    public int getBaseRevisionCode() {
        return this.baseRevisionCode;
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public int getCompileSdkVersion() {
        return this.compileSdkVersion;
    }

    @Override
    public String getCompileSdkVersionCodeName() {
        return this.compileSdkVersionCodeName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getRealPackage() {
        return this.realPackage;
    }

    @Override
    public String getBaseApkPath() {
        return this.mBaseApkPath;
    }

    @Override
    public boolean isRequiredForAllUsers() {
        return this.getBoolean(0x4000000000L);
    }

    @Override
    public String getRestrictedAccountType() {
        return this.restrictedAccountType;
    }

    @Override
    public String getRequiredAccountType() {
        return this.requiredAccountType;
    }

    @Override
    public String getOverlayTarget() {
        return this.overlayTarget;
    }

    @Override
    public String getOverlayTargetName() {
        return this.overlayTargetName;
    }

    @Override
    public String getOverlayCategory() {
        return this.overlayCategory;
    }

    @Override
    public int getOverlayPriority() {
        return this.overlayPriority;
    }

    @Override
    public boolean isOverlayIsStatic() {
        return this.getBoolean(0x8000000000L);
    }

    @Override
    public Map<String, String> getOverlayables() {
        return this.overlayables;
    }

    @Override
    public String getStaticSharedLibName() {
        return this.staticSharedLibName;
    }

    @Override
    public long getStaticSharedLibVersion() {
        return this.staticSharedLibVersion;
    }

    @Override
    public List<String> getLibraryNames() {
        return this.libraryNames;
    }

    @Override
    public List<String> getUsesLibraries() {
        return this.usesLibraries;
    }

    @Override
    public List<String> getUsesOptionalLibraries() {
        return this.usesOptionalLibraries;
    }

    @Override
    public List<String> getUsesNativeLibraries() {
        return this.usesNativeLibraries;
    }

    @Override
    public List<String> getUsesOptionalNativeLibraries() {
        return this.usesOptionalNativeLibraries;
    }

    @Override
    public List<String> getUsesStaticLibraries() {
        return this.usesStaticLibraries;
    }

    @Override
    public long[] getUsesStaticLibrariesVersions() {
        return this.usesStaticLibrariesVersions;
    }

    @Override
    public String[][] getUsesStaticLibrariesCertDigests() {
        return this.usesStaticLibrariesCertDigests;
    }

    @Override
    public String getSharedUserId() {
        return this.sharedUserId;
    }

    @Override
    public int getSharedUserLabel() {
        return this.sharedUserLabel;
    }

    @Override
    public List<ConfigurationInfo> getConfigPreferences() {
        return this.configPreferences;
    }

    @Override
    public List<FeatureInfo> getReqFeatures() {
        return this.reqFeatures;
    }

    @Override
    public List<FeatureGroupInfo> getFeatureGroups() {
        return this.featureGroups;
    }

    @Override
    public byte[] getRestrictUpdateHash() {
        return this.restrictUpdateHash;
    }

    @Override
    public List<String> getOriginalPackages() {
        return this.originalPackages;
    }

    @Override
    public List<String> getAdoptPermissions() {
        return this.adoptPermissions;
    }

    @Override
    @Deprecated
    public List<String> getRequestedPermissions() {
        return this.requestedPermissions;
    }

    @Override
    public List<ParsedUsesPermission> getUsesPermissions() {
        return this.usesPermissions;
    }

    @Override
    public List<String> getImplicitPermissions() {
        return this.implicitPermissions;
    }

    @Override
    public Map<String, PackageManager.Property> getProperties() {
        return this.mProperties;
    }

    @Override
    public Set<String> getUpgradeKeySets() {
        return this.upgradeKeySets;
    }

    @Override
    public Map<String, ArraySet<PublicKey>> getKeySetMapping() {
        return this.keySetMapping;
    }

    @Override
    public List<String> getProtectedBroadcasts() {
        return this.protectedBroadcasts;
    }

    @Override
    public List<ParsedActivity> getActivities() {
        return this.activities;
    }

    @Override
    public List<ParsedActivity> getReceivers() {
        return this.receivers;
    }

    @Override
    public List<ParsedService> getServices() {
        return this.services;
    }

    @Override
    public List<ParsedProvider> getProviders() {
        return this.providers;
    }

    @Override
    public List<ParsedAttribution> getAttributions() {
        return this.attributions;
    }

    @Override
    public List<ParsedPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public List<ParsedPermissionGroup> getPermissionGroups() {
        return this.permissionGroups;
    }

    @Override
    public List<ParsedInstrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    @Override
    public List<Pair<String, ParsedIntentInfo>> getPreferredActivityFilters() {
        return this.preferredActivityFilters;
    }

    @Override
    public Map<String, ParsedProcess> getProcesses() {
        return this.processes;
    }

    @Override
    public Bundle getMetaData() {
        return this.metaData;
    }

    private void addMimeGroupsFromComponent(ParsedComponent component) {
        for (int i = component.getIntents().size() - 1; i >= 0; --i) {
            IntentFilter filter = component.getIntents().get(i);
            for (int groupIndex = filter.countMimeGroups() - 1; groupIndex >= 0; --groupIndex) {
                this.mimeGroups = ArrayUtils.add(this.mimeGroups, filter.getMimeGroup(groupIndex));
            }
        }
    }

    @Override
    public Set<String> getMimeGroups() {
        return this.mimeGroups;
    }

    @Override
    public String getVolumeUuid() {
        return this.volumeUuid;
    }

    @Override
    public PackageParser.SigningDetails getSigningDetails() {
        return this.signingDetails;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public boolean isUse32BitAbi() {
        return this.getBoolean(0x10000000000L);
    }

    @Override
    public boolean isVisibleToInstantApps() {
        return this.getBoolean(0x20000000000L);
    }

    @Override
    public boolean isForceQueryable() {
        return this.getBoolean(0x40000000000L);
    }

    @Override
    public List<Intent> getQueriesIntents() {
        return this.queriesIntents;
    }

    @Override
    public List<String> getQueriesPackages() {
        return this.queriesPackages;
    }

    @Override
    public Set<String> getQueriesProviders() {
        return this.queriesProviders;
    }

    @Override
    public String[] getSplitClassLoaderNames() {
        return this.splitClassLoaderNames;
    }

    @Override
    public String[] getSplitCodePaths() {
        return this.splitCodePaths;
    }

    @Override
    public SparseArray<int[]> getSplitDependencies() {
        return this.splitDependencies;
    }

    @Override
    public int[] getSplitFlags() {
        return this.splitFlags;
    }

    @Override
    public String[] getSplitNames() {
        return this.splitNames;
    }

    @Override
    public int[] getSplitRevisionCodes() {
        return this.splitRevisionCodes;
    }

    @Override
    public String getAppComponentFactory() {
        return this.appComponentFactory;
    }

    @Override
    public String getBackupAgentName() {
        return this.backupAgentName;
    }

    @Override
    public int getBanner() {
        return this.banner;
    }

    @Override
    public int getCategory() {
        return this.category;
    }

    @Override
    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int getCompatibleWidthLimitDp() {
        return this.compatibleWidthLimitDp;
    }

    @Override
    public int getDescriptionRes() {
        return this.descriptionRes;
    }

    @Override
    public boolean isEnabled() {
        return this.getBoolean(0x100000000000L);
    }

    @Override
    public boolean isCrossProfile() {
        return this.getBoolean(0x80000000000L);
    }

    @Override
    public int getFullBackupContent() {
        return this.fullBackupContent;
    }

    @Override
    public int getDataExtractionRules() {
        return this.dataExtractionRules;
    }

    @Override
    public int getIconRes() {
        return this.iconRes;
    }

    @Override
    public int getInstallLocation() {
        return this.installLocation;
    }

    @Override
    public int getLabelRes() {
        return this.labelRes;
    }

    @Override
    public int getLargestWidthLimitDp() {
        return this.largestWidthLimitDp;
    }

    @Override
    public int getLogo() {
        return this.logo;
    }

    @Override
    public String getManageSpaceActivityName() {
        return this.manageSpaceActivityName;
    }

    @Override
    public float getMaxAspectRatio() {
        return this.maxAspectRatio;
    }

    @Override
    public float getMinAspectRatio() {
        return this.minAspectRatio;
    }

    @Override
    public SparseIntArray getMinExtensionVersions() {
        return this.minExtensionVersions;
    }

    @Override
    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @Override
    public int getNetworkSecurityConfigRes() {
        return this.networkSecurityConfigRes;
    }

    @Override
    public CharSequence getNonLocalizedLabel() {
        return this.nonLocalizedLabel;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public int getRequiresSmallestWidthDp() {
        return this.requiresSmallestWidthDp;
    }

    @Override
    public int getRoundIconRes() {
        return this.roundIconRes;
    }

    @Override
    public int getTargetSandboxVersion() {
        return this.targetSandboxVersion;
    }

    @Override
    public int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    @Override
    public String getTaskAffinity() {
        return this.taskAffinity;
    }

    @Override
    public int getTheme() {
        return this.theme;
    }

    @Override
    public int getUiOptions() {
        return this.uiOptions;
    }

    @Override
    public String getZygotePreloadName() {
        return this.zygotePreloadName;
    }

    @Override
    public boolean isExternalStorage() {
        return this.getBoolean(1L);
    }

    @Override
    public boolean isBaseHardwareAccelerated() {
        return this.getBoolean(2L);
    }

    @Override
    public boolean isAllowBackup() {
        return this.getBoolean(4L);
    }

    @Override
    public boolean isKillAfterRestore() {
        return this.getBoolean(8L);
    }

    @Override
    public boolean isRestoreAnyVersion() {
        return this.getBoolean(16L);
    }

    @Override
    public boolean isFullBackupOnly() {
        return this.getBoolean(32L);
    }

    @Override
    public boolean isPersistent() {
        return this.getBoolean(64L);
    }

    @Override
    public boolean isDebuggable() {
        return this.getBoolean(128L);
    }

    @Override
    public boolean isVmSafeMode() {
        return this.getBoolean(256L);
    }

    @Override
    public boolean isHasCode() {
        return this.getBoolean(512L);
    }

    @Override
    public boolean isAllowTaskReparenting() {
        return this.getBoolean(1024L);
    }

    @Override
    public boolean isAllowClearUserData() {
        return this.getBoolean(2048L);
    }

    @Override
    public boolean isLargeHeap() {
        return this.getBoolean(4096L);
    }

    @Override
    public boolean isUsesCleartextTraffic() {
        return this.getBoolean(8192L);
    }

    @Override
    public boolean isSupportsRtl() {
        return this.getBoolean(16384L);
    }

    @Override
    public boolean isTestOnly() {
        return this.getBoolean(32768L);
    }

    @Override
    public boolean isMultiArch() {
        return this.getBoolean(65536L);
    }

    @Override
    public boolean isExtractNativeLibs() {
        return this.getBoolean(131072L);
    }

    @Override
    public boolean isGame() {
        return this.getBoolean(262144L);
    }

    @Override
    public Boolean getResizeableActivity() {
        return this.resizeableActivity;
    }

    @Override
    public boolean isStaticSharedLibrary() {
        return this.getBoolean(524288L);
    }

    @Override
    public boolean isOverlay() {
        return this.getBoolean(0x100000L);
    }

    @Override
    public boolean isIsolatedSplitLoading() {
        return this.getBoolean(0x200000L);
    }

    @Override
    public boolean isHasDomainUrls() {
        return this.getBoolean(0x400000L);
    }

    @Override
    public boolean isProfileableByShell() {
        return this.isProfileable() && this.getBoolean(0x800000L);
    }

    @Override
    public boolean isProfileable() {
        return !this.getBoolean(0x200000000000L);
    }

    @Override
    public boolean isBackupInForeground() {
        return this.getBoolean(0x1000000L);
    }

    @Override
    public boolean isUseEmbeddedDex() {
        return this.getBoolean(0x2000000L);
    }

    @Override
    public boolean isDefaultToDeviceProtectedStorage() {
        return this.getBoolean(0x4000000L);
    }

    @Override
    public boolean isDirectBootAware() {
        return this.getBoolean(0x8000000L);
    }

    @Override
    public int getGwpAsanMode() {
        return this.gwpAsanMode;
    }

    @Override
    public int getMemtagMode() {
        return this.memtagMode;
    }

    @Override
    public int getNativeHeapZeroInitialized() {
        return this.nativeHeapZeroInitialized;
    }

    @Override
    public Boolean hasRequestRawExternalStorageAccess() {
        return this.requestRawExternalStorageAccess;
    }

    @Override
    public boolean isPartiallyDirectBootAware() {
        return this.getBoolean(0x10000000L);
    }

    @Override
    public boolean isResizeableActivityViaSdkVersion() {
        return this.getBoolean(0x20000000L);
    }

    @Override
    public boolean isAllowClearUserDataOnFailedRestore() {
        return this.getBoolean(0x40000000L);
    }

    @Override
    public boolean isAllowAudioPlaybackCapture() {
        return this.getBoolean(0x80000000L);
    }

    @Override
    public boolean isRequestLegacyExternalStorage() {
        return this.getBoolean(0x100000000L);
    }

    @Override
    public boolean isUsesNonSdkApi() {
        return this.getBoolean(0x200000000L);
    }

    @Override
    public boolean isHasFragileUserData() {
        return this.getBoolean(0x400000000L);
    }

    @Override
    public boolean isCantSaveState() {
        return this.getBoolean(0x800000000L);
    }

    @Override
    public boolean isAllowNativeHeapPointerTagging() {
        return this.getBoolean(0x1000000000L);
    }

    @Override
    public int getAutoRevokePermissions() {
        return this.autoRevokePermissions;
    }

    @Override
    public boolean hasPreserveLegacyExternalStorage() {
        return this.getBoolean(0x2000000000L);
    }

    @Override
    public boolean hasRequestForegroundServiceExemption() {
        return this.getBoolean(0x400000000000L);
    }

    @Override
    public boolean areAttributionsUserVisible() {
        return this.getBoolean(0x800000000000L);
    }

    @Override
    public ParsingPackageImpl setBaseRevisionCode(int value) {
        this.baseRevisionCode = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setCompileSdkVersion(int value) {
        this.compileSdkVersion = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRequiredForAllUsers(boolean value) {
        return this.setBoolean(0x4000000000L, value);
    }

    @Override
    public ParsingPackageImpl setOverlayPriority(int value) {
        this.overlayPriority = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setOverlayIsStatic(boolean value) {
        return this.setBoolean(0x8000000000L, value);
    }

    @Override
    public ParsingPackageImpl setStaticSharedLibVersion(long value) {
        this.staticSharedLibVersion = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setSharedUserLabel(int value) {
        this.sharedUserLabel = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRestrictUpdateHash(byte ... value) {
        this.restrictUpdateHash = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setUpgradeKeySets(Set<String> value) {
        this.upgradeKeySets = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setProcesses(Map<String, ParsedProcess> value) {
        this.processes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMetaData(Bundle value) {
        this.metaData = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setSigningDetails(PackageParser.SigningDetails value) {
        this.signingDetails = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setUse32BitAbi(boolean value) {
        return this.setBoolean(0x10000000000L, value);
    }

    @Override
    public ParsingPackageImpl setVisibleToInstantApps(boolean value) {
        return this.setBoolean(0x20000000000L, value);
    }

    @Override
    public ParsingPackageImpl setForceQueryable(boolean value) {
        return this.setBoolean(0x40000000000L, value);
    }

    @Override
    public ParsingPackageImpl setBanner(int value) {
        this.banner = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setCategory(int value) {
        this.category = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setCompatibleWidthLimitDp(int value) {
        this.compatibleWidthLimitDp = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setDescriptionRes(int value) {
        this.descriptionRes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setEnabled(boolean value) {
        return this.setBoolean(0x100000000000L, value);
    }

    @Override
    public ParsingPackageImpl setCrossProfile(boolean value) {
        return this.setBoolean(0x80000000000L, value);
    }

    @Override
    public ParsingPackageImpl setFullBackupContent(int value) {
        this.fullBackupContent = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setDataExtractionRules(int value) {
        this.dataExtractionRules = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setIconRes(int value) {
        this.iconRes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setInstallLocation(int value) {
        this.installLocation = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setLabelRes(int value) {
        this.labelRes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setLargestWidthLimitDp(int value) {
        this.largestWidthLimitDp = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setLogo(int value) {
        this.logo = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMaxAspectRatio(float value) {
        this.maxAspectRatio = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMinAspectRatio(float value) {
        this.minAspectRatio = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMinExtensionVersions(SparseIntArray value) {
        this.minExtensionVersions = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMinSdkVersion(int value) {
        this.minSdkVersion = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setNetworkSecurityConfigRes(int value) {
        this.networkSecurityConfigRes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRequiresSmallestWidthDp(int value) {
        this.requiresSmallestWidthDp = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRoundIconRes(int value) {
        this.roundIconRes = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setTargetSandboxVersion(int value) {
        this.targetSandboxVersion = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setTargetSdkVersion(int value) {
        this.targetSdkVersion = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setTheme(int value) {
        this.theme = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRequestForegroundServiceExemption(boolean value) {
        return this.setBoolean(0x400000000000L, value);
    }

    @Override
    public ParsingPackageImpl setUiOptions(int value) {
        this.uiOptions = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setExternalStorage(boolean value) {
        return this.setBoolean(1L, value);
    }

    @Override
    public ParsingPackageImpl setBaseHardwareAccelerated(boolean value) {
        return this.setBoolean(2L, value);
    }

    @Override
    public ParsingPackageImpl setAllowBackup(boolean value) {
        return this.setBoolean(4L, value);
    }

    @Override
    public ParsingPackageImpl setKillAfterRestore(boolean value) {
        return this.setBoolean(8L, value);
    }

    @Override
    public ParsingPackageImpl setRestoreAnyVersion(boolean value) {
        return this.setBoolean(16L, value);
    }

    @Override
    public ParsingPackageImpl setFullBackupOnly(boolean value) {
        return this.setBoolean(32L, value);
    }

    @Override
    public ParsingPackageImpl setPersistent(boolean value) {
        return this.setBoolean(64L, value);
    }

    @Override
    public ParsingPackageImpl setDebuggable(boolean value) {
        return this.setBoolean(128L, value);
    }

    @Override
    public ParsingPackageImpl setVmSafeMode(boolean value) {
        return this.setBoolean(256L, value);
    }

    @Override
    public ParsingPackageImpl setHasCode(boolean value) {
        return this.setBoolean(512L, value);
    }

    @Override
    public ParsingPackageImpl setAllowTaskReparenting(boolean value) {
        return this.setBoolean(1024L, value);
    }

    @Override
    public ParsingPackageImpl setAllowClearUserData(boolean value) {
        return this.setBoolean(2048L, value);
    }

    @Override
    public ParsingPackageImpl setLargeHeap(boolean value) {
        return this.setBoolean(4096L, value);
    }

    @Override
    public ParsingPackageImpl setUsesCleartextTraffic(boolean value) {
        return this.setBoolean(8192L, value);
    }

    @Override
    public ParsingPackageImpl setSupportsRtl(boolean value) {
        return this.setBoolean(16384L, value);
    }

    @Override
    public ParsingPackageImpl setTestOnly(boolean value) {
        return this.setBoolean(32768L, value);
    }

    @Override
    public ParsingPackageImpl setMultiArch(boolean value) {
        return this.setBoolean(65536L, value);
    }

    @Override
    public ParsingPackageImpl setExtractNativeLibs(boolean value) {
        return this.setBoolean(131072L, value);
    }

    @Override
    public ParsingPackageImpl setGame(boolean value) {
        return this.setBoolean(262144L, value);
    }

    @Override
    public ParsingPackageImpl setResizeableActivity(Boolean value) {
        this.resizeableActivity = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setStaticSharedLibrary(boolean value) {
        return this.setBoolean(524288L, value);
    }

    @Override
    public ParsingPackageImpl setOverlay(boolean value) {
        return this.setBoolean(0x100000L, value);
    }

    @Override
    public ParsingPackageImpl setIsolatedSplitLoading(boolean value) {
        return this.setBoolean(0x200000L, value);
    }

    @Override
    public ParsingPackageImpl setHasDomainUrls(boolean value) {
        return this.setBoolean(0x400000L, value);
    }

    @Override
    public ParsingPackageImpl setProfileableByShell(boolean value) {
        return this.setBoolean(0x800000L, value);
    }

    @Override
    public ParsingPackageImpl setProfileable(boolean value) {
        return this.setBoolean(0x200000000000L, !value);
    }

    @Override
    public ParsingPackageImpl setBackupInForeground(boolean value) {
        return this.setBoolean(0x1000000L, value);
    }

    @Override
    public ParsingPackageImpl setUseEmbeddedDex(boolean value) {
        return this.setBoolean(0x2000000L, value);
    }

    @Override
    public ParsingPackageImpl setDefaultToDeviceProtectedStorage(boolean value) {
        return this.setBoolean(0x4000000L, value);
    }

    @Override
    public ParsingPackageImpl setDirectBootAware(boolean value) {
        return this.setBoolean(0x8000000L, value);
    }

    @Override
    public ParsingPackageImpl setGwpAsanMode(int value) {
        this.gwpAsanMode = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setMemtagMode(int value) {
        this.memtagMode = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setNativeHeapZeroInitialized(int value) {
        this.nativeHeapZeroInitialized = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setRequestRawExternalStorageAccess(Boolean value) {
        this.requestRawExternalStorageAccess = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setPartiallyDirectBootAware(boolean value) {
        return this.setBoolean(0x10000000L, value);
    }

    @Override
    public ParsingPackageImpl setResizeableActivityViaSdkVersion(boolean value) {
        return this.setBoolean(0x20000000L, value);
    }

    @Override
    public ParsingPackageImpl setAllowClearUserDataOnFailedRestore(boolean value) {
        return this.setBoolean(0x40000000L, value);
    }

    @Override
    public ParsingPackageImpl setAllowAudioPlaybackCapture(boolean value) {
        return this.setBoolean(0x80000000L, value);
    }

    @Override
    public ParsingPackageImpl setRequestLegacyExternalStorage(boolean value) {
        return this.setBoolean(0x100000000L, value);
    }

    @Override
    public ParsingPackageImpl setUsesNonSdkApi(boolean value) {
        return this.setBoolean(0x200000000L, value);
    }

    @Override
    public ParsingPackageImpl setHasFragileUserData(boolean value) {
        return this.setBoolean(0x400000000L, value);
    }

    @Override
    public ParsingPackageImpl setCantSaveState(boolean value) {
        return this.setBoolean(0x800000000L, value);
    }

    @Override
    public ParsingPackageImpl setAllowNativeHeapPointerTagging(boolean value) {
        return this.setBoolean(0x1000000000L, value);
    }

    @Override
    public ParsingPackageImpl setAutoRevokePermissions(int value) {
        this.autoRevokePermissions = value;
        return this;
    }

    @Override
    public ParsingPackageImpl setPreserveLegacyExternalStorage(boolean value) {
        return this.setBoolean(0x2000000000L, value);
    }

    @Override
    public ParsingPackageImpl setVersionName(String versionName) {
        this.versionName = versionName;
        return this;
    }

    @Override
    public ParsingPackage setCompileSdkVersionCodename(String compileSdkVersionCodename) {
        this.compileSdkVersionCodeName = compileSdkVersionCodename;
        return this;
    }

    @Override
    public ParsingPackageImpl setProcessName(String processName) {
        this.processName = processName;
        return this;
    }

    @Override
    public ParsingPackageImpl setRealPackage(String realPackage) {
        this.realPackage = realPackage;
        return this;
    }

    @Override
    public ParsingPackageImpl setRestrictedAccountType(String restrictedAccountType) {
        this.restrictedAccountType = restrictedAccountType;
        return this;
    }

    @Override
    public ParsingPackageImpl setOverlayTargetName(String overlayTargetName) {
        this.overlayTargetName = overlayTargetName;
        return this;
    }

    @Override
    public ParsingPackageImpl setOverlayCategory(String overlayCategory) {
        this.overlayCategory = overlayCategory;
        return this;
    }

    @Override
    public ParsingPackageImpl setAppComponentFactory(String appComponentFactory) {
        this.appComponentFactory = appComponentFactory;
        return this;
    }

    @Override
    public ParsingPackageImpl setBackupAgentName(String backupAgentName) {
        this.backupAgentName = backupAgentName;
        return this;
    }

    @Override
    public ParsingPackageImpl setClassLoaderName(String classLoaderName) {
        this.classLoaderName = classLoaderName;
        return this;
    }

    @Override
    public ParsingPackageImpl setClassName(String className) {
        this.className = className == null ? null : className.trim();
        return this;
    }

    @Override
    public ParsingPackageImpl setManageSpaceActivityName(String manageSpaceActivityName) {
        this.manageSpaceActivityName = manageSpaceActivityName;
        return this;
    }

    @Override
    public ParsingPackageImpl setPermission(String permission2) {
        this.permission = permission2;
        return this;
    }

    @Override
    public ParsingPackageImpl setTaskAffinity(String taskAffinity) {
        this.taskAffinity = taskAffinity;
        return this;
    }

    @Override
    public ParsingPackageImpl setZygotePreloadName(String zygotePreloadName) {
        this.zygotePreloadName = zygotePreloadName;
        return this;
    }

    @Override
    public ParsingPackage setAttributionsAreUserVisible(boolean attributionsAreUserVisible) {
        this.setBoolean(0x800000000000L, attributionsAreUserVisible);
        return this;
    }

    protected static class Booleans {
        private static final long EXTERNAL_STORAGE = 1L;
        private static final long BASE_HARDWARE_ACCELERATED = 2L;
        private static final long ALLOW_BACKUP = 4L;
        private static final long KILL_AFTER_RESTORE = 8L;
        private static final long RESTORE_ANY_VERSION = 16L;
        private static final long FULL_BACKUP_ONLY = 32L;
        private static final long PERSISTENT = 64L;
        private static final long DEBUGGABLE = 128L;
        private static final long VM_SAFE_MODE = 256L;
        private static final long HAS_CODE = 512L;
        private static final long ALLOW_TASK_REPARENTING = 1024L;
        private static final long ALLOW_CLEAR_USER_DATA = 2048L;
        private static final long LARGE_HEAP = 4096L;
        private static final long USES_CLEARTEXT_TRAFFIC = 8192L;
        private static final long SUPPORTS_RTL = 16384L;
        private static final long TEST_ONLY = 32768L;
        private static final long MULTI_ARCH = 65536L;
        private static final long EXTRACT_NATIVE_LIBS = 131072L;
        private static final long GAME = 262144L;
        private static final long STATIC_SHARED_LIBRARY = 524288L;
        private static final long OVERLAY = 0x100000L;
        private static final long ISOLATED_SPLIT_LOADING = 0x200000L;
        private static final long HAS_DOMAIN_URLS = 0x400000L;
        private static final long PROFILEABLE_BY_SHELL = 0x800000L;
        private static final long BACKUP_IN_FOREGROUND = 0x1000000L;
        private static final long USE_EMBEDDED_DEX = 0x2000000L;
        private static final long DEFAULT_TO_DEVICE_PROTECTED_STORAGE = 0x4000000L;
        private static final long DIRECT_BOOT_AWARE = 0x8000000L;
        private static final long PARTIALLY_DIRECT_BOOT_AWARE = 0x10000000L;
        private static final long RESIZEABLE_ACTIVITY_VIA_SDK_VERSION = 0x20000000L;
        private static final long ALLOW_CLEAR_USER_DATA_ON_FAILED_RESTORE = 0x40000000L;
        private static final long ALLOW_AUDIO_PLAYBACK_CAPTURE = 0x80000000L;
        private static final long REQUEST_LEGACY_EXTERNAL_STORAGE = 0x100000000L;
        private static final long USES_NON_SDK_API = 0x200000000L;
        private static final long HAS_FRAGILE_USER_DATA = 0x400000000L;
        private static final long CANT_SAVE_STATE = 0x800000000L;
        private static final long ALLOW_NATIVE_HEAP_POINTER_TAGGING = 0x1000000000L;
        private static final long PRESERVE_LEGACY_EXTERNAL_STORAGE = 0x2000000000L;
        private static final long REQUIRED_FOR_ALL_USERS = 0x4000000000L;
        private static final long OVERLAY_IS_STATIC = 0x8000000000L;
        private static final long USE_32_BIT_ABI = 0x10000000000L;
        private static final long VISIBLE_TO_INSTANT_APPS = 0x20000000000L;
        private static final long FORCE_QUERYABLE = 0x40000000000L;
        private static final long CROSS_PROFILE = 0x80000000000L;
        private static final long ENABLED = 0x100000000000L;
        private static final long DISALLOW_PROFILING = 0x200000000000L;
        private static final long REQUEST_FOREGROUND_SERVICE_EXEMPTION = 0x400000000000L;
        private static final long ATTRIBUTIONS_ARE_USER_VISIBLE = 0x800000000000L;

        protected Booleans() {
        }

        public static @interface Values {
        }
    }
}

