/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.RenderEffect;
import android.graphics.animation.RenderNodeAnimator;
import android.view.NativeVectorDrawableAnimator;
import com.android.internal.util.ArrayUtils;
import dalvik.annotation.optimization.CriticalNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.NativeAllocationRegistry;

public final class RenderNode {
    public final long mNativeRenderNode;
    private final AnimationHost mAnimationHost;
    private RecordingCanvas mCurrentRecordingCanvas;
    private CompositePositionUpdateListener mCompositePositionUpdateListener;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_BACKGROUND = 1;

    public RenderNode(String name) {
        this(name, null);
    }

    private RenderNode(String name, AnimationHost animationHost) {
        this.mNativeRenderNode = RenderNode.nCreate(name);
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeRenderNode);
        this.mAnimationHost = animationHost;
    }

    private RenderNode(long nativePtr) {
        this.mNativeRenderNode = nativePtr;
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeRenderNode);
        this.mAnimationHost = null;
    }

    public static RenderNode create(String name, AnimationHost animationHost) {
        return new RenderNode(name, animationHost);
    }

    public static RenderNode adopt(long nativePtr) {
        return new RenderNode(nativePtr);
    }

    public void addPositionUpdateListener(PositionUpdateListener listener) {
        CompositePositionUpdateListener comp = this.mCompositePositionUpdateListener;
        comp = comp == null ? new CompositePositionUpdateListener(listener) : comp.with(listener);
        this.mCompositePositionUpdateListener = comp;
        RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, comp);
    }

    public void removePositionUpdateListener(PositionUpdateListener listener) {
        CompositePositionUpdateListener comp = this.mCompositePositionUpdateListener;
        if (comp != null) {
            this.mCompositePositionUpdateListener = comp = comp.without(listener);
            RenderNode.nRequestPositionUpdates(this.mNativeRenderNode, comp);
        }
    }

    public RecordingCanvas beginRecording(int width, int height) {
        if (this.mCurrentRecordingCanvas != null) {
            throw new IllegalStateException("Recording currently in progress - missing #endRecording() call?");
        }
        this.mCurrentRecordingCanvas = RecordingCanvas.obtain(this, width, height);
        return this.mCurrentRecordingCanvas;
    }

    public RecordingCanvas beginRecording() {
        return this.beginRecording(RenderNode.nGetWidth(this.mNativeRenderNode), RenderNode.nGetHeight(this.mNativeRenderNode));
    }

    public void endRecording() {
        if (this.mCurrentRecordingCanvas == null) {
            throw new IllegalStateException("No recording in progress, forgot to call #beginRecording()?");
        }
        RecordingCanvas canvas = this.mCurrentRecordingCanvas;
        this.mCurrentRecordingCanvas = null;
        canvas.finishRecording(this);
        canvas.recycle();
    }

    @Deprecated
    public RecordingCanvas start(int width, int height) {
        return this.beginRecording(width, height);
    }

    @Deprecated
    public void end(RecordingCanvas canvas) {
        if (canvas != this.mCurrentRecordingCanvas) {
            throw new IllegalArgumentException("Wrong canvas");
        }
        this.endRecording();
    }

    public void discardDisplayList() {
        RenderNode.nDiscardDisplayList(this.mNativeRenderNode);
    }

    public boolean hasDisplayList() {
        return RenderNode.nIsValid(this.mNativeRenderNode);
    }

    public boolean hasIdentityMatrix() {
        return RenderNode.nHasIdentityMatrix(this.mNativeRenderNode);
    }

    public void getMatrix(Matrix outMatrix) {
        RenderNode.nGetTransformMatrix(this.mNativeRenderNode, outMatrix.ni());
    }

    public void getInverseMatrix(Matrix outMatrix) {
        RenderNode.nGetInverseTransformMatrix(this.mNativeRenderNode, outMatrix.ni());
    }

    @Deprecated
    public boolean setLayerType(int layerType) {
        return RenderNode.nSetLayerType(this.mNativeRenderNode, layerType);
    }

    @Deprecated
    public boolean setLayerPaint(Paint paint) {
        return RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean setUseCompositingLayer(boolean forceToLayer, Paint paint) {
        boolean didChange = RenderNode.nSetLayerType(this.mNativeRenderNode, forceToLayer ? 2 : 0);
        return didChange |= RenderNode.nSetLayerPaint(this.mNativeRenderNode, paint != null ? paint.getNativeInstance() : 0L);
    }

    public boolean getUseCompositingLayer() {
        return RenderNode.nGetLayerType(this.mNativeRenderNode) != 0;
    }

    public boolean setClipRect(Rect rect) {
        if (rect == null) {
            return RenderNode.nSetClipBoundsEmpty(this.mNativeRenderNode);
        }
        return RenderNode.nSetClipBounds(this.mNativeRenderNode, rect.left, rect.top, rect.right, rect.bottom);
    }

    public boolean setClipToBounds(boolean clipToBounds) {
        return RenderNode.nSetClipToBounds(this.mNativeRenderNode, clipToBounds);
    }

    public boolean getClipToBounds() {
        return RenderNode.nGetClipToBounds(this.mNativeRenderNode);
    }

    public boolean setProjectBackwards(boolean shouldProject) {
        return RenderNode.nSetProjectBackwards(this.mNativeRenderNode, shouldProject);
    }

    public boolean setProjectionReceiver(boolean shouldRecieve) {
        return RenderNode.nSetProjectionReceiver(this.mNativeRenderNode, shouldRecieve);
    }

    public boolean setOutline(Outline outline) {
        if (outline == null) {
            return RenderNode.nSetOutlineNone(this.mNativeRenderNode);
        }
        switch (outline.mMode) {
            case 0: {
                return RenderNode.nSetOutlineEmpty(this.mNativeRenderNode);
            }
            case 1: {
                return RenderNode.nSetOutlineRoundRect(this.mNativeRenderNode, outline.mRect.left, outline.mRect.top, outline.mRect.right, outline.mRect.bottom, outline.mRadius, outline.mAlpha);
            }
            case 2: {
                return RenderNode.nSetOutlinePath(this.mNativeRenderNode, outline.mPath.mNativePath, outline.mAlpha);
            }
        }
        throw new IllegalArgumentException("Unrecognized outline?");
    }

    public boolean clearStretch() {
        return RenderNode.nClearStretch(this.mNativeRenderNode);
    }

    public boolean stretch(float vecX, float vecY, float maxStretchAmountX, float maxStretchAmountY) {
        if (Float.isInfinite(vecX) || Float.isNaN(vecX)) {
            throw new IllegalArgumentException("vecX must be a finite, non-NaN value " + vecX);
        }
        if (Float.isInfinite(vecY) || Float.isNaN(vecY)) {
            throw new IllegalArgumentException("vecY must be a finite, non-NaN value " + vecY);
        }
        if (maxStretchAmountX <= 0.0f) {
            throw new IllegalArgumentException("The max horizontal stretch amount must be >0, got " + maxStretchAmountX);
        }
        if (maxStretchAmountY <= 0.0f) {
            throw new IllegalArgumentException("The max vertical stretch amount must be >0, got " + maxStretchAmountY);
        }
        return RenderNode.nStretch(this.mNativeRenderNode, vecX, vecY, maxStretchAmountX, maxStretchAmountY);
    }

    public boolean hasShadow() {
        return RenderNode.nHasShadow(this.mNativeRenderNode);
    }

    public boolean setSpotShadowColor(int color2) {
        return RenderNode.nSetSpotShadowColor(this.mNativeRenderNode, color2);
    }

    public int getSpotShadowColor() {
        return RenderNode.nGetSpotShadowColor(this.mNativeRenderNode);
    }

    public boolean setAmbientShadowColor(int color2) {
        return RenderNode.nSetAmbientShadowColor(this.mNativeRenderNode, color2);
    }

    public int getAmbientShadowColor() {
        return RenderNode.nGetAmbientShadowColor(this.mNativeRenderNode);
    }

    public boolean setClipToOutline(boolean clipToOutline) {
        return RenderNode.nSetClipToOutline(this.mNativeRenderNode, clipToOutline);
    }

    public boolean getClipToOutline() {
        return RenderNode.nGetClipToOutline(this.mNativeRenderNode);
    }

    public boolean setRevealClip(boolean shouldClip, float x, float y, float radius) {
        return RenderNode.nSetRevealClip(this.mNativeRenderNode, shouldClip, x, y, radius);
    }

    public boolean setStaticMatrix(Matrix matrix) {
        return RenderNode.nSetStaticMatrix(this.mNativeRenderNode, matrix.ni());
    }

    public boolean setAnimationMatrix(Matrix matrix) {
        return RenderNode.nSetAnimationMatrix(this.mNativeRenderNode, matrix != null ? matrix.ni() : 0L);
    }

    public Matrix getAnimationMatrix() {
        Matrix output = new Matrix();
        if (RenderNode.nGetAnimationMatrix(this.mNativeRenderNode, output.ni())) {
            return output;
        }
        return null;
    }

    public boolean setAlpha(float alpha) {
        return RenderNode.nSetAlpha(this.mNativeRenderNode, alpha);
    }

    public boolean setRenderEffect(RenderEffect renderEffect) {
        return RenderNode.nSetRenderEffect(this.mNativeRenderNode, renderEffect != null ? renderEffect.getNativeInstance() : 0L);
    }

    public float getAlpha() {
        return RenderNode.nGetAlpha(this.mNativeRenderNode);
    }

    public boolean setHasOverlappingRendering(boolean hasOverlappingRendering) {
        return RenderNode.nSetHasOverlappingRendering(this.mNativeRenderNode, hasOverlappingRendering);
    }

    public void setUsageHint(int usageHint) {
        RenderNode.nSetUsageHint(this.mNativeRenderNode, usageHint);
    }

    public boolean hasOverlappingRendering() {
        return RenderNode.nHasOverlappingRendering(this.mNativeRenderNode);
    }

    public boolean setElevation(float lift) {
        return RenderNode.nSetElevation(this.mNativeRenderNode, lift);
    }

    public float getElevation() {
        return RenderNode.nGetElevation(this.mNativeRenderNode);
    }

    public boolean setTranslationX(float translationX) {
        return RenderNode.nSetTranslationX(this.mNativeRenderNode, translationX);
    }

    public float getTranslationX() {
        return RenderNode.nGetTranslationX(this.mNativeRenderNode);
    }

    public boolean setTranslationY(float translationY) {
        return RenderNode.nSetTranslationY(this.mNativeRenderNode, translationY);
    }

    public float getTranslationY() {
        return RenderNode.nGetTranslationY(this.mNativeRenderNode);
    }

    public boolean setTranslationZ(float translationZ) {
        return RenderNode.nSetTranslationZ(this.mNativeRenderNode, translationZ);
    }

    public float getTranslationZ() {
        return RenderNode.nGetTranslationZ(this.mNativeRenderNode);
    }

    public boolean setRotationZ(float rotation) {
        return RenderNode.nSetRotation(this.mNativeRenderNode, rotation);
    }

    public float getRotationZ() {
        return RenderNode.nGetRotation(this.mNativeRenderNode);
    }

    public boolean setRotationX(float rotationX) {
        return RenderNode.nSetRotationX(this.mNativeRenderNode, rotationX);
    }

    public float getRotationX() {
        return RenderNode.nGetRotationX(this.mNativeRenderNode);
    }

    public boolean setRotationY(float rotationY) {
        return RenderNode.nSetRotationY(this.mNativeRenderNode, rotationY);
    }

    public float getRotationY() {
        return RenderNode.nGetRotationY(this.mNativeRenderNode);
    }

    public boolean setScaleX(float scaleX) {
        return RenderNode.nSetScaleX(this.mNativeRenderNode, scaleX);
    }

    public float getScaleX() {
        return RenderNode.nGetScaleX(this.mNativeRenderNode);
    }

    public boolean setScaleY(float scaleY) {
        return RenderNode.nSetScaleY(this.mNativeRenderNode, scaleY);
    }

    public float getScaleY() {
        return RenderNode.nGetScaleY(this.mNativeRenderNode);
    }

    public boolean setPivotX(float pivotX) {
        return RenderNode.nSetPivotX(this.mNativeRenderNode, pivotX);
    }

    public float getPivotX() {
        return RenderNode.nGetPivotX(this.mNativeRenderNode);
    }

    public boolean setPivotY(float pivotY) {
        return RenderNode.nSetPivotY(this.mNativeRenderNode, pivotY);
    }

    public float getPivotY() {
        return RenderNode.nGetPivotY(this.mNativeRenderNode);
    }

    public boolean isPivotExplicitlySet() {
        return RenderNode.nIsPivotExplicitlySet(this.mNativeRenderNode);
    }

    public boolean resetPivot() {
        return RenderNode.nResetPivot(this.mNativeRenderNode);
    }

    public boolean setCameraDistance(float distance) {
        if (!Float.isFinite(distance) || distance < 0.0f) {
            throw new IllegalArgumentException("distance must be finite & positive, given=" + distance);
        }
        return RenderNode.nSetCameraDistance(this.mNativeRenderNode, -distance);
    }

    public float getCameraDistance() {
        return -RenderNode.nGetCameraDistance(this.mNativeRenderNode);
    }

    public boolean setLeft(int left) {
        return RenderNode.nSetLeft(this.mNativeRenderNode, left);
    }

    public boolean setTop(int top) {
        return RenderNode.nSetTop(this.mNativeRenderNode, top);
    }

    public boolean setRight(int right) {
        return RenderNode.nSetRight(this.mNativeRenderNode, right);
    }

    public boolean setBottom(int bottom) {
        return RenderNode.nSetBottom(this.mNativeRenderNode, bottom);
    }

    public int getLeft() {
        return RenderNode.nGetLeft(this.mNativeRenderNode);
    }

    public int getTop() {
        return RenderNode.nGetTop(this.mNativeRenderNode);
    }

    public int getRight() {
        return RenderNode.nGetRight(this.mNativeRenderNode);
    }

    public int getBottom() {
        return RenderNode.nGetBottom(this.mNativeRenderNode);
    }

    public int getWidth() {
        return RenderNode.nGetWidth(this.mNativeRenderNode);
    }

    public int getHeight() {
        return RenderNode.nGetHeight(this.mNativeRenderNode);
    }

    public boolean setLeftTopRightBottom(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean setPosition(int left, int top, int right, int bottom) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, left, top, right, bottom);
    }

    public boolean setPosition(Rect position) {
        return RenderNode.nSetLeftTopRightBottom(this.mNativeRenderNode, position.left, position.top, position.right, position.bottom);
    }

    public boolean offsetLeftAndRight(int offset) {
        return RenderNode.nOffsetLeftAndRight(this.mNativeRenderNode, offset);
    }

    public boolean offsetTopAndBottom(int offset) {
        return RenderNode.nOffsetTopAndBottom(this.mNativeRenderNode, offset);
    }

    public void output() {
        RenderNode.nOutput(this.mNativeRenderNode);
    }

    public long computeApproximateMemoryUsage() {
        return RenderNode.nGetUsageSize(this.mNativeRenderNode);
    }

    public long computeApproximateMemoryAllocated() {
        return RenderNode.nGetAllocatedSize(this.mNativeRenderNode);
    }

    public boolean setForceDarkAllowed(boolean allow) {
        return RenderNode.nSetAllowForceDark(this.mNativeRenderNode, allow);
    }

    public boolean isForceDarkAllowed() {
        return RenderNode.nGetAllowForceDark(this.mNativeRenderNode);
    }

    public long getUniqueId() {
        return RenderNode.nGetUniqueId(this.mNativeRenderNode);
    }

    public void addAnimator(RenderNodeAnimator animator2) {
        if (!this.isAttached()) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        RenderNode.nAddAnimator(this.mNativeRenderNode, animator2.getNativeAnimator());
        this.mAnimationHost.registerAnimatingRenderNode(this);
    }

    public boolean isAttached() {
        return this.mAnimationHost != null && this.mAnimationHost.isAttached();
    }

    public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator animatorSet) {
        if (!this.isAttached()) {
            throw new IllegalStateException("Cannot start this animator on a detached view!");
        }
        this.mAnimationHost.registerVectorDrawableAnimator(animatorSet);
    }

    public void endAllAnimators() {
        RenderNode.nEndAllAnimators(this.mNativeRenderNode);
    }

    private static native long nCreate(String var0);

    private static native long nGetNativeFinalizer();

    private static native void nOutput(long var0);

    private static native int nGetUsageSize(long var0);

    private static native int nGetAllocatedSize(long var0);

    private static native void nRequestPositionUpdates(long var0, PositionUpdateListener var2);

    private static native void nAddAnimator(long var0, long var2);

    private static native void nEndAllAnimators(long var0);

    @CriticalNative
    private static native void nDiscardDisplayList(long var0);

    @CriticalNative
    private static native boolean nIsValid(long var0);

    @CriticalNative
    private static native void nGetTransformMatrix(long var0, long var2);

    @CriticalNative
    private static native void nGetInverseTransformMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nHasIdentityMatrix(long var0);

    @CriticalNative
    private static native boolean nOffsetTopAndBottom(long var0, int var2);

    @CriticalNative
    private static native boolean nOffsetLeftAndRight(long var0, int var2);

    @CriticalNative
    private static native boolean nSetLeftTopRightBottom(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native boolean nSetLeft(long var0, int var2);

    @CriticalNative
    private static native boolean nSetTop(long var0, int var2);

    @CriticalNative
    private static native boolean nSetRight(long var0, int var2);

    @CriticalNative
    private static native boolean nSetBottom(long var0, int var2);

    @CriticalNative
    private static native int nGetLeft(long var0);

    @CriticalNative
    private static native int nGetTop(long var0);

    @CriticalNative
    private static native int nGetRight(long var0);

    @CriticalNative
    private static native int nGetBottom(long var0);

    @CriticalNative
    private static native boolean nSetCameraDistance(long var0, float var2);

    @CriticalNative
    private static native boolean nSetPivotY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetPivotX(long var0, float var2);

    @CriticalNative
    private static native boolean nResetPivot(long var0);

    @CriticalNative
    private static native boolean nSetLayerType(long var0, int var2);

    @CriticalNative
    private static native int nGetLayerType(long var0);

    @CriticalNative
    private static native boolean nSetLayerPaint(long var0, long var2);

    @CriticalNative
    private static native boolean nSetClipToBounds(long var0, boolean var2);

    @CriticalNative
    private static native boolean nGetClipToBounds(long var0);

    @CriticalNative
    private static native boolean nSetClipBounds(long var0, int var2, int var3, int var4, int var5);

    @CriticalNative
    private static native boolean nSetClipBoundsEmpty(long var0);

    @CriticalNative
    private static native boolean nSetProjectBackwards(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetProjectionReceiver(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetOutlineRoundRect(long var0, int var2, int var3, int var4, int var5, float var6, float var7);

    @CriticalNative
    private static native boolean nSetOutlinePath(long var0, long var2, float var4);

    @CriticalNative
    private static native boolean nSetOutlineEmpty(long var0);

    @CriticalNative
    private static native boolean nSetOutlineNone(long var0);

    @CriticalNative
    private static native boolean nClearStretch(long var0);

    @CriticalNative
    private static native boolean nStretch(long var0, float var2, float var3, float var4, float var5);

    @CriticalNative
    private static native boolean nHasShadow(long var0);

    @CriticalNative
    private static native boolean nSetSpotShadowColor(long var0, int var2);

    @CriticalNative
    private static native boolean nSetAmbientShadowColor(long var0, int var2);

    @CriticalNative
    private static native int nGetSpotShadowColor(long var0);

    @CriticalNative
    private static native int nGetAmbientShadowColor(long var0);

    @CriticalNative
    private static native boolean nSetClipToOutline(long var0, boolean var2);

    @CriticalNative
    private static native boolean nSetRevealClip(long var0, boolean var2, float var3, float var4, float var5);

    @CriticalNative
    private static native boolean nSetAlpha(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRenderEffect(long var0, long var2);

    @CriticalNative
    private static native boolean nSetHasOverlappingRendering(long var0, boolean var2);

    @CriticalNative
    private static native void nSetUsageHint(long var0, int var2);

    @CriticalNative
    private static native boolean nSetElevation(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetTranslationZ(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotation(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotationX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetRotationY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetScaleX(long var0, float var2);

    @CriticalNative
    private static native boolean nSetScaleY(long var0, float var2);

    @CriticalNative
    private static native boolean nSetStaticMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nSetAnimationMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nHasOverlappingRendering(long var0);

    @CriticalNative
    private static native boolean nGetAnimationMatrix(long var0, long var2);

    @CriticalNative
    private static native boolean nGetClipToOutline(long var0);

    @CriticalNative
    private static native float nGetAlpha(long var0);

    @CriticalNative
    private static native float nGetCameraDistance(long var0);

    @CriticalNative
    private static native float nGetScaleX(long var0);

    @CriticalNative
    private static native float nGetScaleY(long var0);

    @CriticalNative
    private static native float nGetElevation(long var0);

    @CriticalNative
    private static native float nGetTranslationX(long var0);

    @CriticalNative
    private static native float nGetTranslationY(long var0);

    @CriticalNative
    private static native float nGetTranslationZ(long var0);

    @CriticalNative
    private static native float nGetRotation(long var0);

    @CriticalNative
    private static native float nGetRotationX(long var0);

    @CriticalNative
    private static native float nGetRotationY(long var0);

    @CriticalNative
    private static native boolean nIsPivotExplicitlySet(long var0);

    @CriticalNative
    private static native float nGetPivotX(long var0);

    @CriticalNative
    private static native float nGetPivotY(long var0);

    @CriticalNative
    private static native int nGetWidth(long var0);

    @CriticalNative
    private static native int nGetHeight(long var0);

    @CriticalNative
    private static native boolean nSetAllowForceDark(long var0, boolean var2);

    @CriticalNative
    private static native boolean nGetAllowForceDark(long var0);

    @CriticalNative
    private static native long nGetUniqueId(long var0);

    static /* synthetic */ long access$000() {
        return RenderNode.nGetNativeFinalizer();
    }

    public static interface AnimationHost {
        public void registerAnimatingRenderNode(RenderNode var1);

        public void registerVectorDrawableAnimator(NativeVectorDrawableAnimator var1);

        public boolean isAttached();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageHint {
    }

    private static class CompositePositionUpdateListener
    implements PositionUpdateListener {
        private final PositionUpdateListener[] mListeners;
        private static final PositionUpdateListener[] sEmpty = new PositionUpdateListener[0];

        CompositePositionUpdateListener(PositionUpdateListener ... listeners) {
            this.mListeners = listeners != null ? listeners : sEmpty;
        }

        public CompositePositionUpdateListener with(PositionUpdateListener listener) {
            return new CompositePositionUpdateListener(ArrayUtils.appendElement(PositionUpdateListener.class, this.mListeners, listener));
        }

        public CompositePositionUpdateListener without(PositionUpdateListener listener) {
            return new CompositePositionUpdateListener(ArrayUtils.removeElement(PositionUpdateListener.class, this.mListeners, listener));
        }

        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            for (PositionUpdateListener pul : this.mListeners) {
                pul.positionChanged(frameNumber, left, top, right, bottom);
            }
        }

        @Override
        public void positionLost(long frameNumber) {
            for (PositionUpdateListener pul : this.mListeners) {
                pul.positionLost(frameNumber);
            }
        }

        @Override
        public void applyStretch(long frameNumber, float width, float height, float vecX, float vecY, float maxStretchX, float maxStretchY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
            for (PositionUpdateListener pul : this.mListeners) {
                pul.applyStretch(frameNumber, width, height, vecX, vecY, maxStretchX, maxStretchY, childRelativeLeft, childRelativeTop, childRelativeRight, childRelativeBottom);
            }
        }
    }

    public static interface PositionUpdateListener {
        public void positionChanged(long var1, int var3, int var4, int var5, int var6);

        default public void applyStretch(long frameNumber, float width, float height, float vecX, float vecY, float maxStretchX, float maxStretchY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
        }

        public void positionLost(long var1);
    }

    private static class NoImagePreloadHolder {
        public static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(RenderNode.class.getClassLoader(), RenderNode.access$000());

        private NoImagePreloadHolder() {
        }
    }
}

