/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.devicestate;

import android.hardware.devicestate.DeviceStateInfo;
import android.hardware.devicestate.DeviceStateManager;
import android.hardware.devicestate.DeviceStateRequest;
import android.hardware.devicestate.IDeviceStateManager;
import android.hardware.devicestate.IDeviceStateManagerCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class DeviceStateManagerGlobal {
    private static DeviceStateManagerGlobal sInstance;
    private final Object mLock = new Object();
    private final IDeviceStateManager mDeviceStateManager;
    private DeviceStateManagerCallback mCallback;
    @GuardedBy(value={"mLock"})
    private final ArrayList<DeviceStateCallbackWrapper> mCallbacks = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<IBinder, DeviceStateRequestWrapper> mRequests = new ArrayMap();
    @GuardedBy(value={"mLock"})
    private DeviceStateInfo mLastReceivedInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DeviceStateManagerGlobal getInstance() {
        Class<DeviceStateManagerGlobal> clazz = DeviceStateManagerGlobal.class;
        synchronized (DeviceStateManagerGlobal.class) {
            IBinder b;
            if (sInstance == null && (b = ServiceManager.getService("device_state")) != null) {
                sInstance = new DeviceStateManagerGlobal(IDeviceStateManager.Stub.asInterface(b));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @VisibleForTesting
    public DeviceStateManagerGlobal(IDeviceStateManager deviceStateManager) {
        this.mDeviceStateManager = deviceStateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getSupportedStates() {
        Object object = this.mLock;
        synchronized (object) {
            DeviceStateInfo currentInfo;
            if (this.mLastReceivedInfo != null) {
                currentInfo = this.mLastReceivedInfo;
            } else {
                try {
                    currentInfo = this.mDeviceStateManager.getDeviceStateInfo();
                }
                catch (RemoteException ex) {
                    throw ex.rethrowFromSystemServer();
                }
            }
            return Arrays.copyOf(currentInfo.supportedStates, currentInfo.supportedStates.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestState(DeviceStateRequest request, DeviceStateRequest.Callback callback, Executor executor) {
        if (callback == null && executor != null) {
            throw new IllegalArgumentException("Callback must be supplied with executor.");
        }
        if (executor == null && callback != null) {
            throw new IllegalArgumentException("Executor must be supplied with callback.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.registerCallbackIfNeededLocked();
            if (this.findRequestTokenLocked(request) != null) {
                return;
            }
            Binder token = new Binder();
            this.mRequests.put(token, new DeviceStateRequestWrapper(request, callback, executor));
            try {
                this.mDeviceStateManager.requestState(token, request.getState(), request.getFlags());
            }
            catch (RemoteException ex) {
                this.mRequests.remove(token);
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(DeviceStateRequest request) {
        Object object = this.mLock;
        synchronized (object) {
            this.registerCallbackIfNeededLocked();
            IBinder token = this.findRequestTokenLocked(request);
            if (token == null) {
                return;
            }
            try {
                this.mDeviceStateManager.cancelRequest(token);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void registerDeviceStateCallback(DeviceStateManager.DeviceStateCallback callback, Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findCallbackLocked(callback);
            if (index != -1) {
                return;
            }
            this.registerCallbackIfNeededLocked();
            DeviceStateCallbackWrapper wrapper = new DeviceStateCallbackWrapper(callback, executor);
            this.mCallbacks.add(wrapper);
            if (this.mLastReceivedInfo != null) {
                int[] supportedStates = Arrays.copyOf(this.mLastReceivedInfo.supportedStates, this.mLastReceivedInfo.supportedStates.length);
                wrapper.notifySupportedStatesChanged(supportedStates);
                wrapper.notifyBaseStateChanged(this.mLastReceivedInfo.baseState);
                wrapper.notifyStateChanged(this.mLastReceivedInfo.currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void unregisterDeviceStateCallback(DeviceStateManager.DeviceStateCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            int indexToRemove = this.findCallbackLocked(callback);
            if (indexToRemove != -1) {
                this.mCallbacks.remove(indexToRemove);
            }
        }
    }

    private void registerCallbackIfNeededLocked() {
        if (this.mCallback == null) {
            this.mCallback = new DeviceStateManagerCallback();
            try {
                this.mDeviceStateManager.registerCallback(this.mCallback);
            }
            catch (RemoteException ex) {
                this.mCallback = null;
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private int findCallbackLocked(DeviceStateManager.DeviceStateCallback callback) {
        for (int i = 0; i < this.mCallbacks.size(); ++i) {
            if (!this.mCallbacks.get(i).mDeviceStateCallback.equals(callback)) continue;
            return i;
        }
        return -1;
    }

    private IBinder findRequestTokenLocked(DeviceStateRequest request) {
        for (int i = 0; i < this.mRequests.size(); ++i) {
            if (!this.mRequests.valueAt(i).mRequest.equals(request)) continue;
            return this.mRequests.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeviceStateInfoChanged(DeviceStateInfo info) {
        int i;
        int diff;
        ArrayList<DeviceStateCallbackWrapper> callbacks;
        DeviceStateInfo oldInfo;
        Object object = this.mLock;
        synchronized (object) {
            oldInfo = this.mLastReceivedInfo;
            this.mLastReceivedInfo = info;
            callbacks = new ArrayList<DeviceStateCallbackWrapper>(this.mCallbacks);
        }
        int n = diff = oldInfo == null ? -1 : info.diff(oldInfo);
        if ((diff & 1) > 0) {
            for (i = 0; i < callbacks.size(); ++i) {
                int[] supportedStates = Arrays.copyOf(info.supportedStates, info.supportedStates.length);
                callbacks.get(i).notifySupportedStatesChanged(supportedStates);
            }
        }
        if ((diff & 2) > 0) {
            for (i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).notifyBaseStateChanged(info.baseState);
            }
        }
        if ((diff & 4) > 0) {
            for (i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).notifyStateChanged(info.currentState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestActive(IBinder token) {
        DeviceStateRequestWrapper request;
        Object object = this.mLock;
        synchronized (object) {
            request = this.mRequests.get(token);
        }
        if (request != null) {
            request.notifyRequestActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestSuspended(IBinder token) {
        DeviceStateRequestWrapper request;
        Object object = this.mLock;
        synchronized (object) {
            request = this.mRequests.get(token);
        }
        if (request != null) {
            request.notifyRequestSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequestCanceled(IBinder token) {
        DeviceStateRequestWrapper request;
        Object object = this.mLock;
        synchronized (object) {
            request = this.mRequests.remove(token);
        }
        if (request != null) {
            request.notifyRequestCanceled();
        }
    }

    private static class DeviceStateRequestWrapper {
        private final DeviceStateRequest mRequest;
        private final DeviceStateRequest.Callback mCallback;
        private final Executor mExecutor;

        DeviceStateRequestWrapper(DeviceStateRequest request, DeviceStateRequest.Callback callback, Executor executor) {
            this.mRequest = request;
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        void notifyRequestActive() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onRequestActivated(this.mRequest));
        }

        void notifyRequestSuspended() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onRequestSuspended(this.mRequest));
        }

        void notifyRequestCanceled() {
            if (this.mCallback == null) {
                return;
            }
            this.mExecutor.execute(() -> this.mCallback.onRequestSuspended(this.mRequest));
        }
    }

    private static class DeviceStateCallbackWrapper {
        private final DeviceStateManager.DeviceStateCallback mDeviceStateCallback;
        private final Executor mExecutor;

        DeviceStateCallbackWrapper(DeviceStateManager.DeviceStateCallback callback, Executor executor) {
            this.mDeviceStateCallback = callback;
            this.mExecutor = executor;
        }

        void notifySupportedStatesChanged(int[] newSupportedStates) {
            this.mExecutor.execute(() -> this.mDeviceStateCallback.onSupportedStatesChanged(newSupportedStates));
        }

        void notifyBaseStateChanged(int newBaseState) {
            this.mExecutor.execute(() -> this.mDeviceStateCallback.onBaseStateChanged(newBaseState));
        }

        void notifyStateChanged(int newDeviceState) {
            this.mExecutor.execute(() -> this.mDeviceStateCallback.onStateChanged(newDeviceState));
        }
    }

    private class DeviceStateManagerCallback
    extends IDeviceStateManagerCallback.Stub {
        private DeviceStateManagerCallback() {
        }

        @Override
        public void onDeviceStateInfoChanged(DeviceStateInfo info) {
            DeviceStateManagerGlobal.this.handleDeviceStateInfoChanged(info);
        }

        @Override
        public void onRequestActive(IBinder token) {
            DeviceStateManagerGlobal.this.handleRequestActive(token);
        }

        @Override
        public void onRequestSuspended(IBinder token) {
            DeviceStateManagerGlobal.this.handleRequestSuspended(token);
        }

        @Override
        public void onRequestCanceled(IBinder token) {
            DeviceStateManagerGlobal.this.handleRequestCanceled(token);
        }
    }
}

