/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_4;

import java.util.ArrayList;

public class PdpProtocolType {
    public static final int UNKNOWN = -1;
    public static final int IP = 0;
    public static final int IPV6 = 1;
    public static final int IPV4V6 = 2;
    public static final int PPP = 3;
    public static final int NON_IP = 4;
    public static final int UNSTRUCTURED = 5;

    public static String toString(int o) {
        if (o == -1) {
            return "UNKNOWN";
        }
        if (o == 0) {
            return "IP";
        }
        if (o == 1) {
            return "IPV6";
        }
        if (o == 2) {
            return "IPV4V6";
        }
        if (o == 3) {
            return "PPP";
        }
        if (o == 4) {
            return "NON_IP";
        }
        if (o == 5) {
            return "UNSTRUCTURED";
        }
        return "0x" + Integer.toHexString(o);
    }

    public static String dumpBitfield(int o) {
        ArrayList<String> list = new ArrayList<String>();
        int flipped = 0;
        if ((o & 0xFFFFFFFF) == -1) {
            list.add("UNKNOWN");
            flipped |= 0xFFFFFFFF;
        }
        list.add("IP");
        if ((o & 1) == 1) {
            list.add("IPV6");
            flipped |= 1;
        }
        if ((o & 2) == 2) {
            list.add("IPV4V6");
            flipped |= 2;
        }
        if ((o & 3) == 3) {
            list.add("PPP");
            flipped |= 3;
        }
        if ((o & 4) == 4) {
            list.add("NON_IP");
            flipped |= 4;
        }
        if ((o & 5) == 5) {
            list.add("UNSTRUCTURED");
            flipped |= 5;
        }
        if (o != flipped) {
            list.add("0x" + Integer.toHexString(o & ~flipped));
        }
        return String.join((CharSequence)" | ", list);
    }
}

