/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.units;

import android.icu.impl.units.MeasureUnitImpl;
import android.icu.util.MeasureUnit;

public class SingleUnitImpl {
    private int index = -1;
    private String simpleUnit = "";
    private int dimensionality = 1;
    private MeasureUnit.SIPrefix siPrefix = MeasureUnit.SIPrefix.ONE;

    public SingleUnitImpl copy() {
        SingleUnitImpl result = new SingleUnitImpl();
        result.index = this.index;
        result.dimensionality = this.dimensionality;
        result.simpleUnit = this.simpleUnit;
        result.siPrefix = this.siPrefix;
        return result;
    }

    public MeasureUnit build() {
        MeasureUnitImpl measureUnit = new MeasureUnitImpl(this);
        return measureUnit.build();
    }

    public String getNeutralIdentifier() {
        StringBuilder result = new StringBuilder();
        int posPower = Math.abs(this.getDimensionality());
        assert (posPower > 0) : "getIdentifier does not support the dimensionless";
        if (posPower != 1) {
            if (posPower == 2) {
                result.append("square-");
            } else if (posPower == 3) {
                result.append("cubic-");
            } else if (posPower <= 15) {
                result.append("pow");
                result.append(posPower);
                result.append('-');
            } else {
                throw new IllegalArgumentException("Unit Identifier Syntax Error");
            }
        }
        result.append(this.getSiPrefix().getIdentifier());
        result.append(this.getSimpleUnit());
        return result.toString();
    }

    int compareTo(SingleUnitImpl other) {
        if (this.dimensionality < 0 && other.dimensionality > 0) {
            return 1;
        }
        if (this.dimensionality > 0 && other.dimensionality < 0) {
            return -1;
        }
        if (this.index < other.index) {
            return -1;
        }
        if (this.index > other.index) {
            return 1;
        }
        if (this.getSiPrefix().getPower() < other.getSiPrefix().getPower()) {
            return -1;
        }
        if (this.getSiPrefix().getPower() > other.getSiPrefix().getPower()) {
            return 1;
        }
        return 0;
    }

    boolean isCompatibleWith(SingleUnitImpl other) {
        return this.compareTo(other) == 0;
    }

    public String getSimpleUnit() {
        return this.simpleUnit;
    }

    public void setSimpleUnit(int simpleUnitIndex, String[] simpleUnits) {
        this.index = simpleUnitIndex;
        this.simpleUnit = simpleUnits[simpleUnitIndex];
    }

    public int getDimensionality() {
        return this.dimensionality;
    }

    public void setDimensionality(int dimensionality) {
        this.dimensionality = dimensionality;
    }

    public MeasureUnit.SIPrefix getSiPrefix() {
        return this.siPrefix;
    }

    public void setSiPrefix(MeasureUnit.SIPrefix siPrefix) {
        this.siPrefix = siPrefix;
    }

    public int getIndex() {
        return this.index;
    }
}

