/*
 * Decompiled with CFR 0.152.
 */
package android.net.vcn;

import android.content.Context;
import android.net.vcn.VcnGatewayConnectionConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.vcn.repackaged.util.PersistableBundleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class VcnConfig
implements Parcelable {
    private static final String TAG = VcnConfig.class.getSimpleName();
    private static final String PACKAGE_NAME_KEY = "mPackageName";
    private final String mPackageName;
    private static final String GATEWAY_CONNECTION_CONFIGS_KEY = "mGatewayConnectionConfigs";
    private final Set<VcnGatewayConnectionConfig> mGatewayConnectionConfigs;
    private static final String IS_TEST_MODE_PROFILE_KEY = "mIsTestModeProfile";
    private final boolean mIsTestModeProfile;
    public static final Parcelable.Creator<VcnConfig> CREATOR = new Parcelable.Creator<VcnConfig>(){

        @Override
        public VcnConfig createFromParcel(Parcel in) {
            return new VcnConfig((PersistableBundle)in.readParcelable(null));
        }

        public VcnConfig[] newArray(int size) {
            return new VcnConfig[size];
        }
    };

    private VcnConfig(String packageName, Set<VcnGatewayConnectionConfig> gatewayConnectionConfigs, boolean isTestModeProfile) {
        this.mPackageName = packageName;
        this.mGatewayConnectionConfigs = Collections.unmodifiableSet(new ArraySet<VcnGatewayConnectionConfig>(gatewayConnectionConfigs));
        this.mIsTestModeProfile = isTestModeProfile;
        this.validate();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public VcnConfig(PersistableBundle in) {
        this.mPackageName = in.getString(PACKAGE_NAME_KEY);
        PersistableBundle gatewayConnectionConfigsBundle = in.getPersistableBundle(GATEWAY_CONNECTION_CONFIGS_KEY);
        this.mGatewayConnectionConfigs = new ArraySet<VcnGatewayConnectionConfig>(PersistableBundleUtils.toList(gatewayConnectionConfigsBundle, VcnGatewayConnectionConfig::new));
        this.mIsTestModeProfile = in.getBoolean(IS_TEST_MODE_PROFILE_KEY);
        this.validate();
    }

    private void validate() {
        Objects.requireNonNull(this.mPackageName, "packageName was null");
        Preconditions.checkCollectionNotEmpty(this.mGatewayConnectionConfigs, "gatewayConnectionConfigs was empty");
    }

    public String getProvisioningPackageName() {
        return this.mPackageName;
    }

    public Set<VcnGatewayConnectionConfig> getGatewayConnectionConfigs() {
        return Collections.unmodifiableSet(this.mGatewayConnectionConfigs);
    }

    public boolean isTestModeProfile() {
        return this.mIsTestModeProfile;
    }

    public PersistableBundle toPersistableBundle() {
        PersistableBundle result = new PersistableBundle();
        result.putString(PACKAGE_NAME_KEY, this.mPackageName);
        PersistableBundle gatewayConnectionConfigsBundle = PersistableBundleUtils.fromList(new ArrayList<VcnGatewayConnectionConfig>(this.mGatewayConnectionConfigs), VcnGatewayConnectionConfig::toPersistableBundle);
        result.putPersistableBundle(GATEWAY_CONNECTION_CONFIGS_KEY, gatewayConnectionConfigsBundle);
        result.putBoolean(IS_TEST_MODE_PROFILE_KEY, this.mIsTestModeProfile);
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mGatewayConnectionConfigs, this.mIsTestModeProfile);
    }

    public boolean equals(Object other) {
        if (!(other instanceof VcnConfig)) {
            return false;
        }
        VcnConfig rhs = (VcnConfig)other;
        return this.mPackageName.equals(rhs.mPackageName) && this.mGatewayConnectionConfigs.equals(rhs.mGatewayConnectionConfigs) && this.mIsTestModeProfile == rhs.mIsTestModeProfile;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.toPersistableBundle(), flags);
    }

    public static class Builder {
        private final String mPackageName;
        private final Set<VcnGatewayConnectionConfig> mGatewayConnectionConfigs = new ArraySet<VcnGatewayConnectionConfig>();
        private boolean mIsTestModeProfile = false;

        public Builder(Context context) {
            Objects.requireNonNull(context, "context was null");
            this.mPackageName = context.getOpPackageName();
        }

        public Builder addGatewayConnectionConfig(VcnGatewayConnectionConfig gatewayConnectionConfig) {
            Objects.requireNonNull(gatewayConnectionConfig, "gatewayConnectionConfig was null");
            for (VcnGatewayConnectionConfig vcnGatewayConnectionConfig : this.mGatewayConnectionConfigs) {
                if (!vcnGatewayConnectionConfig.getGatewayConnectionName().equals(gatewayConnectionConfig.getGatewayConnectionName())) continue;
                throw new IllegalArgumentException("GatewayConnection for specified name already exists");
            }
            this.mGatewayConnectionConfigs.add(gatewayConnectionConfig);
            return this;
        }

        public Builder setIsTestModeProfile() {
            this.mIsTestModeProfile = true;
            return this;
        }

        public VcnConfig build() {
            return new VcnConfig(this.mPackageName, this.mGatewayConnectionConfigs, this.mIsTestModeProfile);
        }
    }
}

