/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.CoexUnsafeChannel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICoexCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.net.wifi.ICoexCallback";

    public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICoexCallback {
        static final int TRANSACTION_onCoexUnsafeChannelsChanged = 1;

        public Stub() {
            this.attachInterface(this, ICoexCallback.DESCRIPTOR);
        }

        public static ICoexCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICoexCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICoexCallback) {
                return (ICoexCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICoexCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ArrayList<CoexUnsafeChannel> _arg0 = data.createTypedArrayList(CoexUnsafeChannel.CREATOR);
                    int _arg1 = data.readInt();
                    this.onCoexUnsafeChannelsChanged(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ICoexCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ICoexCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ICoexCallback {
            private IBinder mRemote;
            public static ICoexCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICoexCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> unsafeChannels, int restrictions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICoexCallback.DESCRIPTOR);
                    _data.writeTypedList(unsafeChannels);
                    _data.writeInt(restrictions);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCoexUnsafeChannelsChanged(unsafeChannels, restrictions);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICoexCallback {
        @Override
        public void onCoexUnsafeChannelsChanged(List<CoexUnsafeChannel> unsafeChannels, int restrictions) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

