/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.WifiManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.wifi.x.androidx.annotation.RequiresApi;
import com.android.wifi.x.com.android.internal.util.Preconditions;
import com.android.wifi.x.com.android.modules.utils.build.SdkLevel;
import java.util.Objects;

@SystemApi
public class SoftApInfo
implements Parcelable {
    public static final int CHANNEL_WIDTH_INVALID = 0;
    public static final int CHANNEL_WIDTH_20MHZ_NOHT = 1;
    public static final int CHANNEL_WIDTH_20MHZ = 2;
    public static final int CHANNEL_WIDTH_40MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ = 4;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 5;
    public static final int CHANNEL_WIDTH_160MHZ = 6;
    public static final int CHANNEL_WIDTH_2160MHZ = 7;
    public static final int CHANNEL_WIDTH_4320MHZ = 8;
    public static final int CHANNEL_WIDTH_6480MHZ = 9;
    public static final int CHANNEL_WIDTH_8640MHZ = 10;
    private int mFrequency = 0;
    private int mBandwidth = 0;
    private MacAddress mBssid;
    private String mApInstanceIdentifier;
    private int mWifiStandard = 0;
    private long mIdleShutdownTimeoutMillis;
    public static final Parcelable.Creator<SoftApInfo> CREATOR = new Parcelable.Creator<SoftApInfo>(){

        @Override
        public SoftApInfo createFromParcel(Parcel in) {
            SoftApInfo info = new SoftApInfo();
            info.mFrequency = in.readInt();
            info.mBandwidth = in.readInt();
            info.mBssid = (MacAddress)in.readParcelable(MacAddress.class.getClassLoader());
            info.mWifiStandard = in.readInt();
            info.mApInstanceIdentifier = in.readString();
            info.mIdleShutdownTimeoutMillis = in.readLong();
            return info;
        }

        public SoftApInfo[] newArray(int size) {
            return new SoftApInfo[size];
        }
    };

    public int getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(int freq) {
        this.mFrequency = freq;
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    public void setBandwidth(int bandwidth) {
        this.mBandwidth = bandwidth;
    }

    @RequiresApi(value=31)
    public MacAddress getBssid() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getBssidInternal();
    }

    public MacAddress getBssidInternal() {
        return this.mBssid;
    }

    public void setBssid(MacAddress bssid) {
        if (bssid != null) {
            Preconditions.checkArgument(!bssid.equals(WifiManager.ALL_ZEROS_MAC_ADDRESS));
            Preconditions.checkArgument(!bssid.equals(MacAddress.BROADCAST_ADDRESS));
        }
        this.mBssid = bssid;
    }

    public void setWifiStandard(int wifiStandard) {
        this.mWifiStandard = wifiStandard;
    }

    @RequiresApi(value=31)
    public int getWifiStandard() {
        if (!SdkLevel.isAtLeastS()) {
            throw new UnsupportedOperationException();
        }
        return this.getWifiStandardInternal();
    }

    public int getWifiStandardInternal() {
        return this.mWifiStandard;
    }

    public void setApInstanceIdentifier(String apInstanceIdentifier) {
        this.mApInstanceIdentifier = apInstanceIdentifier;
    }

    public String getApInstanceIdentifier() {
        return this.mApInstanceIdentifier;
    }

    public void setAutoShutdownTimeoutMillis(long idleShutdownTimeoutMillis) {
        this.mIdleShutdownTimeoutMillis = idleShutdownTimeoutMillis;
    }

    public long getAutoShutdownTimeoutMillis() {
        return this.mIdleShutdownTimeoutMillis;
    }

    public SoftApInfo(SoftApInfo source) {
        if (source != null) {
            this.mFrequency = source.mFrequency;
            this.mBandwidth = source.mBandwidth;
            this.mBssid = source.mBssid;
            this.mWifiStandard = source.mWifiStandard;
            this.mApInstanceIdentifier = source.mApInstanceIdentifier;
            this.mIdleShutdownTimeoutMillis = source.mIdleShutdownTimeoutMillis;
        }
    }

    public SoftApInfo() {
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFrequency);
        dest.writeInt(this.mBandwidth);
        dest.writeParcelable(this.mBssid, flags);
        dest.writeInt(this.mWifiStandard);
        dest.writeString(this.mApInstanceIdentifier);
        dest.writeLong(this.mIdleShutdownTimeoutMillis);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("SoftApInfo{");
        sbuf.append("bandwidth= ").append(this.mBandwidth);
        sbuf.append(", frequency= ").append(this.mFrequency);
        if (this.mBssid != null) {
            sbuf.append(",bssid=").append(this.mBssid.toString());
        }
        sbuf.append(", wifiStandard= ").append(this.mWifiStandard);
        sbuf.append(", mApInstanceIdentifier= ").append(this.mApInstanceIdentifier);
        sbuf.append(", mIdleShutdownTimeoutMillis= ").append(this.mIdleShutdownTimeoutMillis);
        sbuf.append("}");
        return sbuf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoftApInfo)) {
            return false;
        }
        SoftApInfo softApInfo = (SoftApInfo)o;
        return this.mFrequency == softApInfo.mFrequency && this.mBandwidth == softApInfo.mBandwidth && Objects.equals(this.mBssid, softApInfo.mBssid) && this.mWifiStandard == softApInfo.mWifiStandard && Objects.equals(this.mApInstanceIdentifier, softApInfo.mApInstanceIdentifier) && this.mIdleShutdownTimeoutMillis == softApInfo.mIdleShutdownTimeoutMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mFrequency, this.mBandwidth, this.mBssid, this.mWifiStandard, this.mApInstanceIdentifier, this.mIdleShutdownTimeoutMillis);
    }
}

