/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryUsageStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerComponents;
import android.os.UidBatteryConsumer;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.os.PowerCalculator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class UserBatteryConsumer
extends BatteryConsumer
implements Parcelable {
    private final int mUserId;
    public static final Parcelable.Creator<UserBatteryConsumer> CREATOR = new Parcelable.Creator<UserBatteryConsumer>(){

        @Override
        public UserBatteryConsumer createFromParcel(Parcel in) {
            return new UserBatteryConsumer(in);
        }

        public UserBatteryConsumer[] newArray(int size) {
            return new UserBatteryConsumer[size];
        }
    };

    public int getUserId() {
        return this.mUserId;
    }

    private UserBatteryConsumer(Builder builder) {
        super(builder.mPowerComponentsBuilder.build());
        this.mUserId = builder.mUserId;
    }

    private UserBatteryConsumer(Parcel in) {
        super(new PowerComponents(in));
        this.mUserId = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mUserId);
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        double consumedPower = this.getConsumedPower();
        pw.print("User ");
        pw.print(this.mUserId);
        pw.print(": ");
        PowerCalculator.printPowerMah(pw, consumedPower);
        pw.print(" ( ");
        this.mPowerComponents.dump(pw, skipEmptyComponents);
        pw.print(" ) ");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void writeToXml(TypedXmlSerializer serializer) throws IOException {
        if (this.getConsumedPower() == 0.0) {
            return;
        }
        serializer.startTag(null, "user");
        serializer.attributeInt(null, "user_id", this.getUserId());
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "user");
    }

    static void createFromXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder) throws XmlPullParserException, IOException {
        int userId = parser.getAttributeInt(null, "user_id");
        Builder consumerBuilder = builder.getOrCreateUserBatteryConsumerBuilder(userId);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("user")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        while (!(eventType == 3 && parser.getName().equals("user") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private final int mUserId;
        private List<UidBatteryConsumer.Builder> mUidBatteryConsumers;

        Builder(String[] customPowerComponentNames, boolean includePowerModels, int userId) {
            super(customPowerComponentNames, includePowerModels);
            this.mUserId = userId;
        }

        public void addUidBatteryConsumer(UidBatteryConsumer.Builder uidBatteryConsumerBuilder) {
            if (this.mUidBatteryConsumers == null) {
                this.mUidBatteryConsumers = new ArrayList<UidBatteryConsumer.Builder>();
            }
            this.mUidBatteryConsumers.add(uidBatteryConsumerBuilder);
        }

        public UserBatteryConsumer build() {
            if (this.mUidBatteryConsumers != null) {
                for (int i = this.mUidBatteryConsumers.size() - 1; i >= 0; --i) {
                    UidBatteryConsumer.Builder uidBatteryConsumer = this.mUidBatteryConsumers.get(i);
                    this.mPowerComponentsBuilder.addPowerAndDuration(uidBatteryConsumer.mPowerComponentsBuilder);
                }
            }
            return new UserBatteryConsumer(this);
        }
    }
}

