/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.accounts.Account;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.provider.ContactsInternal;
import android.provider.SyncStateContract;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import com.google.android.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ContactsContract {
    public static final String AUTHORITY = "com.android.contacts";
    public static final Uri AUTHORITY_URI = Uri.parse("content://com.android.contacts");
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String HIDDEN_COLUMN_PREFIX = "x_";
    public static final String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static final String DIRECTORY_PARAM_KEY = "directory";
    public static final String LIMIT_PARAM_KEY = "limit";
    public static final String PRIMARY_ACCOUNT_NAME = "name_for_primary_account";
    public static final String PRIMARY_ACCOUNT_TYPE = "type_for_primary_account";
    public static final String STREQUENT_PHONE_ONLY = "strequent_phone_only";
    public static final String DEFERRED_SNIPPETING = "deferred_snippeting";
    public static final String DEFERRED_SNIPPETING_QUERY = "deferred_snippeting_query";
    public static final String REMOVE_DUPLICATE_ENTRIES = "remove_duplicate_entries";

    public static boolean isProfileId(long id2) {
        return id2 >= 9223372034707292160L;
    }

    @Deprecated
    @SystemApi
    public static class MetadataSyncState
    implements BaseColumns,
    MetadataSyncStateColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(MetadataSync.METADATA_AUTHORITY_URI, "metadata_sync_state");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact_metadata_sync_state";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_metadata_sync_state";

        private MetadataSyncState() {
        }
    }

    @Deprecated
    @SystemApi
    protected static interface MetadataSyncStateColumns {
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String ACCOUNT_NAME = "account_name";
        public static final String DATA_SET = "data_set";
        public static final String STATE = "state";
    }

    @Deprecated
    @SystemApi
    public static class MetadataSync
    implements BaseColumns,
    MetadataSyncColumns {
        public static final String METADATA_AUTHORITY = "com.android.contacts.metadata";
        public static final Uri METADATA_AUTHORITY_URI = Uri.parse("content://com.android.contacts.metadata");
        public static final Uri CONTENT_URI = Uri.withAppendedPath(METADATA_AUTHORITY_URI, "metadata_sync");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact_metadata";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_metadata";

        private MetadataSync() {
        }
    }

    @Deprecated
    @SystemApi
    protected static interface MetadataSyncColumns {
        public static final String RAW_CONTACT_BACKUP_ID = "raw_contact_backup_id";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String ACCOUNT_NAME = "account_name";
        public static final String DATA_SET = "data_set";
        public static final String DATA = "data";
        public static final String DELETED = "deleted";
    }

    public static class Intents {
        public static final String SEARCH_SUGGESTION_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CLICKED";
        public static final String SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_DIAL_NUMBER_CLICKED";
        public static final String SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED = "android.provider.Contacts.SEARCH_SUGGESTION_CREATE_CONTACT_CLICKED";
        public static final String CONTACTS_DATABASE_CREATED = "android.provider.Contacts.DATABASE_CREATED";
        public static final String ATTACH_IMAGE = "com.android.contacts.action.ATTACH_IMAGE";
        public static final String INVITE_CONTACT = "com.android.contacts.action.INVITE_CONTACT";
        public static final String SHOW_OR_CREATE_CONTACT = "com.android.contacts.action.SHOW_OR_CREATE_CONTACT";
        public static final String ACTION_VOICE_SEND_MESSAGE_TO_CONTACTS = "android.provider.action.VOICE_SEND_MESSAGE_TO_CONTACTS";
        public static final String EXTRA_RECIPIENT_CONTACT_URI = "android.provider.extra.RECIPIENT_CONTACT_URI";
        public static final String EXTRA_RECIPIENT_CONTACT_CHAT_ID = "android.provider.extra.RECIPIENT_CONTACT_CHAT_ID";
        public static final String EXTRA_RECIPIENT_CONTACT_NAME = "android.provider.extra.RECIPIENT_CONTACT_NAME";
        public static final String METADATA_ACCOUNT_TYPE = "android.provider.account_type";
        public static final String METADATA_MIMETYPE = "android.provider.mimetype";
        public static final String ACTION_GET_MULTIPLE_PHONES = "com.android.contacts.action.GET_MULTIPLE_PHONES";
        public static final String ACTION_PROFILE_CHANGED = "android.provider.Contacts.PROFILE_CHANGED";
        public static final String EXTRA_FORCE_CREATE = "com.android.contacts.action.FORCE_CREATE";
        public static final String EXTRA_CREATE_DESCRIPTION = "com.android.contacts.action.CREATE_DESCRIPTION";
        public static final String EXTRA_PHONE_URIS = "com.android.contacts.extra.PHONE_URIS";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "target_rect";
        @Deprecated
        public static final String EXTRA_MODE = "mode";
        @Deprecated
        public static final int MODE_SMALL = 1;
        @Deprecated
        public static final int MODE_MEDIUM = 2;
        @Deprecated
        public static final int MODE_LARGE = 3;
        @Deprecated
        public static final String EXTRA_EXCLUDE_MIMES = "exclude_mimes";

        public static class Insert {
            public static final String ACTION = "android.intent.action.INSERT";
            public static final String FULL_MODE = "full_mode";
            public static final String NAME = "name";
            public static final String PHONETIC_NAME = "phonetic_name";
            public static final String COMPANY = "company";
            public static final String JOB_TITLE = "job_title";
            public static final String NOTES = "notes";
            public static final String PHONE = "phone";
            public static final String PHONE_TYPE = "phone_type";
            public static final String PHONE_ISPRIMARY = "phone_isprimary";
            public static final String SECONDARY_PHONE = "secondary_phone";
            public static final String SECONDARY_PHONE_TYPE = "secondary_phone_type";
            public static final String TERTIARY_PHONE = "tertiary_phone";
            public static final String TERTIARY_PHONE_TYPE = "tertiary_phone_type";
            public static final String EMAIL = "email";
            public static final String EMAIL_TYPE = "email_type";
            public static final String EMAIL_ISPRIMARY = "email_isprimary";
            public static final String SECONDARY_EMAIL = "secondary_email";
            public static final String SECONDARY_EMAIL_TYPE = "secondary_email_type";
            public static final String TERTIARY_EMAIL = "tertiary_email";
            public static final String TERTIARY_EMAIL_TYPE = "tertiary_email_type";
            public static final String POSTAL = "postal";
            public static final String POSTAL_TYPE = "postal_type";
            public static final String POSTAL_ISPRIMARY = "postal_isprimary";
            public static final String IM_HANDLE = "im_handle";
            public static final String IM_PROTOCOL = "im_protocol";
            public static final String IM_ISPRIMARY = "im_isprimary";
            public static final String DATA = "data";
            public static final String EXTRA_ACCOUNT = "android.provider.extra.ACCOUNT";
            public static final String EXTRA_DATA_SET = "android.provider.extra.DATA_SET";
        }
    }

    public static class DisplayPhoto {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "display_photo");
        public static final Uri CONTENT_MAX_DIMENSIONS_URI = Uri.withAppendedPath(AUTHORITY_URI, "photo_dimensions");
        public static final String DISPLAY_MAX_DIM = "display_max_dim";
        public static final String THUMBNAIL_MAX_DIM = "thumbnail_max_dim";

        private DisplayPhoto() {
        }
    }

    public static class QuickContact {
        public static final String ACTION_QUICK_CONTACT = "android.provider.action.QUICK_CONTACT";
        @Deprecated
        public static final String EXTRA_TARGET_RECT = "android.provider.extra.TARGET_RECT";
        public static final String EXTRA_MODE = "android.provider.extra.MODE";
        public static final String EXTRA_PRIORITIZED_MIMETYPE = "android.provider.extra.PRIORITIZED_MIMETYPE";
        public static final String EXTRA_EXCLUDE_MIMES = "android.provider.extra.EXCLUDE_MIMES";
        public static final int MODE_SMALL = 1;
        public static final int MODE_MEDIUM = 2;
        public static final int MODE_LARGE = 3;
        public static final int MODE_DEFAULT = 3;

        public static Intent composeQuickContactsIntent(Context context, View target, Uri lookupUri, int mode, String[] excludeMimes) {
            float appScale = context.getResources().getCompatibilityInfo().applicationScale;
            int[] pos = new int[2];
            target.getLocationOnScreen(pos);
            Rect rect = new Rect();
            rect.left = (int)((float)pos[0] * appScale + 0.5f);
            rect.top = (int)((float)pos[1] * appScale + 0.5f);
            rect.right = (int)((float)(pos[0] + target.getWidth()) * appScale + 0.5f);
            rect.bottom = (int)((float)(pos[1] + target.getHeight()) * appScale + 0.5f);
            return QuickContact.composeQuickContactsIntent(context, rect, lookupUri, mode, excludeMimes);
        }

        @UnsupportedAppUsage
        public static Intent composeQuickContactsIntent(Context context, Rect target, Uri lookupUri, int mode, String[] excludeMimes) {
            Context actualContext = context;
            while (actualContext instanceof ContextWrapper && !(actualContext instanceof Activity)) {
                actualContext = ((ContextWrapper)actualContext).getBaseContext();
            }
            int intentFlags = (actualContext instanceof Activity ? 0 : 0x10008000) | 0x20000000;
            Intent intent = new Intent(ACTION_QUICK_CONTACT).addFlags(intentFlags);
            intent.setData(lookupUri);
            intent.setSourceBounds(target);
            intent.putExtra(EXTRA_MODE, mode);
            intent.putExtra(EXTRA_EXCLUDE_MIMES, excludeMimes);
            return intent;
        }

        public static Intent rebuildManagedQuickContactsIntent(String lookupKey, long contactId, boolean isContactIdIgnored, long directoryId, Intent originalIntent) {
            Intent intent = new Intent(ACTION_QUICK_CONTACT);
            Uri uri = null;
            if (!TextUtils.isEmpty(lookupKey)) {
                Uri uri2 = uri = isContactIdIgnored ? Uri.withAppendedPath(Contacts.CONTENT_LOOKUP_URI, lookupKey) : Contacts.getLookupUri(contactId, lookupKey);
            }
            if (uri != null && directoryId != 0L) {
                uri = uri.buildUpon().appendQueryParameter(ContactsContract.DIRECTORY_PARAM_KEY, String.valueOf(directoryId)).build();
            }
            intent.setData(uri);
            intent.setFlags(originalIntent.getFlags() | 0x10000000);
            intent.setSourceBounds(originalIntent.getSourceBounds());
            intent.putExtra(EXTRA_MODE, originalIntent.getIntExtra(EXTRA_MODE, 3));
            intent.putExtra(EXTRA_EXCLUDE_MIMES, originalIntent.getStringArrayExtra(EXTRA_EXCLUDE_MIMES));
            return intent;
        }

        public static void showQuickContact(Context context, View target, Uri lookupUri, int mode, String[] excludeMimes) {
            Intent intent = QuickContact.composeQuickContactsIntent(context, target, lookupUri, mode, excludeMimes);
            ContactsInternal.startQuickContactWithErrorToast(context, intent);
        }

        public static void showQuickContact(Context context, Rect target, Uri lookupUri, int mode, String[] excludeMimes) {
            Intent intent = QuickContact.composeQuickContactsIntent(context, target, lookupUri, mode, excludeMimes);
            ContactsInternal.startQuickContactWithErrorToast(context, intent);
        }

        public static void showQuickContact(Context context, View target, Uri lookupUri, String[] excludeMimes, String prioritizedMimeType) {
            Intent intent = QuickContact.composeQuickContactsIntent(context, target, lookupUri, 3, excludeMimes);
            intent.putExtra(EXTRA_PRIORITIZED_MIMETYPE, prioritizedMimeType);
            ContactsInternal.startQuickContactWithErrorToast(context, intent);
        }

        public static void showQuickContact(Context context, Rect target, Uri lookupUri, String[] excludeMimes, String prioritizedMimeType) {
            Intent intent = QuickContact.composeQuickContactsIntent(context, target, lookupUri, 3, excludeMimes);
            intent.putExtra(EXTRA_PRIORITIZED_MIMETYPE, prioritizedMimeType);
            ContactsInternal.startQuickContactWithErrorToast(context, intent);
        }
    }

    public static class PinnedPositions {
        public static final String UNDEMOTE_METHOD = "undemote";
        public static final int UNPINNED = 0;
        public static final int DEMOTED = -1;

        public static void undemote(ContentResolver contentResolver, long contactId) {
            contentResolver.call(AUTHORITY_URI, UNDEMOTE_METHOD, String.valueOf(contactId), null);
        }

        public static void pin(ContentResolver contentResolver, long contactId, int pinnedPosition) {
            Uri uri = Uri.withAppendedPath(Contacts.CONTENT_URI, String.valueOf(contactId));
            ContentValues values = new ContentValues();
            values.put("pinned", pinnedPosition);
            contentResolver.update(uri, values, null, null);
        }
    }

    @Deprecated
    public static class DataUsageFeedback {
        public static final Uri FEEDBACK_URI = Uri.withAppendedPath(Data.CONTENT_URI, "usagefeedback");
        public static final Uri DELETE_USAGE_URI = Uri.withAppendedPath(Contacts.CONTENT_URI, "delete_usage");
        public static final String USAGE_TYPE = "type";
        public static final String USAGE_TYPE_CALL = "call";
        public static final String USAGE_TYPE_LONG_TEXT = "long_text";
        public static final String USAGE_TYPE_SHORT_TEXT = "short_text";
    }

    public static class ProviderStatus {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "provider_status");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/provider_status";
        public static final String STATUS = "status";
        public static final int STATUS_NORMAL = 0;
        public static final int STATUS_BUSY = 1;
        public static final int STATUS_EMPTY = 2;
        public static final String DATABASE_CREATION_TIMESTAMP = "database_creation_timestamp";

        private ProviderStatus() {
        }
    }

    public static class Settings
    implements SettingsColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "settings");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/setting";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/setting";

        private Settings() {
        }
    }

    protected static interface SettingsColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String DATA_SET = "data_set";
        public static final String SHOULD_SYNC = "should_sync";
        public static final String UNGROUPED_VISIBLE = "ungrouped_visible";
        public static final String ANY_UNSYNCED = "any_unsynced";
        public static final String UNGROUPED_COUNT = "summ_count";
        public static final String UNGROUPED_WITH_PHONES = "summ_phones";
    }

    public static class SimAccount
    implements Parcelable {
        public static final int UNKNOWN_EF_TYPE = 0;
        public static final int ADN_EF_TYPE = 1;
        public static final int FDN_EF_TYPE = 2;
        public static final int SDN_EF_TYPE = 3;
        private final String mAccountName;
        private final String mAccountType;
        private final int mSimSlotIndex;
        private final int mEfType;
        public static final Parcelable.Creator<SimAccount> CREATOR = new Parcelable.Creator<SimAccount>(){

            @Override
            public SimAccount createFromParcel(Parcel source) {
                String accountName = source.readString();
                String accountType = source.readString();
                int simSlot = source.readInt();
                int efType = source.readInt();
                SimAccount simAccount = new SimAccount(accountName, accountType, simSlot, efType);
                return simAccount;
            }

            public SimAccount[] newArray(int size) {
                return new SimAccount[size];
            }
        };

        public static Set<Integer> getValidEfTypes() {
            return Sets.newArraySet(1, 3, 2);
        }

        public SimAccount(String accountName, String accountType, int simSlotIndex, int efType) {
            this.mAccountName = accountName;
            this.mAccountType = accountType;
            this.mSimSlotIndex = simSlotIndex;
            this.mEfType = efType;
        }

        public String getAccountName() {
            return this.mAccountName;
        }

        public String getAccountType() {
            return this.mAccountType;
        }

        public int getSimSlotIndex() {
            return this.mSimSlotIndex;
        }

        public int getEfType() {
            return this.mEfType;
        }

        public int hashCode() {
            return Objects.hash(this.mAccountName, this.mAccountType, this.mSimSlotIndex, this.mEfType);
        }

        public boolean equals(Object obj) {
            SimAccount toCompare;
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            try {
                toCompare = (SimAccount)obj;
            }
            catch (ClassCastException ex) {
                return false;
            }
            return this.mSimSlotIndex == toCompare.mSimSlotIndex && this.mEfType == toCompare.mEfType && Objects.equals(this.mAccountName, toCompare.mAccountName) && Objects.equals(this.mAccountType, toCompare.mAccountType);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mAccountName);
            dest.writeString(this.mAccountType);
            dest.writeInt(this.mSimSlotIndex);
            dest.writeInt(this.mEfType);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class SimContacts {
        public static final String ADD_SIM_ACCOUNT_METHOD = "addSimAccount";
        public static final String REMOVE_SIM_ACCOUNT_METHOD = "removeSimAccount";
        public static final String QUERY_SIM_ACCOUNTS_METHOD = "querySimAccounts";
        public static final String KEY_SIM_SLOT_INDEX = "key_sim_slot_index";
        public static final String KEY_SIM_EF_TYPE = "key_sim_ef_type";
        public static final String KEY_ACCOUNT_NAME = "key_sim_account_name";
        public static final String KEY_ACCOUNT_TYPE = "key_sim_account_type";
        public static final String KEY_SIM_ACCOUNTS = "key_sim_accounts";
        public static final String ACTION_SIM_ACCOUNTS_CHANGED = "android.provider.action.SIM_ACCOUNTS_CHANGED";

        private SimContacts() {
        }

        @SystemApi
        @RequiresPermission(value="android.contacts.permission.MANAGE_SIM_ACCOUNTS")
        public static void addSimAccount(ContentResolver contentResolver, String accountName, String accountType, int simSlotIndex, int efType) {
            if (simSlotIndex < 0) {
                throw new IllegalArgumentException("Sim slot is negative");
            }
            if (!SimAccount.getValidEfTypes().contains(efType)) {
                throw new IllegalArgumentException("Invalid EF type");
            }
            if (TextUtils.isEmpty(accountName) || TextUtils.isEmpty(accountType)) {
                throw new IllegalArgumentException("Account name or type is empty");
            }
            Bundle extras = new Bundle();
            extras.putInt(KEY_SIM_SLOT_INDEX, simSlotIndex);
            extras.putInt(KEY_SIM_EF_TYPE, efType);
            extras.putString(KEY_ACCOUNT_NAME, accountName);
            extras.putString(KEY_ACCOUNT_TYPE, accountType);
            contentResolver.call(AUTHORITY_URI, ADD_SIM_ACCOUNT_METHOD, null, extras);
        }

        @SystemApi
        @RequiresPermission(value="android.contacts.permission.MANAGE_SIM_ACCOUNTS")
        public static void removeSimAccounts(ContentResolver contentResolver, int simSlotIndex) {
            if (simSlotIndex < 0) {
                throw new IllegalArgumentException("Sim slot is negative");
            }
            Bundle extras = new Bundle();
            extras.putInt(KEY_SIM_SLOT_INDEX, simSlotIndex);
            contentResolver.call(AUTHORITY_URI, REMOVE_SIM_ACCOUNT_METHOD, null, extras);
        }

        public static List<SimAccount> getSimAccounts(ContentResolver contentResolver) {
            Bundle response = contentResolver.call(AUTHORITY_URI, QUERY_SIM_ACCOUNTS_METHOD, null, null);
            ArrayList<SimAccount> result = response.getParcelableArrayList(KEY_SIM_ACCOUNTS);
            if (result == null) {
                result = new ArrayList();
            }
            return result;
        }
    }

    public static class AggregationExceptions
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "aggregation_exceptions");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/aggregation_exception";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/aggregation_exception";
        public static final String TYPE = "type";
        public static final int TYPE_AUTOMATIC = 0;
        public static final int TYPE_KEEP_TOGETHER = 1;
        public static final int TYPE_KEEP_SEPARATE = 2;
        public static final String RAW_CONTACT_ID1 = "raw_contact_id1";
        public static final String RAW_CONTACT_ID2 = "raw_contact_id2";

        private AggregationExceptions() {
        }
    }

    public static class Groups
    implements BaseColumns,
    GroupsColumns,
    SyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups");
        public static final Uri CONTENT_SUMMARY_URI = Uri.withAppendedPath(AUTHORITY_URI, "groups_summary");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/group";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group";

        private Groups() {
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                ContentValues values = new ContentValues();
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "account_type");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "res_package");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "title_res");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "group_visible");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "system_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, values, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "notes");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "should_sync");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "favorites");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, values, "auto_add");
                cursor.moveToNext();
                return new Entity(values);
            }
        }
    }

    protected static interface GroupsColumns {
        public static final String DATA_SET = "data_set";
        public static final String ACCOUNT_TYPE_AND_DATA_SET = "account_type_and_data_set";
        public static final String TITLE = "title";
        public static final String RES_PACKAGE = "res_package";
        public static final String TITLE_RES = "title_res";
        public static final String NOTES = "notes";
        public static final String SYSTEM_ID = "system_id";
        public static final String SUMMARY_COUNT = "summ_count";
        public static final String PARAM_RETURN_GROUP_COUNT_PER_ACCOUNT = "return_group_count_per_account";
        public static final String SUMMARY_GROUP_COUNT_PER_ACCOUNT = "group_count_per_account";
        public static final String SUMMARY_WITH_PHONES = "summ_phones";
        public static final String GROUP_VISIBLE = "group_visible";
        public static final String DELETED = "deleted";
        public static final String SHOULD_SYNC = "should_sync";
        public static final String AUTO_ADD = "auto_add";
        public static final String FAVORITES = "favorites";
        public static final String GROUP_IS_READ_ONLY = "group_is_read_only";
    }

    public static class CommonDataKinds {
        public static final String PACKAGE_COMMON = "common";

        private CommonDataKinds() {
        }

        public static class Contactables
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "contactables");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final String VISIBLE_CONTACTS_ONLY = "visible_contacts_only";
        }

        public static class Callable
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "callables");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final Uri ENTERPRISE_CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter_enterprise");
        }

        public static class Identity
        implements DataColumnsWithJoins,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/identity";
            public static final String IDENTITY = "data1";
            public static final String NAMESPACE = "data2";

            private Identity() {
            }
        }

        public static class SipAddress
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/sip_address";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String SIP_ADDRESS = "data1";

            private SipAddress() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17041413;
                    }
                    case 2: {
                        return 17041415;
                    }
                    case 3: {
                        return 17041414;
                    }
                }
                return 17041412;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = SipAddress.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Website
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/website";
            public static final int TYPE_HOMEPAGE = 1;
            public static final int TYPE_BLOG = 2;
            public static final int TYPE_PROFILE = 3;
            public static final int TYPE_HOME = 4;
            public static final int TYPE_WORK = 5;
            public static final int TYPE_FTP = 6;
            public static final int TYPE_OTHER = 7;
            public static final String URL = "data1";

            private Website() {
            }
        }

        public static class GroupMembership
        implements DataColumnsWithJoins,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/group_membership";
            public static final String GROUP_ROW_ID = "data1";
            public static final String GROUP_SOURCE_ID = "group_sourceid";

            private GroupMembership() {
            }
        }

        public static class Note
        implements DataColumnsWithJoins,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/note";
            public static final String NOTE = "data1";

            private Note() {
            }
        }

        public static class Photo
        implements DataColumnsWithJoins,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/photo";
            public static final String PHOTO_FILE_ID = "data14";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static class Event
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_event";
            public static final int TYPE_ANNIVERSARY = 1;
            public static final int TYPE_OTHER = 2;
            public static final int TYPE_BIRTHDAY = 3;
            public static final String START_DATE = "data1";

            private Event() {
            }

            public static int getTypeResource(Integer type) {
                if (type == null) {
                    return 17040151;
                }
                switch (type) {
                    case 1: {
                        return 17040148;
                    }
                    case 3: {
                        return 17040149;
                    }
                    case 2: {
                        return 17040151;
                    }
                }
                return 17040150;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Event.getTypeResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Relation
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/relation";
            public static final int TYPE_ASSISTANT = 1;
            public static final int TYPE_BROTHER = 2;
            public static final int TYPE_CHILD = 3;
            public static final int TYPE_DOMESTIC_PARTNER = 4;
            public static final int TYPE_FATHER = 5;
            public static final int TYPE_FRIEND = 6;
            public static final int TYPE_MANAGER = 7;
            public static final int TYPE_MOTHER = 8;
            public static final int TYPE_PARENT = 9;
            public static final int TYPE_PARTNER = 10;
            public static final int TYPE_REFERRED_BY = 11;
            public static final int TYPE_RELATIVE = 12;
            public static final int TYPE_SISTER = 13;
            public static final int TYPE_SPOUSE = 14;
            public static final String NAME = "data1";

            private Relation() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17041252;
                    }
                    case 2: {
                        return 17041253;
                    }
                    case 3: {
                        return 17041254;
                    }
                    case 4: {
                        return 17041256;
                    }
                    case 5: {
                        return 17041257;
                    }
                    case 6: {
                        return 17041258;
                    }
                    case 7: {
                        return 17041259;
                    }
                    case 8: {
                        return 17041260;
                    }
                    case 9: {
                        return 17041261;
                    }
                    case 10: {
                        return 17041262;
                    }
                    case 11: {
                        return 17041263;
                    }
                    case 12: {
                        return 17041264;
                    }
                    case 13: {
                        return 17041265;
                    }
                    case 14: {
                        return 17041266;
                    }
                }
                return 17040841;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Relation.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Organization
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/organization";
            public static final int TYPE_WORK = 1;
            public static final int TYPE_OTHER = 2;
            public static final String COMPANY = "data1";
            public static final String TITLE = "data4";
            public static final String DEPARTMENT = "data5";
            public static final String JOB_DESCRIPTION = "data6";
            public static final String SYMBOL = "data7";
            public static final String PHONETIC_NAME = "data8";
            public static final String OFFICE_LOCATION = "data9";
            public static final String PHONETIC_NAME_STYLE = "data10";

            private Organization() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17040843;
                    }
                    case 2: {
                        return 17040842;
                    }
                }
                return 17040841;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Organization.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Im
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/im";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String PROTOCOL = "data5";
            public static final String CUSTOM_PROTOCOL = "data6";
            public static final int PROTOCOL_CUSTOM = -1;
            @Deprecated
            public static final int PROTOCOL_AIM = 0;
            @Deprecated
            public static final int PROTOCOL_MSN = 1;
            @Deprecated
            public static final int PROTOCOL_YAHOO = 2;
            @Deprecated
            public static final int PROTOCOL_SKYPE = 3;
            @Deprecated
            public static final int PROTOCOL_QQ = 4;
            @Deprecated
            public static final int PROTOCOL_GOOGLE_TALK = 5;
            @Deprecated
            public static final int PROTOCOL_ICQ = 6;
            @Deprecated
            public static final int PROTOCOL_JABBER = 7;
            @Deprecated
            public static final int PROTOCOL_NETMEETING = 8;

            private Im() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17040389;
                    }
                    case 2: {
                        return 17040391;
                    }
                    case 3: {
                        return 17040390;
                    }
                }
                return 0x1040404;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Im.getTypeLabelResource(type);
                return res.getText(labelRes);
            }

            public static int getProtocolLabelResource(int type) {
                switch (type) {
                    case 0: {
                        return 17040378;
                    }
                    case 1: {
                        return 17040383;
                    }
                    case 2: {
                        return 17040387;
                    }
                    case 3: {
                        return 17040386;
                    }
                    case 4: {
                        return 0x1040401;
                    }
                    case 5: {
                        return 17040380;
                    }
                    case 6: {
                        return 17040381;
                    }
                    case 7: {
                        return 17040382;
                    }
                    case 8: {
                        return 0x1040400;
                    }
                }
                return 17040379;
            }

            public static CharSequence getProtocolLabel(Resources res, int type, CharSequence label) {
                if (type == -1 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Im.getProtocolLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class StructuredPostal
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/postal-address_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/postal-address_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "postals");
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final String FORMATTED_ADDRESS = "data1";
            public static final String STREET = "data4";
            public static final String POBOX = "data5";
            public static final String NEIGHBORHOOD = "data6";
            public static final String CITY = "data7";
            public static final String REGION = "data8";
            public static final String POSTCODE = "data9";
            public static final String COUNTRY = "data10";

            private StructuredPostal() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17041218;
                    }
                    case 2: {
                        return 17041220;
                    }
                    case 3: {
                        return 17041219;
                    }
                }
                return 17041217;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = StructuredPostal.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Email
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/email_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/email_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "emails");
            public static final Uri CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
            public static final Uri ENTERPRISE_CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup_enterprise");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final Uri ENTERPRISE_CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter_enterprise");
            public static final String ADDRESS = "data1";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_WORK = 2;
            public static final int TYPE_OTHER = 3;
            public static final int TYPE_MOBILE = 4;
            public static final String DISPLAY_NAME = "data4";

            private Email() {
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17040132;
                    }
                    case 2: {
                        return 17040135;
                    }
                    case 3: {
                        return 17040134;
                    }
                    case 4: {
                        return 17040133;
                    }
                }
                return 17040131;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (type == 0 && !TextUtils.isEmpty(label)) {
                    return label;
                }
                int labelRes = Email.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Phone
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/phone_v2";
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_v2";
            public static final Uri CONTENT_URI = Uri.withAppendedPath(Data.CONTENT_URI, "phones");
            @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
            public static final Uri ENTERPRISE_CONTENT_URI = Uri.withAppendedPath(Data.ENTERPRISE_CONTENT_URI, "phones");
            public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
            public static final Uri ENTERPRISE_CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter_enterprise");
            public static final String SEARCH_DISPLAY_NAME_KEY = "search_display_name";
            public static final String SEARCH_PHONE_NUMBER_KEY = "search_phone_number";
            public static final int TYPE_HOME = 1;
            public static final int TYPE_MOBILE = 2;
            public static final int TYPE_WORK = 3;
            public static final int TYPE_FAX_WORK = 4;
            public static final int TYPE_FAX_HOME = 5;
            public static final int TYPE_PAGER = 6;
            public static final int TYPE_OTHER = 7;
            public static final int TYPE_CALLBACK = 8;
            public static final int TYPE_CAR = 9;
            public static final int TYPE_COMPANY_MAIN = 10;
            public static final int TYPE_ISDN = 11;
            public static final int TYPE_MAIN = 12;
            public static final int TYPE_OTHER_FAX = 13;
            public static final int TYPE_RADIO = 14;
            public static final int TYPE_TELEX = 15;
            public static final int TYPE_TTY_TDD = 16;
            public static final int TYPE_WORK_MOBILE = 17;
            public static final int TYPE_WORK_PAGER = 18;
            public static final int TYPE_ASSISTANT = 19;
            public static final int TYPE_MMS = 20;
            public static final String NUMBER = "data1";
            public static final String NORMALIZED_NUMBER = "data4";

            private Phone() {
            }

            @Deprecated
            public static CharSequence getDisplayLabel(Context context, int type, CharSequence label, CharSequence[] labelArray) {
                return Phone.getTypeLabel(context.getResources(), type, label);
            }

            @Deprecated
            @UnsupportedAppUsage
            public static CharSequence getDisplayLabel(Context context, int type, CharSequence label) {
                return Phone.getTypeLabel(context.getResources(), type, label);
            }

            public static int getTypeLabelResource(int type) {
                switch (type) {
                    case 1: {
                        return 17041177;
                    }
                    case 2: {
                        return 17041181;
                    }
                    case 3: {
                        return 17041188;
                    }
                    case 4: {
                        return 17041176;
                    }
                    case 5: {
                        return 17041175;
                    }
                    case 6: {
                        return 17041184;
                    }
                    case 7: {
                        return 17041182;
                    }
                    case 8: {
                        return 17041171;
                    }
                    case 9: {
                        return 17041172;
                    }
                    case 10: {
                        return 17041173;
                    }
                    case 11: {
                        return 17041178;
                    }
                    case 12: {
                        return 17041179;
                    }
                    case 13: {
                        return 17041183;
                    }
                    case 14: {
                        return 17041185;
                    }
                    case 15: {
                        return 17041186;
                    }
                    case 16: {
                        return 17041187;
                    }
                    case 17: {
                        return 17041189;
                    }
                    case 18: {
                        return 17041190;
                    }
                    case 19: {
                        return 17041170;
                    }
                    case 20: {
                        return 17041180;
                    }
                }
                return 17041174;
            }

            public static CharSequence getTypeLabel(Resources res, int type, CharSequence label) {
                if (!(type != 0 && type != 19 || TextUtils.isEmpty(label))) {
                    return label;
                }
                int labelRes = Phone.getTypeLabelResource(type);
                return res.getText(labelRes);
            }
        }

        public static class Nickname
        implements DataColumnsWithJoins,
        CommonColumns,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/nickname";
            public static final int TYPE_DEFAULT = 1;
            public static final int TYPE_OTHER_NAME = 2;
            public static final int TYPE_MAIDEN_NAME = 3;
            @Deprecated
            public static final int TYPE_MAINDEN_NAME = 3;
            public static final int TYPE_SHORT_NAME = 4;
            public static final int TYPE_INITIALS = 5;
            public static final String NAME = "data1";

            private Nickname() {
            }
        }

        public static class StructuredName
        implements DataColumnsWithJoins,
        ContactCounts {
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/name";
            public static final String DISPLAY_NAME = "data1";
            public static final String GIVEN_NAME = "data2";
            public static final String FAMILY_NAME = "data3";
            public static final String PREFIX = "data4";
            public static final String MIDDLE_NAME = "data5";
            public static final String SUFFIX = "data6";
            public static final String PHONETIC_GIVEN_NAME = "data7";
            public static final String PHONETIC_MIDDLE_NAME = "data8";
            public static final String PHONETIC_FAMILY_NAME = "data9";
            public static final String FULL_NAME_STYLE = "data10";
            public static final String PHONETIC_NAME_STYLE = "data11";

            private StructuredName() {
            }
        }

        protected static interface CommonColumns
        extends BaseTypes {
            public static final String DATA = "data1";
            public static final String TYPE = "data2";
            public static final String LABEL = "data3";
        }

        public static interface BaseTypes {
            public static final int TYPE_CUSTOM = 0;
        }
    }

    public static class SearchSnippets {
        public static final String SNIPPET = "snippet";
        public static final String SNIPPET_ARGS_PARAM_KEY = "snippet_args";
        public static final String DEFERRED_SNIPPETING_KEY = "deferred_snippeting";
    }

    @Deprecated
    public static class Presence
    extends StatusUpdates {
    }

    public static class StatusUpdates
    implements StatusColumns,
    PresenceColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "status_updates");
        public static final Uri PROFILE_CONTENT_URI = Uri.withAppendedPath(Profile.CONTENT_URI, "status_updates");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/status-update";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/status-update";

        private StatusUpdates() {
        }

        public static int getPresenceIconResourceId(int status) {
            switch (status) {
                case 5: {
                    return 17301611;
                }
                case 2: 
                case 3: {
                    return 17301607;
                }
                case 4: {
                    return 17301608;
                }
                case 1: {
                    return 17301609;
                }
            }
            return 17301610;
        }

        public static int getPresencePrecedence(int status) {
            return status;
        }
    }

    protected static interface PresenceColumns {
        public static final String DATA_ID = "presence_data_id";
        public static final String PROTOCOL = "protocol";
        public static final String CUSTOM_PROTOCOL = "custom_protocol";
        public static final String IM_HANDLE = "im_handle";
        public static final String IM_ACCOUNT = "im_account";
    }

    public static class PhoneLookup
    implements BaseColumns,
    PhoneLookupColumns,
    ContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns {
        public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(AUTHORITY_URI, "phone_lookup");
        public static final Uri ENTERPRISE_CONTENT_FILTER_URI = Uri.withAppendedPath(AUTHORITY_URI, "phone_lookup_enterprise");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/phone_lookup";
        public static final String QUERY_PARAMETER_SIP_ADDRESS = "sip";

        private PhoneLookup() {
        }
    }

    protected static interface PhoneLookupColumns {
        public static final String DATA_ID = "data_id";
        public static final String CONTACT_ID = "contact_id";
        public static final String NUMBER = "number";
        public static final String TYPE = "type";
        public static final String LABEL = "label";
        public static final String NORMALIZED_NUMBER = "normalized_number";
    }

    public static class RawContactsEntity
    implements BaseColumns,
    DataColumns,
    RawContactsColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contact_entities");
        public static final Uri CORP_CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contact_entities_corp");
        public static final Uri PROFILE_CONTENT_URI = Uri.withAppendedPath(Profile.CONTENT_URI, "raw_contact_entities");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact_entity";
        public static final String FOR_EXPORT_ONLY = "for_export_only";
        public static final String DATA_ID = "data_id";

        private RawContactsEntity() {
        }
    }

    public static class Data
    implements DataColumnsWithJoins,
    ContactCounts {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "data");
        static final Uri ENTERPRISE_CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "data_enterprise");
        public static final String VISIBLE_CONTACTS_ONLY = "visible_contacts_only";
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/data";

        private Data() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getContactLookupUri(ContentResolver resolver, Uri dataUri) {
            Uri lookupUri = null;
            try (Cursor cursor = resolver.query(dataUri, new String[]{"contact_id", "lookup"}, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    long contactId = cursor.getLong(0);
                    String lookupKey = cursor.getString(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            return lookupUri;
        }
    }

    protected static interface DataColumnsWithJoins
    extends BaseColumns,
    DataColumns,
    StatusColumns,
    RawContactsColumns,
    ContactsColumns,
    ContactNameColumns,
    ContactOptionsColumns,
    ContactStatusColumns,
    DataUsageStatColumns {
    }

    protected static interface DataUsageStatColumns {
        @Deprecated
        public static final String LAST_TIME_USED = "last_time_used";
        @Deprecated
        public static final String TIMES_USED = "times_used";
        public static final String RAW_LAST_TIME_USED = "x_last_time_used";
        public static final String RAW_TIMES_USED = "x_times_used";
        public static final String LR_LAST_TIME_USED = "last_time_used";
        public static final String LR_TIMES_USED = "times_used";
    }

    protected static interface DataColumns {
        public static final String RES_PACKAGE = "res_package";
        public static final String MIMETYPE = "mimetype";
        @Deprecated
        public static final String HASH_ID = "hash_id";
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        public static final String IS_PRIMARY = "is_primary";
        public static final String IS_SUPER_PRIMARY = "is_super_primary";
        public static final String IS_READ_ONLY = "is_read_only";
        public static final String DATA_VERSION = "data_version";
        public static final String DATA1 = "data1";
        public static final String DATA2 = "data2";
        public static final String DATA3 = "data3";
        public static final String DATA4 = "data4";
        public static final String DATA5 = "data5";
        public static final String DATA6 = "data6";
        public static final String DATA7 = "data7";
        public static final String DATA8 = "data8";
        public static final String DATA9 = "data9";
        public static final String DATA10 = "data10";
        public static final String DATA11 = "data11";
        public static final String DATA12 = "data12";
        public static final String DATA13 = "data13";
        public static final String DATA14 = "data14";
        public static final String DATA15 = "data15";
        public static final String SYNC1 = "data_sync1";
        public static final String SYNC2 = "data_sync2";
        public static final String SYNC3 = "data_sync3";
        public static final String SYNC4 = "data_sync4";
        @Deprecated
        public static final String CARRIER_PRESENCE = "carrier_presence";
        @Deprecated
        public static final int CARRIER_PRESENCE_VT_CAPABLE = 1;
        public static final String PREFERRED_PHONE_ACCOUNT_COMPONENT_NAME = "preferred_phone_account_component_name";
        public static final String PREFERRED_PHONE_ACCOUNT_ID = "preferred_phone_account_id";
    }

    protected static interface PhotoFilesColumns {
        public static final String HEIGHT = "height";
        public static final String WIDTH = "width";
        public static final String FILESIZE = "filesize";
    }

    public static class PhotoFiles
    implements BaseColumns,
    PhotoFilesColumns {
        private PhotoFiles() {
        }
    }

    @Deprecated
    protected static interface StreamItemPhotosColumns {
        @Deprecated
        public static final String STREAM_ITEM_ID = "stream_item_id";
        @Deprecated
        public static final String SORT_INDEX = "sort_index";
        @Deprecated
        public static final String PHOTO_FILE_ID = "photo_file_id";
        @Deprecated
        public static final String PHOTO_URI = "photo_uri";
        @Deprecated
        public static final String SYNC1 = "stream_item_photo_sync1";
        @Deprecated
        public static final String SYNC2 = "stream_item_photo_sync2";
        @Deprecated
        public static final String SYNC3 = "stream_item_photo_sync3";
        @Deprecated
        public static final String SYNC4 = "stream_item_photo_sync4";
    }

    @Deprecated
    public static class StreamItemPhotos
    implements BaseColumns,
    StreamItemPhotosColumns {
        @Deprecated
        public static final String PHOTO = "photo";

        @Deprecated
        private StreamItemPhotos() {
        }
    }

    @Deprecated
    protected static interface StreamItemsColumns {
        @Deprecated
        public static final String CONTACT_ID = "contact_id";
        @Deprecated
        public static final String CONTACT_LOOKUP_KEY = "contact_lookup";
        @Deprecated
        public static final String RAW_CONTACT_ID = "raw_contact_id";
        @Deprecated
        public static final String RES_PACKAGE = "res_package";
        @Deprecated
        public static final String ACCOUNT_TYPE = "account_type";
        @Deprecated
        public static final String ACCOUNT_NAME = "account_name";
        @Deprecated
        public static final String DATA_SET = "data_set";
        @Deprecated
        public static final String RAW_CONTACT_SOURCE_ID = "raw_contact_source_id";
        @Deprecated
        public static final String RES_ICON = "icon";
        @Deprecated
        public static final String RES_LABEL = "label";
        @Deprecated
        public static final String TEXT = "text";
        @Deprecated
        public static final String TIMESTAMP = "timestamp";
        @Deprecated
        public static final String COMMENTS = "comments";
        @Deprecated
        public static final String SYNC1 = "stream_item_sync1";
        @Deprecated
        public static final String SYNC2 = "stream_item_sync2";
        @Deprecated
        public static final String SYNC3 = "stream_item_sync3";
        @Deprecated
        public static final String SYNC4 = "stream_item_sync4";
    }

    @Deprecated
    public static class StreamItems
    implements BaseColumns,
    StreamItemsColumns {
        @Deprecated
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "stream_items");
        @Deprecated
        public static final Uri CONTENT_PHOTO_URI = Uri.withAppendedPath(CONTENT_URI, "photo");
        @Deprecated
        public static final Uri CONTENT_LIMIT_URI = Uri.withAppendedPath(AUTHORITY_URI, "stream_items_limit");
        @Deprecated
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/stream_item";
        @Deprecated
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/stream_item";
        @Deprecated
        public static final String MAX_ITEMS = "max_items";

        @Deprecated
        private StreamItems() {
        }

        @Deprecated
        public static class StreamItemPhotos
        implements BaseColumns,
        StreamItemPhotosColumns {
            @Deprecated
            public static final String CONTENT_DIRECTORY = "photo";
            @Deprecated
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/stream_item_photo";
            @Deprecated
            public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/stream_item_photo";

            @Deprecated
            private StreamItemPhotos() {
            }
        }
    }

    protected static interface StatusColumns {
        public static final String PRESENCE = "mode";
        @Deprecated
        public static final String PRESENCE_STATUS = "mode";
        public static final int OFFLINE = 0;
        public static final int INVISIBLE = 1;
        public static final int AWAY = 2;
        public static final int IDLE = 3;
        public static final int DO_NOT_DISTURB = 4;
        public static final int AVAILABLE = 5;
        public static final String STATUS = "status";
        @Deprecated
        public static final String PRESENCE_CUSTOM_STATUS = "status";
        public static final String STATUS_TIMESTAMP = "status_ts";
        public static final String STATUS_RES_PACKAGE = "status_res_package";
        public static final String STATUS_LABEL = "status_label";
        public static final String STATUS_ICON = "status_icon";
        public static final String CHAT_CAPABILITY = "chat_capability";
        public static final int CAPABILITY_HAS_VOICE = 1;
        public static final int CAPABILITY_HAS_VIDEO = 2;
        public static final int CAPABILITY_HAS_CAMERA = 4;
    }

    public static class RawContacts
    implements BaseColumns,
    RawContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    SyncColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "raw_contacts");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/raw_contact";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/raw_contact";
        public static final int AGGREGATION_MODE_DEFAULT = 0;
        @Deprecated
        public static final int AGGREGATION_MODE_IMMEDIATE = 1;
        public static final int AGGREGATION_MODE_SUSPENDED = 2;
        public static final int AGGREGATION_MODE_DISABLED = 3;

        private RawContacts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getContactLookupUri(ContentResolver resolver, Uri rawContactUri) {
            Uri dataUri = Uri.withAppendedPath(rawContactUri, "data");
            Uri lookupUri = null;
            try (Cursor cursor = resolver.query(dataUri, new String[]{"contact_id", "lookup"}, null, null, null);){
                if (cursor != null && cursor.moveToFirst()) {
                    long contactId = cursor.getLong(0);
                    String lookupKey = cursor.getString(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            return lookupUri;
        }

        public static String getLocalAccountName(Context context) {
            return TextUtils.nullIfEmpty(context.getString(17039983));
        }

        public static String getLocalAccountType(Context context) {
            return TextUtils.nullIfEmpty(context.getString(17039984));
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            private static final String[] DATA_KEYS = new String[]{"data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "data11", "data12", "data13", "data14", "data15", "data_sync1", "data_sync2", "data_sync3", "data_sync4"};

            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            @Override
            public android.content.Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                int columnRawContactId = cursor.getColumnIndexOrThrow("_id");
                long rawContactId = cursor.getLong(columnRawContactId);
                ContentValues cv = new ContentValues();
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_type");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "data_set");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "version");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sourceid");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync4");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "deleted");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "contact_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "starred");
                android.content.Entity contact = new android.content.Entity(cv);
                while (rawContactId == cursor.getLong(columnRawContactId)) {
                    cv = new ContentValues();
                    cv.put("_id", cursor.getLong(cursor.getColumnIndexOrThrow("data_id")));
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "res_package");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mimetype");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "is_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "is_super_primary");
                    DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "data_version");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "group_sourceid");
                    DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "data_version");
                    block6: for (String key : DATA_KEYS) {
                        int columnIndex = cursor.getColumnIndexOrThrow(key);
                        switch (cursor.getType(columnIndex)) {
                            case 0: {
                                continue block6;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                cv.put(key, cursor.getString(columnIndex));
                                continue block6;
                            }
                            case 4: {
                                cv.put(key, cursor.getBlob(columnIndex));
                                continue block6;
                            }
                            default: {
                                throw new IllegalStateException("Invalid or unhandled data type");
                            }
                        }
                    }
                    contact.addSubValue(android.provider.ContactsContract$Data.CONTENT_URI, cv);
                    if (cursor.moveToNext()) continue;
                }
                return contact;
            }
        }

        public static class DisplayPhoto {
            public static final String CONTENT_DIRECTORY = "display_photo";

            private DisplayPhoto() {
            }
        }

        @Deprecated
        public static class StreamItems
        implements BaseColumns,
        StreamItemsColumns {
            @Deprecated
            public static final String CONTENT_DIRECTORY = "stream_items";

            @Deprecated
            private StreamItems() {
            }
        }

        public static class Entity
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "entity";
            public static final String DATA_ID = "data_id";

            private Entity() {
            }
        }

        public static class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    protected static interface RawContactsColumns {
        public static final String CONTACT_ID = "contact_id";
        public static final String BACKUP_ID = "backup_id";
        public static final String DATA_SET = "data_set";
        public static final String ACCOUNT_TYPE_AND_DATA_SET = "account_type_and_data_set";
        public static final String AGGREGATION_MODE = "aggregation_mode";
        public static final String DELETED = "deleted";
        public static final String RAW_CONTACT_IS_READ_ONLY = "raw_contact_is_read_only";
        public static final String RAW_CONTACT_IS_USER_PROFILE = "raw_contact_is_user_profile";
        @Deprecated
        public static final String METADATA_DIRTY = "metadata_dirty";
    }

    public static class DeletedContacts
    implements DeletedContactsColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "deleted_contacts");
        private static final int DAYS_KEPT = 30;
        public static final long DAYS_KEPT_MILLISECONDS = 2592000000L;

        private DeletedContacts() {
        }
    }

    protected static interface DeletedContactsColumns {
        public static final String CONTACT_ID = "contact_id";
        public static final String CONTACT_DELETED_TIMESTAMP = "contact_deleted_timestamp";
    }

    public static class Profile
    implements BaseColumns,
    ContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    ContactStatusColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "profile");
        public static final Uri CONTENT_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_vcard");
        public static final Uri CONTENT_RAW_CONTACTS_URI = Uri.withAppendedPath(CONTENT_URI, "raw_contacts");
        public static final long MIN_ID = 9223372034707292160L;

        private Profile() {
        }
    }

    public static class Contacts
    implements BaseColumns,
    ContactsColumns,
    ContactOptionsColumns,
    ContactNameColumns,
    ContactStatusColumns,
    ContactCounts {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "contacts");
        @UnsupportedAppUsage
        public static final Uri CORP_CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "contacts_corp");
        public static final Uri CONTENT_LOOKUP_URI = Uri.withAppendedPath(CONTENT_URI, "lookup");
        public static final Uri CONTENT_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_vcard");
        public static final String QUERY_PARAMETER_VCARD_NO_PHOTO = "no_photo";
        public static final Uri CONTENT_MULTI_VCARD_URI = Uri.withAppendedPath(CONTENT_URI, "as_multi_vcard");
        public static final Uri CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter");
        public static final Uri ENTERPRISE_CONTENT_FILTER_URI = Uri.withAppendedPath(CONTENT_URI, "filter_enterprise");
        public static final Uri CONTENT_STREQUENT_URI = Uri.withAppendedPath(CONTENT_URI, "strequent");
        @Deprecated
        public static final Uri CONTENT_FREQUENT_URI = Uri.withAppendedPath(CONTENT_URI, "frequent");
        public static final Uri CONTENT_STREQUENT_FILTER_URI = Uri.withAppendedPath(CONTENT_STREQUENT_URI, "filter");
        public static final Uri CONTENT_GROUP_URI = Uri.withAppendedPath(CONTENT_URI, "group");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact";
        public static final String CONTENT_VCARD_TYPE = "text/x-vcard";
        public static long ENTERPRISE_CONTACT_ID_BASE = 1000000000L;
        public static String ENTERPRISE_CONTACT_LOOKUP_PREFIX = "c-";

        private Contacts() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri getLookupUri(ContentResolver resolver, Uri contactUri) {
            Cursor c = resolver.query(contactUri, new String[]{"lookup", "_id"}, null, null, null);
            if (c == null) {
                return null;
            }
            try {
                if (c.moveToFirst()) {
                    String lookupKey = c.getString(0);
                    long contactId = c.getLong(1);
                    Uri uri = Contacts.getLookupUri(contactId, lookupKey);
                    return uri;
                }
            }
            finally {
                c.close();
            }
            return null;
        }

        public static Uri getLookupUri(long contactId, String lookupKey) {
            if (TextUtils.isEmpty(lookupKey)) {
                return null;
            }
            return ContentUris.withAppendedId(Uri.withAppendedPath(CONTENT_LOOKUP_URI, lookupKey), contactId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Uri lookupContact(ContentResolver resolver, Uri lookupUri) {
            if (lookupUri == null) {
                return null;
            }
            Cursor c = resolver.query(lookupUri, new String[]{"_id"}, null, null, null);
            if (c == null) {
                return null;
            }
            try {
                if (c.moveToFirst()) {
                    long contactId = c.getLong(0);
                    Uri uri = ContentUris.withAppendedId(CONTENT_URI, contactId);
                    return uri;
                }
            }
            finally {
                c.close();
            }
            return null;
        }

        @Deprecated
        public static void markAsContacted(ContentResolver resolver, long contactId) {
        }

        public static boolean isEnterpriseContactId(long contactId) {
            return contactId >= ENTERPRISE_CONTACT_ID_BASE && contactId < 9223372034707292160L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InputStream openContactPhotoInputStream(ContentResolver cr, Uri contactUri, boolean preferHighres) {
            Uri photoUri;
            if (preferHighres) {
                Uri displayPhotoUri = Uri.withAppendedPath(contactUri, "display_photo");
                try {
                    AssetFileDescriptor fd = cr.openAssetFileDescriptor(displayPhotoUri, "r");
                    if (fd != null) {
                        return fd.createInputStream();
                    }
                }
                catch (IOException fd) {
                    // empty catch block
                }
            }
            if ((photoUri = Uri.withAppendedPath(contactUri, "photo")) == null) {
                return null;
            }
            try (Cursor cursor = cr.query(photoUri, new String[]{"data15"}, null, null, null);){
                if (cursor == null || !cursor.moveToNext()) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                byte[] data = cursor.getBlob(0);
                if (data == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
                return byteArrayInputStream;
            }
        }

        public static InputStream openContactPhotoInputStream(ContentResolver cr, Uri contactUri) {
            return Contacts.openContactPhotoInputStream(cr, contactUri, false);
        }

        public static Uri createCorpLookupUriFromEnterpriseLookupUri(Uri enterpriseLookupUri) {
            List<String> pathSegments = enterpriseLookupUri.getPathSegments();
            if (pathSegments == null || pathSegments.size() <= 2) {
                return null;
            }
            String key = pathSegments.get(2);
            if (TextUtils.isEmpty(key) || !key.startsWith(ENTERPRISE_CONTACT_LOOKUP_PREFIX)) {
                return null;
            }
            String actualKey = key.substring(ENTERPRISE_CONTACT_LOOKUP_PREFIX.length());
            return Uri.withAppendedPath(CONTENT_LOOKUP_URI, actualKey);
        }

        public static class Photo
        implements BaseColumns,
        DataColumnsWithJoins {
            public static final String CONTENT_DIRECTORY = "photo";
            public static final String DISPLAY_PHOTO = "display_photo";
            public static final String PHOTO_FILE_ID = "data14";
            public static final String PHOTO = "data15";

            private Photo() {
            }
        }

        public static class AggregationSuggestions
        implements BaseColumns,
        ContactsColumns,
        ContactOptionsColumns,
        ContactStatusColumns {
            public static final String CONTENT_DIRECTORY = "suggestions";
            public static final String PARAMETER_MATCH_NAME = "name";

            private AggregationSuggestions() {
            }

            @UnsupportedAppUsage
            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private long mContactId;
                private final ArrayList<String> mValues = new ArrayList();
                private int mLimit;

                public Builder setContactId(long contactId) {
                    this.mContactId = contactId;
                    return this;
                }

                public Builder addNameParameter(String name) {
                    this.mValues.add(name);
                    return this;
                }

                public Builder setLimit(int limit) {
                    this.mLimit = limit;
                    return this;
                }

                public Uri build() {
                    Uri.Builder builder = CONTENT_URI.buildUpon();
                    builder.appendEncodedPath(String.valueOf(this.mContactId));
                    builder.appendPath(AggregationSuggestions.CONTENT_DIRECTORY);
                    if (this.mLimit != 0) {
                        builder.appendQueryParameter(ContactsContract.LIMIT_PARAM_KEY, String.valueOf(this.mLimit));
                    }
                    int count = this.mValues.size();
                    for (int i = 0; i < count; ++i) {
                        builder.appendQueryParameter("query", "name:" + this.mValues.get(i));
                    }
                    return builder.build();
                }
            }
        }

        @Deprecated
        public static class StreamItems
        implements StreamItemsColumns {
            @Deprecated
            public static final String CONTENT_DIRECTORY = "stream_items";

            @Deprecated
            private StreamItems() {
            }
        }

        public static class Entity
        implements BaseColumns,
        ContactsColumns,
        ContactNameColumns,
        RawContactsColumns,
        BaseSyncColumns,
        SyncColumns,
        DataColumns,
        StatusColumns,
        ContactOptionsColumns,
        ContactStatusColumns,
        DataUsageStatColumns {
            public static final String CONTENT_DIRECTORY = "entities";
            public static final String RAW_CONTACT_ID = "raw_contact_id";
            public static final String DATA_ID = "data_id";

            private Entity() {
            }
        }

        public static class Data
        implements BaseColumns,
        DataColumns {
            public static final String CONTENT_DIRECTORY = "data";

            private Data() {
            }
        }
    }

    static interface ContactCounts {
        public static final String EXTRA_ADDRESS_BOOK_INDEX = "android.provider.extra.ADDRESS_BOOK_INDEX";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_TITLES = "android.provider.extra.ADDRESS_BOOK_INDEX_TITLES";
        public static final String EXTRA_ADDRESS_BOOK_INDEX_COUNTS = "android.provider.extra.ADDRESS_BOOK_INDEX_COUNTS";
    }

    protected static interface ContactNameColumns {
        public static final String DISPLAY_NAME_SOURCE = "display_name_source";
        public static final String DISPLAY_NAME_PRIMARY = "display_name";
        public static final String DISPLAY_NAME_ALTERNATIVE = "display_name_alt";
        public static final String PHONETIC_NAME_STYLE = "phonetic_name_style";
        public static final String PHONETIC_NAME = "phonetic_name";
        public static final String SORT_KEY_PRIMARY = "sort_key";
        public static final String SORT_KEY_ALTERNATIVE = "sort_key_alt";
    }

    public static interface DisplayNameSources {
        public static final int UNDEFINED = 0;
        public static final int EMAIL = 10;
        public static final int PHONE = 20;
        public static final int ORGANIZATION = 30;
        public static final int NICKNAME = 35;
        public static final int STRUCTURED_PHONETIC_NAME = 37;
        public static final int STRUCTURED_NAME = 40;
    }

    public static interface PhoneticNameStyle {
        public static final int UNDEFINED = 0;
        public static final int PINYIN = 3;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
    }

    public static interface FullNameStyle {
        public static final int UNDEFINED = 0;
        public static final int WESTERN = 1;
        public static final int CJK = 2;
        public static final int CHINESE = 3;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
    }

    protected static interface ContactStatusColumns {
        public static final String CONTACT_PRESENCE = "contact_presence";
        public static final String CONTACT_CHAT_CAPABILITY = "contact_chat_capability";
        public static final String CONTACT_STATUS = "contact_status";
        public static final String CONTACT_STATUS_TIMESTAMP = "contact_status_ts";
        public static final String CONTACT_STATUS_RES_PACKAGE = "contact_status_res_package";
        public static final String CONTACT_STATUS_LABEL = "contact_status_label";
        public static final String CONTACT_STATUS_ICON = "contact_status_icon";
    }

    protected static interface ContactsColumns {
        public static final String DISPLAY_NAME = "display_name";
        public static final String NAME_RAW_CONTACT_ID = "name_raw_contact_id";
        public static final String PHOTO_ID = "photo_id";
        public static final String PHOTO_FILE_ID = "photo_file_id";
        public static final String PHOTO_URI = "photo_uri";
        public static final String PHOTO_THUMBNAIL_URI = "photo_thumb_uri";
        public static final String IN_DEFAULT_DIRECTORY = "in_default_directory";
        public static final String IN_VISIBLE_GROUP = "in_visible_group";
        public static final String IS_USER_PROFILE = "is_user_profile";
        public static final String HAS_PHONE_NUMBER = "has_phone_number";
        public static final String LOOKUP_KEY = "lookup";
        public static final String CONTACT_LAST_UPDATED_TIMESTAMP = "contact_last_updated_timestamp";
    }

    protected static interface ContactOptionsColumns {
        @Deprecated
        public static final String TIMES_CONTACTED = "times_contacted";
        @Deprecated
        public static final String LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String RAW_TIMES_CONTACTED = "x_times_contacted";
        public static final String RAW_LAST_TIME_CONTACTED = "x_last_time_contacted";
        public static final String LR_TIMES_CONTACTED = "times_contacted";
        public static final String LR_LAST_TIME_CONTACTED = "last_time_contacted";
        public static final String STARRED = "starred";
        public static final String PINNED = "pinned";
        public static final String CUSTOM_RINGTONE = "custom_ringtone";
        public static final String SEND_TO_VOICEMAIL = "send_to_voicemail";
    }

    protected static interface SyncColumns
    extends BaseSyncColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String SOURCE_ID = "sourceid";
        public static final String VERSION = "version";
        public static final String DIRTY = "dirty";
    }

    protected static interface BaseSyncColumns {
        public static final String SYNC1 = "sync1";
        public static final String SYNC2 = "sync2";
        public static final String SYNC3 = "sync3";
        public static final String SYNC4 = "sync4";
    }

    public static class ProfileSyncState
    implements SyncStateContract.Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(Profile.CONTENT_URI, "syncstate");

        private ProfileSyncState() {
        }

        public static byte[] get(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.get(provider, CONTENT_URI, account);
        }

        public static Pair<Uri, byte[]> getWithUri(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.getWithUri(provider, CONTENT_URI, account);
        }

        public static void set(ContentProviderClient provider, Account account, byte[] data) throws RemoteException {
            SyncStateContract.Helpers.set(provider, CONTENT_URI, account, data);
        }

        public static ContentProviderOperation newSetOperation(Account account, byte[] data) {
            return SyncStateContract.Helpers.newSetOperation(CONTENT_URI, account, data);
        }
    }

    public static class SyncState
    implements SyncStateContract.Columns {
        public static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "syncstate");

        private SyncState() {
        }

        public static byte[] get(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.get(provider, CONTENT_URI, account);
        }

        public static Pair<Uri, byte[]> getWithUri(ContentProviderClient provider, Account account) throws RemoteException {
            return SyncStateContract.Helpers.getWithUri(provider, CONTENT_URI, account);
        }

        public static void set(ContentProviderClient provider, Account account, byte[] data) throws RemoteException {
            SyncStateContract.Helpers.set(provider, CONTENT_URI, account, data);
        }

        public static ContentProviderOperation newSetOperation(Account account, byte[] data) {
            return SyncStateContract.Helpers.newSetOperation(CONTENT_URI, account, data);
        }
    }

    @Deprecated
    public static interface SyncStateColumns
    extends SyncStateContract.Columns {
    }

    public static class Directory
    implements BaseColumns {
        public static final Uri CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "directories");
        public static final Uri ENTERPRISE_CONTENT_URI = Uri.withAppendedPath(AUTHORITY_URI, "directories_enterprise");
        public static final Uri ENTERPRISE_FILE_URI = Uri.withAppendedPath(AUTHORITY_URI, "directory_file_enterprise");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/contact_directories";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/contact_directory";
        public static final long DEFAULT = 0L;
        public static final long LOCAL_INVISIBLE = 1L;
        public static final long ENTERPRISE_DEFAULT = 1000000000L;
        public static final long ENTERPRISE_LOCAL_INVISIBLE = 1000000001L;
        public static final String PACKAGE_NAME = "packageName";
        public static final String TYPE_RESOURCE_ID = "typeResourceId";
        public static final String DISPLAY_NAME = "displayName";
        public static final String DIRECTORY_AUTHORITY = "authority";
        public static final String ACCOUNT_TYPE = "accountType";
        public static final String ACCOUNT_NAME = "accountName";
        public static final long ENTERPRISE_DIRECTORY_ID_BASE = 1000000000L;
        public static final String EXPORT_SUPPORT = "exportSupport";
        public static final int EXPORT_SUPPORT_NONE = 0;
        public static final int EXPORT_SUPPORT_SAME_ACCOUNT_ONLY = 1;
        public static final int EXPORT_SUPPORT_ANY_ACCOUNT = 2;
        public static final String SHORTCUT_SUPPORT = "shortcutSupport";
        public static final int SHORTCUT_SUPPORT_NONE = 0;
        public static final int SHORTCUT_SUPPORT_DATA_ITEMS_ONLY = 1;
        public static final int SHORTCUT_SUPPORT_FULL = 2;
        public static final String PHOTO_SUPPORT = "photoSupport";
        public static final int PHOTO_SUPPORT_NONE = 0;
        public static final int PHOTO_SUPPORT_THUMBNAIL_ONLY = 1;
        public static final int PHOTO_SUPPORT_FULL_SIZE_ONLY = 2;
        public static final int PHOTO_SUPPORT_FULL = 3;
        public static final String CALLER_PACKAGE_PARAM_KEY = "callerPackage";

        private Directory() {
        }

        public static boolean isRemoteDirectoryId(long directoryId) {
            return directoryId != 0L && directoryId != 1L && directoryId != 1000000000L && directoryId != 1000000001L;
        }

        public static boolean isRemoteDirectory(long directoryId) {
            return Directory.isRemoteDirectoryId(directoryId);
        }

        public static boolean isEnterpriseDirectoryId(long directoryId) {
            return directoryId >= 1000000000L;
        }

        public static void notifyDirectoryChange(ContentResolver resolver) {
            ContentValues contentValues = new ContentValues();
            resolver.update(CONTENT_URI, contentValues, null, null);
        }
    }

    public static class Authorization {
        public static final String AUTHORIZATION_METHOD = "authorize";
        public static final String KEY_URI_TO_AUTHORIZE = "uri_to_authorize";
        public static final String KEY_AUTHORIZED_URI = "authorized_uri";
    }
}

