/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.DeviceConfig_Delegate;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

@SystemApi
public class DeviceConfig {
    public static final Uri CONTENT_URI = Uri.parse("content://settings/config");
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER = "activity_manager";
    @SystemApi
    public static final String NAMESPACE_ACTIVITY_MANAGER_NATIVE_BOOT = "activity_manager_native_boot";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_ALARM_MANAGER = "alarm_manager";
    @SystemApi
    public static final String NAMESPACE_APP_COMPAT = "app_compat";
    @SystemApi
    public static final String NAMESPACE_APP_HIBERNATION = "app_hibernation";
    @SystemApi
    public static final String NAMESPACE_APPSEARCH = "appsearch";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_APP_STANDBY = "app_standby";
    @SystemApi
    public static final String NAMESPACE_ATTENTION_MANAGER_SERVICE = "attention_manager_service";
    @SystemApi
    public static final String NAMESPACE_AUTOFILL = "autofill";
    @SystemApi
    public static final String NAMESPACE_BATTERY_SAVER = "battery_saver";
    @SystemApi
    public static final String NAMESPACE_BLOBSTORE = "blobstore";
    @SystemApi
    public static final String NAMESPACE_BLUETOOTH = "bluetooth";
    @SystemApi
    public static final String NAMESPACE_CLIPBOARD = "clipboard";
    @SystemApi
    public static final String NAMESPACE_CONNECTIVITY = "connectivity";
    @SystemApi
    public static final String NAMESPACE_CONTENT_CAPTURE = "content_capture";
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String NAMESPACE_DEVICE_IDLE = "device_idle";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_DEX_BOOT = "dex_boot";
    @SystemApi
    public static final String NAMESPACE_DISPLAY_MANAGER = "display_manager";
    @SystemApi
    public static final String NAMESPACE_GAME_DRIVER = "game_driver";
    @SystemApi
    public static final String NAMESPACE_INPUT_NATIVE_BOOT = "input_native_boot";
    @SystemApi
    public static final String NAMESPACE_INTELLIGENCE_ATTENTION = "intelligence_attention";
    public static final String NAMESPACE_INTELLIGENCE_CONTENT_SUGGESTIONS = "intelligence_content_suggestions";
    public static final String NAMESPACE_JOB_SCHEDULER = "jobscheduler";
    public static final String NAMESPACE_LMKD_NATIVE = "lmkd_native";
    @SystemApi
    public static final String NAMESPACE_LOCATION = "location";
    @SystemApi
    public static final String NAMESPACE_MEDIA = "media";
    @SystemApi
    public static final String NAMESPACE_MEDIA_NATIVE = "media_native";
    @SystemApi
    public static final String NAMESPACE_NETD_NATIVE = "netd_native";
    @SystemApi
    public static final String NAMESPACE_PACKAGE_MANAGER_SERVICE = "package_manager_service";
    @SystemApi
    public static final String NAMESPACE_PROFCOLLECT_NATIVE_BOOT = "profcollect_native_boot";
    @SystemApi
    public static final String NAMESPACE_REBOOT_READINESS = "reboot_readiness";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK = "rollback";
    @SystemApi
    public static final String NAMESPACE_ROLLBACK_BOOT = "rollback_boot";
    public static final String NAMESPACE_ROTATION_RESOLVER = "rotation_resolver";
    @SystemApi
    public static final String NAMESPACE_RUNTIME = "runtime";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE = "runtime_native";
    @SystemApi
    public static final String NAMESPACE_RUNTIME_NATIVE_BOOT = "runtime_native_boot";
    @SystemApi
    public static final String NAMESPACE_SCHEDULER = "scheduler";
    public static final String NAMESPACE_SETTINGS_STATS = "settings_stats";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA = "statsd_java";
    @SystemApi
    public static final String NAMESPACE_STATSD_JAVA_BOOT = "statsd_java_boot";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE = "statsd_native";
    @SystemApi
    public static final String NAMESPACE_STATSD_NATIVE_BOOT = "statsd_native_boot";
    @Deprecated
    @SystemApi
    public static final String NAMESPACE_STORAGE = "storage";
    @SystemApi
    public static final String NAMESPACE_STORAGE_NATIVE_BOOT = "storage_native_boot";
    @SystemApi
    public static final String NAMESPACE_SYSTEMUI = "systemui";
    @SystemApi
    public static final String NAMESPACE_SYSTEM_TIME = "system_time";
    @SystemApi
    public static final String NAMESPACE_TELEPHONY = "telephony";
    @SystemApi
    public static final String NAMESPACE_TEXTCLASSIFIER = "textclassifier";
    public static final String NAMESPACE_CONTACTS_PROVIDER = "contacts_provider";
    public static final String NAMESPACE_SETTINGS_UI = "settings_ui";
    public static final String NAMESPACE_ANDROID = "android";
    public static final String NAMESPACE_WINDOW_MANAGER = "window_manager";
    @SystemApi
    public static final String NAMESPACE_WINDOW_MANAGER_NATIVE_BOOT = "window_manager_native_boot";
    private static final List<String> PUBLIC_NAMESPACES = Arrays.asList("textclassifier", "runtime", "statsd_java", "statsd_java_boot");
    @SystemApi
    public static final String NAMESPACE_PRIVACY = "privacy";
    @SystemApi
    public static final String NAMESPACE_BIOMETRICS = "biometrics";
    @SystemApi
    public static final String NAMESPACE_PERMISSIONS = "permissions";
    @SystemApi
    public static final String NAMESPACE_OTA = "ota";
    public static final String NAMESPACE_WIDGET = "widget";
    public static final String NAMESPACE_CONNECTIVITY_THERMAL_POWER_MANAGER = "connectivity_thermal_power_manager";
    public static final String NAMESPACE_CONFIGURATION = "configuration";
    public static final String NAMESPACE_LATENCY_TRACKER = "latency_tracker";
    public static final String NAMESPACE_INTERACTION_JANK_MONITOR = "interaction_jank_monitor";
    public static final String NAMESPACE_GAME_OVERLAY = "game_overlay";
    public static final String NAMESPACE_CONSTRAIN_DISPLAY_APIS = "constrain_display_apis";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static ArrayMap<OnPropertiesChangedListener, Pair<String, Executor>> sListeners = new ArrayMap();
    @GuardedBy(value={"sLock"})
    private static Map<String, Pair<ContentObserver, Integer>> sNamespaces = new HashMap<String, Pair<ContentObserver, Integer>>();
    private static final String TAG = "DeviceConfig";

    private DeviceConfig() {
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static String getProperty(String namespace, String name) {
        return DeviceConfig.getProperties(namespace, name).getString(name, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static Properties getProperties(String namespace, String ... names) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        return new Properties(namespace, Settings.Config.getStrings(contentResolver, namespace, Arrays.asList(names)));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static String getString_Original(String namespace, String name, String defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? value : defaultValue;
    }

    @LayoutlibDelegate
    public static String getString(String string2, String string3, String string4) {
        return DeviceConfig_Delegate.getString(string2, string3, string4);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static boolean getBoolean_Original(String namespace, String name, boolean defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @LayoutlibDelegate
    public static boolean getBoolean(String string2, String string3, boolean bl) {
        return DeviceConfig_Delegate.getBoolean(string2, string3, bl);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static int getInt_Original(String namespace, String name, int defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing integer failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static int getInt(String string2, String string3, int n) {
        return DeviceConfig_Delegate.getInt(string2, string3, n);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static long getLong_Original(String namespace, String name, long defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing long failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static long getLong(String string2, String string3, long l) {
        return DeviceConfig_Delegate.getLong(string2, string3, l);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static float getFloat_Original(String namespace, String name, float defaultValue) {
        String value = DeviceConfig.getProperty(namespace, name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            Log.e(TAG, "Parsing float failed for " + namespace + ":" + name);
            return defaultValue;
        }
    }

    @LayoutlibDelegate
    public static float getFloat(String string2, String string3, float f) {
        return DeviceConfig_Delegate.getFloat(string2, string3, f);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static boolean setProperty(String namespace, String name, String value, boolean makeDefault) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        return Settings.Config.putString(contentResolver, namespace, name, value, makeDefault);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static boolean setProperties(Properties properties) throws BadConfigException {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        return Settings.Config.setStrings(contentResolver, properties.getNamespace(), properties.mMap);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static void resetToDefaults(int resetMode, String namespace) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        Settings.Config.resetToDefaults(contentResolver, resetMode, namespace);
    }

    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static void setSyncDisabled(int syncDisabledMode) {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        Settings.Config.setSyncDisabled(contentResolver, syncDisabledMode);
    }

    @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
    public static boolean isSyncDisabled() {
        ContentResolver contentResolver = ActivityThread.currentApplication().getContentResolver();
        return Settings.Config.isSyncDisabled(contentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public static void addOnPropertiesChangedListener(String namespace, Executor executor, OnPropertiesChangedListener onPropertiesChangedListener) {
        DeviceConfig.enforceReadPermission(ActivityThread.currentApplication().getApplicationContext(), namespace);
        Object object = sLock;
        synchronized (object) {
            Pair<String, Executor> oldNamespace = sListeners.get(onPropertiesChangedListener);
            if (oldNamespace == null) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            } else if (namespace.equals(oldNamespace.first)) {
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
            } else {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.put(onPropertiesChangedListener, new Pair<String, Executor>(namespace, executor));
                DeviceConfig.incrementNamespace(namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public static void removeOnPropertiesChangedListener(OnPropertiesChangedListener onPropertiesChangedListener) {
        Preconditions.checkNotNull(onPropertiesChangedListener);
        Object object = sLock;
        synchronized (object) {
            if (sListeners.containsKey(onPropertiesChangedListener)) {
                DeviceConfig.decrementNamespace((String)DeviceConfig.sListeners.get((Object)onPropertiesChangedListener).first);
                sListeners.remove(onPropertiesChangedListener);
            }
        }
    }

    private static Uri createNamespaceUri(String namespace) {
        Preconditions.checkNotNull(namespace);
        return CONTENT_URI.buildUpon().appendPath(namespace).build();
    }

    @GuardedBy(value={"sLock"})
    private static void incrementNamespace(String namespace) {
        Preconditions.checkNotNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount != null) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second + 1));
        } else {
            ContentObserver contentObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange, Uri uri) {
                    if (uri != null) {
                        DeviceConfig.handleChange(uri);
                    }
                }
            };
            ActivityThread.currentApplication().getContentResolver().registerContentObserver(DeviceConfig.createNamespaceUri(namespace), true, contentObserver);
            sNamespaces.put(namespace, new Pair<1, Integer>(contentObserver, 1));
        }
    }

    @GuardedBy(value={"sLock"})
    private static void decrementNamespace(String namespace) {
        Preconditions.checkNotNull(namespace);
        Pair<ContentObserver, Integer> namespaceCount = sNamespaces.get(namespace);
        if (namespaceCount == null) {
            return;
        }
        if ((Integer)namespaceCount.second > 1) {
            sNamespaces.put(namespace, new Pair<ContentObserver, Integer>((ContentObserver)namespaceCount.first, (Integer)namespaceCount.second - 1));
        } else {
            ActivityThread.currentApplication().getContentResolver().unregisterContentObserver((ContentObserver)namespaceCount.first);
            sNamespaces.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleChange(Uri uri) {
        Preconditions.checkNotNull(uri);
        List<String> pathSegments = uri.getPathSegments();
        String namespace = pathSegments.get(1);
        Properties.Builder propBuilder = new Properties.Builder(namespace);
        try {
            Properties allProperties = DeviceConfig.getProperties(namespace, new String[0]);
            for (int i = 2; i < pathSegments.size(); ++i) {
                String key = pathSegments.get(i);
                propBuilder.setString(key, allProperties.getString(key, null));
            }
        }
        catch (SecurityException e) {
            Log.e(TAG, "OnPropertyChangedListener update failed: permission violation.");
            return;
        }
        Properties properties = propBuilder.build();
        Object object = sLock;
        synchronized (object) {
            for (int i = 0; i < sListeners.size(); ++i) {
                if (!namespace.equals(DeviceConfig.sListeners.valueAt((int)i).first)) continue;
                OnPropertiesChangedListener listener = sListeners.keyAt(i);
                ((Executor)DeviceConfig.sListeners.valueAt((int)i).second).execute(() -> listener.onPropertiesChanged(properties));
            }
        }
    }

    public static void enforceReadPermission(Context context, String namespace) {
        if (context.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") != 0 && !PUBLIC_NAMESPACES.contains(namespace)) {
            throw new SecurityException("Permission denial: reading from settings requires:android.permission.READ_DEVICE_CONFIG");
        }
    }

    public static List<String> getPublicNamespaces() {
        return PUBLIC_NAMESPACES;
    }

    @SystemApi
    public static class Properties {
        private final String mNamespace;
        private final HashMap<String, String> mMap;
        private Set<String> mKeyset;

        public Properties(String namespace, Map<String, String> keyValueMap) {
            Preconditions.checkNotNull(namespace);
            this.mNamespace = namespace;
            this.mMap = new HashMap();
            if (keyValueMap != null) {
                this.mMap.putAll(keyValueMap);
            }
        }

        public String getNamespace() {
            return this.mNamespace;
        }

        public Set<String> getKeyset() {
            if (this.mKeyset == null) {
                this.mKeyset = Collections.unmodifiableSet(this.mMap.keySet());
            }
            return this.mKeyset;
        }

        public String getString(String name, String defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            return value != null ? value : defaultValue;
        }

        public boolean getBoolean(String name, boolean defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            return value != null ? Boolean.parseBoolean(value) : defaultValue;
        }

        public int getInt(String name, int defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing int failed for " + name);
                return defaultValue;
            }
        }

        public long getLong(String name, long defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing long failed for " + name);
                return defaultValue;
            }
        }

        public float getFloat(String name, float defaultValue) {
            Preconditions.checkNotNull(name);
            String value = this.mMap.get(name);
            if (value == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                Log.e(DeviceConfig.TAG, "Parsing float failed for " + name);
                return defaultValue;
            }
        }

        public static class Builder {
            private final String mNamespace;
            private final Map<String, String> mKeyValues = new HashMap<String, String>();

            public Builder(String namespace) {
                this.mNamespace = namespace;
            }

            public Builder setString(String name, String value) {
                this.mKeyValues.put(name, value);
                return this;
            }

            public Builder setBoolean(String name, boolean value) {
                this.mKeyValues.put(name, Boolean.toString(value));
                return this;
            }

            public Builder setInt(String name, int value) {
                this.mKeyValues.put(name, Integer.toString(value));
                return this;
            }

            public Builder setLong(String name, long value) {
                this.mKeyValues.put(name, Long.toString(value));
                return this;
            }

            public Builder setFloat(String name, float value) {
                this.mKeyValues.put(name, Float.toString(value));
                return this;
            }

            public Properties build() {
                return new Properties(this.mNamespace, this.mKeyValues);
            }
        }
    }

    @SystemApi
    public static class BadConfigException
    extends Exception {
    }

    @SystemApi
    public static interface OnPropertiesChangedListener {
        public void onPropertiesChanged(Properties var1);
    }
}

