/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.security.KeyStoreSecurityLevel;
import android.security.keystore.ArrayUtils;
import android.security.keystore2.AndroidKeyStoreKey;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import java.security.PublicKey;

public abstract class AndroidKeyStorePublicKey
extends AndroidKeyStoreKey
implements PublicKey {
    private final byte[] mCertificate;
    private final byte[] mCertificateChain;
    private final byte[] mEncoded;

    public AndroidKeyStorePublicKey(KeyDescriptor descriptor, KeyMetadata metadata, byte[] x509EncodedForm, String algorithm, KeyStoreSecurityLevel securityLevel) {
        super(descriptor, metadata.key.nspace, metadata.authorizations, algorithm, securityLevel);
        this.mCertificate = metadata.certificate;
        this.mCertificateChain = metadata.certificateChain;
        this.mEncoded = x509EncodedForm;
    }

    abstract AndroidKeyStorePrivateKey getPrivateKey();

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return ArrayUtils.cloneIfNotEmpty(this.mEncoded);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.mCertificate == null ? 0 : this.mCertificate.hashCode());
        result = 31 * result + (this.mCertificateChain == null ? 0 : this.mCertificateChain.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

