/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellConfigLte;
import android.telephony.CellIdentityLte;
import android.telephony.CellInfo;
import android.telephony.CellSignalStrengthLte;
import com.android.telephony.Rlog;
import java.util.Objects;

public class CellInfoLte
extends CellInfo
implements Parcelable {
    private static final String LOG_TAG = "CellInfoLte";
    private static final boolean DBG = false;
    private CellIdentityLte mCellIdentityLte;
    private CellSignalStrengthLte mCellSignalStrengthLte;
    private CellConfigLte mCellConfig;
    public static final Parcelable.Creator<CellInfoLte> CREATOR = new Parcelable.Creator<CellInfoLte>(){

        @Override
        public CellInfoLte createFromParcel(Parcel in) {
            in.readInt();
            return CellInfoLte.createFromParcelBody(in);
        }

        public CellInfoLte[] newArray(int size) {
            return new CellInfoLte[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CellInfoLte() {
        this.mCellIdentityLte = new CellIdentityLte();
        this.mCellSignalStrengthLte = new CellSignalStrengthLte();
        this.mCellConfig = new CellConfigLte();
    }

    public CellInfoLte(CellInfoLte ci) {
        super(ci);
        this.mCellIdentityLte = ci.mCellIdentityLte.copy();
        this.mCellSignalStrengthLte = ci.mCellSignalStrengthLte.copy();
        this.mCellConfig = new CellConfigLte(ci.mCellConfig);
    }

    public CellInfoLte(android.hardware.radio.V1_0.CellInfo ci) {
        super(ci);
        android.hardware.radio.V1_0.CellInfoLte cil = ci.lte.get(0);
        this.mCellIdentityLte = new CellIdentityLte(cil.cellIdentityLte);
        this.mCellSignalStrengthLte = new CellSignalStrengthLte(cil.signalStrengthLte);
        this.mCellConfig = new CellConfigLte();
    }

    public CellInfoLte(android.hardware.radio.V1_2.CellInfo ci) {
        super(ci);
        android.hardware.radio.V1_2.CellInfoLte cil = ci.lte.get(0);
        this.mCellIdentityLte = new CellIdentityLte(cil.cellIdentityLte);
        this.mCellSignalStrengthLte = new CellSignalStrengthLte(cil.signalStrengthLte);
        this.mCellConfig = new CellConfigLte();
    }

    public CellInfoLte(android.hardware.radio.V1_4.CellInfo ci, long timeStamp) {
        super(ci, timeStamp);
        android.hardware.radio.V1_4.CellInfoLte cil = ci.info.lte();
        this.mCellIdentityLte = new CellIdentityLte(cil.base.cellIdentityLte);
        this.mCellSignalStrengthLte = new CellSignalStrengthLte(cil.base.signalStrengthLte);
        this.mCellConfig = new CellConfigLte(cil.cellConfig);
    }

    public CellInfoLte(android.hardware.radio.V1_5.CellInfo ci, long timeStamp) {
        super(ci, timeStamp);
        android.hardware.radio.V1_5.CellInfoLte cil = ci.ratSpecificInfo.lte();
        this.mCellIdentityLte = new CellIdentityLte(cil.cellIdentityLte);
        this.mCellSignalStrengthLte = new CellSignalStrengthLte(cil.signalStrengthLte);
        this.mCellConfig = new CellConfigLte();
    }

    public CellInfoLte(android.hardware.radio.V1_6.CellInfo ci, long timeStamp) {
        super(ci, timeStamp);
        android.hardware.radio.V1_6.CellInfoLte cil = ci.ratSpecificInfo.lte();
        this.mCellIdentityLte = new CellIdentityLte(cil.cellIdentityLte);
        this.mCellSignalStrengthLte = new CellSignalStrengthLte(cil.signalStrengthLte);
        this.mCellConfig = new CellConfigLte();
    }

    @Override
    public CellIdentityLte getCellIdentity() {
        return this.mCellIdentityLte;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCellIdentity(CellIdentityLte cid) {
        this.mCellIdentityLte = cid;
    }

    @Override
    public CellSignalStrengthLte getCellSignalStrength() {
        return this.mCellSignalStrengthLte;
    }

    @Override
    public CellInfo sanitizeLocationInfo() {
        CellInfoLte result = new CellInfoLte(this);
        result.mCellIdentityLte = this.mCellIdentityLte.sanitizeLocationInfo();
        return result;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setCellSignalStrength(CellSignalStrengthLte css) {
        this.mCellSignalStrengthLte = css;
    }

    public void setCellConfig(CellConfigLte cellConfig) {
        this.mCellConfig = cellConfig;
    }

    public CellConfigLte getCellConfig() {
        return this.mCellConfig;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mCellIdentityLte.hashCode(), this.mCellSignalStrengthLte.hashCode(), this.mCellConfig.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CellInfoLte)) {
            return false;
        }
        CellInfoLte o = (CellInfoLte)other;
        return super.equals(o) && this.mCellIdentityLte.equals(o.mCellIdentityLte) && this.mCellSignalStrengthLte.equals(o.mCellSignalStrengthLte) && this.mCellConfig.equals(o.mCellConfig);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CellInfoLte:{");
        sb.append(super.toString());
        sb.append(" ").append(this.mCellIdentityLte);
        sb.append(" ").append(this.mCellSignalStrengthLte);
        sb.append(" ").append(this.mCellConfig);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags, 3);
        this.mCellIdentityLte.writeToParcel(dest, flags);
        this.mCellSignalStrengthLte.writeToParcel(dest, flags);
        this.mCellConfig.writeToParcel(dest, flags);
    }

    private CellInfoLte(Parcel in) {
        super(in);
        this.mCellIdentityLte = CellIdentityLte.CREATOR.createFromParcel(in);
        this.mCellSignalStrengthLte = CellSignalStrengthLte.CREATOR.createFromParcel(in);
        this.mCellConfig = CellConfigLte.CREATOR.createFromParcel(in);
    }

    protected static CellInfoLte createFromParcelBody(Parcel in) {
        return new CellInfoLte(in);
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

