/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import com.android.internal.telephony.IMms;

public class MmsManager {
    private static final String TAG = "MmsManager";
    private final Context mContext;

    public MmsManager(Context context) {
        this.mContext = context;
    }

    public void sendMultimediaMessage(int subId, Uri contentUri, String locationUrl, Bundle configOverrides, PendingIntent sentIntent, long messageId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.sendMessage(subId, ActivityThread.currentPackageName(), contentUri, locationUrl, configOverrides, sentIntent, messageId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void downloadMultimediaMessage(int subId, String locationUrl, Uri contentUri, Bundle configOverrides, PendingIntent downloadedIntent, long messageId) {
        try {
            IMms iMms = IMms.Stub.asInterface(ServiceManager.getService("imms"));
            if (iMms == null) {
                return;
            }
            iMms.downloadMessage(subId, ActivityThread.currentPackageName(), locationUrl, contentUri, configOverrides, downloadedIntent, messageId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

