/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class ModemActivityInfo
implements Parcelable {
    private static final int TX_POWER_LEVELS = 5;
    public static final int TX_POWER_LEVEL_0 = 0;
    public static final int TX_POWER_LEVEL_1 = 1;
    public static final int TX_POWER_LEVEL_2 = 2;
    public static final int TX_POWER_LEVEL_3 = 3;
    public static final int TX_POWER_LEVEL_4 = 4;
    private static final Range<Integer>[] TX_POWER_RANGES = new Range[]{new Range<Integer>(Integer.MIN_VALUE, 0), new Range<Integer>(0, 5), new Range<Integer>(5, 15), new Range<Integer>(15, 20), new Range<Integer>(20, Integer.MAX_VALUE)};
    private long mTimestamp;
    private int mSleepTimeMs;
    private int mIdleTimeMs;
    private int[] mTxTimeMs;
    private int mRxTimeMs;
    public static final Parcelable.Creator<ModemActivityInfo> CREATOR = new Parcelable.Creator<ModemActivityInfo>(){

        @Override
        public ModemActivityInfo createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            int sleepTimeMs = in.readInt();
            int idleTimeMs = in.readInt();
            int[] txTimeMs = new int[5];
            in.readIntArray(txTimeMs);
            int rxTimeMs = in.readInt();
            return new ModemActivityInfo(timestamp, sleepTimeMs, idleTimeMs, txTimeMs, rxTimeMs);
        }

        public ModemActivityInfo[] newArray(int size) {
            return new ModemActivityInfo[size];
        }
    };

    public static int getNumTxPowerLevels() {
        return 5;
    }

    public ModemActivityInfo(long timestamp, int sleepTimeMs, int idleTimeMs, int[] txTimeMs, int rxTimeMs) {
        Objects.requireNonNull(txTimeMs);
        if (txTimeMs.length != 5) {
            throw new IllegalArgumentException("txTimeMs must have length == TX_POWER_LEVELS");
        }
        this.mTimestamp = timestamp;
        this.mSleepTimeMs = sleepTimeMs;
        this.mIdleTimeMs = idleTimeMs;
        this.mTxTimeMs = txTimeMs;
        this.mRxTimeMs = rxTimeMs;
    }

    public ModemActivityInfo(long timestamp, long sleepTimeMs, long idleTimeMs, int[] txTimeMs, long rxTimeMs) {
        this(timestamp, (int)sleepTimeMs, (int)idleTimeMs, txTimeMs, (int)rxTimeMs);
    }

    public String toString() {
        return "ModemActivityInfo{ mTimestamp=" + this.mTimestamp + " mSleepTimeMs=" + this.mSleepTimeMs + " mIdleTimeMs=" + this.mIdleTimeMs + " mTxTimeMs[]=" + Arrays.toString(this.mTxTimeMs) + " mRxTimeMs=" + this.mRxTimeMs + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeInt(this.mSleepTimeMs);
        dest.writeInt(this.mIdleTimeMs);
        dest.writeIntArray(this.mTxTimeMs);
        dest.writeInt(this.mRxTimeMs);
    }

    public long getTimestampMillis() {
        return this.mTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    public long getTransmitDurationMillisAtPowerLevel(int powerLevel) {
        return this.mTxTimeMs[powerLevel];
    }

    public Range<Integer> getTransmitPowerRange(int powerLevel) {
        return TX_POWER_RANGES[powerLevel];
    }

    public void setTransmitTimeMillis(int[] txTimeMs) {
        this.mTxTimeMs = Arrays.copyOf(txTimeMs, 5);
    }

    public int[] getTransmitTimeMillis() {
        return this.mTxTimeMs;
    }

    public long getSleepTimeMillis() {
        return this.mSleepTimeMs;
    }

    public void setSleepTimeMillis(int sleepTimeMillis) {
        this.mSleepTimeMs = sleepTimeMillis;
    }

    public void setSleepTimeMillis(long sleepTimeMillis) {
        this.mSleepTimeMs = (int)sleepTimeMillis;
    }

    public ModemActivityInfo getDelta(ModemActivityInfo other) {
        int[] txTimeMs = new int[5];
        for (int i = 0; i < 5; ++i) {
            txTimeMs[i] = other.mTxTimeMs[i] - this.mTxTimeMs[i];
        }
        return new ModemActivityInfo(other.getTimestampMillis(), other.getSleepTimeMillis() - this.getSleepTimeMillis(), other.getIdleTimeMillis() - this.getIdleTimeMillis(), txTimeMs, other.getReceiveTimeMillis() - this.getReceiveTimeMillis());
    }

    public long getIdleTimeMillis() {
        return this.mIdleTimeMs;
    }

    public void setIdleTimeMillis(int idleTimeMillis) {
        this.mIdleTimeMs = idleTimeMillis;
    }

    public void setIdleTimeMillis(long idleTimeMillis) {
        this.mIdleTimeMs = (int)idleTimeMillis;
    }

    public long getReceiveTimeMillis() {
        return this.mRxTimeMs;
    }

    public void setReceiveTimeMillis(int rxTimeMillis) {
        this.mRxTimeMs = rxTimeMillis;
    }

    public void setReceiveTimeMillis(long receiveTimeMillis) {
        this.mRxTimeMs = (int)receiveTimeMillis;
    }

    public boolean isValid() {
        boolean isTxPowerValid = Arrays.stream(this.mTxTimeMs).allMatch(i -> i >= 0);
        return isTxPowerValid && this.getIdleTimeMillis() >= 0L && this.getSleepTimeMillis() >= 0L && this.getReceiveTimeMillis() >= 0L && !this.isEmpty();
    }

    public boolean isEmpty() {
        boolean isTxPowerEmpty = this.mTxTimeMs == null || this.mTxTimeMs.length == 0 || Arrays.stream(this.mTxTimeMs).allMatch(i -> i == 0);
        return isTxPowerEmpty && this.getIdleTimeMillis() == 0L && this.getSleepTimeMillis() == 0L && this.getReceiveTimeMillis() == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModemActivityInfo that = (ModemActivityInfo)o;
        return this.mTimestamp == that.mTimestamp && this.mSleepTimeMs == that.mSleepTimeMs && this.mIdleTimeMs == that.mIdleTimeMs && this.mRxTimeMs == that.mRxTimeMs && Arrays.equals(this.mTxTimeMs, that.mTxTimeMs);
    }

    public int hashCode() {
        int result = Objects.hash(this.mTimestamp, this.mSleepTimeMs, this.mIdleTimeMs, this.mRxTimeMs);
        result = 31 * result + Arrays.hashCode(this.mTxTimeMs);
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TxPowerLevel {
    }
}

