/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.telephony.ims.RcsClientConfiguration;
import android.telephony.ims.RcsConfig;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsConfigCallback;
import android.telephony.ims.aidl.IRcsConfigCallback;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.util.RemoteCallbackListExt;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;

@SystemApi
public class ImsConfigImplBase {
    private static final String TAG = "ImsConfigImplBase";
    public static final int CONFIG_RESULT_UNKNOWN = -1;
    public static final int CONFIG_RESULT_SUCCESS = 0;
    public static final int CONFIG_RESULT_FAILED = 1;
    private final RemoteCallbackListExt<IImsConfigCallback> mCallbacks = new RemoteCallbackListExt();
    private final RemoteCallbackListExt<IRcsConfigCallback> mRcsCallbacks = new RemoteCallbackListExt();
    private byte[] mRcsConfigData;
    ImsConfigStub mImsConfigStub = new ImsConfigStub(this);

    public ImsConfigImplBase(Context context) {
    }

    public ImsConfigImplBase() {
    }

    private void addImsConfigCallback(IImsConfigCallback c) {
        this.mCallbacks.register(c);
    }

    private void removeImsConfigCallback(IImsConfigCallback c) {
        this.mCallbacks.unregister(c);
    }

    private void notifyConfigChanged(int item, int value) {
        if (this.mCallbacks == null) {
            return;
        }
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onIntConfigChanged(item, value);
            }
            catch (RemoteException e) {
                Log.w(TAG, "notifyConfigChanged(int): dead binder in notify, skipping.");
            }
        });
    }

    private void notifyConfigChanged(int item, String value) {
        if (this.mCallbacks == null) {
            return;
        }
        this.mCallbacks.broadcastAction(c -> {
            try {
                c.onStringConfigChanged(item, value);
            }
            catch (RemoteException e) {
                Log.w(TAG, "notifyConfigChanged(string): dead binder in notify, skipping.");
            }
        });
    }

    private void addRcsConfigCallback(IRcsConfigCallback c) {
        this.mRcsCallbacks.register(c);
        if (this.mRcsConfigData != null) {
            try {
                c.onConfigurationChanged(this.mRcsConfigData);
            }
            catch (RemoteException e) {
                Log.w(TAG, "dead binder to call onConfigurationChanged, skipping.");
            }
        }
    }

    private void removeRcsConfigCallback(IRcsConfigCallback c) {
        this.mRcsCallbacks.unregister(c);
    }

    private void onNotifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) {
        byte[] byArray = config = isCompressed ? RcsConfig.decompressGzip(config) : config;
        if (Arrays.equals(this.mRcsConfigData, config)) {
            return;
        }
        this.mRcsConfigData = config;
        if (this.mRcsCallbacks != null) {
            this.mRcsCallbacks.broadcastAction(c -> {
                try {
                    c.onConfigurationChanged(this.mRcsConfigData);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "dead binder in notifyRcsAutoConfigurationReceived, skipping.");
                }
            });
        }
        this.notifyRcsAutoConfigurationReceived(config, isCompressed);
    }

    private void onNotifyRcsAutoConfigurationRemoved() {
        this.mRcsConfigData = null;
        if (this.mRcsCallbacks != null) {
            this.mRcsCallbacks.broadcastAction(c -> {
                try {
                    c.onConfigurationReset();
                }
                catch (RemoteException e) {
                    Log.w(TAG, "dead binder in notifyRcsAutoConfigurationRemoved, skipping.");
                }
            });
        }
        this.notifyRcsAutoConfigurationRemoved();
    }

    public IImsConfig getIImsConfig() {
        return this.mImsConfigStub;
    }

    public void notifyProvisionedValueChanged(int item, int value) {
        try {
            this.mImsConfigStub.updateCachedValue(item, value, true);
        }
        catch (RemoteException e) {
            Log.w(TAG, "notifyProvisionedValueChanged(int): Framework connection is dead.");
        }
    }

    public void notifyProvisionedValueChanged(int item, String value) {
        try {
            this.mImsConfigStub.updateCachedValue(item, value, true);
        }
        catch (RemoteException e) {
            Log.w(TAG, "notifyProvisionedValueChanged(string): Framework connection is dead.");
        }
    }

    public void notifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) {
    }

    public void notifyRcsAutoConfigurationRemoved() {
    }

    public int setConfig(int item, int value) {
        return 1;
    }

    public int setConfig(int item, String value) {
        return 1;
    }

    public int getConfigInt(int item) {
        return -1;
    }

    public String getConfigString(int item) {
        return null;
    }

    public void updateImsCarrierConfigs(PersistableBundle bundle) {
    }

    public void setRcsClientConfiguration(RcsClientConfiguration rcc) {
    }

    public void triggerAutoConfiguration() {
    }

    public void notifyAutoConfigurationErrorReceived(int errorCode, String errorString) {
        if (this.mRcsCallbacks == null) {
            return;
        }
        this.mRcsCallbacks.broadcastAction(c -> {
            try {
                c.onAutoConfigurationErrorReceived(errorCode, errorString);
            }
            catch (RemoteException e) {
                Log.w(TAG, "dead binder in notifyAutoConfigurationErrorReceived, skipping.");
            }
        });
    }

    public void notifyPreProvisioningReceived(byte[] configXml) {
        if (this.mRcsCallbacks == null) {
            return;
        }
        this.mRcsCallbacks.broadcastAction(c -> {
            try {
                c.onPreProvisioningReceived(configXml);
            }
            catch (RemoteException e) {
                Log.w(TAG, "dead binder in notifyPreProvisioningReceived, skipping.");
            }
        });
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetConfigResult {
    }

    @VisibleForTesting
    public static class ImsConfigStub
    extends IImsConfig.Stub {
        WeakReference<ImsConfigImplBase> mImsConfigImplBaseWeakReference;
        private HashMap<Integer, Integer> mProvisionedIntValue = new HashMap();
        private HashMap<Integer, String> mProvisionedStringValue = new HashMap();

        @VisibleForTesting
        public ImsConfigStub(ImsConfigImplBase imsConfigImplBase) {
            this.mImsConfigImplBaseWeakReference = new WeakReference<ImsConfigImplBase>(imsConfigImplBase);
        }

        @Override
        public void addImsConfigCallback(IImsConfigCallback c) throws RemoteException {
            this.getImsConfigImpl().addImsConfigCallback(c);
        }

        @Override
        public void removeImsConfigCallback(IImsConfigCallback c) throws RemoteException {
            this.getImsConfigImpl().removeImsConfigCallback(c);
        }

        @Override
        public synchronized int getConfigInt(int item) throws RemoteException {
            if (this.mProvisionedIntValue.containsKey(item)) {
                return this.mProvisionedIntValue.get(item);
            }
            int retVal = this.getImsConfigImpl().getConfigInt(item);
            if (retVal != -1) {
                this.updateCachedValue(item, retVal, false);
            }
            return retVal;
        }

        @Override
        public synchronized String getConfigString(int item) throws RemoteException {
            if (this.mProvisionedStringValue.containsKey(item)) {
                return this.mProvisionedStringValue.get(item);
            }
            String retVal = this.getImsConfigImpl().getConfigString(item);
            if (retVal != null) {
                this.updateCachedValue(item, retVal, false);
            }
            return retVal;
        }

        @Override
        public synchronized int setConfigInt(int item, int value) throws RemoteException {
            this.mProvisionedIntValue.remove(item);
            int retVal = this.getImsConfigImpl().setConfig(item, value);
            if (retVal == 0) {
                this.updateCachedValue(item, value, true);
            } else {
                Log.d(ImsConfigImplBase.TAG, "Set provision value of " + item + " to " + value + " failed with error code " + retVal);
            }
            return retVal;
        }

        @Override
        public synchronized int setConfigString(int item, String value) throws RemoteException {
            this.mProvisionedStringValue.remove(item);
            int retVal = this.getImsConfigImpl().setConfig(item, value);
            if (retVal == 0) {
                this.updateCachedValue(item, value, true);
            }
            return retVal;
        }

        @Override
        public void updateImsCarrierConfigs(PersistableBundle bundle) throws RemoteException {
            this.getImsConfigImpl().updateImsCarrierConfigs(bundle);
        }

        private ImsConfigImplBase getImsConfigImpl() throws RemoteException {
            ImsConfigImplBase ref = (ImsConfigImplBase)this.mImsConfigImplBaseWeakReference.get();
            if (ref == null) {
                throw new RemoteException("Fail to get ImsConfigImpl");
            }
            return ref;
        }

        @Override
        public void notifyRcsAutoConfigurationReceived(byte[] config, boolean isCompressed) throws RemoteException {
            this.getImsConfigImpl().onNotifyRcsAutoConfigurationReceived(config, isCompressed);
        }

        @Override
        public void notifyRcsAutoConfigurationRemoved() throws RemoteException {
            this.getImsConfigImpl().onNotifyRcsAutoConfigurationRemoved();
        }

        private void notifyImsConfigChanged(int item, int value) throws RemoteException {
            this.getImsConfigImpl().notifyConfigChanged(item, value);
        }

        private void notifyImsConfigChanged(int item, String value) throws RemoteException {
            this.getImsConfigImpl().notifyConfigChanged(item, value);
        }

        protected synchronized void updateCachedValue(int item, int value, boolean notifyChange) throws RemoteException {
            this.mProvisionedIntValue.put(item, value);
            if (notifyChange) {
                this.notifyImsConfigChanged(item, value);
            }
        }

        protected synchronized void updateCachedValue(int item, String value, boolean notifyChange) throws RemoteException {
            this.mProvisionedStringValue.put(item, value);
            if (notifyChange) {
                this.notifyImsConfigChanged(item, value);
            }
        }

        @Override
        public void addRcsConfigCallback(IRcsConfigCallback c) throws RemoteException {
            this.getImsConfigImpl().addRcsConfigCallback(c);
        }

        @Override
        public void removeRcsConfigCallback(IRcsConfigCallback c) throws RemoteException {
            this.getImsConfigImpl().removeRcsConfigCallback(c);
        }

        @Override
        public void triggerRcsReconfiguration() throws RemoteException {
            this.getImsConfigImpl().triggerAutoConfiguration();
        }

        @Override
        public void setRcsClientConfiguration(RcsClientConfiguration rcc) throws RemoteException {
            this.getImsConfigImpl().setRcsClientConfiguration(rcc);
        }

        @Override
        public void notifyIntImsConfigChanged(int item, int value) throws RemoteException {
            this.notifyImsConfigChanged(item, value);
        }

        @Override
        public void notifyStringImsConfigChanged(int item, String value) throws RemoteException {
            this.notifyImsConfigChanged(item, value);
        }
    }
}

