/*
 * Decompiled with CFR 0.152.
 */
package android.util.imetracing;

import android.app.ActivityThread;
import android.inputmethodservice.AbstractInputMethodService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.imetracing.ImeTracingClientImpl;
import android.util.imetracing.ImeTracingServerImpl;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.view.IInputMethodManager;
import java.io.PrintWriter;

public abstract class ImeTracing {
    static final String TAG = "imeTracing";
    public static final String PROTO_ARG = "--proto-com-android-imetracing";
    public static final int IME_TRACING_FROM_CLIENT = 0;
    public static final int IME_TRACING_FROM_IMS = 1;
    public static final int IME_TRACING_FROM_IMMS = 2;
    private static ImeTracing sInstance;
    static boolean sEnabled;
    IInputMethodManager mService;
    protected boolean mDumpInProgress;
    protected final Object mDumpInProgressLock = new Object();

    ImeTracing() throws ServiceManager.ServiceNotFoundException {
        this.mService = IInputMethodManager.Stub.asInterface(ServiceManager.getServiceOrThrow("input_method"));
    }

    public static ImeTracing getInstance() {
        if (sInstance == null) {
            try {
                sInstance = ImeTracing.isSystemProcess() ? new ImeTracingServerImpl() : new ImeTracingClientImpl();
            }
            catch (RemoteException | ServiceManager.ServiceNotFoundException e) {
                Log.e(TAG, "Exception while creating ImeTracing instance", e);
            }
        }
        return sInstance;
    }

    public void sendToService(byte[] protoDump, int source, String where) throws RemoteException {
        this.mService.startProtoDump(protoDump, source, where);
    }

    public abstract void addToBuffer(ProtoOutputStream var1, int var2);

    public abstract void triggerClientDump(String var1, InputMethodManager var2, ProtoOutputStream var3);

    public abstract void triggerServiceDump(String var1, AbstractInputMethodService var2, ProtoOutputStream var3);

    public abstract void triggerManagerServiceDump(String var1);

    public void saveForBugreport(PrintWriter pw) {
    }

    public void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public boolean isEnabled() {
        return sEnabled;
    }

    public boolean isAvailable() {
        return this.mService != null;
    }

    public abstract void startTrace(PrintWriter var1);

    public abstract void stopTrace(PrintWriter var1);

    private static boolean isSystemProcess() {
        return ActivityThread.isSystem();
    }

    protected void logAndPrintln(PrintWriter pw, String msg) {
        Log.i(TAG, msg);
        if (pw != null) {
            pw.println(msg);
            pw.flush();
        }
    }

    static {
        sEnabled = false;
    }
}

