/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.res.CompatibilityInfo;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.imetracing.ImeTracing;
import android.util.proto.ProtoOutputStream;
import android.view.ImeInsetsSourceConsumer;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationThreadControlRunner;
import android.view.InsetsSource;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.SfVsyncFrameCallbackProvider;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class InsetsController
implements WindowInsetsController,
InsetsAnimationControlCallbacks {
    private int mTypesBeingCancelled;
    private static final String TAG = "InsetsController";
    private static final int ANIMATION_DURATION_MOVE_IN_MS = 275;
    private static final int ANIMATION_DURATION_MOVE_OUT_MS = 340;
    private static final int ANIMATION_DURATION_FADE_IN_MS = 500;
    private static final int ANIMATION_DURATION_FADE_OUT_MS = 1500;
    private static final int ANIMATION_DELAY_DIM_MS = 500;
    private static final int ANIMATION_DURATION_SYNC_IME_MS = 285;
    private static final int ANIMATION_DURATION_UNSYNC_IME_MS = 200;
    private static final int PENDING_CONTROL_TIMEOUT_MS = 2000;
    private static final Interpolator SYSTEM_BARS_INSETS_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private static final Interpolator SYSTEM_BARS_ALPHA_INTERPOLATOR = new PathInterpolator(0.3f, 0.0f, 1.0f, 1.0f);
    private static final Interpolator SYSTEM_BARS_DIM_INTERPOLATOR = alphaFraction -> {
        float fraction2 = 1.0f - alphaFraction;
        float fractionDelay = 0.33333334f;
        if (fraction2 <= 0.33333334f) {
            return 1.0f;
        }
        float innerFraction = (fraction2 - 0.33333334f) / 0.6666666f;
        return 1.0f - SYSTEM_BARS_ALPHA_INTERPOLATOR.getInterpolation(innerFraction);
    };
    private static final Interpolator SYNC_IME_INTERPOLATOR = new PathInterpolator(0.2f, 0.0f, 0.0f, 1.0f);
    private static final Interpolator LINEAR_OUT_SLOW_IN_INTERPOLATOR = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    private static final Interpolator FAST_OUT_LINEAR_IN_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    private static final int FLOATING_IME_BOTTOM_INSET_DP = -80;
    static final boolean DEBUG = false;
    static final boolean WARN = false;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_SHOWN = 0;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_HIDDEN = 1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_NONE = -1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_SHOW = 0;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_HIDE = 1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_USER = 2;
    private static TypeEvaluator<Insets> sEvaluator = (fraction2, startValue, endValue) -> Insets.of((int)((float)startValue.left + fraction2 * (float)(endValue.left - startValue.left)), (int)((float)startValue.top + fraction2 * (float)(endValue.top - startValue.top)), (int)((float)startValue.right + fraction2 * (float)(endValue.right - startValue.right)), (int)((float)startValue.bottom + fraction2 * (float)(endValue.bottom - startValue.bottom)));
    private final InsetsState mState = new InsetsState();
    private final InsetsState mLastDispatchedState = new InsetsState();
    private final InsetsState mRequestedState = new InsetsState();
    private final Rect mFrame = new Rect();
    private final BiFunction<InsetsController, Integer, InsetsSourceConsumer> mConsumerCreator;
    private final SparseArray<InsetsSourceConsumer> mSourceConsumers = new SparseArray();
    private final Host mHost;
    private final Handler mHandler;
    private final SparseArray<InsetsSourceControl> mTmpControlArray = new SparseArray();
    private final ArrayList<RunningAnimation> mRunningAnimations = new ArrayList();
    private final ArrayList<InsetsAnimationControlImpl> mTmpFinishedControls = new ArrayList();
    private final ArraySet<InsetsSourceConsumer> mRequestedVisibilityChanged = new ArraySet();
    private WindowInsets mLastInsets;
    private boolean mAnimCallbackScheduled;
    private final Runnable mAnimCallback;
    private PendingControlRequest mPendingImeControlRequest;
    private int mWindowType;
    private int mLastLegacySoftInputMode;
    private int mLastLegacyWindowFlags;
    private int mLastLegacySystemUiFlags;
    private int mLastWindowingMode;
    private boolean mStartingAnimation;
    private int mCaptionInsetsHeight = 0;
    private boolean mAnimationsDisabled;
    private Runnable mPendingControlTimeout = this::abortPendingImeControlRequest;
    private final ArrayList<WindowInsetsController.OnControllableInsetsChangedListener> mControllableInsetsChangedListeners = new ArrayList();
    private int mLastStartedAnimTypes;
    private int mDisabledUserAnimationInsetsTypes;
    private Runnable mInvokeControllableInsetsChangedListeners = this::invokeControllableInsetsChangedListeners;

    public InsetsController(Host host) {
        this(host, (controller, type) -> {
            if (type == 19) {
                return new ImeInsetsSourceConsumer(controller.mState, SurfaceControl.Transaction::new, (InsetsController)controller);
            }
            return new InsetsSourceConsumer((int)type, controller.mState, SurfaceControl.Transaction::new, (InsetsController)controller);
        }, host.getHandler());
    }

    @VisibleForTesting
    public InsetsController(Host host, BiFunction<InsetsController, Integer, InsetsSourceConsumer> consumerCreator, Handler handler) {
        this.mHost = host;
        this.mConsumerCreator = consumerCreator;
        this.mHandler = handler;
        this.mAnimCallback = () -> {
            this.mAnimCallbackScheduled = false;
            if (this.mRunningAnimations.isEmpty()) {
                return;
            }
            ArrayList<WindowInsetsAnimation> runningAnimations = new ArrayList<WindowInsetsAnimation>();
            InsetsState state = new InsetsState(this.mState, true);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                InsetsAnimationControlRunner runner = runningAnimation.runner;
                if (!(runner instanceof InsetsAnimationControlImpl)) continue;
                InsetsAnimationControlImpl control = (InsetsAnimationControlImpl)runner;
                if (runningAnimation.startDispatched) {
                    runningAnimations.add(control.getAnimation());
                }
                if (!control.applyChangeInsets(state)) continue;
                this.mTmpFinishedControls.add(control);
            }
            WindowInsets insets = state.calculateInsets(this.mFrame, this.mState, this.mLastInsets.isRound(), this.mLastInsets.shouldAlwaysConsumeSystemBars(), this.mLastLegacySoftInputMode, this.mLastLegacyWindowFlags, this.mLastLegacySystemUiFlags, this.mWindowType, this.mLastWindowingMode, null);
            this.mHost.dispatchWindowInsetsAnimationProgress(insets, Collections.unmodifiableList(runningAnimations));
            for (int i = this.mTmpFinishedControls.size() - 1; i >= 0; --i) {
                this.dispatchAnimationEnd(this.mTmpFinishedControls.get(i).getAnimation());
            }
            this.mTmpFinishedControls.clear();
        };
    }

    @VisibleForTesting
    public void onFrameChanged(Rect frame) {
        if (this.mFrame.equals(frame)) {
            return;
        }
        this.mHost.notifyInsetsChanged();
        this.mFrame.set(frame);
    }

    @Override
    public InsetsState getState() {
        return this.mState;
    }

    @Override
    public boolean isRequestedVisible(int type) {
        return this.getSourceConsumer(type).isRequestedVisible();
    }

    public InsetsState getLastDispatchedState() {
        return this.mLastDispatchedState;
    }

    @VisibleForTesting
    public boolean onStateChanged(InsetsState state) {
        boolean stateChanged;
        boolean bl = stateChanged = !this.mState.equals(state, true, false) || !this.captionInsetsUnchanged();
        if (!stateChanged && this.mLastDispatchedState.equals(state)) {
            return false;
        }
        this.mLastDispatchedState.set(state, true);
        InsetsState lastState = new InsetsState(this.mState, true);
        this.updateState(state);
        this.applyLocalVisibilityOverride();
        if (!this.mState.equals(lastState, false, true)) {
            this.mHost.notifyInsetsChanged();
        }
        return true;
    }

    private void updateState(InsetsState newState) {
        InsetsSource source;
        int type;
        this.mState.setDisplayFrame(newState.getDisplayFrame());
        this.mState.setDisplayCutout(newState.getDisplayCutout());
        this.mState.setRoundedCorners(newState.getRoundedCorners());
        this.mState.setPrivacyIndicatorBounds(newState.getPrivacyIndicatorBounds());
        int disabledUserAnimationTypes = 0;
        int[] cancelledUserAnimationTypes = new int[]{0};
        for (type = 0; type < 22; ++type) {
            source = newState.peekSource(type);
            if (source == null) continue;
            int animationType = this.getAnimationType(type);
            if (!source.isUserControllable()) {
                int insetsType = InsetsState.toPublicType(type);
                disabledUserAnimationTypes |= insetsType;
                if (animationType == 2) {
                    animationType = -1;
                    cancelledUserAnimationTypes[0] = cancelledUserAnimationTypes[0] | insetsType;
                }
            }
            this.getSourceConsumer(type).updateSource(source, animationType);
        }
        for (type = 0; type < 22; ++type) {
            if (type == 2 || (source = this.mState.peekSource(type)) == null || newState.peekSource(type) != null) continue;
            this.mState.removeSource(type);
        }
        this.updateDisabledUserAnimationTypes(disabledUserAnimationTypes);
        if (cancelledUserAnimationTypes[0] != 0) {
            this.mHandler.post(() -> this.show(cancelledUserAnimationTypes[0]));
        }
    }

    private void updateDisabledUserAnimationTypes(int disabledUserAnimationTypes) {
        int diff = this.mDisabledUserAnimationInsetsTypes ^ disabledUserAnimationTypes;
        if (diff != 0) {
            for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
                InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
                if (consumer.getControl() == null || (InsetsState.toPublicType(consumer.getType()) & diff) == 0) continue;
                this.mHandler.removeCallbacks(this.mInvokeControllableInsetsChangedListeners);
                this.mHandler.post(this.mInvokeControllableInsetsChangedListeners);
                break;
            }
            this.mDisabledUserAnimationInsetsTypes = disabledUserAnimationTypes;
        }
    }

    private boolean captionInsetsUnchanged() {
        if (this.mState.peekSource(2) == null && this.mCaptionInsetsHeight == 0) {
            return true;
        }
        return this.mState.peekSource(2) != null && this.mCaptionInsetsHeight == this.mState.peekSource(2).getFrame().height();
    }

    @VisibleForTesting
    public WindowInsets calculateInsets(boolean isScreenRound, boolean alwaysConsumeSystemBars, int windowType, int windowingMode, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags) {
        this.mWindowType = windowType;
        this.mLastWindowingMode = windowingMode;
        this.mLastLegacySoftInputMode = legacySoftInputMode;
        this.mLastLegacyWindowFlags = legacyWindowFlags;
        this.mLastLegacySystemUiFlags = legacySystemUiFlags;
        this.mLastInsets = this.mState.calculateInsets(this.mFrame, null, isScreenRound, alwaysConsumeSystemBars, legacySoftInputMode, legacyWindowFlags, legacySystemUiFlags, windowType, windowingMode, null);
        return this.mLastInsets;
    }

    public Rect calculateVisibleInsets(int softInputMode) {
        return this.mState.calculateVisibleInsets(this.mFrame, softInputMode);
    }

    public void onControlsChanged(InsetsSourceControl[] activeControls) {
        int i;
        if (activeControls != null) {
            for (InsetsSourceControl activeControl : activeControls) {
                if (activeControl == null) continue;
                this.mTmpControlArray.put(activeControl.getType(), activeControl);
            }
        }
        boolean requestedStateStale = false;
        int[] showTypes = new int[1];
        int[] hideTypes = new int[1];
        for (i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSourceControl control = this.mTmpControlArray.get(consumer.getType());
            consumer.setControl(control, showTypes, hideTypes);
        }
        for (i = this.mTmpControlArray.size() - 1; i >= 0; --i) {
            InsetsSourceControl control = this.mTmpControlArray.valueAt(i);
            int type = control.getType();
            InsetsSourceConsumer consumer = this.getSourceConsumer(type);
            consumer.setControl(control, showTypes, hideTypes);
            if (requestedStateStale) continue;
            boolean requestedVisible = consumer.isRequestedVisible();
            boolean requestedVisibilityChanged = requestedVisible != this.mRequestedState.getSourceOrDefaultVisibility(type);
            boolean imeRequestedVisible = type == 19 && requestedVisible;
            requestedStateStale = requestedVisibilityChanged || imeRequestedVisible;
        }
        if (this.mTmpControlArray.size() > 0) {
            for (i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                this.mRunningAnimations.get((int)i).runner.updateSurfacePosition(this.mTmpControlArray);
            }
        }
        this.mTmpControlArray.clear();
        int animatingTypes = this.invokeControllableInsetsChangedListeners();
        showTypes[0] = showTypes[0] & ~animatingTypes;
        hideTypes[0] = hideTypes[0] & ~animatingTypes;
        if (showTypes[0] != 0) {
            this.applyAnimation(showTypes[0], true, false);
        }
        if (hideTypes[0] != 0) {
            this.applyAnimation(hideTypes[0], false, false);
        }
        this.updateRequestedVisibility();
    }

    @Override
    public void show(int types) {
        this.show(types, false);
    }

    @VisibleForTesting
    public void show(int types, boolean fromIme) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            Log.d(TAG, "show(ime(), fromIme=" + fromIme + ")");
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#show", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApi", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApiToImeReady", 0);
        }
        if (fromIme && this.mPendingImeControlRequest != null) {
            PendingControlRequest pendingRequest = this.mPendingImeControlRequest;
            this.mPendingImeControlRequest = null;
            this.mHandler.removeCallbacks(this.mPendingControlTimeout);
            this.controlAnimationUnchecked(pendingRequest.types, pendingRequest.cancellationSignal, pendingRequest.listener, null, true, pendingRequest.durationMs, pendingRequest.interpolator, pendingRequest.animationType, pendingRequest.layoutInsetsDuringAnimation, pendingRequest.useInsetsAnimationThread);
            return;
        }
        int typesReady = 0;
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            int internalType = internalTypes.valueAt(i);
            int animationType = this.getAnimationType(internalType);
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalType);
            if (consumer.isRequestedVisible() && animationType == -1 || animationType == 0 || fromIme && animationType == 2) continue;
            typesReady |= InsetsState.toPublicType(consumer.getType());
        }
        this.applyAnimation(typesReady, true, fromIme);
    }

    @Override
    public void hide(int types) {
        this.hide(types, false);
    }

    @VisibleForTesting
    public void hide(int types, boolean fromIme) {
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#hide", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromApi", 0);
        }
        int typesReady = 0;
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            int internalType = internalTypes.valueAt(i);
            int animationType = this.getAnimationType(internalType);
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalType);
            if (!consumer.isRequestedVisible() && animationType == -1 || animationType == 1) continue;
            typesReady |= InsetsState.toPublicType(consumer.getType());
        }
        this.applyAnimation(typesReady, false, fromIme);
    }

    @Override
    public void controlWindowInsetsAnimation(int types, long durationMillis, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener) {
        this.controlWindowInsetsAnimation(types, cancellationSignal, listener, false, durationMillis, interpolator2, 2);
    }

    private void controlWindowInsetsAnimation(int types, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, boolean fromIme, long durationMs, Interpolator interpolator2, int animationType) {
        if ((this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame) & types) != 0) {
            listener.onCancelled(null);
            return;
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#controlWindowInsetsAnimation", this.mHost.getInputMethodManager(), null);
        }
        this.controlAnimationUnchecked(types, cancellationSignal, listener, this.mFrame, fromIme, durationMs, interpolator2, animationType, this.getLayoutInsetsDuringAnimationMode(types), false);
    }

    private void controlAnimationUnchecked(int types, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, Rect frame, boolean fromIme, long durationMs, Interpolator interpolator2, int animationType, int layoutInsetsDuringAnimation, boolean useInsetsAnimationThread) {
        InsetsAnimationControlRunner runner;
        if ((types & this.mTypesBeingCancelled) != 0) {
            throw new IllegalStateException("Cannot start a new insets animation of " + WindowInsets.Type.toString(types) + " while an existing " + WindowInsets.Type.toString(this.mTypesBeingCancelled) + " is being cancelled.");
        }
        if (animationType == 2) {
            int disabledTypes = types & this.mDisabledUserAnimationInsetsTypes;
            types &= ~this.mDisabledUserAnimationInsetsTypes;
            if (fromIme && (disabledTypes & WindowInsets.Type.ime()) != 0 && !this.mState.getSource(19).isVisible()) {
                this.getSourceConsumer(19).hide(true, animationType);
            }
        }
        if (types == 0) {
            listener.onCancelled(null);
            this.updateRequestedVisibility();
            return;
        }
        this.cancelExistingControllers(types);
        this.mLastStartedAnimTypes |= types;
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        SparseArray<InsetsSourceControl> controls = new SparseArray<InsetsSourceControl>();
        Pair<Integer, Boolean> typesReadyPair = this.collectSourceControls(fromIme, internalTypes, controls, animationType);
        int typesReady = (Integer)typesReadyPair.first;
        boolean imeReady = (Boolean)typesReadyPair.second;
        if (!imeReady) {
            PendingControlRequest request;
            this.abortPendingImeControlRequest();
            this.mPendingImeControlRequest = request = new PendingControlRequest(types, listener, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, cancellationSignal, useInsetsAnimationThread);
            this.mHandler.postDelayed(this.mPendingControlTimeout, 2000L);
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(() -> {
                    if (this.mPendingImeControlRequest == request) {
                        this.abortPendingImeControlRequest();
                    }
                });
            }
            this.updateRequestedVisibility();
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            return;
        }
        if (typesReady == 0) {
            listener.onCancelled(null);
            this.updateRequestedVisibility();
            return;
        }
        InsetsAnimationControlRunner insetsAnimationControlRunner = runner = useInsetsAnimationThread ? new InsetsAnimationThreadControlRunner(controls, frame, this.mState, listener, typesReady, this, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator(), this.mHost.getHandler()) : new InsetsAnimationControlImpl(controls, frame, this.mState, listener, typesReady, this, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator());
        if ((typesReady & WindowInsets.Type.ime()) != 0) {
            ImeTracing.getInstance().triggerClientDump("InsetsAnimationControlImpl", this.mHost.getInputMethodManager(), null);
        }
        this.mRunningAnimations.add(new RunningAnimation(runner, animationType));
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(() -> this.cancelAnimation(runner, true));
        } else {
            Trace.asyncTraceBegin(8L, "IC.pendingAnim", 0);
        }
        if (layoutInsetsDuringAnimation == 0) {
            this.showDirectly(types, fromIme);
        } else {
            this.hideDirectly(types, false, animationType, fromIme);
        }
        this.updateRequestedVisibility();
    }

    private Pair<Integer, Boolean> collectSourceControls(boolean fromIme, ArraySet<Integer> internalTypes, SparseArray<InsetsSourceControl> controls, int animationType) {
        int typesReady = 0;
        boolean imeReady = true;
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.getSourceConsumer(internalTypes.valueAt(i));
            boolean show = animationType == 0 || animationType == 2;
            boolean canRun = false;
            if (show) {
                if (fromIme) {
                    ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#requestShow", this.mHost.getInputMethodManager(), null);
                }
                switch (consumer.requestShow(fromIme)) {
                    case 0: {
                        canRun = true;
                        break;
                    }
                    case 1: {
                        imeReady = false;
                        break;
                    }
                }
            } else {
                if (!fromIme) {
                    consumer.notifyHidden();
                }
                canRun = true;
            }
            if (!canRun) continue;
            InsetsSourceControl control = consumer.getControl();
            if (control != null && control.getLeash() != null) {
                controls.put(consumer.getType(), new InsetsSourceControl(control));
                typesReady |= InsetsState.toPublicType(consumer.getType());
                continue;
            }
            if (animationType == 0) {
                if (fromIme) {
                    ImeTracing.getInstance().triggerClientDump("InsetsSourceConsumer#show", this.mHost.getInputMethodManager(), null);
                }
                consumer.show(fromIme);
                continue;
            }
            if (animationType != 1) continue;
            if (fromIme) {
                ImeTracing.getInstance().triggerClientDump("InsetsSourceConsumer#hide", this.mHost.getInputMethodManager(), null);
            }
            consumer.hide();
        }
        return new Pair<Integer, Boolean>(typesReady, imeReady);
    }

    private int getLayoutInsetsDuringAnimationMode(int types) {
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.get(internalTypes.valueAt(i));
            if (consumer == null || consumer.isRequestedVisible()) continue;
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelExistingControllers(int types) {
        int originalmTypesBeingCancelled = this.mTypesBeingCancelled;
        this.mTypesBeingCancelled |= types;
        try {
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
                if ((control.getTypes() & types) == 0) continue;
                this.cancelAnimation(control, true);
            }
            if ((types & WindowInsets.Type.ime()) != 0) {
                this.abortPendingImeControlRequest();
            }
        }
        finally {
            this.mTypesBeingCancelled = originalmTypesBeingCancelled;
        }
    }

    private void abortPendingImeControlRequest() {
        if (this.mPendingImeControlRequest != null) {
            this.mPendingImeControlRequest.listener.onCancelled(null);
            this.mPendingImeControlRequest = null;
            this.mHandler.removeCallbacks(this.mPendingControlTimeout);
        }
    }

    @Override
    @VisibleForTesting
    public void notifyFinished(InsetsAnimationControlRunner runner, boolean shown) {
        this.cancelAnimation(runner, false);
        if (shown) {
            this.showDirectly(runner.getTypes(), true);
        } else {
            this.hideDirectly(runner.getTypes(), true, runner.getAnimationType(), true);
        }
    }

    @Override
    public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
        this.mHost.applySurfaceParams(params);
    }

    void notifyControlRevoked(InsetsSourceConsumer consumer) {
        int types = InsetsState.toPublicType(consumer.getType());
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
            control.notifyControlRevoked(types);
            if (control.getControllingTypes() != 0) continue;
            this.cancelAnimation(control, true);
        }
        if (consumer.getType() == 19) {
            this.abortPendingImeControlRequest();
        }
    }

    private void cancelAnimation(InsetsAnimationControlRunner control, boolean invokeCallback) {
        if (invokeCallback) {
            control.cancel();
        }
        boolean stateChanged = false;
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
            if (runningAnimation.runner != control) continue;
            this.mRunningAnimations.remove(i);
            ArraySet<Integer> types = InsetsState.toInternalType(control.getTypes());
            for (int j = types.size() - 1; j >= 0; --j) {
                if (types.valueAt(j) == 19) {
                    ImeTracing.getInstance().triggerClientDump("InsetsSourceConsumer#notifyAnimationFinished", this.mHost.getInputMethodManager(), null);
                }
                stateChanged |= this.getSourceConsumer(types.valueAt(j)).notifyAnimationFinished();
            }
            if (!invokeCallback) break;
            this.dispatchAnimationEnd(runningAnimation.runner.getAnimation());
            break;
        }
        if (stateChanged) {
            this.mHost.notifyInsetsChanged();
        }
    }

    private void applyLocalVisibilityOverride() {
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            consumer.applyLocalVisibilityOverride();
        }
    }

    @VisibleForTesting
    public InsetsSourceConsumer getSourceConsumer(int type) {
        InsetsSourceConsumer controller = this.mSourceConsumers.get(type);
        if (controller != null) {
            return controller;
        }
        controller = this.mConsumerCreator.apply(this, type);
        this.mSourceConsumers.put(type, controller);
        return controller;
    }

    @VisibleForTesting
    public void notifyVisibilityChanged() {
        this.mHost.notifyInsetsChanged();
    }

    public void updateCompatSysUiVisibility(int type, boolean visible, boolean hasControl) {
        this.mHost.updateCompatSysUiVisibility(type, visible, hasControl);
    }

    public void onWindowFocusGained(boolean hasViewFocused) {
        this.getSourceConsumer(19).onWindowFocusGained(hasViewFocused);
    }

    public void onWindowFocusLost() {
        this.getSourceConsumer(19).onWindowFocusLost();
    }

    @VisibleForTesting
    public int getAnimationType(int type) {
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
            if (!control.controlsInternalType(type)) continue;
            return this.mRunningAnimations.get((int)i).type;
        }
        return -1;
    }

    @VisibleForTesting
    public void onRequestedVisibilityChanged(InsetsSourceConsumer consumer) {
        this.mRequestedVisibilityChanged.add(consumer);
    }

    private void updateRequestedVisibility() {
        boolean changed = false;
        for (int i = this.mRequestedVisibilityChanged.size() - 1; i >= 0; --i) {
            boolean requestedVisible;
            InsetsSourceConsumer consumer = this.mRequestedVisibilityChanged.valueAt(i);
            int type = consumer.getType();
            if (type == 2 || (requestedVisible = consumer.isRequestedVisible()) == this.mRequestedState.getSourceOrDefaultVisibility(type)) continue;
            this.mRequestedState.getSource(type).setVisible(requestedVisible);
            changed = true;
        }
        this.mRequestedVisibilityChanged.clear();
        if (!changed) {
            return;
        }
        this.mHost.onInsetsModified(this.mRequestedState);
    }

    InsetsState getRequestedVisibility() {
        return this.mRequestedState;
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme) {
        boolean skipAnim = false;
        if ((types & WindowInsets.Type.ime()) != 0) {
            InsetsSourceControl imeControl;
            InsetsSourceConsumer consumer = this.mSourceConsumers.get(19);
            InsetsSourceControl insetsSourceControl = imeControl = consumer != null ? consumer.getControl() : null;
            if (imeControl != null) {
                skipAnim = imeControl.getAndClearSkipAnimationOnce() && show && consumer.hasViewFocusWhenWindowFocusGain();
            }
        }
        this.applyAnimation(types, show, fromIme, skipAnim);
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme, boolean skipAnim) {
        if (types == 0) {
            return;
        }
        boolean hasAnimationCallbacks = this.mHost.hasAnimationCallbacks();
        InternalAnimationControlListener listener = new InternalAnimationControlListener(show, hasAnimationCallbacks, types, this.mHost.getSystemBarsBehavior(), skipAnim || this.mAnimationsDisabled, this.mHost.dipToPx(-80));
        this.controlAnimationUnchecked(types, null, listener, null, fromIme, listener.getDurationMs(), listener.getInsetsInterpolator(), show ? 0 : 1, show ? 0 : 1, !hasAnimationCallbacks);
    }

    private void hideDirectly(int types, boolean animationFinished, int animationType, boolean fromIme) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#hideDirectly", this.mHost.getInputMethodManager(), null);
        }
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            this.getSourceConsumer(internalTypes.valueAt(i)).hide(animationFinished, animationType);
        }
        this.updateRequestedVisibility();
        if (fromIme) {
            Trace.asyncTraceEnd(8L, "IC.hideRequestFromIme", 0);
        }
    }

    private void showDirectly(int types, boolean fromIme) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#showDirectly", this.mHost.getInputMethodManager(), null);
        }
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        for (int i = internalTypes.size() - 1; i >= 0; --i) {
            this.getSourceConsumer(internalTypes.valueAt(i)).show(false);
        }
        this.updateRequestedVisibility();
        if (fromIme) {
            Trace.asyncTraceEnd(8L, "IC.showRequestFromIme", 0);
        }
    }

    @VisibleForTesting
    public void cancelExistingAnimations() {
        this.cancelExistingControllers(WindowInsets.Type.all());
    }

    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.println("InsetsController:");
        this.mState.dump(prefix + "  ", pw);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mState.dumpDebug(proto, 0x10B00000001L);
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            runner.dumpDebug(proto, 0x20B00000002L);
        }
        proto.end(token);
    }

    @Override
    @VisibleForTesting
    public void startAnimation(InsetsAnimationControlImpl controller, WindowInsetsAnimationControlListener listener, int types, WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        this.mHost.dispatchWindowInsetsAnimationPrepare(animation);
        this.mHost.addOnPreDrawRunnable(() -> {
            if (controller.isCancelled()) {
                return;
            }
            Trace.asyncTraceBegin(8L, "InsetsAnimation: " + WindowInsets.Type.toString(types), types);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                if (runningAnimation.runner != controller) continue;
                runningAnimation.startDispatched = true;
            }
            Trace.asyncTraceEnd(8L, "IC.pendingAnim", 0);
            this.mHost.dispatchWindowInsetsAnimationStart(animation, bounds);
            this.mStartingAnimation = true;
            controller.mReadyDispatched = true;
            listener.onReady(controller, types);
            this.mStartingAnimation = false;
        });
    }

    @VisibleForTesting
    public void dispatchAnimationEnd(WindowInsetsAnimation animation) {
        Trace.asyncTraceEnd(8L, "InsetsAnimation: " + WindowInsets.Type.toString(animation.getTypeMask()), animation.getTypeMask());
        this.mHost.dispatchWindowInsetsAnimationEnd(animation);
    }

    @Override
    @VisibleForTesting
    public void scheduleApplyChangeInsets(InsetsAnimationControlRunner runner) {
        if (this.mStartingAnimation || runner.getAnimationType() == 2) {
            this.mAnimCallback.run();
            this.mAnimCallbackScheduled = false;
            return;
        }
        if (!this.mAnimCallbackScheduled) {
            this.mHost.postInsetsAnimationCallback(this.mAnimCallback);
            this.mAnimCallbackScheduled = true;
        }
    }

    @Override
    public void setSystemBarsAppearance(int appearance, int mask) {
        this.mHost.setSystemBarsAppearance(appearance, mask);
    }

    @Override
    public int getSystemBarsAppearance() {
        if (!this.mHost.isSystemBarsAppearanceControlled()) {
            return 0;
        }
        return this.mHost.getSystemBarsAppearance();
    }

    @Override
    public void setCaptionInsetsHeight(int height) {
        if (this.mCaptionInsetsHeight != height) {
            this.mCaptionInsetsHeight = height;
            if (this.mCaptionInsetsHeight != 0) {
                this.mState.getSource(2).setFrame(new Rect(this.mFrame.left, this.mFrame.top, this.mFrame.right, this.mFrame.top + this.mCaptionInsetsHeight));
            } else {
                this.mState.removeSource(2);
            }
            this.mHost.notifyInsetsChanged();
        }
    }

    @Override
    public void setSystemBarsBehavior(int behavior) {
        this.mHost.setSystemBarsBehavior(behavior);
    }

    @Override
    public int getSystemBarsBehavior() {
        if (!this.mHost.isSystemBarsBehaviorControlled()) {
            return 0;
        }
        return this.mHost.getSystemBarsBehavior();
    }

    @Override
    public void setAnimationsDisabled(boolean disable) {
        this.mAnimationsDisabled = disable;
    }

    private int calculateControllableTypes() {
        int result = 0;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSource source = this.mState.peekSource(consumer.mType);
            if (consumer.getControl() == null || source == null || !source.isUserControllable()) continue;
            result |= InsetsState.toPublicType(consumer.mType);
        }
        return result & ~this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame);
    }

    private int invokeControllableInsetsChangedListeners() {
        this.mHandler.removeCallbacks(this.mInvokeControllableInsetsChangedListeners);
        this.mLastStartedAnimTypes = 0;
        int types = this.calculateControllableTypes();
        int size = this.mControllableInsetsChangedListeners.size();
        for (int i = 0; i < size; ++i) {
            this.mControllableInsetsChangedListeners.get(i).onControllableInsetsChanged(this, types);
        }
        return this.mLastStartedAnimTypes;
    }

    @Override
    public void addOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.add(listener);
        listener.onControllableInsetsChanged(this, this.calculateControllableTypes());
    }

    @Override
    public void removeOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.remove(listener);
    }

    @Override
    public void releaseSurfaceControlFromRt(SurfaceControl sc) {
        this.mHost.releaseSurfaceControlFromRt(sc);
    }

    @Override
    public void reportPerceptible(int types, boolean perceptible) {
        ArraySet<Integer> internalTypes = InsetsState.toInternalType(types);
        int size = this.mSourceConsumers.size();
        for (int i = 0; i < size; ++i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if (!internalTypes.contains(consumer.getType())) continue;
            consumer.onPerceptible(perceptible);
        }
    }

    Host getHost() {
        return this.mHost;
    }

    private static class PendingControlRequest {
        final int types;
        final WindowInsetsAnimationControlListener listener;
        final long durationMs;
        final Interpolator interpolator;
        final int animationType;
        final int layoutInsetsDuringAnimation;
        final CancellationSignal cancellationSignal;
        final boolean useInsetsAnimationThread;

        PendingControlRequest(int types, WindowInsetsAnimationControlListener listener, long durationMs, Interpolator interpolator2, int animationType, int layoutInsetsDuringAnimation, CancellationSignal cancellationSignal, boolean useInsetsAnimationThread) {
            this.types = types;
            this.listener = listener;
            this.durationMs = durationMs;
            this.interpolator = interpolator2;
            this.animationType = animationType;
            this.layoutInsetsDuringAnimation = layoutInsetsDuringAnimation;
            this.cancellationSignal = cancellationSignal;
            this.useInsetsAnimationThread = useInsetsAnimationThread;
        }
    }

    private static class RunningAnimation {
        final InsetsAnimationControlRunner runner;
        final int type;
        boolean startDispatched;

        RunningAnimation(InsetsAnimationControlRunner runner, int type) {
            this.runner = runner;
            this.type = type;
        }
    }

    public static class InternalAnimationControlListener
    implements WindowInsetsAnimationControlListener {
        private WindowInsetsAnimationController mController;
        private ValueAnimator mAnimator;
        private final boolean mShow;
        private final boolean mHasAnimationCallbacks;
        private final int mRequestedTypes;
        private final int mBehavior;
        private final long mDurationMs;
        private final boolean mDisable;
        private final int mFloatingImeBottomInset;
        private ThreadLocal<AnimationHandler> mSfAnimationHandlerThreadLocal = new ThreadLocal<AnimationHandler>(){

            @Override
            protected AnimationHandler initialValue() {
                AnimationHandler handler = new AnimationHandler();
                handler.setProvider(new SfVsyncFrameCallbackProvider());
                return handler;
            }
        };

        public InternalAnimationControlListener(boolean show, boolean hasAnimationCallbacks, int requestedTypes, int behavior, boolean disable, int floatingImeBottomInset) {
            this.mShow = show;
            this.mHasAnimationCallbacks = hasAnimationCallbacks;
            this.mRequestedTypes = requestedTypes;
            this.mBehavior = behavior;
            this.mDurationMs = this.calculateDurationMs();
            this.mDisable = disable;
            this.mFloatingImeBottomInset = floatingImeBottomInset;
        }

        @Override
        public void onReady(WindowInsetsAnimationController controller, int types) {
            this.mController = controller;
            if (this.mDisable) {
                this.onAnimationFinish();
                return;
            }
            this.mAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mAnimator.setDuration(this.mDurationMs);
            this.mAnimator.setInterpolator(new LinearInterpolator());
            Insets hiddenInsets = controller.getHiddenStateInsets();
            hiddenInsets = controller.hasZeroInsetsIme() ? Insets.of(hiddenInsets.left, hiddenInsets.top, hiddenInsets.right, this.mFloatingImeBottomInset) : hiddenInsets;
            Insets start = this.mShow ? hiddenInsets : controller.getShownStateInsets();
            Insets end = this.mShow ? controller.getShownStateInsets() : hiddenInsets;
            Interpolator insetsInterpolator = this.getInsetsInterpolator();
            Interpolator alphaInterpolator = this.getAlphaInterpolator();
            this.mAnimator.addUpdateListener(animation -> {
                float rawFraction = animation.getAnimatedFraction();
                float alphaFraction = this.mShow ? rawFraction : 1.0f - rawFraction;
                float insetsFraction = insetsInterpolator.getInterpolation(rawFraction);
                controller.setInsetsAndAlpha(sEvaluator.evaluate(insetsFraction, start, end), alphaInterpolator.getInterpolation(alphaFraction), rawFraction);
            });
            this.mAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    this.onAnimationFinish();
                }
            });
            if (!this.mHasAnimationCallbacks) {
                this.mAnimator.setAnimationHandler(this.mSfAnimationHandlerThreadLocal.get());
            }
            this.mAnimator.start();
        }

        @Override
        public void onFinished(WindowInsetsAnimationController controller) {
        }

        @Override
        public void onCancelled(WindowInsetsAnimationController controller) {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
        }

        protected Interpolator getInsetsInterpolator() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return SYNC_IME_INTERPOLATOR;
                }
                if (this.mShow) {
                    return LINEAR_OUT_SLOW_IN_INTERPOLATOR;
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return SYSTEM_BARS_INSETS_INTERPOLATOR;
            }
            return input -> this.mShow ? 1.0f : 0.0f;
        }

        Interpolator getAlphaInterpolator() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return input -> 1.0f;
                }
                if (this.mShow) {
                    return input -> Math.min(1.0f, 2.0f * input);
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return input -> 1.0f;
            }
            if (this.mShow) {
                return SYSTEM_BARS_ALPHA_INTERPOLATOR;
            }
            return SYSTEM_BARS_DIM_INTERPOLATOR;
        }

        protected void onAnimationFinish() {
            this.mController.finish(this.mShow);
        }

        public long getDurationMs() {
            return this.mDurationMs;
        }

        private long calculateDurationMs() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return 285L;
                }
                return 200L;
            }
            if (this.mBehavior == 2) {
                return this.mShow ? 275L : 340L;
            }
            return this.mShow ? 500L : 1500L;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface AnimationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LayoutInsetsDuringAnimation {
    }

    public static interface Host {
        public Handler getHandler();

        public void notifyInsetsChanged();

        public void dispatchWindowInsetsAnimationPrepare(WindowInsetsAnimation var1);

        public WindowInsetsAnimation.Bounds dispatchWindowInsetsAnimationStart(WindowInsetsAnimation var1, WindowInsetsAnimation.Bounds var2);

        public WindowInsets dispatchWindowInsetsAnimationProgress(WindowInsets var1, List<WindowInsetsAnimation> var2);

        public void dispatchWindowInsetsAnimationEnd(WindowInsetsAnimation var1);

        public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... var1);

        public void updateCompatSysUiVisibility(int var1, boolean var2, boolean var3);

        public void onInsetsModified(InsetsState var1);

        public boolean hasAnimationCallbacks();

        public void setSystemBarsAppearance(int var1, int var2);

        public int getSystemBarsAppearance();

        default public boolean isSystemBarsAppearanceControlled() {
            return false;
        }

        public void setSystemBarsBehavior(int var1);

        public int getSystemBarsBehavior();

        default public boolean isSystemBarsBehaviorControlled() {
            return false;
        }

        public void releaseSurfaceControlFromRt(SurfaceControl var1);

        public void addOnPreDrawRunnable(Runnable var1);

        public void postInsetsAnimationCallback(Runnable var1);

        public InputMethodManager getInputMethodManager();

        public String getRootViewTitle();

        public int dipToPx(int var1);

        public IBinder getWindowToken();

        default public CompatibilityInfo.Translator getTranslator() {
            return null;
        }
    }
}

