/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.res.Configuration;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;

public class TaskSnapshot
implements Parcelable {
    private final long mId;
    private final ComponentName mTopActivityComponent;
    private final HardwareBuffer mSnapshot;
    @Configuration.Orientation
    private final int mOrientation;
    private final int mRotation;
    private final Point mTaskSize;
    private final Rect mContentInsets;
    private final boolean mIsLowResolution;
    private final boolean mIsRealSnapshot;
    private final int mWindowingMode;
    private final int mAppearance;
    private final boolean mIsTranslucent;
    private final boolean mHasImeSurface;
    private final ColorSpace mColorSpace;
    public static final Parcelable.Creator<TaskSnapshot> CREATOR = new Parcelable.Creator<TaskSnapshot>(){

        @Override
        public TaskSnapshot createFromParcel(Parcel source) {
            return new TaskSnapshot(source);
        }

        public TaskSnapshot[] newArray(int size) {
            return new TaskSnapshot[size];
        }
    };

    public TaskSnapshot(long id2, ComponentName topActivityComponent, HardwareBuffer snapshot, ColorSpace colorSpace, int orientation, int rotation, Point taskSize, Rect contentInsets, boolean isLowResolution, boolean isRealSnapshot, int windowingMode, int appearance, boolean isTranslucent, boolean hasImeSurface) {
        this.mId = id2;
        this.mTopActivityComponent = topActivityComponent;
        this.mSnapshot = snapshot;
        this.mColorSpace = colorSpace.getId() < 0 ? ColorSpace.get(ColorSpace.Named.SRGB) : colorSpace;
        this.mOrientation = orientation;
        this.mRotation = rotation;
        this.mTaskSize = new Point(taskSize);
        this.mContentInsets = new Rect(contentInsets);
        this.mIsLowResolution = isLowResolution;
        this.mIsRealSnapshot = isRealSnapshot;
        this.mWindowingMode = windowingMode;
        this.mAppearance = appearance;
        this.mIsTranslucent = isTranslucent;
        this.mHasImeSurface = hasImeSurface;
    }

    private TaskSnapshot(Parcel source) {
        this.mId = source.readLong();
        this.mTopActivityComponent = ComponentName.readFromParcel(source);
        this.mSnapshot = source.readTypedObject(HardwareBuffer.CREATOR);
        int colorSpaceId = source.readInt();
        this.mColorSpace = colorSpaceId >= 0 && colorSpaceId < ColorSpace.Named.values().length ? ColorSpace.get(ColorSpace.Named.values()[colorSpaceId]) : ColorSpace.get(ColorSpace.Named.SRGB);
        this.mOrientation = source.readInt();
        this.mRotation = source.readInt();
        this.mTaskSize = source.readTypedObject(Point.CREATOR);
        this.mContentInsets = source.readTypedObject(Rect.CREATOR);
        this.mIsLowResolution = source.readBoolean();
        this.mIsRealSnapshot = source.readBoolean();
        this.mWindowingMode = source.readInt();
        this.mAppearance = source.readInt();
        this.mIsTranslucent = source.readBoolean();
        this.mHasImeSurface = source.readBoolean();
    }

    public long getId() {
        return this.mId;
    }

    public ComponentName getTopActivityComponent() {
        return this.mTopActivityComponent;
    }

    @UnsupportedAppUsage
    public GraphicBuffer getSnapshot() {
        return GraphicBuffer.createFromHardwareBuffer(this.mSnapshot);
    }

    public HardwareBuffer getHardwareBuffer() {
        return this.mSnapshot;
    }

    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    @UnsupportedAppUsage
    public int getOrientation() {
        return this.mOrientation;
    }

    public int getRotation() {
        return this.mRotation;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Point getTaskSize() {
        return this.mTaskSize;
    }

    @UnsupportedAppUsage
    public Rect getContentInsets() {
        return this.mContentInsets;
    }

    @UnsupportedAppUsage
    public boolean isLowResolution() {
        return this.mIsLowResolution;
    }

    @UnsupportedAppUsage
    public boolean isRealSnapshot() {
        return this.mIsRealSnapshot;
    }

    public boolean isTranslucent() {
        return this.mIsTranslucent;
    }

    public boolean hasImeSurface() {
        return this.mHasImeSurface;
    }

    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    public int getAppearance() {
        return this.mAppearance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        ComponentName.writeToParcel(this.mTopActivityComponent, dest);
        dest.writeTypedObject(this.mSnapshot != null && !this.mSnapshot.isClosed() ? this.mSnapshot : null, 0);
        dest.writeInt(this.mColorSpace.getId());
        dest.writeInt(this.mOrientation);
        dest.writeInt(this.mRotation);
        dest.writeTypedObject(this.mTaskSize, 0);
        dest.writeTypedObject(this.mContentInsets, 0);
        dest.writeBoolean(this.mIsLowResolution);
        dest.writeBoolean(this.mIsRealSnapshot);
        dest.writeInt(this.mWindowingMode);
        dest.writeInt(this.mAppearance);
        dest.writeBoolean(this.mIsTranslucent);
        dest.writeBoolean(this.mHasImeSurface);
    }

    public String toString() {
        int width = this.mSnapshot != null ? this.mSnapshot.getWidth() : 0;
        int height = this.mSnapshot != null ? this.mSnapshot.getHeight() : 0;
        return "TaskSnapshot{ mId=" + this.mId + " mTopActivityComponent=" + this.mTopActivityComponent.flattenToShortString() + " mSnapshot=" + this.mSnapshot + " (" + width + "x" + height + ") mColorSpace=" + this.mColorSpace.toString() + " mOrientation=" + this.mOrientation + " mRotation=" + this.mRotation + " mTaskSize=" + this.mTaskSize.toString() + " mContentInsets=" + this.mContentInsets.toShortString() + " mIsLowResolution=" + this.mIsLowResolution + " mIsRealSnapshot=" + this.mIsRealSnapshot + " mWindowingMode=" + this.mWindowingMode + " mAppearance=" + this.mAppearance + " mIsTranslucent=" + this.mIsTranslucent + " mHasImeSurface=" + this.mHasImeSurface;
    }

    public static class Builder {
        private long mId;
        private ComponentName mTopActivity;
        private HardwareBuffer mSnapshot;
        private ColorSpace mColorSpace;
        private int mOrientation;
        private int mRotation;
        private Point mTaskSize;
        private Rect mContentInsets;
        private boolean mIsRealSnapshot;
        private int mWindowingMode;
        private int mAppearance;
        private boolean mIsTranslucent;
        private boolean mHasImeSurface;
        private int mPixelFormat;

        public Builder setId(long id2) {
            this.mId = id2;
            return this;
        }

        public Builder setTopActivityComponent(ComponentName name) {
            this.mTopActivity = name;
            return this;
        }

        public Builder setSnapshot(HardwareBuffer buffer) {
            this.mSnapshot = buffer;
            return this;
        }

        public Builder setColorSpace(ColorSpace colorSpace) {
            this.mColorSpace = colorSpace;
            return this;
        }

        public Builder setOrientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.mRotation = rotation;
            return this;
        }

        public Builder setTaskSize(Point size) {
            this.mTaskSize = size;
            return this;
        }

        public Builder setContentInsets(Rect contentInsets) {
            this.mContentInsets = contentInsets;
            return this;
        }

        public Builder setIsRealSnapshot(boolean realSnapshot) {
            this.mIsRealSnapshot = realSnapshot;
            return this;
        }

        public Builder setWindowingMode(int windowingMode) {
            this.mWindowingMode = windowingMode;
            return this;
        }

        public Builder setAppearance(int appearance) {
            this.mAppearance = appearance;
            return this;
        }

        public Builder setIsTranslucent(boolean isTranslucent) {
            this.mIsTranslucent = isTranslucent;
            return this;
        }

        public Builder setHasImeSurface(boolean hasImeSurface) {
            this.mHasImeSurface = hasImeSurface;
            return this;
        }

        public int getPixelFormat() {
            return this.mPixelFormat;
        }

        public Builder setPixelFormat(int pixelFormat) {
            this.mPixelFormat = pixelFormat;
            return this;
        }

        public TaskSnapshot build() {
            return new TaskSnapshot(this.mId, this.mTopActivity, this.mSnapshot, this.mColorSpace, this.mOrientation, this.mRotation, this.mTaskSize, this.mContentInsets, false, this.mIsRealSnapshot, this.mWindowingMode, this.mAppearance, this.mIsTranslucent, this.mHasImeSurface);
        }
    }
}

