/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.ActivityManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.WindowManager;
import android.window.IRemoteTransition;
import com.android.internal.util.AnnotationValidations;

public class TransitionRequestInfo
implements Parcelable {
    private final int mType;
    private ActivityManager.RunningTaskInfo mTriggerTask;
    private IRemoteTransition mRemoteTransition;
    public static final Parcelable.Creator<TransitionRequestInfo> CREATOR = new Parcelable.Creator<TransitionRequestInfo>(){

        public TransitionRequestInfo[] newArray(int size) {
            return new TransitionRequestInfo[size];
        }

        @Override
        public TransitionRequestInfo createFromParcel(Parcel in) {
            return new TransitionRequestInfo(in);
        }
    };

    public TransitionRequestInfo(int type, ActivityManager.RunningTaskInfo triggerTask, IRemoteTransition remoteTransition) {
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mRemoteTransition = remoteTransition;
    }

    public int getType() {
        return this.mType;
    }

    public ActivityManager.RunningTaskInfo getTriggerTask() {
        return this.mTriggerTask;
    }

    public IRemoteTransition getRemoteTransition() {
        return this.mRemoteTransition;
    }

    public TransitionRequestInfo setTriggerTask(ActivityManager.RunningTaskInfo value) {
        this.mTriggerTask = value;
        return this;
    }

    public TransitionRequestInfo setRemoteTransition(IRemoteTransition value) {
        this.mRemoteTransition = value;
        return this;
    }

    public String toString() {
        return "TransitionRequestInfo { type = " + this.mType + ", triggerTask = " + this.mTriggerTask + ", remoteTransition = " + this.mRemoteTransition + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mTriggerTask != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mRemoteTransition != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mType);
        if (this.mTriggerTask != null) {
            dest.writeTypedObject(this.mTriggerTask, flags);
        }
        if (this.mRemoteTransition != null) {
            dest.writeStrongInterface(this.mRemoteTransition);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TransitionRequestInfo(Parcel in) {
        byte flg = in.readByte();
        int type = in.readInt();
        ActivityManager.RunningTaskInfo triggerTask = (flg & 2) == 0 ? null : in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        IRemoteTransition remoteTransition = (flg & 4) == 0 ? null : IRemoteTransition.Stub.asInterface(in.readStrongBinder());
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mRemoteTransition = remoteTransition;
    }

    @Deprecated
    private void __metadata() {
    }
}

