/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.cam;

import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.CamUtils;
import com.android.internal.graphics.cam.Frame;

public class Cam {
    private static final float DL_MAX = 0.2f;
    private static final float DE_MAX = 1.0f;
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;
    private final float mHue;
    private final float mChroma;
    private final float mJ;
    private final float mQ;
    private final float mM;
    private final float mS;
    private final float mJstar;
    private final float mAstar;
    private final float mBstar;

    public float getHue() {
        return this.mHue;
    }

    public float getChroma() {
        return this.mChroma;
    }

    public float getJ() {
        return this.mJ;
    }

    public float getQ() {
        return this.mQ;
    }

    public float getM() {
        return this.mM;
    }

    public float getS() {
        return this.mS;
    }

    public float getJstar() {
        return this.mJstar;
    }

    public float getAstar() {
        return this.mAstar;
    }

    public float getBstar() {
        return this.mBstar;
    }

    Cam(float hue, float chroma, float j, float q, float m, float s, float jstar, float astar, float bstar) {
        this.mHue = hue;
        this.mChroma = chroma;
        this.mJ = j;
        this.mQ = q;
        this.mM = m;
        this.mS = s;
        this.mJstar = jstar;
        this.mAstar = astar;
        this.mBstar = bstar;
    }

    public static int getInt(float hue, float chroma, float lstar) {
        return Cam.getInt(hue, chroma, lstar, Frame.DEFAULT);
    }

    public static Cam fromInt(int argb) {
        return Cam.fromIntInFrame(argb, Frame.DEFAULT);
    }

    public static Cam fromIntInFrame(int argb, Frame frame) {
        float[] xyz = CamUtils.xyzFromInt(argb);
        float[][] matrix = CamUtils.XYZ_TO_CAM16RGB;
        float rT = xyz[0] * matrix[0][0] + xyz[1] * matrix[0][1] + xyz[2] * matrix[0][2];
        float gT = xyz[0] * matrix[1][0] + xyz[1] * matrix[1][1] + xyz[2] * matrix[1][2];
        float bT = xyz[0] * matrix[2][0] + xyz[1] * matrix[2][1] + xyz[2] * matrix[2][2];
        float rD = frame.getRgbD()[0] * rT;
        float gD = frame.getRgbD()[1] * gT;
        float bD = frame.getRgbD()[2] * bT;
        float rAF = (float)Math.pow((double)(frame.getFl() * Math.abs(rD)) / 100.0, 0.42);
        float gAF = (float)Math.pow((double)(frame.getFl() * Math.abs(gD)) / 100.0, 0.42);
        float bAF = (float)Math.pow((double)(frame.getFl() * Math.abs(bD)) / 100.0, 0.42);
        float rA = Math.signum(rD) * 400.0f * rAF / (rAF + 27.13f);
        float gA = Math.signum(gD) * 400.0f * gAF / (gAF + 27.13f);
        float bA = Math.signum(bD) * 400.0f * bAF / (bAF + 27.13f);
        float a = (float)(11.0 * (double)rA + -12.0 * (double)gA + (double)bA) / 11.0f;
        float b = (float)((double)(rA + gA) - 2.0 * (double)bA) / 9.0f;
        float u = (20.0f * rA + 20.0f * gA + 21.0f * bA) / 20.0f;
        float p2 = (40.0f * rA + 20.0f * gA + bA) / 20.0f;
        float atan2 = (float)Math.atan2(b, a);
        float atanDegrees = atan2 * 180.0f / (float)Math.PI;
        float hue = atanDegrees < 0.0f ? atanDegrees + 360.0f : (atanDegrees >= 360.0f ? atanDegrees - 360.0f : atanDegrees);
        float hueRadians = hue * (float)Math.PI / 180.0f;
        float ac = p2 * frame.getNbb();
        float j = 100.0f * (float)Math.pow(ac / frame.getAw(), frame.getC() * frame.getZ());
        float q = 4.0f / frame.getC() * (float)Math.sqrt(j / 100.0f) * (frame.getAw() + 4.0f) * frame.getFlRoot();
        float huePrime = (double)hue < 20.14 ? hue + 360.0f : hue;
        float eHue = 0.25f * (float)(Math.cos((double)huePrime * Math.PI / 180.0 + 2.0) + 3.8);
        float p1 = 3846.1538f * eHue * frame.getNc() * frame.getNcb();
        float t = p1 * (float)Math.sqrt(a * a + b * b) / (u + 0.305f);
        float alpha = (float)Math.pow(t, 0.9) * (float)Math.pow(1.64 - Math.pow(0.29, frame.getN()), 0.73);
        float c = alpha * (float)Math.sqrt((double)j / 100.0);
        float m = c * frame.getFlRoot();
        float s = 50.0f * (float)Math.sqrt(alpha * frame.getC() / (frame.getAw() + 4.0f));
        float jstar = 1.7f * j / (1.0f + 0.007f * j);
        float mstar = 43.85965f * (float)Math.log(1.0f + 0.0228f * m);
        float astar = mstar * (float)Math.cos(hueRadians);
        float bstar = mstar * (float)Math.sin(hueRadians);
        return new Cam(hue, c, j, q, m, s, jstar, astar, bstar);
    }

    private static Cam fromJch(float j, float c, float h) {
        return Cam.fromJchInFrame(j, c, h, Frame.DEFAULT);
    }

    private static Cam fromJchInFrame(float j, float c, float h, Frame frame) {
        float q = 4.0f / frame.getC() * (float)Math.sqrt((double)j / 100.0) * (frame.getAw() + 4.0f) * frame.getFlRoot();
        float m = c * frame.getFlRoot();
        float alpha = c / (float)Math.sqrt((double)j / 100.0);
        float s = 50.0f * (float)Math.sqrt(alpha * frame.getC() / (frame.getAw() + 4.0f));
        float hueRadians = h * (float)Math.PI / 180.0f;
        float jstar = 1.7f * j / (1.0f + 0.007f * j);
        float mstar = 43.85965f * (float)Math.log(1.0 + 0.0228 * (double)m);
        float astar = mstar * (float)Math.cos(hueRadians);
        float bstar = mstar * (float)Math.sin(hueRadians);
        return new Cam(h, c, j, q, m, s, jstar, astar, bstar);
    }

    public float distance(Cam other) {
        float dJ = this.getJstar() - other.getJstar();
        float dA = this.getAstar() - other.getAstar();
        float dB = this.getBstar() - other.getBstar();
        double dEPrime = Math.sqrt(dJ * dJ + dA * dA + dB * dB);
        double dE = 1.41 * Math.pow(dEPrime, 0.63);
        return (float)dE;
    }

    public int viewedInSrgb() {
        return this.viewed(Frame.DEFAULT);
    }

    public int viewed(Frame frame) {
        float alpha = (double)this.getChroma() == 0.0 || (double)this.getJ() == 0.0 ? 0.0f : this.getChroma() / (float)Math.sqrt((double)this.getJ() / 100.0);
        float t = (float)Math.pow((double)alpha / Math.pow(1.64 - Math.pow(0.29, frame.getN()), 0.73), 1.1111111111111112);
        float hRad = this.getHue() * (float)Math.PI / 180.0f;
        float eHue = 0.25f * (float)(Math.cos((double)hRad + 2.0) + 3.8);
        float ac = frame.getAw() * (float)Math.pow((double)this.getJ() / 100.0, 1.0 / (double)frame.getC() / (double)frame.getZ());
        float p1 = eHue * 3846.1538f * frame.getNc() * frame.getNcb();
        float p2 = ac / frame.getNbb();
        float hSin = (float)Math.sin(hRad);
        float hCos = (float)Math.cos(hRad);
        float gamma = 23.0f * (p2 + 0.305f) * t / (23.0f * p1 + 11.0f * t * hCos + 108.0f * t * hSin);
        float a = gamma * hCos;
        float b = gamma * hSin;
        float rA = (460.0f * p2 + 451.0f * a + 288.0f * b) / 1403.0f;
        float gA = (460.0f * p2 - 891.0f * a - 261.0f * b) / 1403.0f;
        float bA = (460.0f * p2 - 220.0f * a - 6300.0f * b) / 1403.0f;
        float rCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(rA) / (400.0 - (double)Math.abs(rA)));
        float rC = Math.signum(rA) * (100.0f / frame.getFl()) * (float)Math.pow(rCBase, 2.380952380952381);
        float gCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(gA) / (400.0 - (double)Math.abs(gA)));
        float gC = Math.signum(gA) * (100.0f / frame.getFl()) * (float)Math.pow(gCBase, 2.380952380952381);
        float bCBase = (float)Math.max(0.0, 27.13 * (double)Math.abs(bA) / (400.0 - (double)Math.abs(bA)));
        float bC = Math.signum(bA) * (100.0f / frame.getFl()) * (float)Math.pow(bCBase, 2.380952380952381);
        float rF = rC / frame.getRgbD()[0];
        float gF = gC / frame.getRgbD()[1];
        float bF = bC / frame.getRgbD()[2];
        float[][] matrix = CamUtils.CAM16RGB_TO_XYZ;
        float x = rF * matrix[0][0] + gF * matrix[0][1] + bF * matrix[0][2];
        float y = rF * matrix[1][0] + gF * matrix[1][1] + bF * matrix[1][2];
        float z = rF * matrix[2][0] + gF * matrix[2][1] + bF * matrix[2][2];
        int argb = ColorUtils.XYZToColor(x, y, z);
        return argb;
    }

    public static int getInt(float hue, float chroma, float lstar, Frame frame) {
        if ((double)chroma < 1.0 || (double)Math.round(lstar) <= 0.0 || (double)Math.round(lstar) >= 100.0) {
            return CamUtils.intFromLstar(lstar);
        }
        hue = hue < 0.0f ? 0.0f : Math.min(360.0f, hue);
        float high = chroma;
        float mid = chroma;
        float low = 0.0f;
        boolean isFirstLoop = true;
        Cam answer = null;
        while (Math.abs(low - high) >= 0.4f) {
            Cam possibleAnswer = Cam.findCamByJ(hue, mid, lstar);
            if (isFirstLoop) {
                if (possibleAnswer != null) {
                    return possibleAnswer.viewed(frame);
                }
                isFirstLoop = false;
                mid = low + (high - low) / 2.0f;
                continue;
            }
            if (possibleAnswer == null) {
                high = mid;
            } else {
                answer = possibleAnswer;
                low = mid;
            }
            mid = low + (high - low) / 2.0f;
        }
        if (answer == null) {
            return CamUtils.intFromLstar(lstar);
        }
        return answer.viewed(frame);
    }

    private static Cam findCamByJ(float hue, float chroma, float lstar) {
        float low = 0.0f;
        float high = 100.0f;
        float mid = 0.0f;
        float bestdL = 1000.0f;
        float bestdE = 1000.0f;
        Cam bestCam = null;
        while (Math.abs(low - high) > 0.01f) {
            Cam camClipped;
            float dE;
            mid = low + (high - low) / 2.0f;
            Cam camBeforeClip = Cam.fromJch(mid, chroma, hue);
            int clipped = camBeforeClip.viewedInSrgb();
            float clippedLstar = CamUtils.lstarFromInt(clipped);
            float dL = Math.abs(lstar - clippedLstar);
            if (dL < 0.2f && (dE = (camClipped = Cam.fromInt(clipped)).distance(Cam.fromJch(camClipped.getJ(), camClipped.getChroma(), hue))) <= 1.0f) {
                bestdL = dL;
                bestdE = dE;
                bestCam = camClipped;
            }
            if (bestdL == 0.0f && bestdE == 0.0f) break;
            if (clippedLstar < lstar) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return bestCam;
    }
}

